/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import org.lwjgl.input.Keyboard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMIUtils {
    public static final String COPYRIGHT = "All of TooManyItems except for thesmall portion excerpted from the original Minecraft game is copyright 2011Marglyph. TooManyItems is free for personal use only. Do not redistributeTooManyItems, including in mod packs, and do not use TooManyItems' sourcecode or graphics in your own mods.";
    public static final String CONFIG_FILENAME = "TooManyItems.txt";
    public static final String NBT_FILENAME = "TMI.nbt";
    public static final int SPAWNER_ID = 52;
    public static final int MODE_SURVIVAL = 0;
    public static final int MODE_CREATIVE = 1;
    public static final int MODE_ADVENTURE = 2;
    public static final List<String> EMPTY_NAME = new ArrayList<String>(){
        {
            this.add("");
        }
    };
    public static boolean haveReplacedItems = false;
    public static final Random random = new Random();
    private static Map<Integer, wk> originalItems = new HashMap<Integer, wk>();
    public static List<wm> availableItems = new ArrayList<wm>();

    public static File configFile() {
        return new File(Minecraft.b(), CONFIG_FILENAME);
    }

    public static File nbtFile() {
        return new File(Minecraft.b(), NBT_FILENAME);
    }

    public static void loadPreferences(TMIConfig tMIConfig) {
        try {
            Map<String, String> map = tMIConfig.getSettings();
            File file = TMIUtils.configFile();
            if (file.exists()) {
                String string;
                if (!TMIUtils.nbtFile().exists()) {
                    map.put("favorites", "");
                    for (int i2 = 0; i2 < 7; ++i2) {
                        map.put("save" + (i2 + 1), "");
                    }
                }
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = string.split(":", 2);
                    if (stringArray.length <= 1 || !map.containsKey(stringArray[0])) continue;
                    map.put(stringArray[0], stringArray[1]);
                }
                bufferedReader.close();
                if (!TMIUtils.nbtFile().exists()) {
                    for (int i3 = 0; i3 < tMIConfig.getNumSaves(); ++i3) {
                        if (!map.containsKey("save" + (i3 + 1))) continue;
                        tMIConfig.decodeState(i3, map.get("save" + (i3 + 1)));
                    }
                    System.out.println("Loading old favorites");
                    tMIConfig.decodeFavorites();
                }
            }
            TMIUtils.loadNBTFile(tMIConfig);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void savePreferences(TMIConfig tMIConfig) {
        try {
            TMIUtils.saveNBTFile(tMIConfig);
            Map<String, String> map = tMIConfig.getSettings();
            File file = TMIUtils.configFile();
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (String string : map.keySet()) {
                if (string.matches("favorites|save\\d")) continue;
                printWriter.println(string + ":" + map.get(string));
            }
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void saveNBTFile(TMIConfig tMIConfig) {
        try {
            cf cf2;
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(TMIUtils.nbtFile()));
            ca ca2 = new ca();
            ca ca3 = new ca();
            List<wm> list = tMIConfig.getFavorites();
            for (wm object : list) {
                cf2 = new bs();
                if (object != null) {
                    object.b((bs)cf2);
                }
                ca3.a(cf2);
            }
            ca2.a(ca3);
            for (int i2 = 0; i2 < 7; ++i2) {
                if (TMIConfig.statesSaved[i2]) {
                    wm[] wmArray = tMIConfig.getState(i2);
                    cf2 = new ca();
                    for (int i3 = 0; i3 < wmArray.length; ++i3) {
                        bs bs2 = new bs();
                        if (wmArray[i3] != null) {
                            wmArray[i3].b(bs2);
                        }
                        ((ca)cf2).a(bs2);
                    }
                    ca2.a(cf2);
                    continue;
                }
                ca ca4 = new ca();
                ca2.a(ca4);
            }
            TMIPrivateFields.writeTagList.invoke((Object)ca2, dataOutputStream);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void loadNBTFile(TMIConfig tMIConfig) {
        try {
            wm[] wmArray;
            Object object;
            File file = TMIUtils.nbtFile();
            if (!file.exists()) {
                return;
            }
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            ca ca2 = new ca();
            TMIPrivateFields.readTagList.invoke((Object)ca2, dataInputStream);
            int n2 = 0;
            if (ca2.c() > 0) {
                ca ca3 = (ca)ca2.b(0);
                object = tMIConfig.getFavorites();
                object.clear();
                for (int i2 = 0; i2 < ca3.c(); ++i2) {
                    wmArray = (wm[])ca3.b(i2);
                    wm wm2 = new wm(0, 1, 0);
                    wm2.c((bs)wmArray);
                    object.add(wm2);
                }
            }
            for (int i3 = 1; i3 < ca2.c(); ++i3) {
                ca ca4;
                n2 = i3 - 1;
                object = ca2.b(i3);
                if (!(object instanceof ca) || (ca4 = (ca)object).c() <= 0 || n2 >= 7) continue;
                wmArray = tMIConfig.getState(n2);
                for (int i4 = 0; i4 < ca4.c(); ++i4) {
                    cf cf2 = ca4.b(i4);
                    if (!(cf2 instanceof bs)) continue;
                    bs bs2 = (bs)cf2;
                    if (bs2.b("id")) {
                        wmArray[i4] = new wm(0, 1, 0);
                        wmArray[i4].c(bs2);
                        continue;
                    }
                    wmArray[i4] = null;
                }
                TMIConfig.statesSaved[n2] = true;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void loadItems(TMIConfig tMIConfig) {
        cf n4;
        Object exception;
        Object object2;
        Serializable serializable;
        List<wm> list = availableItems;
        List<wk> list2 = tMIConfig.getEnchantableItems();
        boolean bl2 = TMIConfig.isMultiplayer();
        list.clear();
        list2.clear();
        try {
            serializable = Class.forName("com.eloraam.redpower.RedPowerBase");
            object2 = (apa)((Class)serializable).getDeclaredField("blockMicro").get(null);
            Field field = apa.class.getDeclaredField("cz");
            TMIItemInfo.setMaxDamageException(field.getInt(object2), 32000);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception2) {
            System.out.println(exception2);
        }
        serializable = new ArrayList();
        block11: for (wk object3 : wk.f) {
            Object nullPointerException;
            wm wm2;
            if (object3 == null) continue;
            if (object3.cp == TMIItemInfo.addItemOffset(127)) {
                if (!tMIConfig.areDamageVariantsShown()) continue;
                for (Object n2 : mv.a.keySet()) {
                    list.add(new wm(TMIItemInfo.addItemOffset(127), 64, (int)((Integer)n2)));
                }
                continue;
            }
            if (object3.cp == 52) {
                if (bl2) {
                    list.add(new wm(52, 64, 0));
                    continue;
                }
                try {
                    exception = TMIPrivateFields.getSpawnerEntityIdSet().iterator();
                    while (exception.hasNext()) {
                        int wm3 = (Integer)exception.next();
                        list.add(new wm(52, 64, wm3));
                    }
                    exception = TMIUtils.makeSingleSpawner(50, 64, "\u00a7r\u00a79Charged Creeper Spawner");
                    ((wm)exception).d.l("SpawnData").a("powered", true);
                    list.add((wm)exception);
                    wm wm5 = TMIUtils.makeSingleSpawner(51, 64, "\u00a7r\u00a79Wither Skeleton Spawner");
                    wm5.d.l("SpawnData").a("SkeletonType", new br("", 1));
                    n4 = new ca();
                    wm bl3 = new wm(TMIItemInfo.addItemOffset(16), 1, 0);
                    bs i2 = new bs();
                    bl3.b(i2);
                    n4.a(i2);
                    n4.a(new bs());
                    n4.a(new bs());
                    n4.a(new bs());
                    n4.a(new bs());
                    wm5.d.l("SpawnData").a("Equipment", n4);
                    list.add(wm5);
                    wm2 = TMIUtils.makeSingleSpawner(90, 64, "\u00a7r\u00a79Saddled Pig Spawner");
                    wm2.d.l("SpawnData").a("Saddle", true);
                    list.add(wm2);
                    list.add(TMIUtils.makeRandomFireworkSpawner());
                    nullPointerException = TMIUtils.makeSingleSpawner(21, 64, "\u00a7r\u00a79TMI Wide-Area Torch Spawner");
                    TMIUtils.addLore((wm)nullPointerException, "It's full of torches!");
                    ((wm)nullPointerException).d.l("SpawnData").a("Tile", (byte)50);
                    ((wm)nullPointerException).d.l("SpawnData").a("Time", (byte)2);
                    ((wm)nullPointerException).d.l("SpawnData").a("DropItem", false);
                    ((wm)nullPointerException).d.a("MinSpawnDelay", (short)15);
                    ((wm)nullPointerException).d.a("MaxSpawnDelay", (short)15);
                    ((wm)nullPointerException).d.a("SpawnCount", (short)10);
                    ((wm)nullPointerException).d.a("MaxNearbyEntities", (short)15);
                    ((wm)nullPointerException).d.a("RequiredPlayerRange", (short)16);
                    ((wm)nullPointerException).d.a("SpawnRange", (short)136);
                }
                catch (Exception exception3) {
                    System.out.println(exception3);
                    list.add(new wm(52, 64, 0));
                }
                continue;
            }
            if (TMIItemInfo.isHidden(object3.cp)) continue;
            if (object3.c() > 0) {
                list2.add(object3);
            }
            if (object3.cp < apa.r.length && apa.r[object3.cp] != null) {
                serializable.clear();
                apa.r[object3.cp].a(object3.cp, (ve)null, (List)((Object)serializable));
                if (serializable.size() > 1) {
                    exception = serializable.iterator();
                    while (exception.hasNext()) {
                        wm n3 = (wm)exception.next();
                        n3.a = wk.f[n3.c].l();
                        list.add(n3);
                    }
                    continue;
                }
            }
            exception = new HashSet();
            int wm8 = tMIConfig.areDamageVariantsShown() ? 15 : 0;
            int n2 = TMIItemInfo.getMaxDamageException(object3.cp);
            if (n2 > wm8) {
                wm8 = n2;
            }
            boolean bl3 = false;
            for (int i2 = 0; i2 <= wm8; ++i2) {
                if (object3.cp == 43 && i2 > 0 || object3.cp == 44 && i2 > 5 || object3.cp == 59 && (i2 != 7 || bl2) || object3.cp == 104 && (i2 != 7 || bl2) || object3.cp == 105 && (i2 != 7 || bl2) || object3.cp == 115 && (i2 != 3 || bl2) || object3.cp == 78 && i2 > 0 && bl2 || object3.cp == 125 && i2 > 0 || object3.cp == 126 && i2 > 3) continue;
                wm2 = new wm(object3, object3.l(), i2);
                try {
                    nullPointerException = object3.h(wm2);
                    String string = object3.d(wm2);
                    if (TMIUtils.itemDisplayName(wm2).equals("Unnamed")) {
                        if (i2 != 0) continue;
                        continue block11;
                    }
                    if (object3.cp < apa.r.length && apa.r[object3.cp] != null) {
                        try {
                            apa.r[object3.cp].a(1, i2);
                        }
                        catch (Exception bl4) {
                            continue;
                        }
                    }
                    boolean bl4 = !bl2 && (object3.cp == 99 || object3.cp == 100) && i2 < 16;
                    String string2 = string + "@" + nullPointerException.i();
                    if (((HashSet)exception).contains(string2) && !TMIItemInfo.isShown(object3.cp, i2) && !bl4) continue;
                    list.add(wm2);
                    ((HashSet)exception).add(string2);
                    continue;
                }
                catch (NullPointerException indexOutOfBoundsException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        if (tMIConfig.areDamageVariantsShown()) {
            object2 = TMIItemInfo.potionValues.iterator();
            while (object2.hasNext()) {
                int n5 = (Integer)object2.next();
                wm wm6 = new wm(TMIItemInfo.addItemOffset(117), 64, n5);
                list.add(wm6);
            }
        }
        if (tMIConfig.areDamageVariantsShown()) {
            if (!tMIConfig.isMultiplayer()) {
                object2 = new wm(TMIItemInfo.addItemOffset(117), 64, 1);
                ml ml2 = new ml(3, 0, 1);
                TMIUtils.addEffectToPotion((wm)object2, ml2);
                list.add((wm)object2);
                wm wm7 = new wm(TMIItemInfo.addItemOffset(117), 64, 16384);
                ml ml3 = new ml(7, 0, 3);
                TMIUtils.addEffectToPotion(wm7, ml3);
                list.add(wm7);
                list.add(TMIUtils.makeFirework("Creepy Sparkler", 2, 3, new int[]{4312372}, new int[]{15435844}, true, false));
                list.add(TMIUtils.makeFirework("Star", 4, 2, new int[]{6719955}, null, false, false));
                list.add(TMIUtils.makeFirework("Big Red", 1, 1, new int[]{11743532}, null, false, false));
                exception = TMIUtils.makeExplosionTag(1, new int[]{11743532, 0xF0F0F0, 2437522}, new int[]{0xF0F0F0}, true, true);
                wm wm3 = new wm(TMIItemInfo.addItemOffset(145), 64, 0);
                wm3.d = new bs();
                n4 = TMIUtils.makeFireworksTag(2, new bs[]{exception, exception});
                wm3.d.a("Fireworks", (bs)n4);
                TMIUtils.nameStack(wm3, "Old Glory");
                list.add(wm3);
            }
        }
        TMIUtils.filterItems(null, tMIConfig);
    }

    public static wm makeRandomFireworkSpawner() {
        wm wm2 = new wm(52, 1, 22);
        wm2.d = new bs();
        TMIUtils.nameStack(wm2, "\u00a7r\u00a79TMI Random Firework Spawner");
        TMIUtils.addLore(wm2, "Every one is different");
        wm2.d.a("MinSpawnDelay", (short)20);
        wm2.d.a("MaxSpawnDelay", (short)20);
        wm2.d.a("SpawnCount", (short)1);
        wm2.d.a("MaxNearbyEntities", (short)5);
        wm2.d.a("RequiredPlayerRange", (short)120);
        wm2.d.a("SpawnRange", (short)2);
        ca ca2 = new ca("SpawnPotentials");
        wm2.d.a("SpawnPotentials", ca2);
        for (int i2 = 0; i2 < 10; ++i2) {
            bs bs2 = new bs("SpawnData");
            bs2.a("Type", "FireworksRocketEntity");
            bs2.a("Weight", 1);
            bs bs3 = new bs("Properties");
            bs2.a("Properties", bs3);
            bs bs4 = TMIUtils.makeRandomFirework().b(new bs());
            bs3.a("FireworksItem", bs4);
            bs3.a("LifeTime", random.nextInt(15) + random.nextInt(15) + 20);
            ca2.a(bs2);
        }
        return wm2;
    }

    public static wm makeSingleSpawner(int n2, int n3, String string) {
        String string2 = mv.b(n2);
        wm wm2 = new wm(52, n3, n2);
        wm2.d = new bs();
        bs bs2 = new bs("SpawnData");
        wm2.d.a("SpawnData", bs2);
        if (string != null) {
            TMIUtils.nameStack(wm2, string);
        }
        return wm2;
    }

    public static wm makeFirework(String string, int n2, int n3, int[] nArray, int[] nArray2, boolean bl2, boolean bl3) {
        wm wm2 = new wm(TMIItemInfo.addItemOffset(145), 64, 0);
        wm2.d = new bs();
        bs bs2 = TMIUtils.makeExplosionTag(n3, nArray, nArray2, bl2, bl3);
        bs bs3 = TMIUtils.makeFireworksTag(n2, bs2);
        wm2.d.a("Fireworks", bs3);
        if (string != null && !string.equals("")) {
            TMIUtils.nameStack(wm2, string);
        }
        return wm2;
    }

    public static bs makeExplosionTag(int n2, int[] nArray, int[] nArray2, boolean bl2, boolean bl3) {
        bs bs2 = new bs("Explosion");
        bs2.a("Flicker", bl2);
        bs2.a("Trail", bl3);
        bs2.a("Type", (byte)(n2 & 0xF));
        if (nArray != null && nArray.length > 0) {
            bs2.a("Colors", nArray);
        }
        if (nArray2 != null && nArray2.length > 0) {
            bs2.a("FadeColors", nArray2);
        }
        return bs2;
    }

    public static wm makeRandomFirework() {
        int[] nArray = random.nextBoolean() ? new int[]{TMIUtils.randomBrightColor(), TMIUtils.randomBrightColor()} : new int[]{TMIUtils.randomBrightColor()};
        int[] nArray2 = random.nextBoolean() ? new int[]{TMIUtils.randomBrightColor()} : null;
        return TMIUtils.makeFirework("Random Firework", random.nextInt(3) + 1, random.nextInt(4), nArray, nArray2, random.nextBoolean(), random.nextBoolean());
    }

    public static int randomBrightColor() {
        return Color.HSBtoRGB(random.nextFloat(), random.nextFloat(), random.nextFloat() * 0.5f + 0.5f);
    }

    public static bs makeFireworksTag(int n2, bs ... bsArray) {
        bs bs2 = new bs("Fireworks");
        bs2.a("Flight", (byte)(n2 & 0xF));
        ca ca2 = new ca();
        bs2.a("Explosions", ca2);
        for (bs bs3 : bsArray) {
            ca2.a(bs3);
        }
        return bs2;
    }

    public static String deaccent(String string) {
        try {
            Class.forName("java.text.Normalizer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return string;
        }
        String string2 = Normalizer.normalize(string, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(string2).replaceAll("");
    }

    public static void filterItems(String string, TMIConfig tMIConfig) {
        List<wm> list = availableItems;
        List<wm> list2 = tMIConfig.getItems();
        list2.clear();
        if (string == null || string.equals("")) {
            for (wm wm2 : list) {
                list2.add(wm2);
            }
        } else {
            string = TMIUtils.deaccent(string.toLowerCase());
            for (wm wm3 : list) {
                String string2;
                if (wm3 == null || (string2 = TMIUtils.itemDisplayName(wm3)) == null || !TMIUtils.deaccent(string2.toLowerCase()).contains(string)) continue;
                list2.add(wm3);
            }
        }
    }

    public static void safeReportException(Exception exception) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(".yyyyMMdd.HHmmss");
            StringBuffer stringBuffer = new StringBuffer();
            simpleDateFormat.format(new Date(), stringBuffer, new FieldPosition(1));
            String string = "tmi" + stringBuffer.toString() + ".txt";
            File file = new File(Minecraft.a("minecraft"), string);
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.print("[code]TMI Version: 1.5.2 2013-04-25\n");
            exception.printStackTrace(printWriter);
            printWriter.println("[/code]");
            printWriter.close();
        }
        catch (Exception exception2) {
            System.out.println("Error during safeReportException:");
            exception2.printStackTrace();
        }
    }

    public static List<String> itemDisplayNameMultiline(wm wm2, boolean bl2) {
        return TMIUtils.itemDisplayNameMultiline(wm2, bl2, false);
    }

    public static List<String> itemDisplayNameMultiline(wm wm2, boolean bl2, boolean bl3) {
        Object object;
        if (wm2 == null) {
            return EMPTY_NAME;
        }
        if (bl3) {
            bl2 = false;
        }
        List<String> list = null;
        if (TMIUtils.isValidItem(wm2)) {
            try {
                object = wm2.a(Minecraft.x().g, bl3);
                list = object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (list == null || list.size() == 0 || wm2.c == 52 && wm2.d == null) {
            list = new ArrayList<String>();
            list.add(TMIItemInfo.getFallbackName(wm2.c, wm2.j()));
            if (bl3) {
                bl2 = true;
            }
        }
        if (((String)(object = ((String)list.get(0)).trim())).length() == 0) {
            object = TMIItemInfo.getFallbackName(wm2.c, wm2.j());
            list.set(0, (String)object);
        }
        if (bl2 && wm2 != null) {
            object = (String)object + " " + wm2.c;
            if (wm2.j() != 0) {
                object = (String)object + " : " + wm2.j();
            }
            list.set(0, (String)object);
        }
        return list;
    }

    public static String itemDisplayName(wm wm2) {
        List<String> list = TMIUtils.itemDisplayNameMultiline(wm2, false);
        return list.get(0);
    }

    public static boolean isValidItem(wm wm2) {
        return wm2 == null || wm2.c >= 0 && wm2.c < wk.f.length && wk.f[wm2.c] != null;
    }

    public static wm getValidItem(wm wm2) {
        if (TMIUtils.isValidItem(wm2)) {
            return wm2;
        }
        return new wm(wk.f[52]);
    }

    public static String getValidItemDisplayName(wm wm2) {
        if (TMIUtils.isValidItem(wm2)) {
            return TMIUtils.itemDisplayName(wm2);
        }
        return "Undefined Item";
    }

    public static void setHeldItem(wm wm2) {
        TMIUtils.getPlayer().bK.b(wm2);
        Minecraft.x().g.bK.b(wm2);
    }

    public static void deleteHeldItem() {
        TMIUtils.setHeldItem(null);
    }

    public static wm getHeldItem() {
        return Minecraft.x().g.bK.o();
    }

    public static void giveStack(wm wm2, TMIConfig tMIConfig) {
        TMIUtils.giveStack(wm2, tMIConfig, wm2.a);
    }

    public static void giveStack(wm wm2, TMIConfig tMIConfig, int n2) {
        wm wm3 = TMIUtils.copyStack(wm2, n2);
        Minecraft minecraft = Minecraft.x();
        if (TMIConfig.isMultiplayer()) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            numberFormat.setGroupingUsed(false);
            MessageFormat messageFormat = new MessageFormat(tMIConfig.getSettings().get("give-command"));
            messageFormat.setFormatByArgumentIndex(1, numberFormat);
            messageFormat.setFormatByArgumentIndex(2, numberFormat);
            messageFormat.setFormatByArgumentIndex(3, numberFormat);
            Object[] objectArray = new Object[]{minecraft.g.bS, wm3.c, wm3.a, wm3.j()};
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(messageFormat.format(objectArray));
            for (int[] nArray : TMIUtils.getEnchantments(wm3)) {
                stringBuilder.append(" ");
                stringBuilder.append(nArray[0]);
                stringBuilder.append(":");
                stringBuilder.append(nArray[1]);
            }
            minecraft.g.d(stringBuilder.toString());
        } else {
            TMIUtils.getPlayer().bK.a(wm3);
        }
    }

    public static wm copyStack(wm wm2, int n2) {
        if (wm2 == null) {
            return null;
        }
        wm2.a += n2;
        return wm2.a(n2);
    }

    public static wm copyStack(wm wm2) {
        if (wm2 == null) {
            return null;
        }
        return TMIUtils.copyStack(wm2, wm2.a);
    }

    public static void updateUnlimitedItems() {
        try {
            if (TMIConfig.isMultiplayer() || !TMIConfig.getInstance().isEnabled()) {
                return;
            }
            for (wm wm2 : TMIUtils.getPlayer().bK.a) {
                bs bs2;
                if (wm2 == null) continue;
                if (wm2.d != null && wm2.d.b("TooManyItems") && (bs2 = wm2.d.l("TooManyItems")).b("Unlimited")) {
                    int n2 = TMIUtils.maxStackSize(wm2.c);
                    if (n2 == 1) {
                        n2 = 64;
                    }
                    wm2.a = n2;
                }
                if (wm2.j() >= 0) continue;
                TMIUtils.setStackDamage(wm2, -32000);
            }
            wm nullPointerException = TMIUtils.getHeldItem();
            if (nullPointerException != null && nullPointerException.a > 64) {
                nullPointerException.a = -1;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void setStackDamage(wm wm2, int n2) {
        try {
            TMIPrivateFields.stackDamage.setInt(wm2, n2);
        }
        catch (Exception exception) {
            System.out.println("[TMI] Error setting stack damage");
            exception.printStackTrace();
        }
    }

    public static void deleteInventory() {
        List list = TMIUtils.getPlayer().bM.c;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ul ul2 = (ul)list.get(i2);
            if (ul2 == null) continue;
            ul2.c(null);
        }
    }

    public static void deleteItemsOfType(wm wm2, ayl ayl2) {
        List list = TMIUtils.getPlayer().bM.c;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            wm wm3;
            ul ul2 = (ul)list.get(i2);
            if (ul2 == null || (wm3 = ul2.c()) == null || wm3.c != wm2.c || wm3.j() != wm2.j()) continue;
            ul2.c(null);
        }
    }

    public static boolean shiftKey() {
        return Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
    }

    public static int getGameMode() {
        try {
            return ((aaj)((Object)TMIPrivateFields.gameMode.get(Minecraft.x().b))).a();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(illegalAccessException);
            return 0;
        }
    }

    public static void setGameMode(int n2) {
        if (TMIConfig.isMultiplayer()) {
            Minecraft.x().g.d("/gamemode " + n2);
        } else {
            TMIUtils.getPlayer().a(aaj.a(n2));
        }
    }

    public static boolean isCreativeMode() {
        return Minecraft.x().b.h();
    }

    public static void setCreativeMode(boolean bl2) {
        if (TMIConfig.isMultiplayer()) {
            Minecraft.x().g.d("/gamemode " + (bl2 ? "1" : "0"));
        } else {
            TMIUtils.getPlayer().a(bl2 ? aaj.c : aaj.b);
        }
    }

    public static boolean isCreativeSearchTab() {
        return false;
    }

    public static boolean isRaining() {
        return Minecraft.x().e.x.p();
    }

    public static void setRaining(boolean bl2) {
        if (TMIConfig.isMultiplayer()) {
            Minecraft.x().g.d("/toggledownfall");
        } else {
            MinecraftServer.D().b[0].x.b(bl2);
            MinecraftServer.D().b[0].x.g(bl2 ? 18000 : 180000);
        }
    }

    public static long getTime() {
        return Minecraft.x().e.x.g();
    }

    public static void setTime(long l2) {
        if (TMIConfig.isMultiplayer()) {
            Minecraft.x().g.d("/time set " + l2);
        } else {
            MinecraftServer.D().b[0].b(l2);
        }
    }

    public static void setHourForward(int n2) {
        long l2 = TMIUtils.getTime() / 24000L * 24000L;
        long l3 = l2 + 24000L + (long)(n2 * 1000);
        TMIUtils.setTime(l3);
    }

    public static void logWithTrace(String string) {
        System.out.println(string);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
            System.out.println(stackTraceElementArray[i2].toString());
        }
    }

    public static void logWithTrace(String string, int n2) {
        System.out.println(string);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i2 = 0; i2 < stackTraceElementArray.length && i2 < n2; ++i2) {
            System.out.println(stackTraceElementArray[i2].toString());
        }
    }

    public static boolean playerIsAlive() {
        return !Minecraft.x().g.M;
    }

    public static void setPlayerHealth(int n2) {
        if (TMIUtils.playerIsAlive()) {
            TMIUtils.getPlayer().b(n2);
        }
    }

    public static void fillHunger() {
        if (TMIUtils.playerIsAlive()) {
            TMIUtils.getPlayer().bN.a(20);
            TMIUtils.getPlayer().bN.b(5.0f);
        }
    }

    public static void incrementDifficulty() {
        Minecraft.x().z.a(awa.l, 1);
    }

    public static String getDifficultyString() {
        return Minecraft.x().z.c(awa.l);
    }

    public static void suppressAchievementNotice() {
        try {
            for (Field field : Minecraft.x().v.getClass().getDeclaredFields()) {
                if (!field.getName().equals("_gui_achievement_time")) continue;
                field.setAccessible(true);
                field.setInt(Minecraft.x().v, 0);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static int maxStackSize(int n2) {
        return wk.f[n2].l();
    }

    public static List<int[]> getEnchantments(wm wm2) {
        ca ca2;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        if (wm2 != null && (ca2 = wm2.r()) != null) {
            for (int i2 = 0; i2 < ca2.c(); ++i2) {
                short s2 = ((bs)ca2.b(i2)).d("id");
                short s3 = ((bs)ca2.b(i2)).d("lvl");
                int[] nArray = new int[]{s2, s3};
                arrayList.add(nArray);
            }
        }
        return arrayList;
    }

    public static boolean addEnchantment(wm wm2, int n2, int n3) {
        if (n2 < yz.b.length && yz.b[n2] != null) {
            wm2.a(yz.b[n2], n3);
            return true;
        }
        return false;
    }

    public static void addEffectToPotion(wm wm2, ml ml2) {
        ca ca2;
        if (wm2.c != TMIItemInfo.addItemOffset(117)) {
            return;
        }
        if (wm2.d == null) {
            wm2.d = new bs();
        }
        if (wm2.d.b("CustomPotionEffects")) {
            ca2 = wm2.d.m("CustomPotionEffects");
        } else {
            ca2 = new ca();
            wm2.d.a("CustomPotionEffects", ca2);
        }
        bs bs2 = new bs();
        ml2.a(bs2);
        ca2.a(bs2);
    }

    public static void nameStack(wm wm2, String string) {
        if (string != null) {
            bs bs2;
            if (wm2.d == null) {
                wm2.d = new bs();
            }
            if (wm2.d.b("display")) {
                bs2 = wm2.d.l("display");
            } else {
                bs2 = new bs();
                wm2.d.a("display", bs2);
            }
            bs2.a("Name", string);
        }
    }

    public static void addLore(wm wm2, String string) {
        if (string != null) {
            ca ca2;
            bs bs2;
            if (wm2.d == null) {
                wm2.d = new bs();
            }
            if (wm2.d.b("display")) {
                bs2 = wm2.d.l("display");
            } else {
                bs2 = new bs();
                wm2.d.a("display", bs2);
            }
            if (bs2.b("Lore")) {
                ca2 = bs2.m("Lore");
            } else {
                ca2 = new ca();
                bs2.a("Lore", ca2);
            }
            ce ce2 = new ce("Lore", string);
            ca2.a(ce2);
        }
    }

    public static bs getTagCompoundWithCreate(wm wm2, String string) {
        bs bs2;
        if (wm2.d == null) {
            wm2.d = new bs();
        }
        if (!wm2.d.b(string)) {
            bs2 = new bs();
            wm2.d.a(string, bs2);
        } else {
            bs2 = wm2.d.l(string);
        }
        return bs2;
    }

    public static jc getPlayer() {
        return MinecraftServer.D().ad().f(Minecraft.x().g.bS);
    }

    public static void fastTransfer(int n2, int n3, tj tj2) {
        Minecraft minecraft = Minecraft.x();
        wm wm2 = TMIUtils.getHeldItem();
        minecraft.b.a(tj2.d, n2, n3, 0, minecraft.g);
        int n4 = tj2.c.size() - 36;
        boolean bl2 = n2 < n4;
        int n5 = 0;
        int n6 = n4;
        int n7 = n4 - 1;
        int n8 = tj2.c.size();
        if (bl2) {
            n5 = n4;
            n6 = tj2.c.size();
            n7 = -1;
            n8 = n4;
        }
        boolean bl3 = true;
        while (n5 < n6 && n7 < n8) {
            wm wm3;
            ul ul2 = (ul)tj2.c.get(n5);
            if (ul2 != null && (wm3 = ul2.c()) != null && wm3.c == wm2.c && wm3.j() == wm2.j()) {
                ul ul3 = bl3 ? (ul)tj2.c.get(n2) : (ul)tj2.c.get(n7);
                if (ul3 == null) {
                    ++n7;
                    bl3 = false;
                    continue;
                }
                wm wm4 = ul3.c();
                if (wm4 == null) {
                    ul3.c(wm3);
                    ul2.c(null);
                } else if (wm4.c == wm3.c && wm4.j() == wm3.j()) {
                    int n9 = wm3.a + wm4.a;
                    int n10 = wk.f[wm3.c].l();
                    int n11 = n9 - n10;
                    if (n11 > 0) {
                        wm4.a = n10;
                        wm3.a = n11;
                        ++n7;
                        bl3 = false;
                        continue;
                    }
                    wm4.a = n9;
                    ul2.c(null);
                } else {
                    ++n7;
                    bl3 = false;
                    continue;
                }
            }
            ++n5;
        }
    }

    public static boolean isEnchantmentNormallyPossible(yz yz2, wk wk2) {
        return yz2.A.a(wk2) || wk2.cp == TMIItemInfo.addItemOffset(147);
    }

    public static boolean isEnchantmentNormallyPossible(yz yz2, wm wm2) {
        return yz2.A.a(wk.f[wm2.c]) || wm2.c == TMIItemInfo.addItemOffset(147);
    }

    public static List<yz> getPossibleEnchantments(wk wk2) {
        if (wk2.c() > 0) {
            ArrayList<yz> arrayList = new ArrayList<yz>();
            for (yz yz2 : yz.b) {
                if (yz2 == null || !yz2.A.a(wk2)) continue;
                arrayList.add(yz2);
            }
            return arrayList;
        }
        return new ArrayList<yz>();
    }

    public static void replaceCustomItems() {
        block6: {
            block5: {
                if (haveReplacedItems) break block5;
                TMIConfig.getInstance();
                if (!TMIConfig.isMultiplayer() && TMIConfig.getInstance().getBooleanSetting("replace-items")) break block6;
            }
            return;
        }
        try {
            Class<?> clazz = Class.forName("cpw.mods.fml.common.registry.GameData");
            System.out.println("[TMI] Please ignore Forge item allocation errors. The items are fine.");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        TMIUtils.modMushroomBlock(true);
        TMIUtils.modMobSpawner(true);
        TMIUtils.modCrops(true);
        TMIUtils.modSnowCover(true);
        haveReplacedItems = true;
    }

    public static void dumpItemList() {
        try {
            File file = new File(Minecraft.a("minecraft"), "TMIItemList.txt");
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (wm wm2 : TMIConfig.getInstance().getItems()) {
                printWriter.println("" + wm2.c + ":" + wm2.j() + " " + TMIUtils.getValidItemDisplayName(wm2));
            }
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public static wk unsetItem(int n2) {
        wk wk2 = wk.f[n2];
        wk.f[n2] = null;
        try {
            Class<?> clazz = Class.forName("cpw.mods.fml.common.registry.GameData");
            Field field = clazz.getDeclaredField("idMap");
            TMIPrivateFields.unsetFinalPrivate(field);
            Map map = (Map)field.get(null);
            if (map.containsKey(n2)) {
                map.remove(n2);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return wk2;
    }

    public static void unsetAndSaveItem(int n2) {
        originalItems.put(n2, TMIUtils.unsetItem(n2));
    }

    public static void modMobSpawner(boolean bl2) {
        TMIUtils.unsetAndSaveItem(52);
        wk.f[52] = new TMIItemSpawner(52 - TMIItemInfo.itemOffset).b("mobSpawner");
    }

    public static void modMushroomBlock(boolean bl2) {
        TMIUtils.unsetAndSaveItem(99);
        TMIUtils.unsetAndSaveItem(100);
        wk.f[99] = new TMIItemMushroomCap(99 - TMIItemInfo.itemOffset).b("mushroom");
        wk.f[100] = new TMIItemMushroomCap(100 - TMIItemInfo.itemOffset).b("mushroom");
    }

    public static void modCrops(boolean bl2) {
        TMIUtils.unsetAndSaveItem(59);
        TMIUtils.unsetAndSaveItem(104);
        TMIUtils.unsetAndSaveItem(105);
        TMIUtils.unsetAndSaveItem(115);
        wk.f[59] = new TMIItemCrop(59 - TMIItemInfo.itemOffset).b("crops");
        wk.f[104] = new TMIItemCrop(104 - TMIItemInfo.itemOffset).b("pumpkinStem");
        wk.f[105] = new TMIItemCrop(105 - TMIItemInfo.itemOffset).b("melonStem");
        wk.f[115] = new TMIItemCrop(115 - TMIItemInfo.itemOffset).b("netherStalk");
    }

    public static void modSnowCover(boolean bl2) {
    }

    public static void resetItems() {
        for (int n2 : originalItems.keySet()) {
            TMIUtils.unsetItem(n2);
            wk.f[n2] = originalItems.get(n2);
        }
        originalItems.clear();
        haveReplacedItems = false;
    }
}

