/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import org.lwjgl.input.Keyboard;

public class TMIView
implements _tmi_MgTooltipHandler {
    public static final String COPYRIGHT = "All of TooManyItems except for thesmall portion excerpted from the original Minecraft game is copyright 2011Marglyph. TooManyItems is free for personal use only. Do not redistributeTooManyItems, including in mod packs, and do not use TooManyItems' sourcecode or graphics in your own mods.";
    private _tmi_MgCanvas canvas;
    private TMIConfig config;
    private TMIController controller;
    private boolean widgetsCreated = false;
    private String activeTooltip = null;
    private static String savedTabName = "items";
    private _tmi_MgButton prevButton;
    private _tmi_MgButton nextButton;
    private _tmi_MgButton trashButton;
    private _tmi_MgButton[] stateButtons;
    private _tmi_MgButton[] deleteButtons;
    public TMIItemPanel itemPanel;
    public _tmi_MgTabView tabView = new _tmi_MgTabView();
    public TMIEnchantPanel enchantPanel = new TMIEnchantPanel(this);
    public TMIConfigPanel configPanel = new TMIConfigPanel();
    public TMIFavoritesPanel favoritesPanel;
    public TMIPotionPanel potionPanel = new TMIPotionPanel();
    public TMIFireworkPanel fireworkPanel = new TMIFireworkPanel();
    public _tmi_MgButton rain;
    public _tmi_MgButton survival;
    public _tmi_MgButton creative;
    public _tmi_MgButton adventure;
    public _tmi_MgButton delete;
    public _tmi_MgButton noon;
    public _tmi_MgButton dawn;
    public _tmi_MgButton dusk;
    public _tmi_MgButton midnight;
    public _tmi_MgButton difficulty;
    public _tmi_MgButton health;

    public TMIView(_tmi_MgCanvas _tmi_MgCanvas2, TMIConfig tMIConfig, TMIController tMIController) {
        this.canvas = _tmi_MgCanvas2;
        this.config = tMIConfig;
        this.controller = tMIController;
        this.stateButtons = new _tmi_MgButton[this.config.getNumSaves()];
        this.deleteButtons = new _tmi_MgButton[this.config.getNumSaves()];
        this.createWidgets();
    }

    public void createWidgets() {
        this.itemPanel = new TMIItemPanel(0, 0, 0, 0, 0, this.config.getItems(), this.controller);
        this.favoritesPanel = new TMIFavoritesPanel(this.config, this.controller);
        this.tabView.addChild("items", TMIImages.iconChest, TMIImages.iconChestLight, this.itemPanel);
        this.tabView.addChild("favorites", TMIImages.iconStar, TMIImages.iconStarLight, this.favoritesPanel);
        this.tabView.addChild("enchant", TMIImages.iconBook, TMIImages.iconBookLight, this.enchantPanel);
        TMIView tMIView = this;
        if (!tMIView.config.isMultiplayer()) {
            this.tabView.addChild("potions", TMIImages.iconPotion, TMIImages.iconPotion, this.potionPanel);
            this.tabView.addChild("fireworks", TMIImages.iconFirework, TMIImages.iconFirework, this.fireworkPanel);
        }
        this.canvas.widgets.add(this.tabView);
        this.tabView.setActiveChild(savedTabName);
        this.delete = new _tmi_MgButton("", this.controller, "deleteMode");
        this.delete.icon = TMIImages.iconDelete;
        this.delete.showState = true;
        this.delete.setOwnWidth(this.canvas);
        this.delete.height = 14;
        this.canvas.widgets.add(this.delete);
        this.rain = new _tmi_MgButton("", this.controller, "rain");
        this.rain.showState = true;
        this.rain.icon = TMIImages.iconRain;
        this.rain.setOwnWidth(this.canvas);
        this.rain.height = 14;
        this.canvas.widgets.add(this.rain);
        this.survival = new _tmi_MgButton("", this.controller, "survival");
        this.survival.icon = TMIImages.iconModeS;
        this.survival.setOwnWidth(this.canvas);
        this.survival.height = 14;
        this.canvas.widgets.add(this.survival);
        this.creative = new _tmi_MgButton("", this.controller, "creative");
        this.creative.icon = TMIImages.iconModeC;
        this.creative.setOwnWidth(this.canvas);
        this.creative.height = 14;
        this.canvas.widgets.add(this.creative);
        this.adventure = new _tmi_MgButton("", this.controller, "adventure");
        this.adventure.icon = TMIImages.iconModeA;
        this.adventure.setOwnWidth(this.canvas);
        this.adventure.height = 14;
        this.canvas.widgets.add(this.adventure);
        this.noon = new _tmi_MgButton("", this.controller, "noon");
        this.noon.icon = TMIImages.iconNoon;
        this.noon.setOwnWidth(this.canvas);
        this.noon.height = 14;
        this.canvas.widgets.add(this.noon);
        this.dawn = new _tmi_MgButton("", this.controller, "dawn");
        this.dawn.icon = TMIImages.iconDawn;
        this.dawn.setOwnWidth(this.canvas);
        this.dawn.height = 14;
        this.canvas.widgets.add(this.dawn);
        this.dusk = new _tmi_MgButton("", this.controller, "dusk");
        this.dusk.icon = TMIImages.iconDusk;
        this.dusk.setOwnWidth(this.canvas);
        this.dusk.height = 14;
        this.canvas.widgets.add(this.dusk);
        this.midnight = new _tmi_MgButton("", this.controller, "midnight");
        this.midnight.icon = TMIImages.iconMidnight;
        this.midnight.setOwnWidth(this.canvas);
        this.midnight.height = 14;
        this.canvas.widgets.add(this.midnight);
        this.difficulty = new _tmi_MgButton("", this.controller, "difficulty");
        this.difficulty.icon = TMIImages.iconDifficulty;
        this.difficulty.setOwnWidth(this.canvas);
        this.difficulty.height = 14;
        this.canvas.widgets.add(this.difficulty);
        this.health = new _tmi_MgButton("", this.controller, "health");
        this.health.icon = TMIImages.iconHeart;
        this.health.setOwnWidth(this.canvas);
        this.health.height = 14;
        this.canvas.widgets.add(this.health);
        this.delete.x = 2;
        this.delete.y = 2;
        this.canvas.arrangeHorizontally(1, 1001, this.delete, this.survival, this.creative, this.adventure, this.rain, this.dawn, this.noon, this.dusk, this.midnight, this.difficulty, this.health);
        this.stateButtons = new _tmi_MgButton[this.config.getNumSaves()];
        for (int i2 = 0; i2 < this.config.getNumSaves(); ++i2) {
            this.stateButtons[i2] = new _tmi_MgButton("Save " + (i2 + 1), this.controller, new TMIStateButtonData(i2, 0));
            this.canvas.widgets.add(this.stateButtons[i2]);
            this.deleteButtons[i2] = new _tmi_MgButton("x", this.controller, new TMIStateButtonData(i2, 1));
            this.canvas.widgets.add(this.deleteButtons[i2]);
        }
        this.widgetsCreated = true;
    }

    public void layout(int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = (n2 - n4) / 2;
        if (!this.widgetsCreated) {
            this.createWidgets();
        }
        this.itemPanel.x = (n2 + n4) / 2 + 5;
        this.itemPanel.y = 20;
        this.itemPanel.resize();
        this.tabView.x = (n2 + n4) / 2 + 5;
        this.tabView.y = 0;
        this.tabView.width = n2 - this.itemPanel.x - 2;
        this.tabView.height = n3 - 1;
        savedTabName = this.tabView.getActiveChildName();
        this.tabView.resize();
        this.rain.state = TMIUtils.isRaining();
        this.delete.state = this.controller.deleteMode;
        int n8 = TMIUtils.getGameMode();
        this.survival.icon = n8 == 0 ? TMIImages.iconModeSs : TMIImages.iconModeS;
        this.creative.icon = n8 == 1 ? TMIImages.iconModeCs : TMIImages.iconModeC;
        this.adventure.icon = n8 == 2 ? TMIImages.iconModeAs : TMIImages.iconModeA;
        this.canvas.drawRect(0, 0, n2, 18, -16445675);
        String string = "" + (TMIItemPanel.page + 1) + "/" + this.itemPanel.numPages;
        this.canvas.drawText(2, n3 - 13, "TMI 1.5.2 2013-04-25", -1);
        this.rain.show = TMIConfig.canChangeWeather();
        this.survival.show = this.adventure.show = TMIConfig.canChangeCreativeMode();
        this.creative.show = this.adventure.show;
        this.delete.show = TMIConfig.canDelete();
        this.dusk.show = this.midnight.show = TMIConfig.canChangeTime();
        this.noon.show = this.midnight.show;
        this.dawn.show = this.midnight.show;
        this.difficulty.show = TMIConfig.canChangeDifficulty();
        this.health.show = !TMIConfig.isMultiplayer();
        boolean bl2 = TMIConfig.canRestoreSaves();
        int n9 = 0;
        for (n6 = 0; n6 < this.config.getNumSaves(); ++n6) {
            this.deleteButtons[n6].x = -1000;
            this.stateButtons[n6].y = 30 + n6 * 22;
            this.stateButtons[n6].height = 20;
            String string2 = this.config.getSettings().get("save-name" + (n6 + 1));
            if (string2 == null) {
                string2 = "" + (n6 + 1);
            }
            this.stateButtons[n6].label = this.config.isStateSaved(n6) ? "Load " + string2 : "Save " + string2;
            int n10 = this.canvas.getTextWidth(this.stateButtons[n6].label) + 26;
            if (n10 + 2 + 20 > n7) {
                n10 = n7 - 20 - 2;
            }
            if (n10 <= n9) continue;
            n9 = n10;
        }
        for (n6 = 0; n6 < this.config.getNumSaves(); ++n6) {
            this.stateButtons[n6].width = n9;
            this.stateButtons[n6].show = bl2;
            this.deleteButtons[n6].show = bl2;
            if (!this.config.isStateSaved(n6)) continue;
            this.deleteButtons[n6].x = this.stateButtons[n6].width + 2;
            this.deleteButtons[n6].y = this.stateButtons[n6].y;
            this.deleteButtons[n6].width = 20;
            this.deleteButtons[n6].height = 20;
        }
    }

    public void determineTooltip(int n2, int n3) {
        if (this.rain != null && this.rain.contains(n2, n3)) {
            this.setTooltip("Rain/snow is " + (this.rain.state ? "ON" : "OFF"));
        } else if (this.creative != null && this.creative.contains(n2, n3)) {
            this.setTooltip("Creative mode");
        } else if (this.survival != null && this.survival.contains(n2, n3)) {
            this.setTooltip("Survival mode");
        } else if (this.adventure != null && this.adventure.contains(n2, n3)) {
            this.setTooltip("Adventure mode");
        } else if (this.noon != null && this.noon.contains(n2, n3)) {
            this.setTooltip("Set time to noon");
        } else if (this.dawn != null && this.dawn.contains(n2, n3)) {
            this.setTooltip("Set time to sunrise");
        } else if (this.dusk != null && this.dusk.contains(n2, n3)) {
            this.setTooltip("Set time to sunset");
        } else if (this.midnight != null && this.midnight.contains(n2, n3)) {
            this.setTooltip("Set time to midnight");
        } else if (this.difficulty != null && this.difficulty.contains(n2, n3)) {
            this.setTooltip(TMIUtils.getDifficultyString());
        } else if (this.health != null && this.health.contains(n2, n3)) {
            this.setTooltip("Fill health and food");
        } else if (this.delete != null && this.delete.contains(n2, n3)) {
            wm wm2 = TMIUtils.getHeldItem();
            if (wm2 == null) {
                if (TMIUtils.shiftKey()) {
                    this.setTooltip("DELETE ALL ITEMS from current inventory screen");
                } else {
                    this.setTooltip("Delete mode is " + (this.delete.state ? "ON" : "OFF"));
                }
            } else if (TMIUtils.shiftKey()) {
                this.setTooltip("DELETE ALL " + TMIUtils.itemDisplayName(wm2));
            } else {
                this.setTooltip("DELETE " + TMIUtils.itemDisplayName(wm2));
            }
        } else if (this.itemPanel.contains(n2, n3)) {
            wm wm3 = TMIUtils.getHeldItem();
            if (wm3 == null) {
                wm wm4 = this.itemPanel.getHoverItem();
                if (wm4 != null) {
                    if (Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184)) {
                        this.setTooltip("Add " + wm4.c + ":" + wm4.j() + " to favorites");
                    } else {
                        List<String> list = TMIUtils.itemDisplayNameMultiline(wm4, true);
                        this.canvas.drawMultilineTip(n2, n3, list, wm4);
                    }
                }
            } else {
                this.setTooltip("DELETE " + TMIUtils.itemDisplayName(wm3));
            }
        } else if (this.favoritesPanel.contains(n2, n3)) {
            wm wm5 = TMIUtils.getHeldItem();
            if (wm5 == null) {
                wm wm6 = this.favoritesPanel.getHoverItem();
                if (wm6 != null) {
                    if (Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184)) {
                        this.setTooltip("Remove " + TMIUtils.itemDisplayName(wm6));
                    } else {
                        List<String> list = TMIUtils.itemDisplayNameMultiline(wm6, true);
                        this.canvas.drawMultilineTip(n2, n3, list, wm6);
                    }
                }
            } else {
                this.setTooltip("Add " + TMIUtils.itemDisplayName(wm5));
            }
        }
        this.showToolTip(n2, n3);
    }

    public boolean isInitialized() {
        return this.widgetsCreated;
    }

    public void setTooltip(String string) {
        this.activeTooltip = string;
    }

    public String getTooltip() {
        return this.activeTooltip;
    }

    public boolean hasTooltip() {
        return this.activeTooltip != null;
    }

    public void showToolTip(int n2, int n3) {
        if (this.activeTooltip != null) {
            this.canvas.drawTip(n2, n3, this.activeTooltip);
        }
    }
}

