/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import cpw.mods.fml.common.FMLModContainer;
import java.lang.reflect.Field;

public interface ILanguageAdapter {
    public Object getNewInstance(FMLModContainer var1, Class<?> var2, ClassLoader var3) throws Exception;

    public boolean supportsStatics();

    public void setProxy(Field var1, Class<?> var2, Object var3) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException;

    public static class JavaAdapter
    implements ILanguageAdapter {
        @Override
        public Object getNewInstance(FMLModContainer container, Class<?> objectClass, ClassLoader classLoader) throws Exception {
            return objectClass.newInstance();
        }

        @Override
        public boolean supportsStatics() {
            return true;
        }

        @Override
        public void setProxy(Field target, Class<?> proxyTarget, Object proxy) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
            target.set(null, proxy);
        }
    }

    public static class ScalaAdapter
    implements ILanguageAdapter {
        @Override
        public Object getNewInstance(FMLModContainer container, Class<?> scalaObjectClass, ClassLoader classLoader) throws Exception {
            Class<?> sObjectClass = Class.forName(scalaObjectClass.getName() + "$", true, classLoader);
            return sObjectClass.getField("MODULE$").get(null);
        }

        @Override
        public boolean supportsStatics() {
            return false;
        }

        @Override
        public void setProxy(Field target, Class<?> proxyTarget, Object proxy) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
            Field field = proxyTarget.getField("INSTANCE");
            Object scalaObject = field.get(null);
            target.set(scalaObject, proxy);
        }
    }
}

