/*
 * Decompiled with CFR 0.152.
 */
package parachute.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import parachute.common.Parachute;
import parachute.common.PlayerInfo;
import parachute.common.PlayerManagerParachute;

public class EntityParachute
extends Entity {
    private boolean isRotating;
    private int newRotationInc;
    private double newPosX;
    private double newPosY;
    private double newPosZ;
    private double newRotationYaw;
    private double newRotationPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double newMotionZ;
    private double motionFactor;
    private double maxAltitude;
    private boolean allowThermals;
    private static double descentRate;
    private final int hitTime = 10;
    private final int maxDamage = 40;
    static final double ascend = -0.02;
    static final double drift = 0.005;
    static final double descend = 0.03;

    public EntityParachute(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(1.0f, 0.5f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        descentRate = 0.005;
        this.motionFactor = 0.07;
        this.isRotating = true;
        this.allowThermals = Parachute.instance.getAllowThermals();
        this.maxAltitude = Parachute.instance.getMaxAltitude();
    }

    public EntityParachute(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y + (double)this.field_70129_M, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public boolean shouldRiderSit() {
        return this.isNearGround(this.field_70165_t, this.field_70163_u, this.field_70161_v, 4.0);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(1));
        this.field_70180_af.func_75682_a(19, (Object)new Integer(0));
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return -2.5;
    }

    public void destroyParachute() {
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource damagesource, int damage) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + damage);
            this.func_70018_K();
            if (this.getDamageTaken() > 40) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                this.dropRemains();
                this.destroyParachute();
            }
        }
        return true;
    }

    public boolean func_70085_c(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.field_77993_c == Item.field_77745_be.field_77779_bT && this.field_70153_n != null) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70153_n = null;
            }
            if (!entityplayer.field_71075_bZ.field_75098_d) {
                itemstack.func_77972_a(2, (EntityLiving)entityplayer);
            }
            return true;
        }
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int inc) {
        if (this.isRotating) {
            this.newRotationInc = inc + 5;
        } else {
            double newX = x - this.field_70165_t;
            double newY = y - this.field_70163_u;
            double newZ = z - this.field_70161_v;
            double magnitude = newX * newX + newY * newY + newZ * newZ;
            if (magnitude <= 1.0) {
                return;
            }
            this.newRotationInc = 3;
        }
        this.newPosX = x;
        this.newPosY = y;
        this.newPosZ = z;
        this.newRotationYaw = yaw;
        this.newRotationPitch = pitch;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.newMotionZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.velocityX = this.field_70159_w = x;
        this.velocityY = this.field_70181_x = y;
        this.newMotionZ = this.field_70179_y = z;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70153_n == null) {
            if (!this.field_70170_p.field_72995_K) {
                this.dropRemains();
                this.destroyParachute();
            }
            return;
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0) {
            this.setDamageTaken(this.getDamageTaken() - 1);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.checkShouldDropChute(this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0);
        double velocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (this.field_70170_p.field_72995_K && this.isRotating) {
            if (this.newRotationInc > 0) {
                double x = this.field_70165_t + (this.newPosX - this.field_70165_t) / (double)this.newRotationInc;
                double y = this.field_70163_u + (this.newPosY - this.field_70163_u) / (double)this.newRotationInc;
                double z = this.field_70161_v + (this.newPosZ - this.field_70161_v) / (double)this.newRotationInc;
                double adjYaw = MathHelper.func_76138_g((double)(this.newRotationYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + adjYaw / (double)this.newRotationInc);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.newRotationPitch - (double)this.field_70125_A) / (double)this.newRotationInc);
                --this.newRotationInc;
                this.func_70107_b(x, y, z);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                this.field_70181_x -= this.currentDescentRate();
                double x = this.field_70165_t + this.field_70159_w;
                double y = this.field_70163_u + this.field_70181_x;
                double z = this.field_70161_v + this.field_70179_y;
                this.func_70107_b(x, y, z);
                this.field_70159_w *= 0.99;
                this.field_70181_x *= 0.95;
                this.field_70179_y *= 0.99;
            }
        } else {
            double adjustedYaw;
            if (this.field_70153_n != null) {
                this.field_70159_w += this.field_70153_n.field_70159_w * this.motionFactor;
                this.field_70179_y += this.field_70153_n.field_70179_y * this.motionFactor;
                double localvelocity = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                if (localvelocity > 0.35) {
                    double motionAdj = 0.35 / localvelocity;
                    this.field_70159_w *= motionAdj;
                    this.field_70179_y *= motionAdj;
                    localvelocity = 0.35;
                }
                if (localvelocity > velocity && this.motionFactor < 0.35) {
                    this.motionFactor += (0.35 - this.motionFactor) / 35.0;
                    if (this.motionFactor > 0.35) {
                        this.motionFactor = 0.35;
                    }
                } else {
                    this.motionFactor -= (this.motionFactor - 0.07) / 35.0;
                    if (this.motionFactor < 0.07) {
                        this.motionFactor = 0.07;
                    }
                }
                this.field_70181_x -= this.currentDescentRate();
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.99;
            this.field_70181_x *= 0.95;
            this.field_70179_y *= 0.99;
            this.field_70125_A = 0.0f;
            double yaw = this.field_70177_z;
            double delta_X = this.field_70169_q - this.field_70165_t;
            double delta_Z = this.field_70166_s - this.field_70161_v;
            if (delta_X * delta_X + delta_Z * delta_Z > 0.001) {
                yaw = (float)(Math.atan2(delta_Z, delta_X) * (double)57.29578f);
            }
            if ((adjustedYaw = MathHelper.func_76138_g((double)(yaw - (double)this.field_70177_z))) > 45.0) {
                adjustedYaw = 45.0;
            }
            if (adjustedYaw < -45.0) {
                adjustedYaw = -45.0;
            }
            this.field_70177_z = (float)((double)this.field_70177_z + adjustedYaw);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (!this.field_70170_p.field_72995_K) {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.2, 0.0, 0.2));
                if (list != null && list.size() > 0) {
                    for (int k = 0; k < list.size(); ++k) {
                        Entity entity = (Entity)list.get(k);
                        if (entity == this.field_70153_n || !entity.func_70104_M() || !(entity instanceof EntityParachute)) continue;
                        entity.func_70108_f((Entity)this);
                    }
                }
                if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
                    this.field_70153_n = null;
                    if (!this.field_70170_p.field_72995_K) {
                        this.dropRemains();
                        this.destroyParachute();
                    }
                }
            }
        }
    }

    public double currentDescentRate() {
        EntityPlayer player = (EntityPlayer)this.field_70153_n;
        if (player == null) {
            return descentRate;
        }
        PlayerInfo pInfo = PlayerManagerParachute.getInstance().getPlayerInfoFromPlayer(player);
        if (pInfo == null) {
            return descentRate;
        }
        switch (pInfo.mode) {
            case 0: {
                descentRate = 0.005;
                break;
            }
            case 1: {
                descentRate = -0.02;
                break;
            }
            case 2: {
                descentRate = 0.03;
                break;
            }
            default: {
                descentRate = 0.005;
            }
        }
        if (this.maxAltitude > 0.0 && this.field_70163_u >= this.maxAltitude) {
            descentRate = 0.005;
        }
        return descentRate;
    }

    protected boolean checkShouldDropChute(double x, double y, double z, double distance) {
        boolean shouldDrop = false;
        if (this.isNearGround(x, y, z, distance)) {
            if (this.field_70153_n != null) {
                this.field_70153_n.field_70143_R = 0.0f;
                this.field_70153_n.func_70078_a((Entity)this);
                if (!this.field_70170_p.field_72995_K) {
                    this.destroyParachute();
                } else {
                    this.field_70153_n = null;
                }
            }
            shouldDrop = true;
        }
        return shouldDrop;
    }

    public boolean isNearGround(double posx, double posy, double posz, double distance) {
        int z;
        int y;
        boolean nearGround = false;
        int x = MathHelper.func_76128_c((double)posx);
        if (this.field_70170_p.func_72798_a(x, y = MathHelper.func_76128_c((double)(posy - distance)), z = MathHelper.func_76128_c((double)posz)) > 0) {
            nearGround = true;
        }
        return nearGround;
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            double cosYaw = Math.cos((double)this.field_70177_z * 0.01745329252) * 0.4;
            double sinYaw = Math.sin((double)this.field_70177_z * 0.01745329252) * 0.4;
            this.field_70153_n.func_70107_b(this.field_70165_t + cosYaw, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v + sinYaw);
        }
    }

    protected void dropRemains() {
        this.func_70025_b(Block.field_72101_ab.field_71990_ca, 2);
        this.func_70025_b(Item.field_77683_K.field_77779_bT, 1);
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public void setDamageTaken(int damage) {
        this.field_70180_af.func_75692_b(19, (Object)damage);
    }

    public int getDamageTaken() {
        return this.field_70180_af.func_75679_c(19);
    }

    public void setTimeSinceHit(int time) {
        this.field_70180_af.func_75692_b(17, (Object)time);
    }

    public int getTimeSinceHit() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setForwardDirection(int forward) {
        this.field_70180_af.func_75692_b(18, (Object)forward);
    }

    public int getForwardDirection() {
        return this.field_70180_af.func_75679_c(18);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70270_d(boolean par1) {
        this.isRotating = par1;
    }
}

