/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.gui;

import java.util.List;

public class GuiControlsPaginated
extends axr {
    protected int controlsPerPage;
    protected int startIndex;
    protected int endIndex;
    protected axr parentScreen;
    protected avy gameSettings;
    protected awg btnNext;
    protected awg btnPrevious;
    protected String screenTitle = "Controls";
    protected int activeButtonId = -1;

    public GuiControlsPaginated(axr parentScreen, avy gameSettings) {
        this.parentScreen = parentScreen;
        this.gameSettings = gameSettings;
        this.controlsPerPage = 14;
        this.endIndex = this.gameSettings.W.length - (this.gameSettings.W.length % this.controlsPerPage == 0 ? this.controlsPerPage : this.gameSettings.W.length % this.controlsPerPage);
    }

    protected List getLegacyControlList() {
        return this.k;
    }

    protected final int getHeight() {
        return this.i;
    }

    protected final int getWidth() {
        return this.h;
    }

    public axr getParentScreen() {
        return this.parentScreen;
    }

    @Override
    public void A_() {
        bp stringtranslate = bp.a();
        this.getLegacyControlList().clear();
        int oldControlsPerPage = this.controlsPerPage;
        this.controlsPerPage = (this.getHeight() - 70) / 24 * 2;
        this.endIndex = this.gameSettings.W.length - (this.gameSettings.W.length % this.controlsPerPage == 0 ? this.controlsPerPage : this.gameSettings.W.length % this.controlsPerPage);
        if (oldControlsPerPage != this.controlsPerPage) {
            this.startIndex = 0;
        }
        for (int controlId = 0; controlId < this.gameSettings.W.length; ++controlId) {
            boolean buttonVisible = controlId >= this.startIndex && controlId < this.startIndex + this.controlsPerPage;
            int left = buttonVisible ? this.getWidth() / 2 - 155 : this.getWidth() + 10000;
            int top = this.getHeight() / 6 + 24 * (controlId - this.startIndex >> 1);
            this.getLegacyControlList().add(new axy(controlId, left + (controlId - this.startIndex) % 2 * 160, top, 70, 20, this.gameSettings.b(controlId)));
        }
        int buttonY = this.getHeight() / 6 + (this.controlsPerPage >> 1) * 24;
        if (this.gameSettings.W.length > this.controlsPerPage) {
            this.btnNext = new awg(201, this.getWidth() / 2 - 51, buttonY, 50, 20, ">>");
            this.getLegacyControlList().add(this.btnNext);
            this.btnPrevious = new awg(202, this.getWidth() / 2 - 103, buttonY, 50, 20, "<<");
            this.getLegacyControlList().add(this.btnPrevious);
            this.getLegacyControlList().add(new awg(200, this.getWidth() / 2 + 1, buttonY, 100, 20, stringtranslate.a("gui.done")));
            this.btnNext.g = this.startIndex < this.endIndex;
            this.btnPrevious.g = this.startIndex > 0;
        } else {
            this.getLegacyControlList().add(new awg(200, this.getWidth() / 2 - 100, buttonY, stringtranslate.a("gui.done")));
        }
        this.screenTitle = stringtranslate.a("controls.title");
    }

    protected String getKeybindDescription(int controlId) {
        return this.gameSettings.a(controlId);
    }

    @Override
    protected void a(awg guibutton) {
        for (int i2 = 0; i2 < this.gameSettings.W.length; ++i2) {
            ((awg)this.getLegacyControlList().get((int)i2)).e = this.gameSettings.b(i2);
        }
        if (guibutton.f == 200) {
            this.g.a(this.parentScreen);
        } else if (guibutton.f == 201) {
            this.startIndex += this.controlsPerPage;
            this.startIndex = Math.min(this.endIndex, this.startIndex);
            this.A_();
        } else if (guibutton.f == 202) {
            this.startIndex -= this.controlsPerPage;
            this.startIndex = Math.max(0, this.startIndex);
            this.A_();
        } else {
            this.activeButtonId = guibutton.f;
            guibutton.e = String.format("> %s <", this.gameSettings.b(guibutton.f));
        }
    }

    @Override
    protected void a(int mouseX, int mouseY, int mouseButton) {
        if (this.activeButtonId >= 0) {
            this.gameSettings.a(this.activeButtonId, -100 + mouseButton);
            ((awg)this.getLegacyControlList().get((int)this.activeButtonId)).e = this.gameSettings.b(this.activeButtonId);
            this.activeButtonId = -1;
            ava.b();
        } else {
            super.a(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    protected void a(char keyChar, int keyCode) {
        if (this.activeButtonId >= 0) {
            this.gameSettings.a(this.activeButtonId, keyCode);
            ((awg)this.getLegacyControlList().get((int)this.activeButtonId)).e = this.gameSettings.b(this.activeButtonId);
            this.activeButtonId = -1;
            ava.b();
        } else {
            super.a(keyChar, keyCode);
        }
    }

    @Override
    public void a(int mouseX, int mouseY, float partialTick) {
        this.e();
        this.a(this.m, this.screenTitle, this.h / 2, 20, 0xFFFFFF);
        for (int controlId = 0; controlId < this.gameSettings.W.length; ++controlId) {
            boolean conflict = false;
            for (int id2 = 0; id2 < this.gameSettings.W.length; ++id2) {
                if (id2 == controlId || this.gameSettings.W[controlId].d != this.gameSettings.W[id2].d) continue;
                conflict = true;
                break;
            }
            ((awg)this.getLegacyControlList().get((int)controlId)).e = this.activeButtonId == controlId ? "\u00a7f> \u00a7e??? \u00a7f<" : (conflict ? "\u00a7c" + this.gameSettings.b(controlId) : this.gameSettings.b(controlId));
            int left = controlId >= this.startIndex && controlId < this.startIndex + this.controlsPerPage ? this.getWidth() / 2 - 155 : this.getWidth() + 10000;
            this.b(this.m, this.getKeybindDescription(controlId), left + (controlId - this.startIndex) % 2 * 160 + 70 + 6, this.getHeight() / 6 + 24 * (controlId - this.startIndex >> 1) + 7, 0xFFFFFF);
        }
        super.a(mouseX, mouseY, partialTick);
    }
}

