/**
 * Copyright 2013 Yamato
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package mod.ymt.air;

import mod.ymt.cmn.Coord3D;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderManager;

/**
 * @author Yamato
 *
 */
public interface Operator {
	public boolean hasSpecialRender();

	public boolean putBlocksToWorld(Materializer owner, ScanTime time, BlockData data, Coord3D target, int rotate);

	public void register(AirCraftCore core);

	public boolean removeBlockFromWorld(Materializer owner, ScanTime time, Coord3D pos, Coord3D base);
	
	public void renderBlock(RenderBlocks render, BlockData data);

	public void renderBlockSpecial(RenderManager manager, RenderBlocks render, BlockData data);
}
