/**
 * Copyright 2013 Yamato
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package mod.ymt.air.op;

import java.util.Set;
import mod.ymt.air.Materializer;
import net.minecraft.src.Block;

/**
 * @author Yamato
 *
 */
public class NormalOperator extends AbstractOperator {
	@Override
	protected void addMoveableBlockIds(Set<Integer> result) {
		result.add(Block.stone.blockID);
		result.add(Block.grass.blockID);
		result.add(Block.dirt.blockID);
		result.add(Block.cobblestone.blockID);
		result.add(Block.planks.blockID); // ؍
		result.add(Block.sand.blockID);
		result.add(Block.gravel.blockID);
		result.add(Block.oreGold.blockID);
		result.add(Block.oreIron.blockID);
		result.add(Block.oreCoal.blockID);
		result.add(Block.leaves.blockID);
		result.add(Block.sponge.blockID);
		result.add(Block.glass.blockID);
		result.add(Block.oreLapis.blockID);
		result.add(Block.blockLapis.blockID);
		result.add(Block.sandStone.blockID);
		result.add(Block.web.blockID);
		result.add(Block.cloth.blockID);
		result.add(Block.blockGold.blockID);
		result.add(Block.blockIron.blockID);
		result.add(Block.stoneDoubleSlab.blockID); // ΂̃n[tubNid
		result.add(Block.stoneSingleSlab.blockID); // ΂̃n[tubN
		result.add(Block.brick.blockID); // K
		result.add(Block.tnt.blockID);
		result.add(Block.bookShelf.blockID);
		result.add(Block.cobblestoneMossy.blockID); // ې
		result.add(Block.obsidian.blockID); // jΓƁAlU[|[^j]
		result.add(Block.oreDiamond.blockID);
		result.add(Block.blockDiamond.blockID);
		result.add(Block.tilledField.blockID); // _n
		result.add(Block.oreRedstone.blockID);
		result.add(Block.oreRedstoneGlowing.blockID);
		result.add(Block.ice.blockID);
		result.add(Block.blockSnow.blockID);
		result.add(Block.blockClay.blockID);
		result.add(Block.fence.blockID);
		result.add(Block.netherrack.blockID); // lU[bN
		result.add(Block.slowSand.blockID); // \ETh
		result.add(Block.glowStone.blockID);
		result.add(Block.silverfish.blockID); // Vo[tBbVubN
		result.add(Block.stoneBrick.blockID); // ΃K
		result.add(Block.mushroomCapRed.blockID); // ԂLmRubN
		result.add(Block.mushroomCapBrown.blockID); // F̃LmRubN
		result.add(Block.fenceIron.blockID); // StFX
		result.add(Block.thinGlass.blockID); // KX
		result.add(Block.melon.blockID); // 
		result.add(Block.mycelium.blockID); // ێubN
		result.add(Block.netherBrick.blockID); // lU[K
		result.add(Block.netherFence.blockID); // lU[KtFX
		result.add(Block.whiteStone.blockID); // GhXg[
		result.add(Block.redstoneLampIdle.blockID); // bhXg[v()
		result.add(Block.redstoneLampActive.blockID); // bhXg[v(_)
		result.add(Block.woodDoubleSlab.blockID); // ؂̃n[tubNid
		result.add(Block.woodSingleSlab.blockID); // ؂̃n[tubN
		result.add(Block.oreEmerald.blockID);
		result.add(Block.blockEmerald.blockID);
		result.add(Block.cobblestoneWall.blockID); // ې΃tFX
		result.add(Block.workbench.blockID); // Ƒ NormalOperator ňړ\
		result.add(Block.cauldron.blockID); // 劘
		result.add(Block.blockRedstone.blockID); // bhXg[ubN
		result.add(Block.oreNetherQuartz.blockID); // lU[z
		result.add(Block.blockNetherQuartz.blockID); // lU[ubN
		// AbstractOperator  TileEntity ɑΉ̂ŁABlockContainer 
		result.add(Block.music.blockID); // m[gubN
	}

	@Override
	protected boolean setRealBlockWithRotation(Materializer owner, int blockId, int metadata, int x, int y, int z, int rotate) {
		return setRealBlock(owner, blockId, metadata, x, y, z);
	}
}
