/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.authoring.debug.model;

import com.adobe.authoring.debug.AuthDebugException;
import com.adobe.authoring.debug.AuthDebugMgr;
import com.adobe.authoring.debug.model.AuthDebugElement;
import com.adobe.authoring.debug.model.AuthDebugTarget;
import com.adobe.authoring.debug.model.AuthStackFrame;
import com.adobe.authoring.debug.model.AuthVariable;
import com.adobe.authoring.debug.model.DebugElementNoLongerExistsException;
import com.adobe.authoring.debug.model.IAuthMemberVariable;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.Variable;

public class AuthMemberVariable
extends AuthVariable
implements IAuthMemberVariable {
    private final long fParentVarId;
    private final AuthVariable fParent;
    private String fDecoratedName;
    private Integer asArrayIndex = null;

    public AuthMemberVariable(AuthDebugTarget debugTarget, AuthVariable parent, Variable underlyingVariable, String name) throws DebugElementNoLongerExistsException {
        super(debugTarget, underlyingVariable, name);
        this.fParent = parent;
        this.fParentVarId = parent.getFlashVariable().getValue().getId();
    }

    public AuthDebugElement getParent() {
        return this.fParent;
    }

    protected long getParentVarId() {
        return this.fParentVarId;
    }

    public Variable getFlashVariable() throws DebugElementNoLongerExistsException {
        try {
            Variable v = this.fParent.getFlashVariable().getValue().getMemberNamed(this.getAuthDebugTarget().getSession(), this.getName());
            if (v == null) {
                throw new DebugElementNoLongerExistsException(1);
            }
            return v;
        }
        catch (NotSuspendedException e) {
            throw new DebugElementNoLongerExistsException(1);
        }
        catch (NotConnectedException e) {
            throw new DebugElementNoLongerExistsException(1);
        }
        catch (NoResponseException e) {
            AuthDebugMgr.log(e);
            throw new DebugElementNoLongerExistsException(1);
        }
    }

    private boolean isMemberOfXML() throws DebugElementNoLongerExistsException, AuthDebugException {
        String referenceTypeName = this.fParent.getValue().getReferenceTypeName();
        return referenceTypeName.equals("XML");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName() throws DebugElementNoLongerExistsException, AuthDebugException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.fDecoratedName == null) {
                String name = this.getName();
                int arrayIndex = this.asArrayIndex();
                this.fDecoratedName = arrayIndex >= 0 ? (this.isMemberOfXML() ? "*[" + name + "]" : "[" + name + "]") : name;
            }
        }
        return this.fDecoratedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int asArrayIndex() {
        AuthMemberVariable authMemberVariable = this;
        synchronized (authMemberVariable) {
            if (this.asArrayIndex == null) {
                try {
                    String name = this.getName();
                    this.asArrayIndex = new Integer(name);
                    if (this.asArrayIndex < 0 || !this.asArrayIndex.toString().equals(name)) {
                        this.asArrayIndex = new Integer(-1);
                    }
                }
                catch (NumberFormatException e) {
                    this.asArrayIndex = new Integer(-1);
                }
            }
            return this.asArrayIndex;
        }
    }

    protected AuthStackFrame getParentFrame() {
        return this.fParent.getParentFrame();
    }

    public String getExpressionText() throws DebugElementNoLongerExistsException, AuthDebugException {
        String parentExpressionText = this.fParent.getExpressionText();
        String name = this.getName();
        if (this.asArrayIndex() >= 0) {
            if (this.fParent.getValue().getReferenceTypeName().equals("XML")) {
                return parentExpressionText + ".*[" + name + "]";
            }
            return parentExpressionText + "[" + name + "]";
        }
        return parentExpressionText + "." + name;
    }
}

