/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.authoring.debug.model;

import com.adobe.authoring.debug.AuthDebugException;
import com.adobe.authoring.debug.model.AuthArgumentVariable;
import com.adobe.authoring.debug.model.AuthDebugElement;
import com.adobe.authoring.debug.model.AuthLocalVariable;
import com.adobe.authoring.debug.model.AuthMemberVariable;
import com.adobe.authoring.debug.model.AuthScopeChainVariable;
import com.adobe.authoring.debug.model.AuthStackVariable;
import com.adobe.authoring.debug.model.AuthThisVariable;
import com.adobe.authoring.debug.model.AuthThread;
import com.adobe.authoring.debug.model.AuthVariable;
import com.adobe.authoring.debug.model.DebugElementNoLongerExistsException;
import com.adobe.authoring.debug.model.IAuthVariable;
import com.adobe.authoring.debug.model.Messages;
import com.adobe.authoring.debug.model.ScopeChainVariable;
import flash.tools.debugger.Frame;
import flash.tools.debugger.Location;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.Variable;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class AuthStackFrame
extends AuthDebugElement {
    private Frame fFrame;
    private AuthThread fThread;
    private String fName;
    private int fLine;
    private String fPackageAndFilename;
    private String fFilename;
    private String fFullPath;
    private int fIndexFromBottom = -2;
    private int fTotalFrames = 0;
    private volatile IAuthVariable[] fVariables;
    private boolean fIsValid;
    private static final Variable[] EMPTY_VARIABLES_ARRAY;
    private static final IAuthVariable[] EMPTY_IVARIABLES_ARRAY;
    private Variable[] fThis;
    private Variable fScopeChainHead;
    private Variable[] fRawScopeChain;
    private AuthVariable[] fScopeChain;
    private LinkedHashMap fArgs = new LinkedHashMap();
    private LinkedHashMap fLocals = new LinkedHashMap();
    private boolean fShowScopeChain;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AuthStackFrame(AuthThread thread, Frame frame, int indexFromBottom, int totalFrames) {
        super(thread.getAuthDebugTarget());
        this.fThread = thread;
        this.bind(frame, indexFromBottom, totalFrames);
    }

    private void init() {
        SourceFile sourceFile;
        this.fIsValid = true;
        Location location = this.fFrame.getLocation();
        this.fLine = location.getLine();
        if (this.fLine == 0) {
            this.fLine = -1;
        }
        if ((sourceFile = location.getFile()) != null) {
            String fullPath = sourceFile.getFullPath();
            if (fullPath != null && fullPath.length() > 0) {
                this.fFullPath = fullPath;
            }
            this.fFilename = sourceFile.getName();
            if (this.fFilename.length() == 0) {
                this.fFilename = null;
            }
            if (this.fFilename != null && this.fFilename.length() > 0) {
                String packageName = sourceFile.getPackageName();
                if (packageName == null || packageName.length() == 0) {
                    this.fPackageAndFilename = this.fFilename;
                } else {
                    this.fPackageAndFilename = packageName + File.separatorChar + this.fFilename;
                    this.fPackageAndFilename = File.separatorChar == '/' ? this.fPackageAndFilename.replace('\\', '/') : this.fPackageAndFilename.replace('/', '\\');
                }
            }
        }
        this.fName = this.fFrame.getCallSignature();
        if (this.fName == null || this.fName.length() == 0 || this.fName.endsWith("/")) {
            if (this.fFilename != null) {
                this.fName = this.fFilename;
                if (this.fLine > 0) {
                    this.fName = MessageFormat.format(Messages.getString("AuthStackFrame.DebugViewStacktraceFilenamePlusLineNumber"), this.fName, Integer.toString(this.fLine));
                }
            } else {
                this.fName = Messages.getString("AuthStackFrame.UnknownFunction");
            }
        } else if (this.fPackageAndFilename == null) {
            this.fName = this.fName + Messages.getString("AuthStackFrame.NoSource");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthStackFrame bind(Frame frame, int indexFromBottom, int totalFrames) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.fIndexFromBottom == -2) {
                this.fFrame = frame;
                this.fIndexFromBottom = indexFromBottom;
                this.fTotalFrames = totalFrames;
                this.init();
                return this;
            }
            if (indexFromBottom == -1) {
                this.fFrame = null;
                this.fIndexFromBottom = -1;
                this.fTotalFrames = totalFrames;
                this.fIsValid = false;
                return null;
            }
            if (this.fIndexFromBottom == indexFromBottom && frame.getCallSignature().equals(this.fFrame.getCallSignature())) {
                this.fFrame = frame;
                this.fTotalFrames = totalFrames;
                this.init();
                return this;
            }
            this.bind(null, -1, 0);
            return new AuthStackFrame(this.fThread, frame, indexFromBottom, totalFrames);
        }
    }

    public Variable getRawThis() throws DebugElementNoLongerExistsException {
        this.initVariables();
        if (this.fThis.length == 0) {
            throw new DebugElementNoLongerExistsException(1);
        }
        return this.fThis[0];
    }

    public Variable getRawScopeChainHead() throws DebugElementNoLongerExistsException {
        this.initVariables();
        return this.fScopeChainHead;
    }

    public Variable[] getRawScopeChain() throws DebugElementNoLongerExistsException {
        this.initVariables();
        return this.fRawScopeChain;
    }

    public AuthVariable[] getScopeChain() {
        block2: {
            try {
                this.initVariables();
            }
            catch (DebugElementNoLongerExistsException e) {
                if ($assertionsDisabled || this.fScopeChain.length == 0) break block2;
                throw new AssertionError();
            }
        }
        return this.fScopeChain;
    }

    public Variable getRawArgument(String name) throws DebugElementNoLongerExistsException {
        this.initVariables();
        Variable v = (Variable)this.fArgs.get(name);
        if (v == null) {
            throw new DebugElementNoLongerExistsException(1);
        }
        return v;
    }

    public Variable getRawLocal(String name) throws DebugElementNoLongerExistsException {
        this.initVariables();
        Variable v = (Variable)this.fLocals.get(name);
        if (v == null) {
            throw new DebugElementNoLongerExistsException(1);
        }
        return v;
    }

    private boolean assertNoNulls(String arrayName, Variable[] vars) {
        for (int i = 0; i < vars.length; ++i) {
            if (!$assertionsDisabled && vars[i] == null) {
                throw new AssertionError((Object)(arrayName + "[" + i + "] != null"));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initVariables() throws DebugElementNoLongerExistsException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.fVariables == null || !this.isStateSynchronized() && this.isSuspended()) {
                Variable v;
                int i;
                this.synchronizeState();
                this.fThis = EMPTY_VARIABLES_ARRAY;
                this.fArgs.clear();
                this.fLocals.clear();
                this.fScopeChainHead = null;
                this.fRawScopeChain = EMPTY_VARIABLES_ARRAY;
                this.fScopeChain = new AuthVariable[0];
                this.fVariables = EMPTY_IVARIABLES_ARRAY;
                this.fShowScopeChain = false;
                this.fThread.getStackFrames();
                if (!this.fIsValid) {
                    throw new DebugElementNoLongerExistsException(2);
                }
                Session session = this.getAuthDebugTarget().getSession();
                try {
                    Variable v2 = this.fFrame.getThis(session);
                    if (v2 != null) {
                        this.fThis = new Variable[]{v2};
                    }
                    this.fRawScopeChain = this.fFrame.getScopeChain(session);
                    Variable[] args = this.fFrame.getArguments(session);
                    for (int i2 = 0; i2 < args.length; ++i2) {
                        this.fArgs.put(args[i2].getName(), args[i2]);
                    }
                    Variable[] locals = this.fFrame.getLocals(session);
                    for (i = 0; i < locals.length; ++i) {
                        this.fLocals.put(locals[i].getName(), locals[i]);
                    }
                }
                catch (NoResponseException e) {
                }
                catch (NotSuspendedException e) {
                }
                catch (NotConnectedException e) {
                    // empty catch block
                }
                if (!$assertionsDisabled && !this.assertNoNulls("fThis", this.fThis)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !this.assertNoNulls("fScopeChain", this.fRawScopeChain)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !this.assertNoNulls("fArgs", this.fArgs.values().toArray(new Variable[0]))) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !this.assertNoNulls("fLocals", this.fLocals.values().toArray(new Variable[0]))) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this.fThis.length != 0 && this.fThis[0].getName() == null) {
                    throw new AssertionError();
                }
                ArrayList<AuthStackVariable> variables = new ArrayList<AuthStackVariable>();
                if (this.fThis.length > 0) {
                    variables.add(new AuthThisVariable(this.getAuthDebugTarget(), this, this.fThis[0]));
                }
                if (this.fRawScopeChain != null && this.fRawScopeChain.length > 0) {
                    Variable topScopeChainEntry = null;
                    for (i = 0; i < this.fRawScopeChain.length; ++i) {
                        String typename = this.fRawScopeChain[i].getValue().getTypeName();
                        int at = typename.indexOf(64);
                        if (at != -1 && (typename = typename.substring(0, at)).equals(this.fFrame.getCallSignature())) continue;
                        topScopeChainEntry = this.fRawScopeChain[i];
                        break;
                    }
                    this.fShowScopeChain = true;
                    if (this.fThis.length > 0 && this.fThis[0].getValue().equals(topScopeChainEntry.getValue())) {
                        this.fShowScopeChain = false;
                    } else if (topScopeChainEntry.getValue().getTypeName().indexOf("$@") != -1) {
                        this.fShowScopeChain = false;
                    }
                    this.fScopeChainHead = new ScopeChainVariable(this);
                    AuthScopeChainVariable scopeChain = new AuthScopeChainVariable(this.getAuthDebugTarget(), this, this.fScopeChainHead, this.fScopeChainHead.getName());
                    if (this.fShowScopeChain) {
                        variables.add(scopeChain);
                    }
                    this.fScopeChain = new AuthVariable[this.fRawScopeChain.length];
                    for (int i3 = 0; i3 < this.fRawScopeChain.length; ++i3) {
                        Variable v3 = this.fRawScopeChain[i3];
                        this.fScopeChain[i3] = new AuthMemberVariable(this.getAuthDebugTarget(), scopeChain, v3, v3.getName());
                        this.fScopeChain[i3].setScopeChainMember(true);
                    }
                }
                Iterator iter = this.fArgs.values().iterator();
                while (iter.hasNext()) {
                    v = (Variable)iter.next();
                    AuthArgumentVariable arg = new AuthArgumentVariable(this.getAuthDebugTarget(), this, v, v.getName());
                    variables.add(arg);
                }
                iter = this.fLocals.values().iterator();
                while (iter.hasNext()) {
                    v = (Variable)iter.next();
                    AuthLocalVariable local = new AuthLocalVariable(this.getAuthDebugTarget(), this, v, v.getName());
                    variables.add(local);
                }
                this.fVariables = variables.toArray(new IAuthVariable[variables.size()]);
            }
        }
    }

    public boolean isShowScopeChain() {
        try {
            this.initVariables();
        }
        catch (DebugElementNoLongerExistsException debugElementNoLongerExistsException) {
            // empty catch block
        }
        return this.fShowScopeChain;
    }

    public AuthThread getThread() {
        return this.fThread;
    }

    public IAuthVariable[] getVariables() {
        block2: {
            try {
                this.initVariables();
            }
            catch (DebugElementNoLongerExistsException e) {
                if ($assertionsDisabled || this.fVariables != null && this.fVariables.length == 0) break block2;
                throw new AssertionError();
            }
        }
        return this.fVariables;
    }

    public boolean hasVariables() {
        block2: {
            try {
                this.initVariables();
            }
            catch (DebugElementNoLongerExistsException e) {
                if ($assertionsDisabled || !this.fIsValid) break block2;
                throw new AssertionError();
            }
        }
        return this.fIsValid && this.fVariables.length > 0;
    }

    public int getLineNumber() {
        return this.fLine;
    }

    public String getName() {
        return this.fName;
    }

    public String getFullPath() {
        return this.fFullPath;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws AuthDebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws AuthDebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws AuthDebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws AuthDebugException {
        this.getThread().resume();
    }

    public void suspend() throws AuthDebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws AuthDebugException {
        this.getThread().terminate();
    }

    public boolean isValid() {
        try {
            this.initVariables();
        }
        catch (DebugElementNoLongerExistsException debugElementNoLongerExistsException) {
            // empty catch block
        }
        return this.fIsValid;
    }

    public AuthThisVariable getThis() {
        try {
            this.initVariables();
        }
        catch (DebugElementNoLongerExistsException debugElementNoLongerExistsException) {
            // empty catch block
        }
        if (this.fVariables.length > 0 && this.fVariables[0] instanceof AuthThisVariable) {
            return (AuthThisVariable)this.fVariables[0];
        }
        return null;
    }

    public String getSourceName() {
        return this.fFilename;
    }

    public int getIndexFromTop() {
        return this.fTotalFrames - 1 - this.getIndexFromBottom();
    }

    public int getIndexFromBottom() {
        return this.fIndexFromBottom;
    }

    public String getPackageAndFilename() {
        return this.fPackageAndFilename;
    }

    public boolean canDisconnect() {
        return this.getAuthDebugTarget().canDisconnect();
    }

    public void disconnect() {
        this.getAuthDebugTarget().disconnect();
    }

    public boolean isDisconnected() {
        return this.getAuthDebugTarget().isDisconnected();
    }

    public static AuthStackFrame forObject(Object o) {
        while (o instanceof AuthMemberVariable) {
            o = ((AuthMemberVariable)o).getParent();
        }
        if (o instanceof AuthStackVariable) {
            o = ((AuthStackVariable)o).getParentFrame();
        }
        if (o instanceof AuthStackFrame) {
            return (AuthStackFrame)o;
        }
        return null;
    }

    static {
        $assertionsDisabled = !AuthStackFrame.class.desiredAssertionStatus();
        EMPTY_VARIABLES_ARRAY = new Variable[0];
        EMPTY_IVARIABLES_ARRAY = new IAuthVariable[0];
    }
}

