/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.authoring.debug.model;

import com.adobe.authoring.debug.AuthDebugException;
import com.adobe.authoring.debug.AuthDebugMgr;
import com.adobe.authoring.debug.model.AuthDebugElement;
import com.adobe.authoring.debug.model.AuthDebugTarget;
import com.adobe.authoring.debug.model.AuthStackFrame;
import com.adobe.authoring.debug.model.DebugElementNoLongerExistsException;
import flash.tools.debugger.Frame;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.Session;
import java.util.ArrayList;

public class AuthThread
extends AuthDebugElement {
    private static final AuthStackFrame[] EMPTY_STACK;
    private boolean fStepping = false;
    private AuthStackFrame[] fStackframes;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AuthThread(AuthDebugTarget target) {
        super(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthStackFrame[] getStackFrames() {
        Object object = this.getLock();
        synchronized (object) {
            if (!this.isSuspended()) {
                return EMPTY_STACK;
            }
            if (!this.isStateSynchronized()) {
                this.synchronizeState();
                try {
                    Session session = this.getAuthDebugTarget().getSession();
                    if (!$assertionsDisabled && session == null) {
                        throw new AssertionError();
                    }
                    Frame[] frames = session.getFrames();
                    int oldSize = this.fStackframes != null ? this.fStackframes.length : 0;
                    int newSize = frames.length;
                    ArrayList<AuthStackFrame> newStackFrames = new ArrayList<AuthStackFrame>(newSize);
                    if (this.fStackframes != null) {
                        for (int i = 0; i < this.fStackframes.length; ++i) {
                            newStackFrames.add(this.fStackframes[i]);
                        }
                    }
                    int discard = oldSize - newSize;
                    for (int i = 0; i < discard; ++i) {
                        AuthStackFrame invalid = (AuthStackFrame)newStackFrames.remove(0);
                        invalid.bind(null, -1, 0);
                    }
                    int newFrames = newSize - oldSize;
                    int depth = oldSize;
                    for (int i = newFrames - 1; i >= 0; --i) {
                        newStackFrames.add(0, new AuthStackFrame(this, frames[i], depth, newSize));
                        ++depth;
                    }
                    int numToRebind = Math.min(newSize, oldSize);
                    int offset = newSize - 1;
                    for (depth = 0; depth < numToRebind; ++depth) {
                        Frame frame;
                        AuthStackFrame oldFrame = (AuthStackFrame)newStackFrames.get(offset);
                        AuthStackFrame newFrame = oldFrame.bind(frame = frames[offset], depth, newSize);
                        if (newFrame != oldFrame) {
                            newStackFrames.set(offset, newFrame);
                        }
                        --offset;
                    }
                    this.fStackframes = newStackFrames.toArray(new AuthStackFrame[newStackFrames.size()]);
                }
                catch (DebugElementNoLongerExistsException e) {
                }
                catch (NotConnectedException notConnectedException) {
                    // empty catch block
                }
                if (this.fStackframes == null) {
                    this.fStackframes = EMPTY_STACK;
                }
            }
            return this.fStackframes;
        }
    }

    public boolean hasStackFrames() throws AuthDebugException {
        return this.isSuspended();
    }

    public AuthStackFrame getTopStackFrame() throws AuthDebugException {
        AuthStackFrame[] frames = this.getStackFrames();
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public boolean canResume() {
        return AuthDebugMgr.getAuthMgr().getDebugTarget().canResume();
    }

    public boolean canSuspend() {
        return AuthDebugMgr.getAuthMgr().getDebugTarget().canSuspend();
    }

    public boolean isSuspended() {
        return AuthDebugMgr.getAuthMgr().getDebugTarget().isSuspended();
    }

    public void resume() throws AuthDebugException {
        AuthDebugMgr.getAuthMgr().getDebugTarget().resume();
    }

    public void suspend() throws AuthDebugException {
        AuthDebugMgr.getAuthMgr().getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return this.isSuspended() && this.getStackFrames().length > 1;
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    public void stepInto() throws AuthDebugException {
        this.getAuthDebugTarget().stepInto();
    }

    public void stepOver() throws AuthDebugException {
        this.getAuthDebugTarget().stepOver();
    }

    public void stepReturn() throws AuthDebugException {
        this.getAuthDebugTarget().stepReturn();
    }

    public boolean canTerminate() {
        return AuthDebugMgr.getAuthMgr().getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return AuthDebugMgr.getAuthMgr().getDebugTarget().isTerminated();
    }

    public void terminate() throws AuthDebugException {
        AuthDebugMgr.getAuthMgr().getDebugTarget().terminate();
    }

    protected void setStepping(boolean stepping) {
        this.fStepping = stepping;
    }

    public boolean canDisconnect() {
        return this.getAuthDebugTarget().canDisconnect();
    }

    public void disconnect() {
        this.getAuthDebugTarget().disconnect();
    }

    public boolean isDisconnected() {
        return this.getAuthDebugTarget().isDisconnected();
    }

    static {
        $assertionsDisabled = !AuthThread.class.desiredAssertionStatus();
        EMPTY_STACK = new AuthStackFrame[0];
    }
}

