/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends FilterInputStream {
    private long offset;

    public CountingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.offset;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.offset += (long)n3;
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray);
        if (n > 0) {
            this.offset += (long)n;
        }
        return n;
    }

    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        if (l2 > 0L) {
            this.offset += l2;
        }
        return l2;
    }

    public long getOffset() {
        return this.offset;
    }
}

