/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.stream.ByteReaderInputByteStream;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStreamImpl;
import com.adobe.internal.io.stream.OutputStreamImpl;
import com.adobe.internal.io.stream.SkippingOutputStream;
import com.adobe.internal.io.stream.StreamManager;
import java.io.IOException;

class ByteWriterOutputByteStream
extends OutputByteStreamImpl {
    private ByteWriter byteWriter = null;
    private StreamManager streamManager;
    private boolean registered = false;

    ByteWriterOutputByteStream(StreamManager streamManager, ByteWriter byteWriter, boolean bl) throws IOException {
        if (byteWriter == null) {
            throw new IOException("Null ByteWriter parameter.");
        }
        this.streamManager = streamManager;
        this.byteWriter = byteWriter;
        this.registered = bl;
        if (bl) {
            this.streamManager.registerOutputByteStream(this, byteWriter);
        }
    }

    ByteWriter getByteWriter() {
        return this.byteWriter;
    }

    public void write(int n) throws IOException {
        this.byteWriter.write(this.getPosition(), n);
        this.seek(this.getPosition() + 1L);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.byteWriter.write(this.getPosition(), byArray, n, n2);
        this.seek(this.getPosition() + (long)n2);
    }

    public long length() throws IOException {
        return this.byteWriter.length();
    }

    public boolean eof() throws IOException {
        return this.getPosition() >= this.byteWriter.length();
    }

    public void close() throws IOException {
        if (this.registered) {
            this.streamManager.deregisterOutputByteStream(this, this.byteWriter);
        } else {
            this.byteWriter.close();
        }
        this.byteWriter = null;
    }

    public InputByteStream closeAndConvert() throws IOException {
        ByteWriter byteWriter = this.byteWriter;
        ByteReaderInputByteStream byteReaderInputByteStream = new ByteReaderInputByteStream(this.streamManager, byteWriter, this.registered);
        if (this.registered) {
            this.streamManager.deregisterOutputByteStream(this, this.byteWriter);
        }
        this.byteWriter = null;
        return byteReaderInputByteStream;
    }

    public void flush() throws IOException {
        this.byteWriter.flush();
    }

    public SkippingOutputStream toOutputStream() throws IOException {
        return new OutputStreamImpl(this);
    }

    public String toString() {
        String string = null;
        try {
            byte[] byArray = new byte[1000];
            long l = Math.max(this.getPosition() - 1000L, 0L);
            long l2 = this.byteWriter.read(l, byArray, 0, byArray.length);
            string = new String("OutputByteStream [ position = " + this.getPosition() + ", limit = " + this.length() + " ] " + (l2 == -1L ? "" : new String(byArray, 0, (int)l2, "US-ASCII")));
        }
        catch (Exception exception) {
            return "";
        }
        return string;
    }

    public void write(String string) throws IOException {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        this.write(byArray);
    }
}

