/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.InputByteStreamImpl;
import java.io.IOException;

public class PaddedInputByteStream
extends InputByteStreamImpl {
    private InputByteStream baseIBS;
    private int paddedChar = 32;
    private long padLength = 0L;
    private long padMark = 0L;

    public PaddedInputByteStream(InputByteStream inputByteStream, int n, long l) {
        this.baseIBS = inputByteStream;
        this.paddedChar = n;
        this.padLength = l;
    }

    public void close() throws IOException {
        this.baseIBS.close();
    }

    public long getPosition() throws IOException {
        if (this.baseIBS.eof()) {
            return this.baseIBS.length() + this.padMark;
        }
        return this.baseIBS.getPosition();
    }

    public long length() throws IOException {
        return this.baseIBS.length() + this.padLength;
    }

    public int read() throws IOException {
        if (this.eof()) {
            return -1;
        }
        if (this.baseIBS.eof()) {
            ++this.padMark;
            return this.paddedChar;
        }
        return this.baseIBS.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.eof()) {
            return -1;
        }
        if (this.getPosition() + (long)n2 <= this.baseIBS.length()) {
            return this.baseIBS.read(byArray, n, n2);
        }
        if (this.getPosition() + (long)n2 > this.length()) {
            n2 = (int)(this.length() - this.getPosition());
        }
        n3 = (n3 = (int)(this.baseIBS.length() - this.getPosition())) > 0 ? n3 : 0;
        this.baseIBS.read(byArray, n, n3);
        for (int i = n += n3; i < n + n2 - n3; ++i) {
            byArray[i] = (byte)this.paddedChar;
        }
        this.padMark += (long)(n2 - n3);
        return n2;
    }

    public InputByteStream seek(long l) throws IOException {
        if (l > this.length()) {
            this.padMark = this.padLength;
            this.baseIBS.seek(this.baseIBS.length());
        } else if (l < this.baseIBS.length()) {
            this.padMark = 0L;
            this.baseIBS.seek(l);
        } else {
            this.baseIBS.seek(this.baseIBS.length());
            this.padMark = l - this.baseIBS.length();
        }
        return this;
    }

    public InputByteStream slice(long l, long l2) throws IOException {
        long l3 = 0L;
        if (l < 0L || l2 < 0L || l + l2 > this.length()) {
            throw new IOException("Invalid slice of PaddedBytestream");
        }
        if (l + l2 > this.baseIBS.length()) {
            if (l > this.baseIBS.length()) {
                l3 = l2;
                l = 0L;
                l2 = 0L;
            } else {
                l3 = (int)(l + l2 - this.baseIBS.length());
                l2 -= l3;
            }
        }
        return new PaddedInputByteStream(this.baseIBS.slice(l, l2), this.paddedChar, l3);
    }
}

