/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import com.adobe.internal.io.ByteArrayByteWriter;
import com.adobe.internal.io.ByteBufferByteReader;
import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.ByteReaderInputByteStream;
import com.adobe.internal.io.stream.ByteWriterOutputByteStream;
import com.adobe.internal.io.stream.ChainedInputByteStream;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.StreamDatabase;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class StreamManager {
    private static final boolean ignoreSlicesOfMaster = false;
    private ByteReader masterByteReader;
    private ByteWriterFactory byteWriterFactory;
    private StreamDatabase streamDB;

    private StreamManager(ByteWriterFactory byteWriterFactory, ByteReader byteReader) {
        this.byteWriterFactory = byteWriterFactory;
        this.masterByteReader = byteReader;
        this.streamDB = new StreamDatabase(byteReader, true, true, true);
    }

    public static StreamManager newInstance(ByteWriterFactory byteWriterFactory, ByteReader byteReader) {
        return new StreamManager(byteWriterFactory, byteReader);
    }

    public void resetMasterByteReader(ByteReader byteReader) throws IOException {
        this.masterByteReader = byteReader;
        ByteReader byteReader2 = this.streamDB.resetMasterByteReader(byteReader);
        if (byteReader2 != null) {
            byteReader2.close();
        }
    }

    public InputByteStream getInputByteStream(ByteReader byteReader) throws IOException {
        return new ByteReaderInputByteStream(this, byteReader, true);
    }

    public InputByteStream getInputByteStream(ByteReader byteReader, long l, long l2) throws IOException {
        return new ByteReaderInputByteStream(this, byteReader, l, l2, true);
    }

    public InputByteStream getInputByteStream(byte[] byArray) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        ByteBufferByteReader byteBufferByteReader = null;
        byteBufferByteReader = new ByteBufferByteReader(byteBuffer);
        return this.getInputByteStream(byteBufferByteReader);
    }

    public InputByteStream getInputByteStream(InputByteStream[] inputByteStreamArray) throws IOException {
        if (inputByteStreamArray != null) {
            return new ChainedInputByteStream(inputByteStreamArray);
        }
        return null;
    }

    public OutputByteStream getOutputByteStream(ByteWriter byteWriter) throws IOException {
        ByteWriterOutputByteStream byteWriterOutputByteStream = new ByteWriterOutputByteStream(this, byteWriter, true);
        return byteWriterOutputByteStream;
    }

    public OutputByteStream getUnregisteredOutputByteStream(ByteWriter byteWriter) throws IOException {
        ByteWriterOutputByteStream byteWriterOutputByteStream = new ByteWriterOutputByteStream(this, byteWriter, false);
        return byteWriterOutputByteStream;
    }

    public OutputByteStream getOutputByteStream() throws IOException {
        return this.getOutputByteStream(ByteWriterFactory.Longevity.LONG, ByteWriterFactory.EncryptionStatus.CLEAR, ByteWriterFactory.Fixed.GROWABLE, -1L, false);
    }

    public OutputByteStream getOutputByteStreamClearTemp(ByteWriterFactory.Fixed fixed, long l) throws IOException {
        return this.getOutputByteStream(ByteWriterFactory.Longevity.TEMPORARY, ByteWriterFactory.EncryptionStatus.CLEAR, fixed, l, false);
    }

    public OutputByteStream getOutputByteStreamEncryptedTemp(ByteWriterFactory.Fixed fixed, long l) throws IOException {
        return this.getOutputByteStream(ByteWriterFactory.Longevity.TEMPORARY, ByteWriterFactory.EncryptionStatus.ENCRYPTED, fixed, l, false);
    }

    public OutputByteStream getOutputByteStreamDecryptedTemp(ByteWriterFactory.Fixed fixed, long l) throws IOException {
        return this.getOutputByteStream(ByteWriterFactory.Longevity.TEMPORARY, ByteWriterFactory.EncryptionStatus.DECRYPTED, fixed, l, false);
    }

    public OutputByteStream getOutputByteStreamClearDocument(ByteWriterFactory.Fixed fixed, long l) throws IOException {
        return this.getOutputByteStream(ByteWriterFactory.Longevity.LONG, ByteWriterFactory.EncryptionStatus.CLEAR, fixed, l, false);
    }

    public OutputByteStream getOutputByteStreamEncryptedDocument(ByteWriterFactory.Fixed fixed, long l) throws IOException {
        return this.getOutputByteStream(ByteWriterFactory.Longevity.LONG, ByteWriterFactory.EncryptionStatus.ENCRYPTED, fixed, l, false);
    }

    public OutputByteStream getOutputByteStreamDecryptedDocument(ByteWriterFactory.Fixed fixed, long l) throws IOException {
        return this.getOutputByteStream(ByteWriterFactory.Longevity.LONG, ByteWriterFactory.EncryptionStatus.DECRYPTED, fixed, l, false);
    }

    public OutputByteStream getUnregisteredOutputByteStream(ByteWriterFactory.Fixed fixed, int n) throws IOException {
        ByteArrayByteWriter byteArrayByteWriter = null;
        byteArrayByteWriter = new ByteArrayByteWriter(n);
        ByteWriterOutputByteStream byteWriterOutputByteStream = new ByteWriterOutputByteStream(this, byteArrayByteWriter, false);
        return byteWriterOutputByteStream;
    }

    public OutputByteStream getOutputByteStream(ByteWriterFactory.Longevity longevity, ByteWriterFactory.EncryptionStatus encryptionStatus, ByteWriterFactory.Fixed fixed, long l, boolean bl) throws IOException {
        ByteWriter byteWriter = this.byteWriterFactory.getByteWriter(longevity, encryptionStatus, fixed, l, bl);
        OutputByteStream outputByteStream = this.getOutputByteStream(byteWriter);
        return outputByteStream;
    }

    public ByteWriter getByteWriter(ByteWriterFactory.Fixed fixed, long l) throws IOException {
        return this.byteWriterFactory.getByteWriter(ByteWriterFactory.Longevity.LONG, ByteWriterFactory.EncryptionStatus.CLEAR, fixed, l, false);
    }

    public void close() throws IOException {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean bl) throws IOException {
        try {
            this.streamDB.closeAllOpen(bl);
        }
        finally {
            try {
                this.byteWriterFactory.closeFactory();
            }
            catch (IOException iOException) {
                IOException iOException2 = new IOException("Unable to close the ByteWriterFactory.");
                iOException2.initCause(iOException);
                throw iOException2;
            }
        }
    }

    void deregisterInputByteStream(ByteReaderInputByteStream byteReaderInputByteStream, ByteReader byteReader, boolean bl) throws IOException {
        if (this.streamDB.removeIBS(byteReaderInputByteStream, byteReader)) {
            try {
                byteReader.close();
            }
            catch (IOException iOException) {
                IOException iOException2 = new IOException("Unable to close ByteReader");
                iOException2.initCause(iOException);
                throw iOException2;
            }
        }
    }

    void registerInputByteStream(ByteReaderInputByteStream byteReaderInputByteStream, ByteReader byteReader, boolean bl) {
        this.streamDB.addIBS(byteReaderInputByteStream, byteReader);
    }

    boolean deregisterOutputByteStream(OutputByteStream outputByteStream, ByteWriter byteWriter) throws IOException {
        boolean bl = this.streamDB.removeOBS(outputByteStream, byteWriter);
        if (bl) {
            try {
                this.byteWriterFactory.closeByteWriter(byteWriter);
            }
            catch (IOException iOException) {
                IOException iOException2 = new IOException("Unable to close ByteReader");
                iOException2.initCause(iOException);
                throw iOException2;
            }
        }
        return bl;
    }

    void registerOutputByteStream(ByteWriterOutputByteStream byteWriterOutputByteStream, ByteWriter byteWriter) {
        this.streamDB.addOBS(byteWriterOutputByteStream, byteWriter);
    }
}

