/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.util;

import com.adobe.internal.util.ArrayListStack;
import com.adobe.internal.util.BitwiseOperandEvaluator;
import com.adobe.internal.util.InvalidOperandException;
import com.adobe.internal.util.MalformedExpressionException;
import java.util.EmptyStackException;
import java.util.StringTokenizer;

public class BitwiseExpression {
    private BitwiseOperandEvaluator m_OperandEvaluator;
    private ArrayListStack m_OperandStack = new ArrayListStack();
    private ArrayListStack m_OperatorStack = new ArrayListStack();

    public BitwiseExpression(BitwiseOperandEvaluator bitwiseOperandEvaluator) {
        this.m_OperandEvaluator = bitwiseOperandEvaluator;
    }

    public boolean evaluateExpression(String string) throws MalformedExpressionException, InvalidOperandException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|&()", true);
        int n = 0;
        int n2 = 48;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(" ")) continue;
            if (string2.equals("|")) {
                this.m_OperatorStack.push(new Character('|'));
                continue;
            }
            if (string2.equals("&")) {
                this.m_OperatorStack.push(new Character('&'));
                continue;
            }
            if (string2.equals("(")) {
                ++n;
                continue;
            }
            if (string2.equals(")")) {
                n2 = this.evaluteExp();
                --n;
                continue;
            }
            boolean bl = this.m_OperandEvaluator.evaluate(string2);
            if (bl) {
                this.m_OperandStack.push(new Character('1'));
                continue;
            }
            this.m_OperandStack.push(new Character('0'));
        }
        if (n != 0) {
            throw new MalformedExpressionException("Invalid expression. Not well formed.");
        }
        while (this.m_OperatorStack.size() > 0) {
            n2 = this.evaluteExp();
        }
        if (this.m_OperandStack.size() > 0) {
            n2 = ((Character)this.m_OperandStack.pop()).charValue();
        }
        return n2 != 48;
    }

    private char evaluteExp() throws MalformedExpressionException {
        Character c = null;
        Character c2 = null;
        Character c3 = null;
        char c4 = '0';
        try {
            c = (Character)this.m_OperandStack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            throw new MalformedExpressionException("Invalid expression. Not well formed.", emptyStackException);
        }
        try {
            c3 = (Character)this.m_OperatorStack.pop();
            try {
                c2 = (Character)this.m_OperandStack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                throw new MalformedExpressionException("Invalid expression. Not well formed.", emptyStackException);
            }
            if (c3.charValue() == '|') {
                c4 = (char)(c.charValue() | c2.charValue());
            }
            if (c3.charValue() == '&') {
                c4 = (char)(c.charValue() & c2.charValue());
            }
        }
        catch (EmptyStackException emptyStackException) {
            c4 = ((Character)this.m_OperandStack.pop()).charValue();
        }
        if (c4 == '0') {
            this.m_OperandStack.push(new Character('0'));
        } else {
            this.m_OperandStack.push(new Character('1'));
        }
        return c4;
    }
}

