/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.util;

import com.adobe.internal.util.ByteSequence;
import java.io.Serializable;

public class ByteString
implements ByteSequence,
Comparable,
Serializable {
    private static final long serialVersionUID = -7911865041315030524L;
    private byte[] value;
    private int offset;
    private int length;
    private int hash = 0;

    public ByteString() {
        this.value = new byte[0];
    }

    public ByteString(ByteString byteString) {
        this.length = byteString.length;
        if (byteString.value.length > this.length) {
            this.value = new byte[this.length];
            System.arraycopy(byteString.value, byteString.offset, this.value, 0, this.length);
        } else {
            this.value = byteString.value;
        }
    }

    public ByteString(byte[] byArray) {
        this.length = byArray.length;
        this.value = new byte[this.length];
        System.arraycopy(byArray, 0, this.value, 0, this.length);
    }

    public ByteString(byte[] byArray, int n, int n2) {
        ByteString.checkBounds(byArray, n, n2);
        this.value = new byte[n2];
        this.length = n2;
        System.arraycopy(byArray, n, this.value, 0, this.length);
    }

    public int hashCode() {
        if (this.hash == 0) {
            for (int i = 0; i < this.length; ++i) {
                this.hash = 31 * this.hash + this.value[this.offset + i];
            }
        }
        return this.hash;
    }

    public byte byteAt(int n) {
        if (n < 0 || n >= this.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n + this.offset];
    }

    public int length() {
        return this.length;
    }

    public void getBytes(int n, int n2, byte[] byArray, int n3) {
        try {
            System.arraycopy(this.value, this.offset + n, byArray, n3, n2 - n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            StringIndexOutOfBoundsException stringIndexOutOfBoundsException = new StringIndexOutOfBoundsException();
            stringIndexOutOfBoundsException.initCause(indexOutOfBoundsException);
            throw stringIndexOutOfBoundsException;
        }
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.value, this.offset, byArray, 0, this.length);
        return byArray;
    }

    public ByteSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public ByteString substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.length) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        return n == 0 && n2 == this.length ? this : new ByteString(this.value, this.offset + n, n2 - n);
    }

    public ByteString concat(ByteString byteString) {
        int n = byteString.length();
        if (n == 0) {
            return this;
        }
        byte[] byArray = new byte[this.length + n];
        this.getBytes(0, this.length, byArray, 0);
        byteString.getBytes(0, n, byArray, this.length);
        return new ByteString(byArray);
    }

    public int compareTo(Object object) {
        return this.compareTo((ByteString)object);
    }

    public int compareTo(ByteString byteString) {
        int n = Math.min(this.length, byteString.length);
        for (int i = 0; i < n; ++i) {
            byte by = this.value[this.offset + i];
            byte by2 = byteString.value[byteString.offset + i];
            if (by == by2) continue;
            return by - by2;
        }
        return this.length - byteString.length;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ByteString) {
            return this.compareTo((ByteString)object) == 0;
        }
        return false;
    }

    private static void checkBounds(byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > byArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
    }

    public String toString() {
        return new String(this.value, this.offset, this.length);
    }
}

