/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.InvalidFontException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FontInputStream {
    private MessageDigest digest;
    private PushbackInputStream pbis;
    private long curOffset = 0L;
    private static int constructions;

    public FontInputStream(FontInputStream fontInputStream) {
        this.pbis = fontInputStream.pbis;
        this.curOffset = fontInputStream.curOffset;
        this.digest = fontInputStream.digest;
    }

    public FontInputStream(InputStream inputStream) {
        MessageDigest messageDigest;
        InputStream inputStream2 = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
            inputStream2 = new DigestInputStream(inputStream, messageDigest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            messageDigest = null;
            inputStream2 = inputStream;
        }
        this.digest = messageDigest;
        this.pbis = new PushbackInputStream(inputStream2, 400);
        ++constructions;
    }

    public static int numFis() {
        return constructions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.pbis.close();
        }
        finally {
            this.pbis = null;
            this.digest = null;
        }
    }

    public long getCurrentOffset() {
        return this.curOffset;
    }

    public long skipTo(long l) throws IOException, InvalidFontException {
        if (this.curOffset > l) {
            throw new InvalidFontException("trying to read the same byte twice (read up to " + Long.toHexString(this.curOffset) + ", want to go back to " + Long.toHexString(l) + ")");
        }
        long l2 = this.curOffset;
        while (this.curOffset < l) {
            long l3 = this.pbis.skip(l - this.curOffset);
            this.curOffset += l3;
        }
        return this.curOffset - l2;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.pbis.read(byArray, n, n2);
        if (n3 > 0) {
            this.curOffset += (long)n3;
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read() throws IOException {
        int n = this.pbis.read();
        if (n != -1) {
            ++this.curOffset;
        }
        return n;
    }

    public void unread(int n) throws IOException {
        this.pbis.unread(n);
        --this.curOffset;
    }

    public void unread(byte[] byArray, int n, int n2) throws IOException {
        this.pbis.unread(byArray, n, n2);
        this.curOffset -= (long)n2;
    }

    public void unread(byte[] byArray) throws IOException {
        this.unread(byArray, 0, byArray.length);
    }

    public byte[] getDigest() throws IOException {
        if (this.digest == null) {
            return new byte[0];
        }
        byte[] byArray = new byte[1024];
        int n = 0;
        while (n != -1) {
            n = this.pbis.read(byArray);
        }
        return this.digest.digest();
    }
}

