/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;

public class SubsetDefaultImpl
implements Subset {
    protected final boolean doSubset;
    protected int subsetGlyphCount;
    protected int[] fullGid2subsetGid;
    protected int[] subsetGid2fullGid;

    public SubsetDefaultImpl(int n, boolean bl) throws InvalidFontException, UnsupportedFontException {
        this.doSubset = bl;
        if (!bl) {
            this.subsetGlyphCount = n;
            this.fullGid2subsetGid = null;
            this.subsetGid2fullGid = null;
        } else {
            this.subsetGlyphCount = 0;
            this.fullGid2subsetGid = new int[n];
            this.subsetGid2fullGid = new int[n];
            for (int i = this.subsetGlyphCount; i < n; ++i) {
                this.fullGid2subsetGid[i] = -1;
            }
        }
    }

    public boolean doSubset() {
        return this.doSubset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumGlyphs() {
        SubsetDefaultImpl subsetDefaultImpl = this;
        synchronized (subsetDefaultImpl) {
            return this.subsetGlyphCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSubsetGid(int n) throws InvalidFontException, UnsupportedFontException {
        if (this.doSubset) {
            SubsetDefaultImpl subsetDefaultImpl = this;
            synchronized (subsetDefaultImpl) {
                try {
                    if (this.fullGid2subsetGid[n] == -1) {
                        this.fullGid2subsetGid[n] = this.subsetGlyphCount;
                        this.subsetGid2fullGid[this.subsetGlyphCount] = n;
                        ++this.subsetGlyphCount;
                        this.pullComponentGlyphs(n);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new InvalidFontException(arrayIndexOutOfBoundsException);
                }
                return this.fullGid2subsetGid[n];
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFullGid(int n) {
        if (this.doSubset) {
            SubsetDefaultImpl subsetDefaultImpl = this;
            synchronized (subsetDefaultImpl) {
                return this.subsetGid2fullGid[n];
            }
        }
        return n;
    }

    protected void pullComponentGlyphs(int n) throws UnsupportedFontException, InvalidFontException {
    }

    public int getExistingSubsetGid(int n) {
        if (this.doSubset) {
            if (n >= this.fullGid2subsetGid.length) {
                return -1;
            }
            return this.fullGid2subsetGid[n];
        }
        return n;
    }
}

