/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.CharStrings;
import java.util.ArrayList;
import java.util.Collections;

public class CFFSubrize {
    private static final int MAX_CALL_LIST_COUNT = 3;
    private static final int NODE_GLOBAL = Short.MAX_VALUE;
    private static final int EDGE_TABLE_SMALLEST_SPARSE_SIZE = 128;
    private static final int EDGE_TABLE_SIZE_USE_SIMPLE_HASH = 16;
    private static final int SUBR_TABLE_SIZE_USE_SIMPLE_HASH = 262144;
    private static final int SUBR_HASH_SAMPLE_COUNT = 8;
    private static final int SUBR_PREFIX_MAP_SIZE = 8192;
    private static final int CALL_OP_SIZE = 1;
    private static final int LISTSIZE = 4000;
    private static final int TX_MAX_CALL_STACK = 10;
    private static final int T2_SEPARATOR = 9;
    private static final int TX_CALLSUBR = 10;
    private static final int TX_RETURN = 11;
    private static final int TX_ESCAPE = 12;
    private static final int TX_ENDCHAR = 14;
    private static final int T2_HINTMASK = 19;
    private static final int T2_CNTRMASK = 20;
    private static final int T2_SHORTINT = 28;
    private static final int T2_CALLGSUBR = 29;
    private static final int CFF_LONGINT = 29;
    private static final int SORT_MODE_LOCAL = 0;
    private static final int SORT_MODE_GLOBAL = 1;
    private static final int SORT_MODE_FITNESS = 2;
    private byte[] mCharStr;
    private Node mRoot;
    private Node mBase;
    private ArrayList mSinks;
    private Edge mBaseEdge;
    private ArrayList mSubrs;
    private ArrayList mTmp;
    private Subr[] mReorder;
    private ArrayList mCalls;
    private ArrayList mMembers;
    private ArrayList mLeaders;
    private boolean mSingleton;
    private int mOffSize = 2;
    private boolean mSubrStackOvl;
    private SubrCSData mGSubrs;
    private int mNumFonts;
    private SubrFont[] mFonts;
    private byte[] mOpLenCache;
    private Subr[] mSubrHash;
    private byte[] mSubrPrefixMap = new byte[8192];
    private short[] mSubrLenMap;
    private short[] mPrefixLen;
    private int mMaxSubrLen;
    private int mMinSubrLen;
    private int mMaxNumSubrs;
    private int mSubrSortMode;

    public CharStrings subrize(CharStrings charStrings) {
        return this.subrize(charStrings, null);
    }

    public CharStrings subrize(CharStrings charStrings, byte[] byArray) {
        int n = charStrings.getCount();
        int[] nArray = new int[n];
        int n2 = charStrings.offsetOf(0);
        int n3 = charStrings.size();
        int n4 = n3 - n2;
        for (int i = 0; i < n; ++i) {
            nArray[i] = charStrings.offsetOf(i + 1) - n2;
        }
        byte[] byArray2 = charStrings.data.getBytes(n2, n4);
        byte[] byArray3 = new byte[byArray2.length + 4 * n];
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            int n7 = nArray[i] - n5;
            System.arraycopy(byArray2, n5, byArray3, n6, n7);
            n5 += n7;
            n6 += n7;
            byArray3[n6++] = 9;
            byArray3[n6++] = (byte)(i >> 16);
            byArray3[n6++] = (byte)(i >> 8);
            byArray3[n6++] = (byte)i;
            nArray[i] = n6;
        }
        byArray2 = byArray3;
        n = this.subrizeRaw(n, nArray, byArray2, byArray);
        nArray = this.getMainOffsets();
        byArray2 = this.getMainData();
        return this.buildIndex(n, nArray, byArray2);
    }

    public CharStrings getLSubrs() {
        int n = this.getLSubrCount();
        if (n == 0) {
            return null;
        }
        return this.buildIndex(n, this.getLSubrOffsets(), this.getLSubrData());
    }

    public CharStrings getLSubrs(int n) {
        if (this.mFonts[0].fdInfo == null || n >= this.mFonts[0].fdInfo.length) {
            return null;
        }
        SubrCSData subrCSData = this.mFonts[0].fdInfo[n].subrs;
        if (subrCSData.nStrings == 0) {
            return null;
        }
        return this.buildIndex(subrCSData.nStrings, subrCSData.offset, subrCSData.data);
    }

    public CharStrings getGSubrs() {
        int n = this.getGSubrCount();
        if (n == 0) {
            return null;
        }
        return this.buildIndex(n, this.getGSubrOffsets(), this.getGSubrData());
    }

    public int subrizeRaw(int n, int[] nArray, byte[] byArray, byte[] byArray2) {
        SubrFont[] subrFontArray = new SubrFont[1];
        SubrFont subrFont = new SubrFont();
        subrFont.chars.nStrings = n;
        subrFont.chars.offset = nArray;
        subrFont.chars.data = byArray;
        if (byArray2 != null) {
            int n2;
            subrFont.subrFontCID = true;
            subrFont.fdIndex = byArray2;
            byte by = 0;
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                if (byArray2[n2] <= by) continue;
                by = byArray2[n2];
            }
            subrFont.fdCount = by + 1;
            subrFont.fdInfo = new SubrFDInfo[by + 1];
            for (n2 = 0; n2 <= by; ++n2) {
                subrFont.fdInfo[n2] = new SubrFDInfo();
            }
        }
        subrFontArray[0] = subrFont;
        this.cfwSubrSubrize(1, subrFontArray);
        return subrFont.chars.nStrings;
    }

    public int[] getMainOffsets() {
        return this.mFonts[0].chars.offset;
    }

    public byte[] getMainData() {
        return this.mFonts[0].chars.data;
    }

    public int getGSubrCount() {
        return this.mGSubrs == null ? 0 : this.mGSubrs.nStrings;
    }

    public int[] getGSubrOffsets() {
        return this.mGSubrs == null ? null : this.mGSubrs.offset;
    }

    public byte[] getGSubrData() {
        return this.mGSubrs == null ? null : this.mGSubrs.data;
    }

    public int getLSubrCount() {
        return this.mFonts[0].subrs.nStrings;
    }

    public int[] getLSubrOffsets() {
        return this.mFonts[0].subrs.offset;
    }

    public byte[] getLSubrData() {
        return this.mFonts[0].subrs.data;
    }

    private CharStrings buildIndex(int n, int[] nArray, byte[] byArray) {
        int n2 = byArray.length + 1;
        CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder = CFFByteArray.getCFFByteArrayBuilderInstance();
        cFFByteArrayBuilder.addCard16(n);
        int n3 = n2 > 0xFFFFFF ? 4 : (n2 > 65535 ? 3 : (n2 > 255 ? 2 : 1));
        cFFByteArrayBuilder.addCard8(n3);
        cFFByteArrayBuilder.addOffset(n3, 1);
        for (int i = 0; i < nArray.length; ++i) {
            cFFByteArrayBuilder.addOffset(n3, nArray[i] + 1);
        }
        cFFByteArrayBuilder.addBytes(byArray, 0, n2 - 1);
        try {
            return new CharStrings(cFFByteArrayBuilder.toCFFByteArray(), 0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int t2oplen(byte[] byArray) {
        switch (byArray[0] & 0xFF) {
            default: {
                return 1;
            }
            case 12: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: {
                return 2;
            }
            case 28: {
                return 3;
            }
            case 9: {
                return 4;
            }
            case 255: {
                return 5;
            }
            case 19: 
            case 20: 
        }
        return byArray[1] & 0xFF;
    }

    private int t2cstrcpy(byte[] byArray, int n, int n2, int n3) {
        int n4 = n2 + n3;
        block6: while (n2 < n4) {
            switch (this.mCharStr[n2] & 0xFF) {
                case 19: 
                case 20: {
                    byArray[n++] = this.mCharStr[n2++];
                    int n5 = this.mCharStr[n2++] - 2;
                    while (n5-- != 0) {
                        byArray[n++] = this.mCharStr[n2++];
                    }
                    --n3;
                    continue block6;
                }
                case 255: {
                    byArray[n++] = this.mCharStr[n2++];
                    byArray[n++] = this.mCharStr[n2++];
                    byArray[n++] = this.mCharStr[n2++];
                    byArray[n++] = this.mCharStr[n2++];
                    byArray[n++] = this.mCharStr[n2++];
                    continue block6;
                }
                case 28: {
                    byArray[n++] = this.mCharStr[n2++];
                    byArray[n++] = this.mCharStr[n2++];
                    byArray[n++] = this.mCharStr[n2++];
                    continue block6;
                }
                case 12: 
                case 247: 
                case 248: 
                case 249: 
                case 250: 
                case 251: 
                case 252: 
                case 253: 
                case 254: {
                    byArray[n++] = this.mCharStr[n2++];
                    byArray[n++] = this.mCharStr[n2++];
                    continue block6;
                }
            }
            byArray[n++] = this.mCharStr[n2++];
        }
        return n;
    }

    private void newEdgeTable(Node node, int n) {
        node.edgeTableSize = n;
        node.edgeCount = 0;
        node.edgeTable = new Edge[n];
    }

    private void initEdge(Edge edge, int n, int n2, Node node) {
        edge.label = n;
        edge.length = n2;
        edge.son = node;
    }

    private int labelcmp(int n, int n2, int n3) {
        int n4;
        if ((n4 = this.mCharStr[n2++] - this.mCharStr[n3]) != 0) {
            return n4;
        }
        int n5 = this.opLen(n3);
        int n6 = n < n5 ? n : n5;
        ++n3;
        while (--n6 != 0) {
            if ((n4 = this.mCharStr[n2++] - this.mCharStr[n3++]) == 0) continue;
            return n4;
        }
        return n - n5;
    }

    private int hashLabel(int n, int n2) {
        int n3 = this.mCharStr[n] & 0xFF;
        n3 += n3 << 5;
        while (--n2 > 0) {
            int n4 = this.mCharStr[++n] & 0xFF;
            n3 += n4;
            n3 <<= 5;
            n3 += n4;
        }
        return n3;
    }

    private Edge lookupEdgeTable(Node node, int n, int n2) {
        int n3 = node.edgeTableSize;
        int n4 = n3 - 1;
        int n5 = n3 <= 16 ? (this.mCharStr[n2] & 0xFF) + n : this.hashLabel(n2, n);
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            Edge edge = node.edgeTable[n5 & n4];
            if (edge == null) {
                Edge edge2 = new Edge();
                node.edgeTable[n5 & n4] = edge2;
                edge = edge2;
            }
            if (edge.length == 0) {
                return edge;
            }
            if (this.labelcmp(n, n2, edge.label) == 0) {
                return edge;
            }
            n5 += ++n6;
        }
        return null;
    }

    private void addEdgeToHashTable(Node node, Node node2, int n, int n2, int n3) {
        Edge edge;
        boolean bl = false;
        if (node.edgeTable == null) {
            this.newEdgeTable(node, 1);
            edge = node.edgeTable[0] = new Edge();
        } else {
            if (node.edgeCount >= node.edgeTableSize) {
                bl = true;
            } else if (node.edgeTableSize >= 128 && node.edgeCount >= node.edgeTableSize - (node.edgeTableSize >> 3)) {
                bl = true;
            }
            if (bl) {
                this.doubleEdgeTable(node);
            }
            edge = this.lookupEdgeTable(node, n, n2);
        }
        this.initEdge(edge, n2, n3, node2);
        ++node.edgeCount;
    }

    private void doubleEdgeTable(Node node) {
        Edge[] edgeArray = node.edgeTable;
        int n = node.edgeTableSize;
        int n2 = node.edgeTableSize * 2;
        Edge[] edgeArray2 = new Edge[n2];
        node.edgeTable = edgeArray2;
        node.edgeTableSize = n2;
        node.edgeCount = 0;
        for (int i = 0; i < n; ++i) {
            Edge edge = edgeArray[i];
            if (edge == null || edge.length == 0) continue;
            this.addEdgeToHashTable(node, edge.son, this.opLen(edge.label), edge.label, edge.length);
        }
    }

    private void addEdge(Node node, Node node2, int n, int n2, int n3) {
        this.addEdgeToHashTable(node, node2, n, n2, n3);
    }

    private Edge findEdge(Node node, int n, int n2) {
        if (node.misc == -1) {
            return this.mBaseEdge;
        }
        Edge edge = this.lookupEdgeTable(node, n, n2);
        if (edge == null || edge.length != 0) {
            return edge;
        }
        return null;
    }

    private void copyEdgeTable(Node node, Node node2) {
        this.newEdgeTable(node, node2.edgeTableSize);
        node.edgeCount = node2.edgeCount;
        for (int i = 0; i < node2.edgeTableSize; ++i) {
            Edge edge = node2.edgeTable[i];
            if (edge == null) continue;
            Edge edge2 = new Edge();
            this.initEdge(edge2, edge.label, edge.length, edge.son);
            node.edgeTable[i] = edge2;
        }
    }

    private void walkEdgeTable(Node node, int n, int n2) {
        for (int i = 0; i < node.edgeTableSize; ++i) {
            Edge edge = node.edgeTable[i];
            if (edge == null || edge.length == 0) continue;
            this.findCandSubrs(edge, n, n2);
        }
    }

    private boolean checkEndPoint(Node node, int n, int n2, int n3, int n4) {
        if (node.misc == -1) {
            return true;
        }
        if (n < n2) {
            Edge edge = this.findEdge(node, this.opLen(n), n);
            return this.labelcmp(n3, n2, edge.label + n2 - n) == 0;
        }
        return this.findEdge(node, n3, n2) != null;
    }

    private Node extension(Node node, int n, int n2) {
        if (n >= n2) {
            return node;
        }
        return this.findEdge((Node)node, (int)this.opLen((int)n), (int)n).son;
    }

    private void redirect(Node node, int n, int n2, Node node2) {
        Edge edge = this.findEdge(node, this.opLen(n), n);
        edge.son = node2;
        edge.length = n2 - n;
    }

    private void canonize(Node node, int n, int n2, RefPair refPair) {
        if (n < n2) {
            int n3 = this.opLen(n);
            if (node.misc == -1) {
                node = this.mRoot;
                if ((n += n3) >= n2) {
                    refPair.node = node;
                    refPair.index = n;
                    return;
                }
                n3 = this.opLen(n);
            }
            Edge edge = this.findEdge(node, n3, n);
            while (edge.length <= n2 - n) {
                node = edge.son;
                if ((n += edge.length) >= n2) continue;
                edge = this.findEdge(node, this.opLen(n), n);
            }
        }
        refPair.node = node;
        refPair.index = n;
    }

    private Node splitEdge(Node node, int n, int n2, int n3) {
        Edge edge = this.findEdge(node, this.opLen(n), n);
        Node node2 = new Node(node.misc + n2 - n, edge.son.id != n3 ? Short.MAX_VALUE : n3);
        int n4 = edge.label + n2 - n;
        this.addEdge(node2, edge.son, this.opLen(n4), n4, edge.label + edge.length - n4);
        edge.length = n2 - n;
        edge.son = node2;
        return node2;
    }

    private void separateNode(Node node, int n, int n2, RefPair refPair, int n3) {
        int n4;
        Node node2;
        this.canonize(node, n, n2, refPair);
        Node node3 = refPair.node;
        int n5 = refPair.index;
        if (n5 < n2) {
            refPair.node = node3;
            refPair.index = n5;
            return;
        }
        if (node.misc == -1) {
            refPair.node = node3;
            refPair.index = n5;
            return;
        }
        if (node3.misc == node.misc + n2 - n) {
            Node node4 = node3;
            while (node4 != null) {
                if (node4.id != n3) {
                    node4.id = Short.MAX_VALUE;
                }
                node4 = node4.suffix;
            }
            refPair.node = node3;
            refPair.index = n5;
            return;
        }
        Node node5 = new Node(node.misc + n2 - n, node3.id != n3 ? Short.MAX_VALUE : n3);
        this.copyEdgeTable(node5, node3);
        node5.suffix = node3.suffix;
        node3.suffix = node5;
        do {
            int n6;
            Edge edge = this.findEdge(node, this.opLen(n), n);
            node3 = edge.son;
            this.initEdge(edge, n, n2 - n, node5);
            int n7 = n;
            while (n7 + (n6 = this.opLen(n7)) < n2) {
                n7 += n6;
            }
            this.canonize(node.suffix, n, n7, refPair);
            node = refPair.node;
            n = refPair.index;
            Node node6 = n < n2 ? this.findEdge((Node)node, (int)this.opLen((int)n), (int)n).son : node;
            if (node6.id != n3) {
                node6.id = Short.MAX_VALUE;
            }
            this.canonize(node, n, n2, refPair);
            node2 = refPair.node;
            n4 = refPair.index;
        } while (node3 == node2 && n5 == n4);
        refPair.node = node5;
        refPair.index = n2;
    }

    private void addFont(SubrFont subrFont, int n, boolean bl) {
        int n2;
        byte[] byArray = null;
        RefPair refPair = new RefPair();
        if (subrFont.chars.nStrings == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = subrFont.chars.offset[subrFont.chars.nStrings - 1];
        this.mCharStr = subrFont.chars.data;
        if (subrFont.subrFontCID) {
            byArray = subrFont.fdIndex;
            n2 = (short)(n + byArray[n4++]);
        } else {
            n2 = n;
        }
        if (this.mBase == null) {
            this.mBase = new Node(-1, n2);
            this.mBase.misc = -1;
            this.mBase.suffix = null;
        }
        if (this.mRoot == null) {
            this.mRoot = new Node(0, n2);
            this.mRoot.suffix = this.mBase;
        }
        this.mBaseEdge = new Edge();
        this.mBaseEdge.son = this.mRoot;
        Node node = this.mRoot;
        int n6 = n3;
        while (n3 < n5) {
            Node node2;
            int n7 = this.opLen(n3);
            Node node3 = null;
            Node node4 = null;
            Node node5 = null;
            while (!this.checkEndPoint(node, n6, n3, n7, n2)) {
                if (n6 < n3) {
                    Node node6 = this.extension(node, n6, n3);
                    if (node6 == node5) {
                        this.redirect(node, n6, n3, node3);
                        this.canonize(node.suffix, n6, n3, refPair);
                        node = refPair.node;
                        n6 = refPair.index;
                        continue;
                    }
                    node5 = node6;
                    node3 = this.splitEdge(node, n6, n3, n2);
                } else {
                    node3 = node;
                }
                if (n2 >= this.mSinks.size()) {
                    this.ensureSize(this.mSinks, n2 + 1);
                }
                if ((node2 = (Node)this.mSinks.get(n2)) == null) {
                    node2 = new Node(0, n2);
                    node2.counted = true;
                    node2.paths = 1;
                    this.mSinks.set(n2, node2);
                }
                this.addEdge(node3, node2, n7, n3, n5 - n3);
                if (node4 != null) {
                    node4.suffix = node3;
                }
                node4 = node3;
                this.canonize(node.suffix, n6, n3, refPair);
                node = refPair.node;
                n6 = refPair.index;
            }
            if (node4 != null) {
                node4.suffix = node;
            }
            if (bl) {
                node2 = node;
                int n8 = n6;
                int n9 = n3 + n7;
                while (node2.misc != -1) {
                    this.canonize(node2.suffix, n8, n9, refPair);
                    node2 = refPair.node;
                    n8 = refPair.index;
                    if (n8 < n9 || node2.id == n2) continue;
                    node2.id = Short.MAX_VALUE;
                }
            }
            this.separateNode(node, n6, n3 + n7, refPair, n2);
            node = refPair.node;
            n6 = refPair.index;
            if (subrFont.subrFontCID && this.mCharStr[n3] == 9 && n3 + n7 < n5) {
                n2 = n + byArray[n4++];
            }
            n3 += n7;
        }
    }

    private int hashSubr(int n, int n2) {
        int n3 = n2;
        int n4 = n2 >= 14 ? n2 / 7 : 1;
        int n5 = n2 - n4;
        for (int i = 0; i < n5; i += n4) {
            n3 += this.mCharStr[n + i] & 0xFF;
            n3 += n3 << 10;
            n3 ^= n3 >> 6;
        }
        n3 += this.mCharStr[n + n2 - 1] & 0xFF;
        n3 += n3 << 10;
        n3 ^= n3 >> 6;
        n3 += n3 << 3;
        n3 ^= n3 >> 11;
        return n3;
    }

    private int lookupSubrHash(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.mSubrHash.length;
        int n6 = n5 - 1;
        int n7 = 0;
        int n8 = 0;
        if (n5 <= 262144) {
            n4 = this.mCharStr[n] & 0xFF;
            int n9 = this.mCharStr[n + n2 / 2] & 0xFF;
            int n10 = this.mCharStr[n + n2 - 1] & 0xFF;
            n3 = n4 + n9 + n10 + n2 + (n2 << 5) + (n9 << 9) + (n10 << 14);
        } else {
            n3 = this.hashSubr(n, n2);
        }
        while (n8 < n5) {
            n4 = n3 & n6;
            Subr subr = this.mSubrHash[n4];
            if (subr == null) {
                return n4;
            }
            if (subr.length == n2 && (n == subr.cstr || this.bytecmp(this.mCharStr, n, this.mCharStr, subr.cstr, n2) == 0)) {
                return n4;
            }
            n3 += ++n7;
            ++n8;
        }
        return -1;
    }

    private void updateSubrQuickTestTables() {
        Subr subr;
        int n;
        this.mMaxSubrLen = 0;
        this.mMinSubrLen = Integer.MAX_VALUE;
        for (n = 0; n < this.mSubrs.size(); ++n) {
            subr = (Subr)this.mSubrs.get(n);
            if (subr.reject) continue;
            short s = subr.length;
            this.setSubrPrefixMap(subr.cstr);
            if (s > this.mMaxSubrLen) {
                this.mMaxSubrLen = s;
            }
            if (s >= this.mMinSubrLen) continue;
            this.mMinSubrLen = s;
        }
        this.mSubrLenMap = new short[this.mMaxSubrLen + 1];
        for (n = 0; n < this.mSubrs.size(); ++n) {
            subr = (Subr)this.mSubrs.get(n);
            if (subr.reject) continue;
            this.mSubrLenMap[subr.length] = 1;
        }
        int n2 = 0;
        for (n = 0; n < this.mSubrLenMap.length; ++n) {
            if (this.mSubrLenMap[n] != 0) {
                n2 = n;
            }
            this.mSubrLenMap[n] = (short)n2;
        }
    }

    private void createSubrHash() {
        int n;
        int n2 = this.mSubrs.size();
        n2 *= 2;
        for (n = 1; n2 > n; n <<= 1) {
        }
        this.mSubrHash = new Subr[n];
        for (int i = 0; i < this.mSubrs.size(); ++i) {
            Subr subr;
            this.mSubrHash[this.lookupSubrHash((int)subr.cstr, (int)subr.length)] = subr = (Subr)this.mSubrs.get(i);
        }
        this.updateSubrQuickTestTables();
    }

    private int countPaths(Edge edge) {
        if (edge == null) {
            return 0;
        }
        Node node = edge.son;
        if (!node.counted) {
            int n = node.paths;
            node.paths = (short)((n += this.countPathsForNode(node)) > Short.MAX_VALUE ? Short.MAX_VALUE : n);
            node.counted = true;
        }
        return node.paths;
    }

    private int countPathsForNode(Node node) {
        int n = 0;
        int n2 = node.edgeTableSize;
        for (int i = 0; i < n2; ++i) {
            Edge edge = node.edgeTable[i];
            if (edge == null || edge.length == 0) continue;
            n += this.countPaths(edge);
        }
        return n;
    }

    private void saveSubr(int n, Node node, int n2, boolean bl, int n3) {
        short s = node.paths;
        if (n3 > Short.MAX_VALUE) {
            return;
        }
        switch (n3 - n2) {
            case 1: 
            case 2: {
                return;
            }
            case 3: {
                if (s >= 7 - (bl ? 1 : 0)) break;
                return;
            }
            case 4: {
                if (s >= 4) break;
                return;
            }
            case 5: 
            case 6: {
                if (s >= 3) break;
                return;
            }
            case 7: {
                if (s >= 3 - (bl ? 1 : 0)) break;
                return;
            }
            default: {
                if (s >= 2) break;
                return;
            }
        }
        Subr subr = new Subr();
        subr.node = node;
        subr.sups = null;
        subr.infs = null;
        subr.next = null;
        subr.cstr = n - n3;
        subr.length = (short)n3;
        subr.count = s;
        subr.deltalen = 0;
        subr.numsize = 1;
        subr.maskcnt = (short)n2;
        this.mSubrs.add(subr);
        node.misc = this.mSubrs.size() - 1;
        if (bl) {
            node.tail = true;
        }
    }

    private void findCandSubrs(Edge edge, int n, int n2) {
        if (n2 + edge.length == edge.son.misc) {
            int n3;
            Node node;
            while (true) {
                int n4;
                int n5;
                node = edge.son;
                if (node.tested || node.paths == 1) {
                    return;
                }
                node.tested = true;
                n3 = n5 + edge.length;
                for (n5 = edge.label; n5 < n3; n5 += n4) {
                    n4 = this.opLen(n5);
                    int n6 = this.mCharStr[n5] & 0xFF;
                    if (n6 == 14) {
                        if (node.paths > 1) {
                            this.saveSubr(n5 += n4, node, n, true, node.misc - (edge.label + edge.length - n5));
                        }
                        return;
                    }
                    if (n6 != 19 && n6 != 20) continue;
                    ++n;
                }
                n2 = node.misc;
                if (node.edgeCount > 1) break;
                if (node.paths <= node.edgeTable[0].son.paths) continue;
                this.saveSubr(n3, node, n, false, n2);
            }
            this.saveSubr(n3, node, n, false, n2);
            this.walkEdgeTable(node, n, n2);
        }
    }

    private int subrSaved(Subr subr) {
        int n = subr.length - subr.maskcnt;
        return subr.count * (n - 1 - subr.numsize) - (this.mOffSize + n + (subr.node.tail ? 0 : 1));
    }

    private int subrSavedByOneCall(Subr subr) {
        int n = subr.length - subr.maskcnt;
        return n - 1 - subr.numsize;
    }

    private void buildCallList(int n, int n2, int n3, boolean bl, int n4) {
        ArrayList<Call> arrayList;
        int n5;
        int n6 = n3 + n2;
        ArrayList arrayList2 = new ArrayList();
        this.mPrefixLen = new short[n2];
        int n7 = n3;
        int n8 = 0;
        while (n8 < n2) {
            int n9 = this.opLen(n7);
            for (n5 = 0; n5 < n9; ++n5) {
                this.mPrefixLen[n8++] = (short)n5;
            }
            n7 += n9;
        }
        int n10 = n6 - n3;
        if (n10 > this.mMaxSubrLen) {
            n10 = this.mMaxSubrLen;
        }
        while (n10 >= this.mMinSubrLen) {
            int n11;
            n10 = this.mSubrLenMap[n10];
            int n12 = n3;
            while ((n11 = n12 + n10) <= n6) {
                if (this.testSubrPrefixMap(n12) && ((n11 = n12 + n10) >= n6 || this.mPrefixLen[n11 - n3] == 0)) {
                    Subr subr;
                    n8 = this.lookupSubrHash(n12, n11 - n12);
                    Subr subr2 = subr = n8 >= 0 ? this.mSubrHash[n8] : null;
                    if (!(subr == null || n != 0 && !subr.select || n11 == n6 && n12 == n3 && !bl || n != 0 && n4 != subr.node.id && subr.node.id != Short.MAX_VALUE)) {
                        n5 = 0;
                        int n13 = n12 - n3;
                        int n14 = n13 + subr.length;
                        for (int i = 0; i < arrayList2.size(); ++i) {
                            Call call;
                            int n15;
                            boolean bl2 = false;
                            arrayList = (ArrayList)arrayList2.get(i);
                            int n16 = arrayList.size();
                            for (n15 = 0; n15 < n16; ++n15) {
                                call = (Call)arrayList.get(n15);
                                if (n14 <= call.offset) break;
                                if (n14 > call.offset && n13 < call.offset + call.subr.length) {
                                    bl2 = true;
                                    break;
                                }
                                if (n13 >= call.offset + call.subr.length || n14 <= call.offset) continue;
                                bl2 = true;
                                break;
                            }
                            if (bl2) continue;
                            call = new Call(subr, n13);
                            arrayList.add(n15, call);
                            n5 = 1;
                            break;
                        }
                        if (n5 == 0 && arrayList2.size() < 3) {
                            Call call = new Call(subr, n13);
                            arrayList = new ArrayList<Call>();
                            arrayList.add(call);
                            arrayList2.add(arrayList);
                        }
                    }
                }
                n12 += this.opLen(n12);
            }
            --n10;
        }
        int n17 = 0;
        int n18 = 0;
        for (n8 = 0; n8 < arrayList2.size(); ++n8) {
            int n19 = 0;
            arrayList = (ArrayList<Call>)arrayList2.get(n8);
            for (n5 = 0; n5 < arrayList.size(); ++n5) {
                n19 += this.subrSavedByOneCall(((Call)arrayList.get((int)n5)).subr);
            }
            if (n19 <= n17) continue;
            n17 = n19;
            n18 = n8;
        }
        ArrayList arrayList3 = this.mCalls = arrayList2.isEmpty() ? new ArrayList() : (ArrayList)arrayList2.get(n18);
        if (n == 0) {
            for (n8 = 0; n8 < this.mCalls.size(); ++n8) {
                Call call = (Call)this.mCalls.get(n8);
                call.subr.count = (short)(call.subr.count + 1);
            }
        }
    }

    private void setSubrActCount() {
        Subr subr;
        int n;
        for (n = 0; n < this.mSubrs.size(); ++n) {
            subr = (Subr)this.mSubrs.get(n);
            subr.count = 0;
        }
        for (n = 0; n < this.mSubrs.size(); ++n) {
            subr = (Subr)this.mSubrs.get(n);
            this.buildCallList(0, subr.length, subr.cstr, false, 0);
            Link link = null;
            for (int i = this.mCalls.size() - 1; i >= 0; --i) {
                Call call = (Call)this.mCalls.get(i);
                Subr subr2 = call.subr;
                subr2.sups = new Link(subr, call.offset, subr2.sups);
                link = new Link(subr2, call.offset, link);
            }
            subr.infs = link;
        }
    }

    private void sortInfSubrs() {
        Subr subr;
        int n;
        for (n = 0; n < this.mSubrs.size(); ++n) {
            subr = (Subr)this.mSubrs.get(n);
            subr.misc = (short)this.subrSaved(subr);
        }
        for (n = 0; n < this.mSubrs.size(); ++n) {
            Link link;
            subr = (Subr)this.mSubrs.get(n);
            Link link2 = subr.infs;
            while (link2 != null && (link = link2.next) != null) {
                Link link3 = null;
                short s = link2.subr.misc;
                do {
                    short s2;
                    if ((s2 = link.subr.misc) <= s) continue;
                    link3 = link;
                    s = s2;
                } while ((link = link.next) != null);
                if (link3 != null) {
                    Call call = new Call(link2.subr, link2.offset);
                    link2.subr = link3.subr;
                    link2.offset = link3.offset;
                    link3.subr = call.subr;
                    link3.offset = call.offset;
                }
                link2 = link2.next;
            }
        }
    }

    private void selectCandSubrs() {
        this.countPathsForNode(this.mRoot);
        this.mSubrs = new ArrayList();
        this.walkEdgeTable(this.mRoot, 0, 0);
        this.createSubrHash();
    }

    private void assocSubrs() {
        for (int i = 0; i < this.mNumFonts; ++i) {
            int n = 0;
            SubrFont subrFont = this.mFonts[i];
            for (int j = 0; j < subrFont.chars.nStrings; ++j) {
                int n2 = subrFont.chars.offset[j];
                this.buildCallList(0, n2 - n, n, true, 0);
                n = n2;
            }
        }
    }

    private void addMember(Subr subr) {
        int n = 0;
        Subr[] subrArray = new Subr[4000];
        ArrayList<Subr> arrayList = new ArrayList<Subr>();
        arrayList.add(subr);
        while (arrayList.size() > 0) {
            subr = (Subr)arrayList.remove(arrayList.size() - 1);
            if (subr.member) continue;
            this.mMembers.add(subr);
            subr.member = true;
            Link link = subr.sups;
            while (link != null) {
                subrArray[n++] = link.subr;
                if (n >= 4000) {
                    return;
                }
                link = link.next;
            }
            link = subr.infs;
            while (link != null) {
                subrArray[n++] = link.subr;
                if (n >= 4000) {
                    return;
                }
                link = link.next;
            }
            for (int i = n - 1; i >= 0; --i) {
                arrayList.add(subrArray[i]);
            }
            n = 0;
        }
    }

    private int tieBreaker(Subr subr, Subr subr2) {
        if (subr.cstr > subr2.cstr) {
            return -1;
        }
        if (subr.cstr < subr2.cstr) {
            return 1;
        }
        if (subr.length > subr2.length) {
            return -1;
        }
        if (subr.length < subr2.length) {
            return 1;
        }
        return 0;
    }

    private int cmpGlobalSetSubrs(Subr subr, Subr subr2) {
        if (subr.node.id == Short.MAX_VALUE) {
            if (subr2.node.id == Short.MAX_VALUE) {
                int n;
                int n2 = this.subrSaved(subr);
                if (n2 > (n = this.subrSaved(subr2))) {
                    return -1;
                }
                if (n2 < n) {
                    return 1;
                }
                return this.tieBreaker(subr, subr2);
            }
            return -1;
        }
        if (subr2.node.id == Short.MAX_VALUE) {
            return 1;
        }
        return this.tieBreaker(subr, subr2);
    }

    private int cmpLocalSetSubrs(Subr subr, Subr subr2) {
        int n = 0;
        if (subr.reject) {
            n |= 8;
        }
        if (subr.select) {
            n |= 4;
        }
        if (subr2.reject) {
            n |= 2;
        }
        if (subr2.select) {
            n |= 1;
        }
        switch (n) {
            case 0: 
            case 5: {
                int n2 = this.subrSaved(subr);
                int n3 = this.subrSaved(subr2);
                if (n2 > n3) {
                    return -1;
                }
                if (n2 < n3) {
                    return 1;
                }
                return this.tieBreaker(subr, subr2);
            }
            case 1: 
            case 8: 
            case 9: {
                return 1;
            }
            case 2: 
            case 4: 
            case 6: {
                return -1;
            }
            case 10: {
                return this.tieBreaker(subr, subr2);
            }
        }
        System.out.println("cmpLocalSetSubrs() can't happen!\n");
        return 0;
    }

    private void findGroups(int n) {
        this.mLeaders = new ArrayList();
        this.mSubrSortMode = n == Short.MAX_VALUE ? 1 : 0;
        for (int i = 0; i < this.mTmp.size(); ++i) {
            Subr subr = (Subr)this.mTmp.get(i);
            if (subr.member) continue;
            this.mMembers = new ArrayList();
            this.addMember(subr);
            Collections.sort(this.mMembers);
            for (int j = 0; j < this.mMembers.size() - 1; ++j) {
                ((Subr)this.mMembers.get((int)j)).next = (Subr)this.mMembers.get(j + 1);
            }
            ((Subr)this.mMembers.get((int)(this.mMembers.size() - 1))).next = null;
            this.mLeaders.add(this.mMembers.get(0));
        }
    }

    private void updateSups(Subr subr, int n, int n2) {
        Link link = subr.sups;
        while (link != null) {
            Subr subr2 = link.subr;
            if (!subr2.select && !subr2.reject && subr2.node.id == n2) {
                this.updateSups(subr2, n, n2);
                subr2.deltalen = (short)(subr2.deltalen + n);
            }
            link = link.next;
        }
    }

    private void selectSubr(Subr subr) {
        short s = subr.count;
        int n = subr.length - subr.maskcnt + subr.deltalen;
        int n2 = s * (n - 1 - subr.numsize) - (this.mOffSize + n + (subr.node.tail ? 0 : 1));
        if (n2 > 0) {
            short s2 = subr.node.id;
            int n3 = subr.numsize + 1 - subr.length - subr.deltalen;
            subr.select = true;
            this.updateSups(subr, n3, s2);
        } else {
            subr.reject = true;
        }
    }

    private void selectGlobalSubrs(Subr subr, int n) {
        while (subr != null) {
            if (subr.node.id != Short.MAX_VALUE) {
                return;
            }
            if (!subr.select && !subr.reject) {
                this.selectSubr(subr);
            }
            subr = subr.next;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void selectLocalSubrs(Subr subr, int n) {
        while (subr != null) {
            if (subr.node.id == Short.MAX_VALUE) {
                if (!subr.select) return;
                this.updateSups(subr, subr.numsize + 1 - subr.length, n);
            } else if (!subr.select && !subr.reject) {
                this.selectSubr(subr);
            }
            subr = subr.next;
        }
    }

    private int cmpSubrFitness(Subr subr, Subr subr2) {
        boolean bl = subr.select;
        boolean bl2 = subr2.select;
        if (bl == bl2) {
            int n;
            int n2 = this.subrSaved(subr);
            if (n2 > (n = this.subrSaved(subr2))) {
                return -1;
            }
            if (n2 < n) {
                return 1;
            }
            if (subr.length > subr2.length) {
                return -1;
            }
            if (subr.length < subr2.length) {
                return 1;
            }
            if (subr.count > subr2.count) {
                return -1;
            }
            if (subr.count < subr2.count) {
                return 1;
            }
            return this.tieBreaker(subr, subr2);
        }
        if (!bl && bl2) {
            return 1;
        }
        return -1;
    }

    private void checkSubrStackOvl(Subr subr, int n) {
        if (n <= subr.misc) {
            return;
        }
        subr.misc = (short)n;
        if (subr.select && ++n >= 10) {
            subr.select = false;
            subr.reject = true;
            --n;
            this.mSubrStackOvl = true;
        }
        Link link = subr.sups;
        while (link != null) {
            this.checkSubrStackOvl(link.subr, n);
            link = link.next;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void selectFinalSubrSet(int var1_1) {
        var3_2 = 0;
        var4_3 = this.mSingleton != false ? 2 : 1;
        var5_4 = 0;
        this.findGroups(var1_1);
        while (true) {
            for (var2_5 = 0; var2_5 < this.mLeaders.size(); ++var2_5) {
                var6_6 = (Subr)this.mLeaders.get(var2_5);
                if (var6_6.next == null) {
                    if (this.subrSaved(var6_6) > 0) {
                        var6_6.select = true;
                        continue;
                    }
                    var6_6.reject = true;
                    continue;
                }
                if (var1_1 == 32767) {
                    this.selectGlobalSubrs(var6_6, var1_1);
                    continue;
                }
                this.selectLocalSubrs(var6_6, var1_1);
            }
            for (var2_5 = 0; var2_5 < this.mTmp.size(); ++var2_5) {
                ((Subr)this.mTmp.get((int)var2_5)).misc = (short)-1;
            }
            for (var2_5 = 0; var2_5 < this.mLeaders.size(); ++var2_5) {
                var6_6 = (Subr)this.mLeaders.get(var2_5);
                while (var6_6 != null) {
                    if (var6_6.infs == null) {
                        this.checkSubrStackOvl(var6_6, 0);
                    }
                    var6_6.member = false;
                    var6_6 = var6_6.next;
                }
            }
            this.mSubrSortMode = 2;
            Collections.sort(this.mTmp);
            for (var2_5 = this.mTmp.size() - 1; var2_5 >= 0; --var2_5) {
                if (!((Subr)this.mTmp.get((int)var2_5)).select) continue;
                var3_2 = var2_5 + 1;
                break;
            }
            if (++var5_4 == 2) {
                if (this.mSingleton && (var3_2 == 2479 || var3_2 == 67799)) {
                    var6_6 = new Subr();
                    var6_6.node = new Node(0, 0);
                    this.mTmp.add(var3_2++, var6_6);
                }
                if ((var6_7 = this.mMaxNumSubrs) == 0) {
                    var6_7 = 32767;
                }
                if (var3_2 > (var6_7 *= var4_3)) {
                    while (var6_7 < this.mTmp.size()) {
                        this.mTmp.remove(this.mTmp.size() - 1);
                    }
                } else {
                    while (var3_2 < this.mTmp.size()) {
                        this.mTmp.remove(this.mTmp.size() - 1);
                    }
                }
                return;
            }
            if (var3_2 < 215 * var4_3) {
                while (var3_2 < this.mTmp.size()) {
                    this.mTmp.remove(this.mTmp.size() - 1);
                }
                return;
            }
            for (var2_5 = 0; var2_5 < this.mTmp.size(); ++var2_5) {
                ((Subr)this.mTmp.get((int)var2_5)).select = false;
                ((Subr)this.mTmp.get((int)var2_5)).reject = false;
            }
            for (var2_5 = this.mTmp.size() - 1; var2_5 >= 2263 * var4_3; --var2_5) {
                ((Subr)this.mTmp.get((int)var2_5)).numsize = (short)3;
            }
            while (var2_5 >= 215 * var4_3) {
                ((Subr)this.mTmp.get((int)var2_5)).numsize = (short)2;
                --var2_5;
            }
            while (true) {
                if (var2_5 < 0) ** continue;
                ((Subr)this.mTmp.get((int)var2_5)).numsize = 1;
                --var2_5;
            }
            break;
        }
    }

    private void stackOverflow() {
    }

    private int subrizeCstr(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < this.mCalls.size(); ++i) {
            Call call = (Call)this.mCalls.get(i);
            Subr subr = call.subr;
            if (subr == null) continue;
            n = this.t2cstrcpy(byArray, n, n2, call.offset - n4);
            n += this.cfwEncInt(subr.subrnum, byArray, n);
            byArray[n++] = subr.node.id == Short.MAX_VALUE ? 29 : 10;
            n2 += call.offset - n4 + subr.length;
            n4 = call.offset + subr.length;
        }
        return this.t2cstrcpy(byArray, n, n2, n3 - n4);
    }

    private void subrizeChars(SubrCSData subrCSData, int n) {
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = new byte[subrCSData.data.length];
        for (int i = 0; i < subrCSData.nStrings; ++i) {
            int n4 = subrCSData.offset[i];
            int n5 = n4 - n2 - 4;
            this.buildCallList(1, n5, n2, true, n);
            subrCSData.offset[i] = n3 = this.subrizeCstr(byArray, n3, n2, n5);
            n2 = n4;
        }
        subrCSData.data = new byte[n3];
        System.arraycopy(byArray, 0, subrCSData.data, 0, n3);
    }

    private void reorderCombined(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        if (bl) {
            n4 = this.mTmp.size() / 2;
            n3 = (this.mTmp.size() & 0xFFFFFFFE) + 1;
        } else {
            n4 = (this.mTmp.size() + 1) / 2;
            n3 = this.mTmp.size() + 1 & 0xFFFFFFFE;
        }
        this.mReorder = new Subr[n4];
        if (n4 < 1240) {
            for (n2 = n4 - 1; n2 >= 0; --n2) {
                this.mReorder[n2 + 0] = (Subr)this.mTmp.get(n3 -= 2);
            }
            n = 107;
        } else if (n4 < 33900) {
            while (n2 >= 1239) {
                this.mReorder[n2 + 0] = (Subr)this.mTmp.get(n3 -= 2);
                --n2;
            }
            while (n2 >= 215) {
                this.mReorder[n2 - 215] = (Subr)this.mTmp.get(n3 -= 2);
                --n2;
            }
            while (n2 >= 0) {
                this.mReorder[n2 + 1024] = (Subr)this.mTmp.get(n3 -= 2);
                --n2;
            }
            n = 1131;
        } else {
            while (n2 >= 33900) {
                this.mReorder[n2 + 0] = (Subr)this.mTmp.get(n3 -= 2);
                --n2;
            }
            while (n2 >= 2263) {
                this.mReorder[n2 - 2263] = (Subr)this.mTmp.get(n3 -= 2);
                --n2;
            }
            while (n2 >= 1239) {
                this.mReorder[n2 + 31637] = (Subr)this.mTmp.get(n3 -= 2);
                --n2;
            }
            while (n2 >= 215) {
                this.mReorder[n2 + 31422] = (Subr)this.mTmp.get(n3 -= 2);
                --n2;
            }
            while (n2 >= 0) {
                this.mReorder[n2 + 32661] = (Subr)this.mTmp.get(n3 -= 2);
                --n2;
            }
            n = 32768;
        }
        if (!bl) {
            for (n2 = 0; n2 < n4; ++n2) {
                Subr subr = this.mReorder[n2];
                subr.subrnum = (short)(n2 - n);
                subr.node.id = Short.MAX_VALUE;
            }
            for (n2 = 0; n2 < this.mTmp.size() - 1; n2 += 2) {
                ((Subr)this.mTmp.get((int)(n2 + 1))).subrnum = ((Subr)this.mTmp.get((int)n2)).subrnum;
            }
        }
    }

    private void reorderSubrs() {
        int n;
        int n2;
        this.mReorder = new Subr[this.mTmp.size()];
        if (this.mTmp.size() < 1240) {
            for (n2 = this.mTmp.size() - 1; n2 >= 0; --n2) {
                this.mReorder[n2 + 0] = (Subr)this.mTmp.get(n2);
            }
            n = 107;
        } else if (this.mTmp.size() < 33900) {
            while (n2 >= 1239) {
                this.mReorder[n2 + 0] = (Subr)this.mTmp.get(n2);
                --n2;
            }
            while (n2 >= 215) {
                this.mReorder[n2 - 215] = (Subr)this.mTmp.get(n2);
                --n2;
            }
            while (n2 >= 0) {
                this.mReorder[n2 + 1024] = (Subr)this.mTmp.get(n2);
                --n2;
            }
            n = 1131;
        } else {
            while (n2 >= 33900) {
                this.mReorder[n2 + 0] = (Subr)this.mTmp.get(n2);
                --n2;
            }
            while (n2 >= 2263) {
                this.mReorder[n2 - 2263] = (Subr)this.mTmp.get(n2);
                --n2;
            }
            while (n2 >= 1239) {
                this.mReorder[n2 + 31637] = (Subr)this.mTmp.get(n2);
                --n2;
            }
            while (n2 >= 215) {
                this.mReorder[n2 + 31422] = (Subr)this.mTmp.get(n2);
                --n2;
            }
            while (n2 >= 0) {
                this.mReorder[n2 + 32661] = (Subr)this.mTmp.get(n2);
                --n2;
            }
            n = 32768;
        }
        for (n2 = 0; n2 < this.mReorder.length; ++n2) {
            this.mReorder[n2].subrnum = (short)(n2 - n);
        }
    }

    private void addSubrs(SubrCSData subrCSData, int n) {
        int n2;
        if (this.mReorder == null || this.mReorder.length == 0) {
            return;
        }
        subrCSData.nStrings = (short)this.mReorder.length;
        subrCSData.offset = new int[this.mReorder.length];
        int n3 = 0;
        for (n2 = 0; n2 < this.mReorder.length; ++n2) {
            n3 += this.mReorder[n2].length + 1;
        }
        n2 = 0;
        byte[] byArray = new byte[n3];
        for (int i = 0; i < this.mReorder.length; ++i) {
            Subr subr = this.mReorder[i];
            this.buildCallList(1, subr.length, subr.cstr, false, n);
            n2 = this.subrizeCstr(byArray, n2, subr.cstr, subr.length);
            if (!subr.node.tail) {
                byArray[n2++] = 11;
            }
            subrCSData.offset[i] = n2;
        }
        subrCSData.data = new byte[n2];
        System.arraycopy(byArray, 0, subrCSData.data, 0, n2);
    }

    private void subrizeFDChars(SubrCSData subrCSData, SubrFont subrFont, int n, int n2) {
        int n3;
        int n4 = 0;
        SubrCSData subrCSData2 = subrFont.chars;
        this.mCharStr = subrFont.chars.data;
        byte[] byArray = new byte[subrFont.chars.data.length];
        subrCSData.nStrings = 0;
        for (n3 = 0; n3 < subrCSData2.nStrings; ++n3) {
            if (subrFont.fdIndex[n3] != n2) continue;
            ++subrCSData.nStrings;
        }
        subrCSData.offset = new int[subrCSData.nStrings];
        n3 = 0;
        for (int i = 0; i < subrCSData2.nStrings; ++i) {
            if (subrFont.fdIndex[i] != n2) continue;
            int n5 = i == 0 ? 0 : subrCSData2.offset[i - 1];
            int n6 = subrCSData2.offset[i] - n5 - 4;
            this.buildCallList(1, n6, n5, true, n + n2);
            n4 = this.subrizeCstr(byArray, n4, n5, n6);
            subrCSData.offset[n3++] = n4;
        }
        subrCSData.data = new byte[n4];
        System.arraycopy(byArray, 0, subrCSData.data, 0, n4);
    }

    private void joinFDChars(SubrFont subrFont) {
        Object object;
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < subrFont.fdCount; ++n2) {
            SubrFDInfo subrFDInfo = subrFont.fdInfo[n2];
            if (subrFDInfo.chars.nStrings != 0) {
                n3 += subrFDInfo.chars.offset[subrFDInfo.chars.nStrings - 1];
            }
            subrFDInfo.iChar = 0;
        }
        subrFont.chars.data = new byte[n3];
        n2 = 0;
        for (n = 0; n < subrFont.chars.nStrings; ++n) {
            object = subrFont.fdInfo[subrFont.fdIndex[n]];
            int n4 = ((SubrFDInfo)object).iChar == 0 ? 0 : ((SubrFDInfo)object).chars.offset[((SubrFDInfo)object).iChar - 1];
            int n5 = ((SubrFDInfo)object).chars.offset[((SubrFDInfo)object).iChar++] - n4;
            System.arraycopy(((SubrFDInfo)object).chars.data, n4, subrFont.chars.data, n2, n5);
            subrFont.chars.offset[n] = n2 += n5;
        }
        for (n = 0; n < subrFont.fdCount; ++n) {
            object = subrFont.fdInfo[n].chars;
            ((SubrCSData)object).offset = null;
            ((SubrCSData)object).data = null;
        }
    }

    private void buildSubrs(SubrCSData subrCSData, int n) {
        this.mTmp = new ArrayList();
        for (int i = 0; i < this.mSubrs.size(); ++i) {
            Subr subr = (Subr)this.mSubrs.get(i);
            if (subr.node.id != n) continue;
            this.mTmp.add(subr);
        }
        this.selectFinalSubrSet(n);
        this.updateSubrQuickTestTables();
        this.reorderSubrs();
        this.addSubrs(subrCSData, n);
    }

    private void cfwSubrSubrize(int n, SubrFont[] subrFontArray) {
        int n2;
        byte[] byArray = new byte[2];
        this.mNumFonts = n;
        this.mFonts = subrFontArray;
        this.mOpLenCache = new byte[256];
        for (n2 = 0; n2 < 256; ++n2) {
            byArray[0] = (byte)n2;
            this.mOpLenCache[n2] = (byte)this.t2oplen(byArray);
        }
        this.mSingleton = this.mNumFonts == 1 && !this.mFonts[0].subrFontCID;
        int n3 = 0;
        this.mSinks = new ArrayList();
        for (n2 = 0; n2 < this.mNumFonts; ++n2) {
            this.addFont(this.mFonts[n2], n3, this.mNumFonts > 1 || this.mFonts[n2].subrFontCID);
            n3 += this.mFonts[n2].subrFontCID ? this.mFonts[n2].fdCount : 1;
        }
        this.selectCandSubrs();
        this.setSubrActCount();
        this.assocSubrs();
        this.sortInfSubrs();
        if (this.mSingleton) {
            this.mTmp = new ArrayList();
            this.mTmp.addAll(this.mSubrs);
            this.mSubrStackOvl = false;
            this.selectFinalSubrSet(0);
            this.updateSubrQuickTestTables();
            if (this.mSubrStackOvl) {
                this.stackOverflow();
            }
            if (this.mTmp.size() >= 215) {
                this.reorderCombined(false);
                this.mGSubrs = new SubrCSData();
                this.addSubrs(this.mGSubrs, Short.MAX_VALUE);
                this.reorderCombined(true);
                this.addSubrs(this.mFonts[0].subrs, 0);
            } else {
                this.reorderSubrs();
                this.addSubrs(this.mFonts[0].subrs, 0);
            }
            this.subrizeChars(this.mFonts[0].chars, 0);
        } else {
            this.mGSubrs = new SubrCSData();
            this.buildSubrs(this.mGSubrs, Short.MAX_VALUE);
            n3 = 0;
            for (n2 = 0; n2 < this.mNumFonts; ++n2) {
                SubrFont subrFont = this.mFonts[n2];
                this.mSubrStackOvl = false;
                if (subrFont.subrFontCID) {
                    for (int i = 0; i < this.mFonts[n2].fdCount; ++i) {
                        SubrFDInfo subrFDInfo = subrFont.fdInfo[i];
                        this.buildSubrs(subrFDInfo.subrs, n3 + i);
                        this.subrizeFDChars(subrFDInfo.chars, subrFont, n3, i);
                    }
                    this.joinFDChars(subrFont);
                    n3 += this.mFonts[n2].fdCount;
                } else {
                    if (subrFont.chars.nStrings != 0) {
                        this.buildSubrs(subrFont.subrs, n3);
                        this.subrizeChars(subrFont.chars, n3);
                    }
                    ++n3;
                }
                if (!this.mSubrStackOvl) continue;
                this.stackOverflow();
            }
        }
    }

    private int opLen(int n) {
        int n2 = this.mOpLenCache[this.mCharStr[n] & 0xFF] & 0xFF;
        if (n2 == 0) {
            n2 = this.mCharStr[n + 1] & 0xFF;
        }
        return n2;
    }

    private void setSubrPrefixMap(int n) {
        int n2 = this.mCharStr[n] & 0xFF;
        int n3 = this.mCharStr[n + 1] & 0xFF;
        int n4 = n2 << 5 | n3 >> 3;
        int n5 = 1 << (n3 & 7);
        int n6 = n4;
        this.mSubrPrefixMap[n6] = (byte)(this.mSubrPrefixMap[n6] | n5);
    }

    private boolean testSubrPrefixMap(int n) {
        int n2 = this.mCharStr[n] & 0xFF;
        int n3 = this.mCharStr[n + 1] & 0xFF;
        int n4 = n2 << 5 | n3 >> 3;
        int n5 = 1 << (n3 & 7);
        return (this.mSubrPrefixMap[n4] & n5) != 0;
    }

    private void ensureSize(ArrayList arrayList, int n) {
        arrayList.ensureCapacity(n);
        for (int i = arrayList.size(); i < n; ++i) {
            arrayList.add(null);
        }
    }

    private int bytecmp(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while (n3-- != 0) {
            if (byArray[n++] == byArray2[n2++]) continue;
            return (byArray[--n] & 0xFF) - (byArray2[--n2] & 0xFF);
        }
        return 0;
    }

    private int cfwEncInt(long l, byte[] byArray, int n) {
        if (-107L <= l && l <= 107L) {
            byArray[n] = (byte)(l + 139L);
            return 1;
        }
        if (108L <= l && l <= 1131L) {
            byArray[n] = (byte)(((l -= 108L) >> 8) + 247L);
            byArray[n + 1] = (byte)l;
            return 2;
        }
        if (-1131L <= l && l <= -108L) {
            byArray[n] = (byte)((-(l += 108L) >> 8) + 251L);
            byArray[n + 1] = (byte)(-l);
            return 2;
        }
        if (-32768L <= l && l <= 32767L) {
            byArray[n] = 28;
            byArray[n + 1] = (byte)(l >> 8);
            byArray[n + 2] = (byte)l;
            return 3;
        }
        byArray[n] = 29;
        byArray[n + 1] = (byte)(l >> 24);
        byArray[n + 2] = (byte)(l >> 16);
        byArray[n + 3] = (byte)(l >> 8);
        byArray[n + 4] = (byte)l;
        return 5;
    }

    private static final class RefPair {
        Node node;
        int index;

        private RefPair() {
        }
    }

    private static final class SubrFont {
        boolean subrFontCID;
        byte[] fdIndex;
        int fdCount;
        SubrFDInfo[] fdInfo;
        SubrCSData subrs = new SubrCSData();
        SubrCSData chars = new SubrCSData();

        private SubrFont() {
        }
    }

    private static final class SubrFDInfo {
        SubrCSData subrs = new SubrCSData();
        SubrCSData chars = new SubrCSData();
        int iChar;

        private SubrFDInfo() {
        }
    }

    private static final class SubrCSData {
        int nStrings;
        int[] offset;
        byte[] data;

        private SubrCSData() {
        }
    }

    private static final class Call {
        Subr subr;
        int offset;

        private Call(Subr subr, int n) {
            this.subr = subr;
            this.offset = n;
        }
    }

    private static final class Link {
        Subr subr;
        Link next;
        int offset;

        private Link(Subr subr, int n, Link link) {
            this.subr = subr;
            this.offset = n;
            this.next = link;
        }
    }

    private final class Subr
    implements Comparable {
        Node node;
        Link sups;
        Link infs;
        Subr next;
        int cstr;
        short length;
        short count;
        short deltalen;
        short subrnum;
        short numsize;
        short maskcnt;
        short misc;
        boolean select;
        boolean reject;
        boolean member;

        private Subr() {
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int compareTo(Object object) {
            if (CFFSubrize.this.mSubrSortMode == 0) {
                return CFFSubrize.this.cmpLocalSetSubrs(this, (Subr)object);
            }
            if (CFFSubrize.this.mSubrSortMode == 1) {
                return CFFSubrize.this.cmpGlobalSetSubrs(this, (Subr)object);
            }
            return CFFSubrize.this.cmpSubrFitness(this, (Subr)object);
        }
    }

    private static final class Node {
        Node suffix;
        Edge[] edgeTable;
        int misc;
        int edgeCount;
        int edgeTableSize;
        short paths;
        short id;
        boolean counted;
        boolean tested;
        boolean tail;

        private Node(int n, int n2) {
            this.misc = n;
            this.id = (short)n2;
        }
    }

    private static final class Edge {
        int label;
        Node son;
        int length;

        private Edge() {
        }
    }
}

