/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OrigFontType;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.StringIndex;
import com.adobe.fontengine.font.postscript.PostscriptTokenParser;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Dict {
    private final Map m;
    private static final String[] floatNibbles = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ".", "E", "E-", "", "-"};
    private static final Map defaultDict;

    Dict(CFFByteArray cFFByteArray, int n, int n2, StringIndex stringIndex) throws InvalidFontException {
        this.m = new LinkedHashMap();
        ValueStack valueStack = new ValueStack();
        int n3 = n;
        int n4 = n + n2;
        block6: while (n3 < n4) {
            int n5 = cFFByteArray.getcard8(n3);
            ++n3;
            switch (n5) {
                case 12: {
                    n5 = cFFByteArray.getcard8(n3);
                    ++n3;
                    if (n5 < Key.extendedKeys.length && Key.extendedKeys[n5] != null) {
                        this.m.put(Key.extendedKeys[n5], Key.extendedKeys[n5].parse(valueStack, stringIndex));
                        continue block6;
                    }
                    valueStack.count = 0;
                    continue block6;
                }
                case 28: {
                    valueStack.pushInt(cFFByteArray.getint16(n3));
                    n3 += 2;
                    continue block6;
                }
                case 29: {
                    valueStack.pushInt(cFFByteArray.getint32(n3));
                    n3 += 4;
                    continue block6;
                }
                case 30: {
                    StringBuffer stringBuffer = new StringBuffer();
                    boolean bl = false;
                    while (!bl) {
                        int n6 = cFFByteArray.getcard8(n3);
                        ++n3;
                        if (n6 == 255) {
                            bl = true;
                            continue;
                        }
                        if ((n6 & 0xF) == 15) {
                            stringBuffer.append(floatNibbles[n6 >> 4]);
                            bl = true;
                            continue;
                        }
                        stringBuffer.append(floatNibbles[n6 >> 4]);
                        stringBuffer.append(floatNibbles[n6 & 0xF]);
                    }
                    valueStack.pushDouble(stringBuffer.toString());
                    continue block6;
                }
            }
            if (n5 < Key.nonExtendedKeys.length && Key.nonExtendedKeys[n5] != null) {
                this.m.put(Key.nonExtendedKeys[n5], Key.nonExtendedKeys[n5].parse(valueStack, stringIndex));
                continue;
            }
            if (32 <= n5 && n5 <= 246) {
                valueStack.pushInt(n5 - 139);
                continue;
            }
            if (247 <= n5 && n5 <= 250) {
                int n7 = cFFByteArray.getcard8(n3);
                ++n3;
                valueStack.pushInt((n5 - 247) * 256 + n7 + 108);
                continue;
            }
            if (241 <= n5 && n5 <= 254) {
                int n8 = cFFByteArray.getcard8(n3);
                ++n3;
                valueStack.pushInt(-(n5 - 251) * 256 - n8 - 108);
                continue;
            }
            valueStack.count = 0;
        }
        if (valueStack.count != 0) {
            throw new InvalidFontException("CFF/Dict stack not empty");
        }
    }

    Dict(Map map) throws InvalidFontException {
        this.m = new LinkedHashMap(map.size(), 1.0f);
        for (Object object : map.keySet()) {
            if (!(object instanceof Key)) {
                throw new InvalidFontException("Invalid key " + object);
            }
            Key key = (Key)object;
            if (!key.compatibleValue(object = map.get(object))) {
                throw new InvalidFontException("Invalid value for " + key);
            }
            this.m.put(key, object);
        }
    }

    private double[] deltaEncode(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        double d = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i] - d;
            d = dArray[i];
        }
        return dArray2;
    }

    public Dict(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, Double d, Double d2, Integer n, Double d3, Double d4, double[] dArray5, double[] dArray6, Boolean bl, Integer n2, Double d5, Integer n3, Double d6, Double d7) {
        this.m = new LinkedHashMap();
        if (d6 != null && d6 != 0.0) {
            this.m.put(Key.nominalWidthX, new NumbersValue(d6));
            if (d7 != null && d7 != 0.0) {
                this.m.put(Key.defaultWidthX, new NumbersValue(d7));
            }
        }
        if (dArray != null) {
            this.m.put(Key.BlueValues, new NumbersValue(this.deltaEncode(dArray)));
        }
        if (bl != null && bl.equals(Boolean.TRUE)) {
            this.m.put(Key.ForceBold, new NumbersValue(1));
        }
        if (n2 != null && n2.doubleValue() != 0.0) {
            this.m.put(Key.LanguageGroup, new NumbersValue(n2));
        }
        if (d5 != null && d5 != 0.06) {
            this.m.put(Key.ExpansionFactor, new NumbersValue(d5));
        }
        if (n3 != null && n3.doubleValue() != 0.0) {
            this.m.put(Key.initialRandomSeed, new NumbersValue(n3));
        }
        if (dArray2 != null) {
            this.m.put(Key.OtherBlues, new NumbersValue(this.deltaEncode(dArray2)));
        }
        if (dArray3 != null) {
            this.m.put(Key.FamilyBlues, new NumbersValue(this.deltaEncode(dArray3)));
        }
        if (dArray4 != null) {
            this.m.put(Key.FamilyOtherBlues, new NumbersValue(this.deltaEncode(dArray4)));
        }
        if (d != null) {
            this.m.put(Key.BlueScale, new NumbersValue(d));
        }
        if (d2 != null && d2 != 7.0) {
            this.m.put(Key.BlueShift, new NumbersValue(d2));
        }
        if (n != null && n.doubleValue() != 1.0) {
            this.m.put(Key.BlueFuzz, new NumbersValue(n));
        }
        if (d3 != null) {
            this.m.put(Key.StdHW, new NumbersValue(d3));
        }
        if (d4 != null) {
            this.m.put(Key.StdVW, new NumbersValue(d4));
        }
        if (dArray5 != null) {
            this.m.put(Key.StemSnapH, new NumbersValue(this.deltaEncode(dArray5)));
        }
        if (dArray6 != null) {
            this.m.put(Key.StemSnapV, new NumbersValue(this.deltaEncode(dArray6)));
        }
    }

    public Dict(Matrix matrix) {
        this.m = new LinkedHashMap();
        if (matrix != null) {
            this.m.put(Key.FontMatrix, new NumbersValue(matrix));
        }
    }

    public Dict(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7, String string8, String string9, Boolean bl, Double d, Double d2, Double d3, Integer n2, Integer n3, Rect rect, Double d4, int[] nArray, String string10, Integer n4, int[] nArray2, String string11, Matrix matrix) throws InvalidFontException {
        this.m = new LinkedHashMap();
        if (string != null && string2 != null) {
            this.m.put(Key.ROS, new ROSValue(string, string2, n));
        }
        if (string7 != null) {
            this.m.put(Key.FontName, new StringValue(string7));
        }
        if (n4 != null) {
            String string12 = "/FSType " + n4.toString() + " def";
            if (string10 != null) {
                this.m.put(Key.PostScript, new StringValue(string10 + " " + string12));
            } else {
                this.m.put(Key.PostScript, new StringValue(string12));
            }
        } else if (string10 != null) {
            this.m.put(Key.PostScript, new StringValue(string10));
        }
        if (string3 != null) {
            this.m.put(Key.version, new StringValue(string3));
        }
        if (string4 != null) {
            this.m.put(Key.Notice, new StringValue(string4));
        }
        if (string5 != null) {
            this.m.put(Key.Copyright, new StringValue(string5));
        }
        if (nArray != null) {
            this.m.put(Key.XUID, new NumbersValue(nArray));
        }
        if (nArray2 != null) {
            this.m.put(Key.BaseFontBlend, new NumbersValue(nArray2));
        }
        if (rect != null) {
            this.m.put(Key.FontBBox, new NumbersValue(rect));
        }
        if (string6 != null) {
            this.m.put(Key.FullName, new StringValue(string6));
        }
        if (string8 != null) {
            this.m.put(Key.FamilyName, new StringValue(string8));
        }
        if (string9 != null) {
            this.m.put(Key.Weight, new StringValue(string9));
        }
        if (d != null && d != 0.0) {
            this.m.put(Key.ItalicAngle, new NumbersValue(d));
        }
        if (d2 != null && d2 != -100.0) {
            this.m.put(Key.UnderlinePosition, new NumbersValue(d2));
        }
        if (d3 != null && d3 != 50.0) {
            this.m.put(Key.UnderlineThickness, new NumbersValue(d3));
        }
        if (n2 != null && n2.doubleValue() != 0.0) {
            this.m.put(Key.PaintType, new NumbersValue(n2));
        }
        if (n3 != null) {
            this.m.put(Key.UniqueID, new NumbersValue(n3));
        }
        if (d4 != null && d4 != 0.0) {
            this.m.put(Key.StrokeWidth, new NumbersValue(d4));
        }
        if (string11 != null) {
            this.m.put(Key.BaseFontName, new StringValue(string11));
        }
        if (matrix != null) {
            this.m.put(Key.FontMatrix, new NumbersValue(matrix));
        }
    }

    OrigFontType getOrigFontType() {
        StringValue stringValue = this.get(Key.PostScript, true);
        if (stringValue != null) {
            return PostscriptTokenParser.getOrigFontType(stringValue.value);
        }
        return null;
    }

    Integer getFSType() {
        StringValue stringValue = this.get(Key.PostScript, true);
        if (stringValue != null) {
            return PostscriptTokenParser.getFSType(stringValue.value);
        }
        return null;
    }

    ROS getROS() {
        ROSValue rOSValue = this.get(Key.ROS, true);
        if (rOSValue != null) {
            return rOSValue.ros;
        }
        return null;
    }

    IntegerValue get(IntegerKey integerKey, boolean bl) {
        IntegerValue integerValue = (IntegerValue)this.m.get(integerKey);
        if (integerValue == null && bl) {
            integerValue = (IntegerValue)defaultDict.get(integerKey);
        }
        return integerValue;
    }

    StringValue get(StringKey stringKey, boolean bl) {
        StringValue stringValue = (StringValue)this.m.get(stringKey);
        if (stringValue == null && bl) {
            stringValue = (StringValue)defaultDict.get(stringKey);
        }
        return stringValue;
    }

    NumbersValue get(NumbersKey numbersKey, boolean bl) {
        NumbersValue numbersValue = (NumbersValue)this.m.get(numbersKey);
        if (numbersValue == null && bl) {
            numbersValue = (NumbersValue)defaultDict.get(numbersKey);
        }
        return numbersValue;
    }

    ROSValue get(ROSKey rOSKey, boolean bl) {
        ROSValue rOSValue = (ROSValue)this.m.get(rOSKey);
        if (rOSValue == null && bl) {
            rOSValue = (ROSValue)defaultDict.get(rOSKey);
        }
        return rOSValue;
    }

    OffsetValue get(OffsetKey offsetKey, boolean bl) {
        OffsetValue offsetValue = (OffsetValue)this.m.get(offsetKey);
        if (offsetValue == null && bl) {
            offsetValue = (OffsetValue)defaultDict.get(offsetKey);
        }
        return offsetValue;
    }

    OffsetSizeValue get(OffsetSizeKey offsetSizeKey, boolean bl) {
        OffsetSizeValue offsetSizeValue = (OffsetSizeValue)this.m.get(offsetSizeKey);
        if (offsetSizeValue == null && bl) {
            offsetSizeValue = (OffsetSizeValue)defaultDict.get(offsetSizeKey);
        }
        return offsetSizeValue;
    }

    void collectStrings(List list) {
        for (Value value : this.m.values()) {
            value.collectStrings(list);
        }
    }

    void stream(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, List list, Key[] keyArray) throws InvalidFontException {
        for (int i = 0; i < keyArray.length; ++i) {
            Value value = (Value)this.m.get(keyArray[i]);
            if (value == null) continue;
            value.stream(cFFByteArrayBuilder, list);
            keyArray[i].stream(cFFByteArrayBuilder);
        }
    }

    void streamValue(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, List list, Key key) throws InvalidFontException {
        Value value = (Value)this.m.get(key);
        if (value != null) {
            value.stream(cFFByteArrayBuilder, list);
            key.stream(cFFByteArrayBuilder);
        }
    }

    static void streamKeyVal(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, IntegerKey integerKey, int n) {
        Dict.streamInt(cFFByteArrayBuilder, n);
        integerKey.stream(cFFByteArrayBuilder);
    }

    static void streamKeyVal(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, StringKey stringKey, String string, List list) {
        Dict.streamInt(cFFByteArrayBuilder, list.indexOf(string));
        stringKey.stream(cFFByteArrayBuilder);
    }

    private static void streamInt(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, int n) {
        if (-107 <= n && n <= 107) {
            cFFByteArrayBuilder.addCard8(n + 139);
        } else if (108 <= n && n <= 1131) {
            cFFByteArrayBuilder.addCard8((n - 108) / 256 + 247);
            cFFByteArrayBuilder.addCard8((n - 108) % 256);
        } else if (-1131 <= n && n <= -108) {
            cFFByteArrayBuilder.addCard8((-108 - n) / 256 + 251);
            cFFByteArrayBuilder.addCard8((-108 - n) % 256);
        } else if (Short.MIN_VALUE <= n && n <= Short.MAX_VALUE) {
            cFFByteArrayBuilder.addCard8(28);
            cFFByteArrayBuilder.addCard16(n);
        } else {
            cFFByteArrayBuilder.addCard8(29);
            cFFByteArrayBuilder.addCard32(n);
        }
    }

    private static void streamDouble(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, Double d) throws InvalidFontException {
        int n = d.intValue();
        if ((double)n == d) {
            Dict.streamInt(cFFByteArrayBuilder, n);
            return;
        }
        Dict.streamDouble(cFFByteArrayBuilder, d.toString());
    }

    private static void streamDouble(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, String string) throws InvalidFontException {
        cFFByteArrayBuilder.addCard8(30);
        int n = 0;
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '0': {
                    n = (byte)(n | 0 << (bl ? 4 : 0));
                    break;
                }
                case '1': {
                    n = (byte)(n | 1 << (bl ? 4 : 0));
                    break;
                }
                case '2': {
                    n = (byte)(n | 2 << (bl ? 4 : 0));
                    break;
                }
                case '3': {
                    n = (byte)(n | 3 << (bl ? 4 : 0));
                    break;
                }
                case '4': {
                    n = (byte)(n | 4 << (bl ? 4 : 0));
                    break;
                }
                case '5': {
                    n = (byte)(n | 5 << (bl ? 4 : 0));
                    break;
                }
                case '6': {
                    n = (byte)(n | 6 << (bl ? 4 : 0));
                    break;
                }
                case '7': {
                    n = (byte)(n | 7 << (bl ? 4 : 0));
                    break;
                }
                case '8': {
                    n = (byte)(n | 8 << (bl ? 4 : 0));
                    break;
                }
                case '9': {
                    n = (byte)(n | 9 << (bl ? 4 : 0));
                    break;
                }
                case '.': {
                    n = (byte)(n | 10 << (bl ? 4 : 0));
                    break;
                }
                case 'E': {
                    int n2 = 11;
                    if (i < string.length() - 1 && string.charAt(i + 1) == '-') {
                        n2 = 12;
                        ++i;
                    }
                    n = (byte)(n | n2 << (bl ? 4 : 0));
                    break;
                }
                case '-': {
                    n = (byte)(n | 14 << (bl ? 4 : 0));
                    break;
                }
                default: {
                    throw new InvalidFontException("CFF: invalid float number");
                }
            }
            if (!bl) {
                cFFByteArrayBuilder.addCard8(n);
                n = 0;
            }
            bl = !bl;
        }
        if (bl) {
            cFFByteArrayBuilder.addCard8(255);
        } else {
            cFFByteArrayBuilder.addCard8(n | 0xF);
        }
    }

    static {
        NumbersValue numbersValue = new NumbersValue(0);
        NumbersValue numbersValue2 = new NumbersValue(1);
        NumbersValue numbersValue3 = new NumbersValue(2);
        OffsetValue offsetValue = new OffsetValue(0);
        NumbersValue numbersValue4 = new NumbersValue(0);
        defaultDict = new HashMap();
        defaultDict.put(Key.isFixedPitch, numbersValue4);
        defaultDict.put(Key.ItalicAngle, numbersValue);
        defaultDict.put(Key.UnderlinePosition, new NumbersValue(-100));
        defaultDict.put(Key.UnderlineThickness, new NumbersValue(50));
        defaultDict.put(Key.PaintType, numbersValue3);
        defaultDict.put(Key.CharstringType, numbersValue3);
        try {
            defaultDict.put(Key.FontMatrix, new NumbersValue(new Object[]{"0.001", "0", "0", "0.001", "0", "0"}));
            defaultDict.put(Key.FontBBox, new NumbersValue(new Object[]{"0", "0", "0", "0"}));
        }
        catch (InvalidFontException invalidFontException) {
            // empty catch block
        }
        defaultDict.put(Key.StrokeWidth, numbersValue);
        defaultDict.put(Key.charset, offsetValue);
        defaultDict.put(Key.Encoding, offsetValue);
        defaultDict.put(Key.BlueScale, new NumbersValue("0.039625"));
        defaultDict.put(Key.BlueShift, new NumbersValue(7));
        defaultDict.put(Key.BlueFuzz, numbersValue2);
        defaultDict.put(Key.ForceBold, numbersValue4);
        defaultDict.put(Key.LanguageGroup, numbersValue);
        defaultDict.put(Key.ExpansionFactor, new NumbersValue("0.06"));
        defaultDict.put(Key.initialRandomSeed, numbersValue);
        defaultDict.put(Key.defaultWidthX, numbersValue);
        defaultDict.put(Key.nominalWidthX, numbersValue);
        defaultDict.put(Key.CIDFontVersion, numbersValue);
        defaultDict.put(Key.CIDFontRevision, numbersValue);
        defaultDict.put(Key.CIDFontType, numbersValue);
        defaultDict.put(Key.CIDCount, new NumbersValue(8720));
        defaultDict.put(Key.ForceBoldThreshold, numbersValue);
    }

    private static class ValueStack {
        int count = 0;
        Object[] values = new Object[48];

        private ValueStack() {
        }

        void pushInt(int n) throws InvalidFontException {
            if (this.count == this.values.length) {
                throw new InvalidFontException("CFF Dict stack overflow");
            }
            this.values[this.count] = new Integer(n);
            ++this.count;
        }

        void pushDouble(String string) throws InvalidFontException {
            if (this.count == this.values.length) {
                throw new InvalidFontException("CFF Dict stack overflow");
            }
            this.values[this.count] = string;
            ++this.count;
        }

        int popInt() throws InvalidFontException {
            if (this.count == 0) {
                throw new InvalidFontException("empty CFF Dict stack");
            }
            --this.count;
            if (this.values[this.count] instanceof Integer) {
                return (Integer)this.values[this.count];
            }
            try {
                return (int)Double.parseDouble((String)this.values[this.count]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFontException("Invalid number on stack", numberFormatException);
            }
        }

        Object popValue() throws InvalidFontException {
            if (this.count == 0) {
                throw new InvalidFontException("empty CFF Dict statck");
            }
            --this.count;
            return this.values[this.count];
        }
    }

    static class StringKey
    extends Key {
        StringKey(int n, int n2, String string) {
            super(n, n2, string);
        }

        StringKey(int n, String string) {
            super(n, string);
        }

        public Value parse(ValueStack valueStack, StringIndex stringIndex) throws InvalidFontException {
            return new StringValue(valueStack, stringIndex);
        }

        public boolean compatibleValue(Object object) {
            return object instanceof StringValue;
        }
    }

    static class ROSKey
    extends Key {
        ROSKey(int n, int n2, String string) {
            super(n, n2, string);
        }

        ROSKey(int n, String string) {
            super(n, string);
        }

        public Value parse(ValueStack valueStack, StringIndex stringIndex) throws InvalidFontException {
            return new ROSValue(valueStack, stringIndex);
        }

        public boolean compatibleValue(Object object) {
            return object instanceof ROSValue;
        }
    }

    static class OffsetSizeKey
    extends Key {
        OffsetSizeKey(int n, int n2, String string) {
            super(n, n2, string);
        }

        OffsetSizeKey(int n, String string) {
            super(n, string);
        }

        public Value parse(ValueStack valueStack, StringIndex stringIndex) throws InvalidFontException {
            return new OffsetSizeValue(valueStack);
        }

        public int streamDummyValue(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder) {
            int n = cFFByteArrayBuilder.getSize();
            cFFByteArrayBuilder.addCard8(29);
            cFFByteArrayBuilder.addCard32(0);
            cFFByteArrayBuilder.addCard8(29);
            cFFByteArrayBuilder.addCard32(0);
            super.stream(cFFByteArrayBuilder);
            return n;
        }

        public void fixOffset(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, int n, int n2) {
            cFFByteArrayBuilder.setCard32(n + 6, n2);
        }

        public void fixSize(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, int n, int n2) {
            cFFByteArrayBuilder.setCard32(n + 1, n2);
        }

        public boolean compatibleValue(Object object) {
            return object instanceof OffsetSizeValue;
        }
    }

    static class OffsetKey
    extends Key {
        OffsetKey(int n, int n2, String string) {
            super(n, n2, string);
        }

        OffsetKey(int n, String string) {
            super(n, string);
        }

        public Value parse(ValueStack valueStack, StringIndex stringIndex) throws InvalidFontException {
            return new OffsetValue(valueStack);
        }

        public int streamDummyValue(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder) {
            int n = cFFByteArrayBuilder.getSize();
            cFFByteArrayBuilder.addCard8(29);
            cFFByteArrayBuilder.addCard32(0);
            this.stream(cFFByteArrayBuilder);
            return n;
        }

        public void fixOffset(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, int n, int n2) {
            cFFByteArrayBuilder.setCard32(n + 1, n2);
        }

        public boolean compatibleValue(Object object) {
            return object instanceof OffsetValue;
        }
    }

    static class NumbersKey
    extends Key {
        final int stackDepth;

        NumbersKey(int n, int n2, String string, int n3) {
            super(n, n2, string);
            this.stackDepth = n3;
        }

        NumbersKey(int n, String string, int n2) {
            super(n, string);
            this.stackDepth = n2;
        }

        public Value parse(ValueStack valueStack, StringIndex stringIndex) throws InvalidFontException {
            return new NumbersValue(valueStack, this.stackDepth);
        }

        public boolean compatibleValue(Object object) {
            if (!(object instanceof NumbersValue)) {
                return false;
            }
            if (this.stackDepth != -1) {
                NumbersValue numbersValue = (NumbersValue)object;
                return numbersValue.values.length == this.stackDepth;
            }
            return true;
        }
    }

    static class IntegerKey
    extends Key {
        IntegerKey(int n, int n2, String string) {
            super(n, n2, string);
        }

        IntegerKey(int n, String string) {
            super(n, string);
        }

        public Value parse(ValueStack valueStack, StringIndex stringIndex) throws InvalidFontException {
            return new IntegerValue(valueStack);
        }

        public boolean compatibleValue(Object object) {
            return object instanceof IntegerValue;
        }
    }

    static abstract class Key {
        private final String name;
        private final int opcode1;
        private final int opcode2;
        private static final Key[] nonExtendedKeys = new Key[27];
        private static final Key[] extendedKeys = new Key[39];
        static final StringKey version = new StringKey(0, "version");
        static final StringKey Notice = new StringKey(1, "Notice");
        static final StringKey FullName = new StringKey(2, "FullName");
        static final StringKey FamilyName = new StringKey(3, "FamilyName");
        static final StringKey Weight = new StringKey(4, "Weight");
        static final NumbersKey FontBBox = new NumbersKey(5, "FontBBox", 4);
        static final NumbersKey BlueValues = new NumbersKey(6, "BlueValues", -1);
        static final NumbersKey OtherBlues = new NumbersKey(7, "OtherBlues", -1);
        static final NumbersKey FamilyBlues = new NumbersKey(8, "FamilyBlues", -1);
        static final NumbersKey FamilyOtherBlues = new NumbersKey(9, "FamilyOtherBlues", -1);
        static final NumbersKey StdHW = new NumbersKey(10, "StdHW", 1);
        static final NumbersKey StdVW = new NumbersKey(11, "StdVW", 1);
        static final NumbersKey UniqueID = new NumbersKey(13, "UniqueID", 1);
        static final NumbersKey XUID = new NumbersKey(14, "XUID", -1);
        static final OffsetKey charset = new OffsetKey(15, "charset");
        static final OffsetKey Encoding = new OffsetKey(16, "Encoding");
        static final OffsetKey CharStrings = new OffsetKey(17, "CharStrings");
        static final OffsetSizeKey Private = new OffsetSizeKey(18, "Private");
        static final OffsetKey Subrs = new OffsetKey(19, "Subrs");
        static final NumbersKey defaultWidthX = new NumbersKey(20, "defaultWidthX", 1);
        static final NumbersKey nominalWidthX = new NumbersKey(21, "nominalWidthX", 1);
        static final StringKey Copyright = new StringKey(12, 0, "Copyright");
        static final NumbersKey isFixedPitch = new NumbersKey(12, 1, "isFixedPitch", 1);
        static final NumbersKey ItalicAngle = new NumbersKey(12, 2, "ItalicAngle", 1);
        static final NumbersKey UnderlinePosition = new NumbersKey(12, 3, "UnderlinePosition", 1);
        static final NumbersKey UnderlineThickness = new NumbersKey(12, 4, "UnderlineThickness", 1);
        static final NumbersKey PaintType = new NumbersKey(12, 5, "PainType", 1);
        static final NumbersKey CharstringType = new NumbersKey(12, 6, "CharstringType", 1);
        static final NumbersKey FontMatrix = new NumbersKey(12, 7, "FontMatrix", 6);
        static final NumbersKey StrokeWidth = new NumbersKey(12, 8, "StrokeWidth", 1);
        static final NumbersKey BlueScale = new NumbersKey(12, 9, "BlueScale", 1);
        static final NumbersKey BlueShift = new NumbersKey(12, 10, "BlueShift", 1);
        static final NumbersKey BlueFuzz = new NumbersKey(12, 11, "BlueFuzz", 1);
        static final NumbersKey StemSnapH = new NumbersKey(12, 12, "StemSnapH", -1);
        static final NumbersKey StemSnapV = new NumbersKey(12, 13, "StemSnapV", -1);
        static final NumbersKey ForceBold = new NumbersKey(12, 14, "ForceBold", 1);
        static final NumbersKey ForceBoldThreshold = new NumbersKey(12, 15, "ForceBoldThreshold", 1);
        static final NumbersKey LanguageGroup = new NumbersKey(12, 17, "LanguageGroup", 1);
        static final NumbersKey ExpansionFactor = new NumbersKey(12, 18, "ExpansionFactor", 1);
        static final NumbersKey initialRandomSeed = new NumbersKey(12, 19, "initialRandomSeed", 1);
        static final IntegerKey SyntheticBase = new IntegerKey(12, 20, "SyntheticBase");
        static final StringKey PostScript = new StringKey(12, 21, "PostScript");
        static final StringKey BaseFontName = new StringKey(12, 22, "BaseFontName");
        static final NumbersKey BaseFontBlend = new NumbersKey(12, 23, "BaseFontBlend", -1);
        static final ROSKey ROS = new ROSKey(12, 30, "ROS");
        static final NumbersKey CIDFontVersion = new NumbersKey(12, 31, "CIDFontVersion", 1);
        static final NumbersKey CIDFontRevision = new NumbersKey(12, 32, "CIDFontRevision", 1);
        static final NumbersKey CIDFontType = new NumbersKey(12, 33, "CIDFontType", 1);
        static final IntegerKey CIDCount = new IntegerKey(12, 34, "CIDCount");
        static final NumbersKey UIDBase = new NumbersKey(12, 35, "UIDBase", 1);
        static final OffsetKey FDArray = new OffsetKey(12, 36, "FDArray");
        static final OffsetKey FDSelect = new OffsetKey(12, 37, "FDSelect");
        static final StringKey FontName = new StringKey(12, 38, "FontName");

        private Key(int n, String string) {
            this.opcode1 = n;
            this.opcode2 = -1;
            this.name = string;
            Key.nonExtendedKeys[n] = this;
        }

        private Key(int n, int n2, String string) {
            this.opcode1 = n;
            this.opcode2 = n2;
            this.name = string;
            Key.extendedKeys[n2] = this;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            return this.name.equals(key.name) && this.opcode1 == key.opcode1 && this.opcode2 == key.opcode2;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }

        int opCodeLength() {
            if (this.opcode2 == -1) {
                return 1;
            }
            return 2;
        }

        void stream(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder) {
            cFFByteArrayBuilder.addCard8(this.opcode1);
            if (this.opcode2 != -1) {
                cFFByteArrayBuilder.addCard8(this.opcode2);
            }
        }

        abstract Value parse(ValueStack var1, StringIndex var2) throws InvalidFontException;

        abstract boolean compatibleValue(Object var1);
    }

    static class IntegerValue
    implements Value {
        public final int value;

        public IntegerValue(ValueStack valueStack) throws InvalidFontException {
            this.value = valueStack.popInt();
        }

        public IntegerValue(int n) {
            this.value = n;
        }

        public void collectStrings(List list) {
        }

        public void stream(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, List list) {
            Dict.streamInt(cFFByteArrayBuilder, this.value);
        }
    }

    static class ROSValue
    implements Value {
        public final ROS ros;

        public ROSValue(ValueStack valueStack, StringIndex stringIndex) throws InvalidFontException {
            int n = valueStack.popInt();
            String string = stringIndex.getString(valueStack.popInt());
            String string2 = stringIndex.getString(valueStack.popInt());
            this.ros = new ROS(string2, string, n);
        }

        public ROSValue(String string, String string2, int n) {
            this.ros = new ROS(string, string2, n);
        }

        public void collectStrings(List list) {
            if (list.indexOf(this.ros.registry) == -1) {
                list.add(this.ros.registry);
            }
            if (list.indexOf(this.ros.ordering) == -1) {
                list.add(this.ros.ordering);
            }
        }

        public void stream(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, List list) {
            Dict.streamInt(cFFByteArrayBuilder, list.indexOf(this.ros.registry));
            Dict.streamInt(cFFByteArrayBuilder, list.indexOf(this.ros.ordering));
            Dict.streamInt(cFFByteArrayBuilder, this.ros.supplement);
        }
    }

    static class OffsetSizeValue
    implements Value {
        public final int size;
        public int offset;

        public OffsetSizeValue(ValueStack valueStack) throws InvalidFontException {
            this.offset = valueStack.popInt();
            this.size = valueStack.popInt();
        }

        public void collectStrings(List list) {
        }

        public void stream(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, List list) {
        }
    }

    static class OffsetValue
    implements Value {
        public final int offset;

        public OffsetValue(ValueStack valueStack) throws InvalidFontException {
            this.offset = valueStack.popInt();
        }

        public OffsetValue(int n) {
            this.offset = n;
        }

        public void collectStrings(List list) {
        }

        public void stream(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, List list) {
        }
    }

    static class NumbersValue
    implements Value {
        public final Object[] values;

        public NumbersValue(ValueStack valueStack, int n) {
            if (n == -1) {
                n = valueStack.count;
            }
            this.values = new Object[n];
            try {
                for (int i = n - 1; i >= 0; --i) {
                    this.values[i] = valueStack.popValue();
                }
            }
            catch (InvalidFontException invalidFontException) {
                // empty catch block
            }
        }

        public NumbersValue(Object[] objectArray) throws InvalidFontException {
            this.values = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Integer || objectArray[i] instanceof String || objectArray[i] instanceof Double)) {
                    throw new InvalidFontException("invalid value");
                }
                this.values[i] = objectArray[i];
            }
        }

        public NumbersValue(int[] nArray) {
            this.values = new Object[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.values[i] = new Integer(nArray[i]);
            }
        }

        public NumbersValue(double[] dArray) {
            this.values = new Object[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.values[i] = new Double(dArray[i]);
            }
        }

        public NumbersValue(Double d) {
            this.values = new Object[]{d};
        }

        public NumbersValue(Integer n) {
            this.values = new Object[]{n};
        }

        public NumbersValue(int n) {
            this.values = new Object[]{new Integer(n)};
        }

        public NumbersValue(String string) {
            this.values = new Object[]{string};
        }

        public NumbersValue(Matrix matrix) {
            this.values = new Object[]{new Double(matrix.a), new Double(matrix.b), new Double(matrix.c), new Double(matrix.d), new Double(matrix.tx), new Double(matrix.ty)};
        }

        public NumbersValue(Rect rect) {
            this.values = new Object[]{new Double(rect.xmin), new Double(rect.ymin), new Double(rect.xmax), new Double(rect.ymax)};
        }

        public void collectStrings(List list) {
        }

        public void stream(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, List list) throws InvalidFontException {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] instanceof Integer) {
                    Dict.streamInt(cFFByteArrayBuilder, (Integer)this.values[i]);
                    continue;
                }
                if (this.values[i] instanceof String) {
                    Dict.streamDouble(cFFByteArrayBuilder, (String)this.values[i]);
                    continue;
                }
                double d = (Double)this.values[i];
                int n = (int)d;
                if ((double)n == d) {
                    Dict.streamInt(cFFByteArrayBuilder, n);
                    continue;
                }
                Dict.streamDouble(cFFByteArrayBuilder, (Double)this.values[i]);
            }
        }

        public int getCount() {
            return this.values.length;
        }

        public double[] getValuesAsDouble() {
            double[] dArray = new double[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                dArray[i] = this.values[i] instanceof Integer ? (double)((Integer)this.values[i]).intValue() : (this.values[i] instanceof String ? Double.parseDouble((String)this.values[i]) : (Double)this.values[i]);
            }
            return dArray;
        }

        public int[] getValuesAsInt() {
            int[] nArray = new int[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                nArray[i] = this.values[i] instanceof Integer ? (Integer)this.values[i] : (this.values[i] instanceof String ? Integer.parseInt((String)this.values[i]) : ((Double)this.values[i]).intValue());
            }
            return nArray;
        }

        public double getFirstValueAsDouble() {
            if (this.values[0] instanceof Integer) {
                return ((Integer)this.values[0]).intValue();
            }
            if (this.values[0] instanceof String) {
                return Double.parseDouble((String)this.values[0]);
            }
            return (Double)this.values[0];
        }
    }

    static class StringValue
    implements Value {
        public final String value;

        public StringValue(ValueStack valueStack, StringIndex stringIndex) throws InvalidFontException {
            this.value = stringIndex.getString(valueStack.popInt());
        }

        public StringValue(String string) {
            this.value = string;
        }

        public void collectStrings(List list) {
            if (list.indexOf(this.value) == -1) {
                list.add(this.value);
            }
        }

        public void stream(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, List list) {
            Dict.streamInt(cFFByteArrayBuilder, list.indexOf(this.value));
        }
    }

    static interface Value {
        public void collectStrings(List var1);

        public void stream(CFFByteArray.CFFByteArrayBuilder var1, List var2) throws InvalidFontException;
    }
}

