/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.ChainingFormat1Harvester;
import com.adobe.fontengine.font.opentype.ChainingFormat2Harvester;
import com.adobe.fontengine.font.opentype.ContextFormat1Harvester;
import com.adobe.fontengine.font.opentype.ContextFormat2Harvester;
import com.adobe.fontengine.font.opentype.Gpos;
import com.adobe.fontengine.font.opentype.IntGrowableArray;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LookupTableHarvester;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class GposHarvester
extends LookupTableHarvester {
    private static final NoopHarvester noopHarvester = new NoopHarvester();
    private final NCoveragesHarvester twoCoveragesHarvester = new NCoveragesHarvester(2, 2, 1);
    private final PairPosFormat1Harvester pairPosHarvester = new PairPosFormat1Harvester();

    GposHarvester(Gpos gpos, int n) {
        super(gpos, n);
    }

    TreeMap gatherPossibleLookups(Subset subset) throws InvalidFontException, UnsupportedFontException {
        TreeMap treeMap = new TreeMap();
        IntGrowableArray intGrowableArray = this.getAllFeatureListFeatures();
        this.harvestAllFeatures(intGrowableArray, treeMap, subset);
        return treeMap;
    }

    private List gatherPairPosLookups(int n, Subset subset, List list, int n2) throws InvalidFontException, UnsupportedFontException {
        int n3 = this.lookupTable.data.getuint16(n);
        switch (n3) {
            case 1: {
                return this.gatherLookupsForCoverage(n, 2, subset, list, this.pairPosHarvester, n2);
            }
            case 2: {
                return this.gatherLookupsForCoverage(n, 2, subset, list, noopHarvester, n2);
            }
        }
        throw new InvalidFontException("Invalid pair pos lookup format (" + n3 + ")");
    }

    private List gatherPairPosLookupsForAllSubtables(Subset subset, int n) throws InvalidFontException, UnsupportedFontException {
        List list = null;
        int n2 = this.lookupTable.data.getuint16(n + 4);
        for (int i = 0; i < n2; ++i) {
            int n3 = this.lookupTable.data.getOffset(n, 6 + 2 * i);
            list = this.gatherPairPosLookups(n3, subset, list, i);
        }
        return list;
    }

    private List gatherContextualLookup(int n, Subset subset, Map map, List list, int n2) throws InvalidFontException, UnsupportedFontException {
        int n3 = this.lookupTable.data.getuint16(n);
        switch (n3) {
            case 1: {
                return this.gatherLookupsForCoverage(n, 2, subset, list, new ContextFormat1Harvester(this, map, false), n2);
            }
            case 2: {
                return this.gatherLookupsForCoverage(n, 2, subset, list, new ContextFormat2Harvester(this, map), n2);
            }
            case 3: {
                int n4 = this.lookupTable.data.getuint16(n + 2);
                if (n4 > 0) {
                    return this.gatherLookupsForCoverage(n, 6, subset, list, new ContextFormat3Harvester(map, n), n2);
                }
                return list;
            }
        }
        throw new InvalidFontException("Invalid contextual lookup format (" + n3 + ")");
    }

    private List gatherContextualLookupsForAllSubtables(Subset subset, int n, Map map) throws InvalidFontException, UnsupportedFontException {
        List list = null;
        int n2 = this.lookupTable.data.getuint16(n + 4);
        for (int i = 0; i < n2; ++i) {
            int n3 = this.lookupTable.data.getOffset(n, 6 + 2 * i);
            list = this.gatherContextualLookup(n3, subset, map, list, i);
        }
        return list;
    }

    private List gatherChainingLookup(int n, Subset subset, Map map, List list, int n2) throws InvalidFontException, UnsupportedFontException {
        int n3 = this.lookupTable.data.getuint16(n);
        switch (n3) {
            case 1: {
                return this.gatherLookupsForCoverage(n, 2, subset, list, new ChainingFormat1Harvester(this, map, false), n2);
            }
            case 2: {
                return this.gatherLookupsForCoverage(n, 2, subset, list, new ChainingFormat2Harvester(this, map), n2);
            }
            case 3: {
                int n4 = this.lookupTable.data.getuint16(n + 2);
                int n5 = this.lookupTable.data.getuint16(n + 4 + 2 * n4);
                if (n5 > 0) {
                    return this.gatherLookupsForCoverage(n, 4 + 2 * n4 + 2, subset, list, new ChainingFormat3Harvester(map, n), n2);
                }
                return list;
            }
        }
        throw new InvalidFontException("Invalid contextual lookup format (" + n3 + ")");
    }

    private List gatherChainingLookupsForAllSubtables(Subset subset, int n, Map map) throws InvalidFontException, UnsupportedFontException {
        List list = null;
        int n2 = this.lookupTable.data.getuint16(n + 4);
        for (int i = 0; i < n2; ++i) {
            int n3 = this.lookupTable.data.getOffset(n, 6 + 2 * i);
            list = this.gatherChainingLookup(n3, subset, map, list, i);
        }
        return list;
    }

    private List gatherExtensionGlyphsForAllSubtables(Subset subset, int n, Map map) throws InvalidFontException, UnsupportedFontException {
        ArrayList<Integer> arrayList = null;
        List list = null;
        int n2 = this.lookupTable.data.getuint16(n + 4);
        for (int i = 0; i < n2; ++i) {
            Integer n3;
            int n4 = this.lookupTable.data.getOffset(n, 6 + 2 * i);
            int n5 = this.lookupTable.data.getuint16(n4);
            if (n5 != 1) {
                throw new InvalidFontException("Invalid extension format (" + n5 + ")");
            }
            int n6 = this.lookupTable.data.getuint16(n4 + 2);
            int n7 = this.lookupTable.data.getuint32asint(n4 + 4, "Only signed extension values supported");
            switch (n6) {
                case 1: 
                case 3: {
                    list = this.gatherLookupsForCoverage(n4 + n7, 2, subset, list, noopHarvester, 0);
                    break;
                }
                case 2: {
                    list = this.gatherPairPosLookups(n4 + n7, subset, list, 0);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    this.twoCoveragesHarvester.resetCoverageInfo(2, 2, 1);
                    list = this.gatherLookupsForCoverage(n4 + n7, 2, subset, list, this.twoCoveragesHarvester, 0);
                    break;
                }
                case 7: {
                    list = this.gatherContextualLookup(n4 + n7, subset, map, list, 0);
                    break;
                }
                case 8: {
                    list = this.gatherChainingLookup(n4 + n7, subset, map, list, 0);
                    break;
                }
                default: {
                    throw new InvalidFontException("Invalid GPOS lookup type (" + n6 + ")");
                }
            }
            if (list == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
            }
            if (arrayList.contains(n3 = new Integer(i))) continue;
            arrayList.add(n3);
        }
        return arrayList;
    }

    List harvestSubtables(Subset subset, int n, int n2, int n3, Map map) throws InvalidFontException, UnsupportedFontException {
        switch (n2) {
            case 1: 
            case 3: {
                return this.gatherLookupsForCoverageAllSubtables(subset, n, noopHarvester);
            }
            case 2: {
                return this.gatherPairPosLookupsForAllSubtables(subset, n);
            }
            case 4: 
            case 5: 
            case 6: {
                this.twoCoveragesHarvester.resetCoverageInfo(2, 2, 1);
                return this.gatherLookupsForCoverageAllSubtables(subset, n, this.twoCoveragesHarvester);
            }
            case 7: {
                return this.gatherContextualLookupsForAllSubtables(subset, n, map);
            }
            case 8: {
                return this.gatherChainingLookupsForAllSubtables(subset, n, map);
            }
            case 9: {
                return this.gatherExtensionGlyphsForAllSubtables(subset, n, map);
            }
        }
        throw new InvalidFontException("Invalid GPOS lookup type (" + n2 + ")");
    }

    private class ChainingFormat3Harvester
    extends NCoveragesHarvester {
        private final Map lookups;
        private int backtrackCount;
        private boolean subsequentCoveragesTested;
        private boolean subsequentCoveragesApply;

        ChainingFormat3Harvester(Map map, int n) throws InvalidFontException {
            super(4, GposHarvester.this.lookupTable.data.getuint16(n + 2), 1);
            this.subsequentCoveragesTested = false;
            this.backtrackCount = GposHarvester.this.lookupTable.data.getuint16(n + 2);
            this.lookups = map;
        }

        public boolean lookupApplies(int n, int n2, int n3, Subset subset) throws InvalidFontException, UnsupportedFontException {
            if (this.subsequentCoveragesTested) {
                return this.subsequentCoveragesApply;
            }
            this.subsequentCoveragesTested = true;
            boolean bl = super.lookupApplies(n, n2, n3, subset);
            if (!bl) {
                this.subsequentCoveragesApply = false;
                return false;
            }
            int n4 = GposHarvester.this.lookupTable.data.getuint16(n2 + 4 + 2 * this.backtrackCount);
            this.resetCoverageInfo(4 + 2 * this.backtrackCount + 2, n4, 0);
            bl = super.lookupApplies(n, n2, n3, subset);
            if (!bl) {
                this.subsequentCoveragesApply = false;
                return false;
            }
            int n5 = GposHarvester.this.lookupTable.data.getuint16(n2 + 6 + 2 * this.backtrackCount + 2 * n4);
            this.resetCoverageInfo(8 + 2 * this.backtrackCount + 2 * n4, n5, 0);
            bl = super.lookupApplies(n, n2, n3, subset);
            if (!bl) {
                this.subsequentCoveragesApply = false;
                return false;
            }
            int n6 = GposHarvester.this.lookupTable.data.getuint16(n2 + 8 + 2 * this.backtrackCount + 2 * n4 + 2 * n5);
            for (int i = 0; i < n6; ++i) {
                int n7 = GposHarvester.this.lookupTable.data.getuint16(n2 + 10 + 2 * this.backtrackCount + 2 * n4 + 2 * n5 + 4 * i + 2);
                GposHarvester.this.harvest(subset, n7, this.lookups);
            }
            this.subsequentCoveragesApply = true;
            return true;
        }
    }

    private class ContextFormat3Harvester
    extends NCoveragesHarvester {
        private final Map lookups;

        ContextFormat3Harvester(Map map, int n) throws InvalidFontException {
            super(6, GposHarvester.this.lookupTable.data.getuint16(n + 2), 1);
            this.lookups = map;
        }

        public boolean lookupApplies(int n, int n2, int n3, Subset subset) throws InvalidFontException, UnsupportedFontException {
            boolean bl = super.lookupApplies(n, n2, n3, subset);
            if (bl) {
                int n4 = GposHarvester.this.lookupTable.data.getuint16(n2 + 4);
                for (int i = 0; i < n4; ++i) {
                    int n5 = GposHarvester.this.lookupTable.data.getuint16(n2 + 6 + 2 * this.numCoverages + 4 * i + 2);
                    GposHarvester.this.harvest(subset, n5, this.lookups);
                }
            }
            return bl;
        }
    }

    private class NCoveragesHarvester
    extends GposLookupHarvester
    implements LayoutTable.CoverageConsumer {
        private boolean covered;
        private boolean subsequentCoveragesIterated;
        private boolean subsequentCoveragesCovered;
        private int offsetDeltaToCoverages;
        protected int numCoverages;
        private int coverageStartIndex;

        NCoveragesHarvester(int n, int n2, int n3) {
            this.subsequentCoveragesIterated = false;
            this.offsetDeltaToCoverages = n;
            this.numCoverages = n2;
            this.coverageStartIndex = n3;
        }

        protected void resetCoverageInfo(int n, int n2, int n3) {
            this.subsequentCoveragesIterated = false;
            this.offsetDeltaToCoverages = n;
            this.numCoverages = n2;
            this.coverageStartIndex = n3;
        }

        public boolean lookupApplies(int n, int n2, int n3, Subset subset) throws InvalidFontException, UnsupportedFontException {
            if (this.subsequentCoveragesIterated) {
                return this.subsequentCoveragesCovered;
            }
            this.subsequentCoveragesIterated = true;
            for (int i = this.coverageStartIndex; i < this.numCoverages; ++i) {
                this.covered = false;
                GposHarvester.this.lookupTable.iterateCoverage(GposHarvester.this.lookupTable.data.getOffset(n2, this.offsetDeltaToCoverages + 2 * i), subset, this);
                if (this.covered) continue;
                this.subsequentCoveragesCovered = false;
                return false;
            }
            this.subsequentCoveragesCovered = true;
            return true;
        }

        public boolean glyphInfo(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            this.covered = true;
            return false;
        }
    }

    private class PairPosFormat1Harvester
    extends GposLookupHarvester {
        private PairPosFormat1Harvester() {
        }

        public boolean lookupApplies(int n, int n2, int n3, Subset subset) throws InvalidFontException, UnsupportedFontException {
            int n4 = GposHarvester.this.lookupTable.data.getOffset(n2, 10 + 2 * n3);
            int n5 = ((Gpos)GposHarvester.this.lookupTable).getValueRecordSize(GposHarvester.this.lookupTable.data.getuint16(n2 + 4));
            int n6 = ((Gpos)GposHarvester.this.lookupTable).getValueRecordSize(GposHarvester.this.lookupTable.data.getuint16(n2 + 6));
            int n7 = GposHarvester.this.lookupTable.data.getuint16(n4);
            for (int i = 0; i < n7; ++i) {
                int n8 = GposHarvester.this.lookupTable.data.getuint16(n4 + 2 + (2 + n5 + n6) * i);
                if (subset.getExistingSubsetGid(n8) == -1) continue;
                return true;
            }
            return false;
        }
    }

    private static class NoopHarvester
    extends GposLookupHarvester {
        private NoopHarvester() {
        }

        public boolean lookupApplies(int n, int n2, int n3, Subset subset) {
            return true;
        }
    }

    private static abstract class GposLookupHarvester
    implements LookupTableHarvester.CoverageLookupHarvester {
        private GposLookupHarvester() {
        }

        public boolean keepGoing() {
            return false;
        }
    }
}

