/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.SWFFont4Description;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.GsubHarvester;
import com.adobe.fontengine.font.opentype.OTFSWFFont3Description;
import com.adobe.fontengine.font.opentype.OTSubset;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;

class OTFSWFFont4Description
extends SWFFont4Description {
    private final OTFSWFFont3Description defineFont3Desc;
    private final OpenTypeFont theFont;

    OTFSWFFont4Description(OpenTypeFont openTypeFont, boolean bl) throws InvalidFontException, UnsupportedFontException {
        this.theFont = openTypeFont;
        this.defineFont3Desc = new OTFSWFFont3Description(openTypeFont, bl);
    }

    public boolean canDisplay(int n) throws UnsupportedFontException, InvalidFontException {
        try {
            return this.theFont.cmap.unicodeChar2glyph(n) != 0;
        }
        catch (NullPointerException nullPointerException) {
            throw new InvalidFontException("Missing required table", nullPointerException);
        }
    }

    public int getFirstChar() throws InvalidFontException, UnsupportedFontException {
        return this.defineFont3Desc.getFirstChar();
    }

    public int getLastChar() throws InvalidFontException, UnsupportedFontException {
        try {
            if (this.theFont.cmap.symbolSubtableOffset != -1) {
                return this.theFont.cmap.getHighestMappedCode(this.theFont.cmap.symbolSubtableOffset, false);
            }
            if (this.theFont.cmap.unicodeSubtableOffset != -1) {
                return this.theFont.cmap.getHighestMappedCode(this.theFont.cmap.unicodeSubtableOffset, false);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new InvalidFontException("Missing required table", nullPointerException);
        }
        return 65535;
    }

    public Permission getPermissions() throws InvalidFontException, UnsupportedFontException {
        return this.defineFont3Desc.getPermissions();
    }

    public String getFamily() throws InvalidFontException, UnsupportedFontException {
        return this.defineFont3Desc.getFamily();
    }

    public String getSubFamily() throws InvalidFontException, UnsupportedFontException {
        return this.defineFont3Desc.getSubFamily();
    }

    public boolean isBold() throws InvalidFontException, UnsupportedFontException {
        return this.defineFont3Desc.isBold();
    }

    public boolean isItalic() throws InvalidFontException, UnsupportedFontException {
        return this.defineFont3Desc.isItalic();
    }

    public void streamFontData(Iterator iterator, OutputStream outputStream) throws InvalidFontException, UnsupportedFontException, IOException {
        Cloneable cloneable;
        OTSubset oTSubset = new OTSubset(this.theFont, true);
        TreeSet treeSet = new TreeSet();
        boolean bl = false;
        if (this.theFont.cmap != null) {
            cloneable = new ArrayList();
            while (iterator.hasNext()) {
                cloneable.add(iterator.next());
            }
            Collections.sort(cloneable);
            iterator = cloneable.iterator();
            bl = this.theFont.cmap.gatherPossibleMappings(iterator, treeSet, oTSubset);
        }
        cloneable = null;
        if (this.theFont.gsub != null) {
            GsubHarvester gsubHarvester = new GsubHarvester(this.theFont.gsub, this.theFont.getNumGlyphs());
            cloneable = gsubHarvester.gatherPossibleLookups(oTSubset);
        }
        this.theFont.subsetAndStreamForSWFEmbedding(oTSubset, outputStream, (TreeMap<Integer, List>)cloneable, treeSet, bl);
    }

    public void streamFontData(OutputStream outputStream) throws InvalidFontException, UnsupportedFontException, IOException {
        this.theFont.streamSFNTForSWFEditting(outputStream);
    }
}

