/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LookupTableSubsetter;
import com.adobe.fontengine.font.opentype.OTByteArray;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

abstract class SetGenerator
implements LayoutTable.CoverageConsumer,
LookupTableSubsetter.LookupSubtableGenerator {
    protected final Subset subset;
    protected final OTByteArray.OTByteArrayBuilder builder;
    protected final LayoutTable origTable;
    protected final int newSTOffset;
    protected final int origSTOffset;
    protected int subtableSize;
    protected int thisSet = 0;
    protected final int origSetCountDelta;
    protected final boolean preserveRuleSetIndexing;
    private int[] subsetGIDToOrigSetOffset;
    private Map origSetOffsetToNewSetOffset;
    private final boolean setElementsHaveOffsets;

    SetGenerator(LayoutTable layoutTable, Subset subset, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, int n3, int n4, boolean bl, boolean bl2) throws InvalidFontException {
        this.subset = subset;
        this.builder = oTByteArrayBuilder;
        this.newSTOffset = n;
        this.origSTOffset = n2;
        this.subtableSize = n4 + 2 + 2 * n3;
        this.origSetCountDelta = n4;
        this.preserveRuleSetIndexing = bl;
        this.origTable = layoutTable;
        this.setElementsHaveOffsets = bl2;
        this.origSetOffsetToNewSetOffset = new HashMap();
        if (bl) {
            n3 = layoutTable.data.getuint16(n2 + n4);
        } else {
            this.subsetGIDToOrigSetOffset = new int[subset.getNumGlyphs()];
            Arrays.fill(this.subsetGIDToOrigSetOffset, -1);
        }
        this.builder.ensureCapacity(n + n4 + 2 + 2 * n3);
        for (int i = 0; i < n3; ++i) {
            this.builder.setuint16(n + n4 + 2 + 2 * i, 0);
        }
    }

    public boolean glyphInfo(int n, int n2) throws InvalidFontException, UnsupportedFontException {
        int n3 = this.whichRuleSetIndexApplies(n, n2);
        int n4 = this.origTable.data.getOffset(this.origSTOffset, this.origSetCountDelta + 2 + 2 * n3);
        if (this.preserveRuleSetIndexing) {
            this.writeSubtableEntry(n3, n4);
        } else {
            this.subsetGIDToOrigSetOffset[this.subset.getExistingSubsetGid((int)n)] = n4;
        }
        return true;
    }

    public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
        if (this.preserveRuleSetIndexing) {
            return this.subtableSize;
        }
        int n = 0;
        for (int i = 0; i < this.subsetGIDToOrigSetOffset.length; ++i) {
            if (this.subsetGIDToOrigSetOffset[i] == -1) continue;
            this.writeSubtableEntry(n, this.subsetGIDToOrigSetOffset[i]);
            ++n;
        }
        return this.subtableSize;
    }

    private void writeSubtableEntry(int n, int n2) throws InvalidFontException, UnsupportedFontException {
        if (this.builder.getuint16(this.newSTOffset + this.origSetCountDelta + 2 + 2 * n) != 0) {
            return;
        }
        if (n2 != 0) {
            Integer n3 = (Integer)this.origSetOffsetToNewSetOffset.get(new Integer(n2));
            if (n3 == null) {
                this.origSetOffsetToNewSetOffset.put(new Integer(n2), new Integer(this.subtableSize));
                this.builder.setuint16(this.newSTOffset + this.origSetCountDelta + 2 + 2 * n, this.subtableSize);
                this.subtableSize += this.writeSet(this.newSTOffset + this.subtableSize, n2);
            } else {
                this.builder.setuint16(this.newSTOffset + this.origSetCountDelta + 2 + 2 * n, n3);
            }
        }
    }

    private int writeSet(int n, int n2) throws InvalidFontException, UnsupportedFontException {
        int n3;
        boolean[] blArray = this.computeMembersToKeep(n, n2);
        int n4 = 0;
        for (n3 = 0; n3 < blArray.length; ++n3) {
            if (!blArray[n3]) continue;
            ++n4;
        }
        n3 = this.setElementsHaveOffsets ? 2 + 2 * n4 : 2;
        this.builder.ensureCapacity(n + n3);
        this.builder.setuint16(n, n4);
        int n5 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            int n6;
            if (!blArray[i]) continue;
            if (this.setElementsHaveOffsets) {
                this.builder.setuint16(n + 2 + 2 * n5, n3);
                n6 = this.origTable.data.getOffset(n2, 2 + 2 * i);
            } else {
                n6 = n2 + 2 + this.getOrigRecordSize() * i;
            }
            n3 += this.writeMember(n + n3, n6);
            ++n5;
        }
        return n3;
    }

    protected int writeByteArrayAtOffset(int n, OTByteArray oTByteArray) throws InvalidFontException {
        this.builder.replace(n, oTByteArray, 0, oTByteArray.getSize());
        return oTByteArray.getSize();
    }

    abstract int whichRuleSetIndexApplies(int var1, int var2) throws InvalidFontException;

    abstract boolean[] computeMembersToKeep(int var1, int var2) throws InvalidFontException, UnsupportedFontException;

    abstract int writeMember(int var1, int var2) throws InvalidFontException, UnsupportedFontException;

    abstract int getOrigRecordSize();
}

