/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.type1.Type1CStringConsumerDefault;
import com.adobe.fontengine.font.type1.Type1CStringParser;
import com.adobe.fontengine.font.type1.Type1Font;

public final class Type1OutlineParser {
    private final Type1CStringParser parser = new Type1CStringParser();
    private OutlineConsumer c;
    private T1OutlineConsumer outlineconsumer = new T1OutlineConsumer();
    double cpx;
    double cpy;
    double pathStartX;
    double pathStartY;
    boolean pathStarted;

    public void parse(Type1Font type1Font, int n, OutlineConsumer outlineConsumer) throws InvalidGlyphException, UnsupportedFontException {
        this.cpy = 0.0;
        this.cpx = 0.0;
        this.pathStarted = false;
        this.c = outlineConsumer;
        outlineConsumer.setMatrix(type1Font.getFontMatrix());
        this.parser.parse(this.outlineconsumer, type1Font, n);
    }

    private class T1OutlineConsumer
    extends Type1CStringConsumerDefault {
        private T1OutlineConsumer() {
        }

        private void startPath(double d, double d2) {
            if (!Type1OutlineParser.this.pathStarted) {
                Type1OutlineParser.this.pathStarted = true;
                Type1OutlineParser.this.pathStartX = d;
                Type1OutlineParser.this.pathStartY = d2;
            }
        }

        public void closepath() {
            if (Type1OutlineParser.this.pathStarted) {
                Type1OutlineParser.this.c.lineto(Type1OutlineParser.this.pathStartX, Type1OutlineParser.this.pathStartY);
                Type1OutlineParser.this.pathStarted = false;
            }
        }

        public void endchar() {
            if (Type1OutlineParser.this.pathStarted) {
                Type1OutlineParser.this.c.lineto(Type1OutlineParser.this.pathStartX, Type1OutlineParser.this.pathStartY);
            }
            Type1OutlineParser.this.c.endchar();
        }

        public void lineto(double d, double d2) {
            this.startPath(Type1OutlineParser.this.cpx, Type1OutlineParser.this.cpy);
            Type1OutlineParser.this.cpx = d;
            Type1OutlineParser.this.cpy = d2;
            Type1OutlineParser.this.c.lineto(d, d2);
        }

        public void curveto(double d, double d2, double d3, double d4, double d5, double d6) {
            this.startPath(Type1OutlineParser.this.cpx, Type1OutlineParser.this.cpy);
            Type1OutlineParser.this.cpx = d5;
            Type1OutlineParser.this.cpy = d6;
            Type1OutlineParser.this.c.curveto(d, d2, d3, d4, d5, d6);
        }

        public void moveto(double d, double d2) {
            Type1OutlineParser.this.pathStarted = false;
            Type1OutlineParser.this.cpx = d;
            Type1OutlineParser.this.cpy = d2;
            Type1OutlineParser.this.c.moveto(d, d2);
        }

        public void flex(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
            this.curveto(d2, d3, d4, d5, d6, d7);
            this.curveto(d8, d9, d10, d11, d12, d13);
        }
    }
}

