/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontLoader;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFont
extends FontImpl {
    static final long serialVersionUID = 1L;
    protected final URL resourceURL;
    protected final int type;
    protected final int fontID;
    protected final int fondID;
    protected String canonicalPath;
    protected long length;
    protected long lastModified;
    protected ConcurrentHashMap descCache = new ConcurrentHashMap(16, 0.75f, 1);
    protected transient SoftReference fontRef;

    public ResourceFont(URL uRL, int n, int n2, int n3) {
        this.resourceURL = uRL;
        this.type = n;
        this.fontID = n2;
        this.fondID = n3;
        this.initCacheTags();
    }

    public ResourceFont(URL uRL, int n, int n2, int n3, FontData fontData) {
        this(uRL, n, n2, n3);
        this.fontRef = new SoftReference<FontData>(fontData);
    }

    @Override
    protected synchronized FontData retrieveFontData() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontData fontData = null;
        fontData = (FontData)this.fontRef.get();
        if (fontData == null) {
            fontData = FontLoader.fromResourceURL(this.resourceURL, this.type, this.fontID, this.fondID);
            this.fontRef = new SoftReference<FontData>(fontData);
        }
        return fontData;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + this.fontID;
        n = 31 * n + this.fondID;
        n = 31 * n + (this.resourceURL == null ? 0 : this.resourceURL.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ResourceFont)) {
            return false;
        }
        ResourceFont resourceFont = (ResourceFont)object;
        if (this.fontID != resourceFont.fontID) {
            return false;
        }
        if (this.fondID != resourceFont.fondID) {
            return false;
        }
        return !(this.resourceURL == null ? resourceFont.resourceURL != null : !this.resourceURL.equals(resourceFont.resourceURL));
    }

    @Override
    public String toString() {
        return new String(this.resourceURL.toString() + " - resource id = " + this.fontID + ", fond id = " + this.fondID);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.fontRef = new SoftReference<Object>(null);
    }

    private void initCacheTags() {
        try {
            try {
                this.canonicalPath = this.resourceURL.toURI().getPath();
                if (this.canonicalPath == null) {
                    throw new IOException("Cannot resolve path to file");
                }
                this.canonicalPath = this.canonicalPath.replace("/..namedfork/rsrc", "");
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IOException(uRISyntaxException.toString());
            }
            File file = new File(this.canonicalPath);
            this.canonicalPath = file.getCanonicalPath();
            this.length = file.length();
            this.lastModified = file.lastModified();
        }
        catch (IOException iOException) {
            this.canonicalPath = null;
            this.length = 0L;
            this.lastModified = 0L;
        }
    }

    @Override
    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public Object getCachedFontDescription(String string) {
        return this.descCache.get(string);
    }

    @Override
    public Map<String, Object> getCachedFontDescriptionMap() {
        return this.descCache;
    }

    @Override
    public void setCachedFontDescription(String string, Object object) {
        this.descCache.put(string, object);
    }
}

