/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts.flashtype;

import flash.fonts.flashtype.ADFMathUtils;
import flash.fonts.flashtype.ADFTypeSystem;
import java.util.ArrayList;
import java.util.Iterator;

public class ADF {
    static long ADF_VERSION_NUMBER = 1L;
    static final int ADF_X_ALGN_ZONE_BIT = 1;
    static final int ADF_Y_ALGN_ZONE_BIT = 2;
    static final int ADF_NON_LEAF_CELL = 0;
    static final int ADF_ONE_SECTION_CELL = 1;
    static final int ADF_TWO_SECTION_CELL = 2;
    static final int ADF_INWARD_CORNER_CELL = 3;
    static final int ADF_OUTWARD_CORNER_CELL = 4;
    static final int ADF_MAX_OFFSET_SIZE = 0xFFFFFF;
    static final float ADF_INVALID_DIST = -1.0f;
    static final int ADF_MAX_GEN_LEVEL = 15;
    static final short ELM_POS_SLOPE = 1;
    static final short ELM_NEG_SLOPE = -1;
    static final int LINE_ELEMENT = 0;
    static final int CURVE_ELEMENT = 1;
    static final int STD_ORIENTATION = 0;
    static final int INV_ORIENTATION = 1;
    static final int VIRTUAL_CORNER = 0;
    static final int INWARD_CORNER = 1;
    static final int OUTWARD_CORNER = 2;
    static final int CT_MAX_LEVELS = 3;
    static final int CT_MAX_CHILDREN = 6;
    static final int INVALID_FEATURE = 65535;
    static final int LFCELL_ID_ONE_SECTION = 65534;
    static final int LFCELL_ID_TWO_SECTION = 65533;
    static final int LFCELL_ID_INWARD_CORNER = 65532;
    static final int LFCELL_ID_OUTWARD_CORNER = 65531;
    static final int SC_MAX_NUM_SCDATA = 16384;

    static int ADF_PACK_CELL_ATTRS(int n, int n2) {
        return n << 24 | n2;
    }

    static long ADF_UNPACK_CELL_TYPE(long l) {
        return l >> 24;
    }

    static int ADF_UNPACK_CELL_OFFSET(long l) {
        return (int)l & 0xFFFFFF;
    }

    static Object ADFGenerateADF(Object object, ADFTypeSystem.ADFPath aDFPath, ADFTypeSystem.ADFGenAttrs aDFGenAttrs) {
        if (aDFPath == null) {
            return null;
        }
        long l = aDFGenAttrs.maxLevel;
        aDFGenAttrs.maxLevel = (long)ADFMathUtils.ADF_MIN(aDFGenAttrs.maxLevel, 15.0f);
        ADFGlyph aDFGlyph = ADF.SCGenerate(aDFPath, aDFGenAttrs);
        aDFGenAttrs.maxLevel = l;
        return aDFGlyph;
    }

    static float GetDistFromBiquadraticCell(float[] fArray, float f, float f2) {
        float f3 = f - 0.5f;
        float f4 = f - 1.0f;
        float f5 = 2.0f * f3 * f4;
        float f6 = -4.0f * f * f4;
        float f7 = 2.0f * f * f3;
        float f8 = f2 - 0.5f;
        float f9 = f2 - 1.0f;
        float f10 = 2.0f * f8 * f9;
        float f11 = -4.0f * f2 * f9;
        float f12 = 2.0f * f2 * f8;
        float f13 = fArray[0];
        float f14 = fArray[1];
        float f15 = fArray[2];
        float f16 = fArray[3];
        float f17 = fArray[4];
        float f18 = fArray[5];
        float f19 = fArray[6];
        float f20 = fArray[7];
        float f21 = fArray[8];
        float f22 = f10 * (f5 * f13 + f6 * f14 + f7 * f15) + f11 * (f5 * f16 + f6 * f17 + f7 * f18) + f12 * (f5 * f19 + f6 * f20 + f7 * f21);
        return f22;
    }

    static float ADFReconstructDist(ADFGlyph aDFGlyph, int n, float f, float f2, float f3, float f4, float[] fArray) {
        long l = ADF.ADF_UNPACK_CELL_TYPE(n);
        int n2 = ADF.ADF_UNPACK_CELL_OFFSET(n);
        if (l == 1L) {
            float f5 = fArray[0];
            float f6 = fArray[1];
            int n3 = 0;
            float[] fArray2 = new float[9];
            float f7 = 3.0517578E-5f;
            for (int i = 0; i < 9; ++i) {
                fArray2[i] = (float)aDFGlyph.cellsAndDists[n2 + n3++] * f7;
            }
            return ADF.GetDistFromBiquadraticCell(fArray2, f5, f6);
        }
        if (l == 2L) {
            float f8 = fArray[0];
            float f9 = fArray[1];
            int n4 = 0;
            float[] fArray3 = new float[18];
            float f10 = 3.0517578E-5f;
            for (int i = 0; i < 18; ++i) {
                fArray3[i] = (float)aDFGlyph.cellsAndDists[n2 + n4++] * f10;
            }
            float f11 = ADF.GetDistFromBiquadraticCell(fArray3, f8, f9);
            float[] fArray4 = new float[9];
            System.arraycopy(fArray3, 9, fArray4, 0, 9);
            float f12 = ADF.GetDistFromBiquadraticCell(fArray4, f8, f9);
            if (Math.abs(f11) < Math.abs(f12)) {
                return f11;
            }
            return f12;
        }
        float f13 = fArray[0];
        float f14 = fArray[1];
        int n5 = 0;
        float[] fArray5 = new float[2];
        float[] fArray6 = new float[2];
        float[] fArray7 = new float[18];
        float f15 = 3.0517578E-5f;
        for (int i = 0; i < 18; ++i) {
            fArray7[i] = (float)aDFGlyph.cellsAndDists[n2 + n5++] * f15;
        }
        float f16 = f13 - ((float)aDFGlyph.cellsAndDists[n2 + n5++] * f15 - f3) * f2;
        float f17 = f14 - ((float)aDFGlyph.cellsAndDists[n2 + n5++] * f15 - f4) * f2;
        f15 = 6.1035156E-5f;
        fArray5[0] = (float)aDFGlyph.cellsAndDists[n2 + n5++] * f15;
        fArray5[1] = (float)aDFGlyph.cellsAndDists[n2 + n5++] * f15;
        fArray6[0] = (float)aDFGlyph.cellsAndDists[n2 + n5++] * f15;
        fArray6[1] = (float)aDFGlyph.cellsAndDists[n2 + n5++] * f15;
        int n6 = fArray5[0] * f16 + fArray5[1] * f17 > 0.0f ? 1 : 0;
        int n7 = fArray6[0] * f16 + fArray6[1] * f17 > 0.0f ? 1 : 0;
        int n8 = n6 << 1 | n7;
        switch (n8) {
            case 3: {
                float f18 = ADF.GetDistFromBiquadraticCell(fArray7, f13, f14);
                float[] fArray8 = new float[9];
                System.arraycopy(fArray7, 9, fArray8, 0, 9);
                float f19 = ADF.GetDistFromBiquadraticCell(fArray8, f13, f14);
                if (f18 * f18 < f19 * f19) {
                    return f18;
                }
                return f19;
            }
            case 2: {
                return ADF.GetDistFromBiquadraticCell(fArray7, f13, f14);
            }
            case 1: {
                float[] fArray9 = new float[9];
                System.arraycopy(fArray7, 9, fArray9, 0, 9);
                return ADF.GetDistFromBiquadraticCell(fArray9, f13, f14);
            }
            case 0: {
                float f20 = (float)Math.sqrt(f16 * f16 + f17 * f17) * f;
                if (l == 4L) {
                    f20 *= -1.0f;
                }
                return f20;
            }
        }
        return -1.0f;
    }

    static float ADFReconstructDistAbs(ADFGlyph aDFGlyph, float[] fArray) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = 0.0f;
        float f4 = 1.0f;
        float f5 = 0.0f;
        float f6 = 1.0f;
        float f7 = 0.5f;
        float f8 = 0.5f;
        int n = aDFGlyph.cellsAndDists[0];
        while ((n & 0xFF000000) == 0) {
            if (f < f7) {
                if (f2 < f8) {
                    f4 = f7;
                    f6 = f8;
                    f7 = 0.5f * (f3 + f7);
                    f8 = 0.5f * (f5 + f8);
                    n = aDFGlyph.cellsAndDists[n];
                    continue;
                }
                f4 = f7;
                f5 = f8;
                f7 = 0.5f * (f3 + f7);
                f8 = 0.5f * (f6 + f8);
                n = aDFGlyph.cellsAndDists[n + 2];
                continue;
            }
            if (f2 < f8) {
                f3 = f7;
                f6 = f8;
                f7 = 0.5f * (f4 + f7);
                f8 = 0.5f * (f5 + f8);
                n = aDFGlyph.cellsAndDists[n + 1];
                continue;
            }
            f3 = f7;
            f5 = f8;
            f7 = 0.5f * (f4 + f7);
            f8 = 0.5f * (f6 + f8);
            n = aDFGlyph.cellsAndDists[n + 3];
        }
        float[] fArray2 = new float[2];
        float f9 = f4 - f3;
        float f10 = 1.0f / (f4 - f3);
        fArray2[0] = (f - f3) * f10;
        fArray2[1] = (f2 - f5) * f10;
        float f11 = ADF.ADFReconstructDist(aDFGlyph, n, f9, f10, f3, f5, fArray2);
        return f11;
    }

    static InternPath CreateInternPath(ADFTypeSystem.ADFPath aDFPath, ADFTypeSystem.ADFGenAttrs aDFGenAttrs) {
        int n = 0;
        int n2 = aDFPath.numContours;
        ArrayList arrayList = aDFPath.penCmds;
        ADFTypeSystem.ADFPenCmd aDFPenCmd = null;
        for (ADFTypeSystem.ADFPenCmd aDFPenCmd2 : arrayList) {
            if (aDFPenCmd != null && aDFPenCmd2.opCode != 0L && (aDFPenCmd2.x != aDFPenCmd.x || aDFPenCmd2.y != aDFPenCmd.y)) {
                ++n;
            }
            aDFPenCmd = aDFPenCmd2;
        }
        if (n == 0) {
            return null;
        }
        int n3 = (1 << (int)(aDFGenAttrs.maxLevel + 1L)) + 1;
        InternPath internPath = new InternPath();
        internPath.numPathElements = n;
        internPath.maxGridLines = n3;
        internPath.elms = new InternPathElm[n + 1];
        internPath.contours = new int[n2];
        internPath.corners = new InternCorner[n];
        int n4 = (1 + n) * n3;
        internPath.crossings = new float[n4];
        internPath.crossingTypes = new short[n4];
        n4 = 1 + n * 3;
        internPath.clusterTreeRoot = new CTNode[n4];
        for (int i = 0; i < n3; ++i) {
            internPath.crossings[i * (1 + n)] = -1.0f;
        }
        ADF.ADFSetGlyphScaleAndOffset(aDFPath, internPath);
        ADF.InitInternPath(aDFPath, internPath, aDFGenAttrs);
        return internPath;
    }

    static void ADFSetGlyphScaleAndOffset(ADFTypeSystem.ADFPath aDFPath, InternPath internPath) {
        float f;
        float f2 = 1.4f;
        float f3 = aDFPath.glyphMaxX - aDFPath.glyphMinX;
        float f4 = aDFPath.glyphMaxY - aDFPath.glyphMinY;
        float f5 = ADFMathUtils.ADF_MAX(f3, f4);
        if (f5 == 0.0f) {
            f5 = 1.0f;
        }
        float f6 = -aDFPath.glyphMinX + 0.5f * ((f5 *= f2) - f3);
        float f7 = -aDFPath.glyphMinY + 0.5f * (f5 - f4);
        internPath.FUToADFScale = f = 1.0f / f5;
        internPath.glyphOffsetX = f6 * f;
        internPath.glyphOffsetY = f7 * f;
        internPath.ADFUnitsPerEM = aDFPath.fontUnitsPerEM * f;
    }

    static void InitInternPath(ADFTypeSystem.ADFPath aDFPath, InternPath internPath, ADFTypeSystem.ADFGenAttrs aDFGenAttrs) {
        long l;
        int n = 0;
        long l2 = aDFPath.numContours;
        int[] nArray = internPath.contours;
        float f = internPath.FUToADFScale;
        float f2 = internPath.glyphOffsetX;
        float f3 = internPath.glyphOffsetY;
        float f4 = 1.0E-5f;
        ArrayList arrayList = aDFPath.penCmds;
        if (aDFPath.numPenCmds == 0L) {
            internPath.numPathElements = 0;
            return;
        }
        int n2 = 0;
        float f5 = -1.0f;
        float f6 = -1.0f;
        ADFTypeSystem.ADFPenCmd aDFPenCmd = null;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            float f7;
            float f8;
            ADFTypeSystem.ADFPenCmd aDFPenCmd2 = aDFPenCmd;
            aDFPenCmd = (ADFTypeSystem.ADFPenCmd)iterator.next();
            float f9 = aDFPenCmd.x * f + f2;
            float f10 = aDFPenCmd.y * f + f3;
            float f11 = f10 * 65536.0f;
            f10 = f11 / 65536.0f + f4;
            if (aDFPenCmd.opCode == 0L) {
                long l3;
                long l4 = l3 = n == 0 ? 0L : (long)(nArray[n - 1] + 1);
                if ((long)n2 > l3) {
                    nArray[n++] = n2 - 1;
                }
                f5 = f9;
                f6 = f10;
                continue;
            }
            InternPathElm internPathElm = internPath.elms[n2];
            if (internPathElm == null) {
                internPath.elms[n2] = internPathElm = new InternPathElm();
            }
            if (aDFPenCmd2 != null && aDFPenCmd.x == aDFPenCmd2.x && aDFPenCmd.y == aDFPenCmd2.y) continue;
            internPathElm.e0[0] = f5;
            internPathElm.e0[1] = f6;
            internPathElm.e1[0] = f9;
            internPathElm.e1[1] = f10;
            if (aDFPenCmd.opCode == 1L) {
                f8 = f9 - f5;
                f7 = f10 - f6;
                float f12 = (float)Math.sqrt(f8 * f8 + f7 * f7);
                if (f12 != 0.0f) {
                    f8 /= f12;
                    f7 /= f12;
                }
                internPathElm.c1 = f12;
                internPathElm.v01[0] = f8;
                internPathElm.v01[1] = f7;
                internPathElm.v21[0] = -f8;
                internPathElm.v21[1] = -f7;
                internPathElm.type = 0;
                internPathElm.xMin = ADFMathUtils.ADF_MIN(f5, f9);
                internPathElm.yMin = ADFMathUtils.ADF_MIN(f6, f10);
                internPathElm.xMax = ADFMathUtils.ADF_MAX(f5, f9);
                internPathElm.yMax = ADFMathUtils.ADF_MAX(f6, f10);
            } else {
                f8 = aDFPenCmd.cx * f + f2;
                f7 = aDFPenCmd.cy * f + f3;
                double[] dArray = new double[]{f8 - f5, f7 - f6};
                double[] dArray2 = new double[]{f8 - f9, f7 - f10};
                double[] dArray3 = new double[]{-dArray2[0] - dArray[0], -dArray2[1] - dArray[1]};
                internPathElm.v01[0] = dArray[0];
                internPathElm.v01[1] = dArray[1];
                internPathElm.v21[0] = dArray2[0];
                internPathElm.v21[1] = dArray2[1];
                internPathElm.v012[0] = dArray3[0];
                internPathElm.v012[1] = dArray3[1];
                internPathElm.c3 = dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1];
                internPathElm.c2 = 3.0 * (dArray[0] * dArray3[0] + dArray[1] * dArray3[1]);
                internPathElm.c1 = 2.0 * (dArray[0] * dArray[0] + dArray[1] * dArray[1]);
                internPathElm.type = 1;
                internPathElm.xMin = ADFMathUtils.ADF_MIN(ADFMathUtils.ADF_MIN(f5, f8), f9);
                internPathElm.yMin = ADFMathUtils.ADF_MIN(ADFMathUtils.ADF_MIN(f6, f7), f10);
                internPathElm.xMax = ADFMathUtils.ADF_MAX(ADFMathUtils.ADF_MAX(f5, f8), f9);
                internPathElm.yMax = ADFMathUtils.ADF_MAX(ADFMathUtils.ADF_MAX(f6, f7), f10);
            }
            ++n2;
            f5 = f9;
            f6 = f10;
        }
        long l5 = l = n == 0 ? 0L : (long)(nArray[n - 1] + 1);
        if ((long)n2 > l) {
            nArray[n++] = n2 - 1;
        }
        l2 = n;
        ADF.CTInitClusterTree(internPath);
        InternCorner[] internCornerArray = internPath.corners;
        InternPathElm[] internPathElmArray = internPath.elms;
        int n3 = 0;
        double d = 3.1415926535;
        double d2 = -Math.cos(0.02 * d);
        double d3 = -Math.cos(0.75 * d);
        int n4 = 0;
        n = 0;
        while ((long)n < l2) {
            int n5 = n == 0 ? 0 : nArray[n - 1] + 1;
            int n6 = nArray[n];
            InternPathElm internPathElm = internPathElmArray[n5];
            long l6 = ADF.GetContourOrientation(internPath, n5, n6);
            for (int i = n5; i <= n6; ++i) {
                boolean bl;
                double[] dArray;
                boolean bl2;
                int n7;
                InternPathElm internPathElm2;
                InternPathElm internPathElm3 = internPathElmArray[i];
                internPathElm3.featureID = n4;
                internPathElm3.orientation = l6;
                if (i < n6) {
                    internPathElm2 = internPathElmArray[i + 1];
                    n7 = n4 + 2;
                } else {
                    internPathElm2 = internPathElmArray[n5];
                    n7 = internPathElmArray[n5].featureID;
                }
                double[] dArray4 = internPathElm3.v21;
                double d4 = Math.sqrt(dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1]);
                double[] dArray5 = internPathElm2.v01;
                double d5 = Math.sqrt(dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1]);
                double d6 = dArray5[0] * dArray4[0] + dArray5[1] * dArray4[1];
                if (d6 != 0.0) {
                    d6 /= d4 * d5;
                }
                boolean bl3 = bl2 = d6 > d2;
                if (bl2) {
                    double d7;
                    int n8;
                    int n9;
                    double d8;
                    double d9;
                    double[] dArray6;
                    if (l6 == 0L) {
                        dArray = internPathElm3.v21;
                        dArray6 = internPathElm2.v01;
                        d9 = d4;
                        d8 = d5;
                        n9 = n4;
                        n8 = n7;
                    } else {
                        dArray = internPathElm2.v01;
                        dArray6 = internPathElm3.v21;
                        d9 = d5;
                        d8 = d4;
                        n9 = n7;
                        n8 = n4;
                    }
                    internCornerArray[n3] = new InternCorner();
                    internCornerArray[n3].p[0] = internPathElm3.e1[0];
                    internCornerArray[n3].p[1] = internPathElm3.e1[1];
                    internCornerArray[n3].t1[0] = (float)dArray[0];
                    internCornerArray[n3].t1[1] = (float)dArray[1];
                    internCornerArray[n3].t2[0] = (float)dArray6[0];
                    internCornerArray[n3].t2[1] = (float)dArray6[1];
                    if (d9 > 0.0) {
                        internCornerArray[n3].t1[0] = internCornerArray[n3].t1[0] / (float)d9;
                        internCornerArray[n3].t1[1] = internCornerArray[n3].t1[1] / (float)d9;
                    }
                    if (d8 > 0.0) {
                        internCornerArray[n3].t2[0] = internCornerArray[n3].t2[0] / (float)d8;
                        internCornerArray[n3].t2[1] = internCornerArray[n3].t2[1] / (float)d8;
                    }
                    internCornerArray[n3].type = (d7 = dArray6[0] * dArray[1] - dArray6[1] * dArray[0]) > 0.0 ? 1L : 2L;
                    internCornerArray[n3].sec1ID = n9;
                    internCornerArray[n3].sec2ID = n8;
                    internPathElm3.e1_ID = n4 + 1;
                    internPathElm2.e0_ID = n4 + 1;
                    n4 += 2;
                    ++n3;
                    internPathElm = internPathElm2;
                    continue;
                }
                dArray = internPathElm.v01;
                double d10 = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
                dArray5 = internPathElm2.v21;
                d5 = Math.sqrt(dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1]);
                d6 = dArray5[0] * dArray[0] + dArray5[1] * dArray[1];
                if (d6 != 0.0) {
                    d6 /= d10 * d5;
                }
                boolean bl4 = bl = d6 > d3;
                if (bl || i == n6) {
                    internCornerArray[n3] = new InternCorner();
                    internCornerArray[n3].sec1ID = 65535;
                    internCornerArray[n3].sec2ID = 65535;
                    internCornerArray[n3].type = 0L;
                    internCornerArray[n3].p[0] = internPathElm3.e1[0];
                    internCornerArray[n3].p[1] = internPathElm3.e1[1];
                    internPathElm3.e1_ID = n4;
                    internPathElm2.e0_ID = n7;
                    n4 += 2;
                    ++n3;
                    internPathElm = internPathElm2;
                    continue;
                }
                internPathElm2.e0_ID = n4;
                internPathElm3.e1_ID = n4;
            }
            ++n;
        }
    }

    static long GetContourOrientation(InternPath internPath, int n, long l) {
        InternPathElm internPathElm;
        float[] fArray = internPath.crossings;
        short[] sArray = internPath.crossingTypes;
        int n2 = internPath.numPathElements;
        float f = 1.0f;
        float f2 = 0.0f;
        int n3 = n;
        while ((long)n3 <= l) {
            internPathElm = internPath.elms[n3];
            f = ADFMathUtils.ADF_MIN(f, internPathElm.yMin);
            f2 = ADFMathUtils.ADF_MAX(f2, internPathElm.yMax);
            ++n3;
        }
        if (f2 <= f) {
            return 0L;
        }
        long l2 = 65536L;
        long l3 = (long)(f * (float)l2);
        long l4 = (long)(f2 * (float)l2);
        long l5 = l2 >> 1;
        long l6 = l2 >> 1;
        while (l6 < l3 || l6 > l4) {
            l5 >>= 1;
            if (l6 < l3) {
                l6 += l5;
                continue;
            }
            l6 -= l5;
        }
        float f3 = (float)l6 / (float)l2;
        int n4 = (int)(f3 * (float)(internPath.maxGridLines - 1)) * (n2 + 1);
        int n5 = n4 + 1;
        int n6 = 0;
        float f4 = 1.0f;
        block6: for (n3 = 0; n3 < n2; ++n3) {
            internPathElm = internPath.elms[n3];
            if (f3 < internPathElm.yMin || f3 > internPathElm.yMax) continue;
            switch (internPathElm.type) {
                case 0: {
                    float f5;
                    float f6 = (f3 - internPathElm.e0[1]) / (internPathElm.e1[1] - internPathElm.e0[1]);
                    fArray[n5 + n6] = f5 = internPathElm.e0[0] * (1.0f - f6) + internPathElm.e1[0] * f6;
                    if (n <= n3 && (long)n3 <= l && f5 < f4) {
                        f4 = f5;
                    }
                    if (internPathElm.v01[1] > 0.0) {
                        sArray[n5 + n6++] = 1;
                        continue block6;
                    }
                    sArray[n5 + n6++] = -1;
                    continue block6;
                }
                case 1: {
                    double[] dArray = new double[]{internPathElm.e0[1] - f3, 2.0 * internPathElm.v01[1], internPathElm.v012[1]};
                    ADFMathUtils.RootValue rootValue = ADFMathUtils.ADFGetRealQuadraticRoots(dArray);
                    int n7 = rootValue.num;
                    double[] dArray2 = rootValue.roots;
                    while (n7 > 0) {
                        float f7;
                        float f8;
                        if (!((f8 = (float)dArray2[--n7]) >= 0.0f) || !(f8 <= 1.0f)) continue;
                        float f9 = 1.0f - f8;
                        float f10 = (float)(internPathElm.v01[0] + (double)internPathElm.e0[0]);
                        fArray[n5 + n6] = f7 = internPathElm.e0[0] * f9 * f9 + 2.0f * f10 * f9 * f8 + internPathElm.e1[0] * f8 * f8;
                        f9 = -2.0f * f8 * (float)(internPathElm.v01[1] + internPathElm.v21[1]) + (float)(2.0 * internPathElm.v01[1]);
                        if (f9 > 0.0f) {
                            sArray[n5 + n6++] = 1;
                        } else if (f9 < 0.0f) {
                            sArray[n5 + n6++] = -1;
                        }
                        if (f9 == 0.0f || n3 < n || (long)n3 > l || !(f7 < f4)) continue;
                        f4 = f7;
                    }
                    continue block6;
                }
            }
        }
        internPath.crossings[n4] = n6;
        if (n6 > 1) {
            boolean bl;
            do {
                bl = true;
                n3 = n6 - 1;
                for (int i = 0; i < n3; ++i) {
                    if (!(fArray[n5 + i] > fArray[n5 + i + 1])) continue;
                    float f11 = fArray[n5 + i];
                    fArray[n5 + i] = fArray[n5 + i + 1];
                    fArray[n5 + i + 1] = f11;
                    short s = sArray[n5 + i];
                    sArray[n5 + i] = sArray[n5 + i + 1];
                    sArray[n5 + i + 1] = s;
                    bl = false;
                }
            } while (!bl);
        }
        int n8 = 0;
        l3 = n6;
        n3 = 0;
        while ((long)n3 < l3 && !(f4 <= fArray[n5 + n3])) {
            n8 += sArray[n5 + n3];
            ++n3;
        }
        if (n8 < 0) {
            return 1L;
        }
        if (n8 > 0) {
            return 0L;
        }
        if (sArray[n5 + n3] == 1) {
            return 0L;
        }
        return 1L;
    }

    static boolean EXCLUDE_PATH_ELEMENT(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17;
        float f18;
        float f19;
        float f20;
        float f21;
        float f22;
        float f23;
        float f24;
        float f25;
        float f26;
        float f27;
        return f2 <= f4 ? (f3 <= f6 ? (f27 = (f26 = f2 - f4) * f26 + (f25 = f3 - f6) * f25) > f : (f3 >= f7 ? (f24 = (f23 = f2 - f4) * f23 + (f22 = f3 - f7) * f22) > f : (f21 = (f20 = f2 - f4) * f20) > f)) : (f2 <= f5 ? (f3 < f6 ? (f19 = (f18 = f3 - f6) * f18) > f : f3 >= f7 && (f17 = (f16 = f3 - f7) * f16) > f) : (f3 <= f6 ? (f15 = (f14 = f2 - f5) * f14 + (f13 = f3 - f6) * f13) > f : (f3 >= f7 ? (f12 = (f11 = f2 - f5) * f11 + (f10 = f3 - f7) * f10) > f : (f9 = (f8 = f2 - f5) * f8) > f)));
    }

    static float DistFromCurv(float[] fArray, InternPathElm internPathElm) {
        double d;
        double[] dArray = new double[4];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = internPathElm.v01;
        double[] dArray5 = internPathElm.v012;
        dArray2[0] = internPathElm.e0[0] - fArray[0];
        dArray2[1] = internPathElm.e0[1] - fArray[1];
        dArray3[0] = internPathElm.e1[0] - fArray[0];
        dArray3[1] = internPathElm.e1[1] - fArray[1];
        dArray[0] = dArray4[0] * dArray2[0] + dArray4[1] * dArray2[1];
        dArray[1] = internPathElm.c1 + dArray5[0] * dArray2[0] + dArray5[1] * dArray2[1];
        dArray[2] = internPathElm.c2;
        dArray[3] = internPathElm.c3;
        double d2 = dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1];
        float f = dArray2[0] * dArray4[1] - dArray2[1] * dArray4[0] > 0.0 ? -1.0f : 1.0f;
        double d3 = dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1];
        if (d < d2) {
            d2 = d3;
            f = dArray3[0] * internPathElm.v21[1] - dArray3[1] * internPathElm.v21[0] < 0.0 ? -1.0f : 1.0f;
        }
        ADFMathUtils.RootValue rootValue = ADFMathUtils.ADFGetRealCubicRoots(dArray);
        long l = rootValue.num;
        double[] dArray6 = rootValue.roots;
        int n = 0;
        while ((long)n < l) {
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9 = dArray6[n];
            if (0.0 <= d9 && d9 <= 1.0 && (d8 = (d7 = (d6 = d9 * d9) * dArray5[0] + (d5 = 2.0 * d9) * dArray4[0] + dArray2[0]) * d7 + (d4 = d6 * dArray5[1] + d5 * dArray4[1] + dArray2[1]) * d4) <= d2) {
                double d10 = d9 * dArray5[0] + dArray4[0];
                double d11 = d9 * dArray5[1] + dArray4[1];
                f = d10 * d4 - d11 * d7 < 0.0 ? -1.0f : 1.0f;
                d2 = d8;
            }
            ++n;
        }
        return f * (float)Math.sqrt(d2);
    }

    static float DistFromLine(float[] fArray, InternPathElm internPathElm) {
        float f = fArray[0] - internPathElm.e0[0];
        float f2 = fArray[1] - internPathElm.e0[1];
        float f3 = (float)((double)f * internPathElm.v01[0] + (double)f2 * internPathElm.v01[1]);
        float f4 = (float)((double)f * internPathElm.v01[1] - (double)f2 * internPathElm.v01[0]);
        if (f3 <= 0.0f) {
            float f5 = f * f + f2 * f2;
            f5 = (float)Math.sqrt(f5);
            if (f4 < 0.0f) {
                return -f5;
            }
            return f5;
        }
        if ((double)f3 >= internPathElm.c1) {
            f = fArray[0] - internPathElm.e1[0];
            f2 = fArray[1] - internPathElm.e1[1];
            float f6 = f * f + f2 * f2;
            f6 = (float)Math.sqrt(f6);
            if (f4 < 0.0f) {
                return -f6;
            }
            return f6;
        }
        return f4;
    }

    static float DistSqrFromCurv(float[] fArray, InternPathElm internPathElm, IntValue intValue) {
        double d;
        double[] dArray = new double[4];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = internPathElm.v01;
        double[] dArray5 = internPathElm.v012;
        dArray2[0] = internPathElm.e0[0] - fArray[0];
        dArray2[1] = internPathElm.e0[1] - fArray[1];
        dArray3[0] = internPathElm.e1[0] - fArray[0];
        dArray3[1] = internPathElm.e1[1] - fArray[1];
        dArray[0] = dArray4[0] * dArray2[0] + dArray4[1] * dArray2[1];
        dArray[1] = internPathElm.c1 + dArray5[0] * dArray2[0] + dArray5[1] * dArray2[1];
        dArray[2] = internPathElm.c2;
        dArray[3] = internPathElm.c3;
        double d2 = dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1];
        intValue.value = internPathElm.e0_ID;
        double d3 = dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1];
        if (d < d2) {
            d2 = d3;
            intValue.value = internPathElm.e1_ID;
        }
        ADFMathUtils.RootValue rootValue = ADFMathUtils.ADFGetRealCubicRoots(dArray);
        int n = rootValue.num;
        double[] dArray6 = rootValue.roots;
        for (int i = 0; i < n; ++i) {
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9 = dArray6[i];
            if (!(d9 > 0.0) || !(d9 < 1.0) || !((d8 = (d7 = (d6 = d9 * d9) * dArray5[0] + (d5 = 2.0 * d9) * dArray4[0] + dArray2[0]) * d7 + (d4 = d6 * dArray5[1] + d5 * dArray4[1] + dArray2[1]) * d4) < d2)) continue;
            intValue.value = internPathElm.featureID;
            d2 = d8;
        }
        return (float)d2;
    }

    static float DistSqrFromLine(float[] fArray, InternPathElm internPathElm, IntValue intValue) {
        double d = fArray[0] - internPathElm.e0[0];
        double d2 = fArray[1] - internPathElm.e0[1];
        double d3 = d * internPathElm.v01[0] + d2 * internPathElm.v01[1];
        if (d3 <= 0.0) {
            double d4 = d * d + d2 * d2;
            intValue.value = internPathElm.e0_ID;
            return (float)d4;
        }
        if (d3 >= internPathElm.c1) {
            d = fArray[0] - internPathElm.e1[0];
            d2 = fArray[1] - internPathElm.e1[1];
            double d5 = d * d + d2 * d2;
            intValue.value = internPathElm.e1_ID;
            return (float)d5;
        }
        double d6 = d * internPathElm.v01[1] - d2 * internPathElm.v01[0];
        intValue.value = internPathElm.featureID;
        return (float)(d6 * d6);
    }

    static float DistFrom2DPath(InternPath internPath, float[] fArray, IntValue intValue) {
        int n;
        float f = fArray[1];
        long l = internPath.numPathElements;
        if (l == 0L) {
            return -1.0f;
        }
        float f2 = ADF.CTDistFromClusterTree(internPath, fArray, intValue);
        float f3 = (float)Math.sqrt(f2);
        int n2 = (int)(f * (float)(internPath.maxGridLines - 1) * (float)(l + 1L));
        int n3 = (int)internPath.crossings[n2];
        if (n3 < 0) {
            n3 = 0;
            n = 0;
            while ((long)n < l) {
                InternPathElm internPathElm = internPath.elms[n];
                if (!(f < internPathElm.yMin) && !(f > internPathElm.yMax)) {
                    switch (internPathElm.type) {
                        case 0: {
                            float f4;
                            float f5 = (f - internPathElm.e0[1]) / (internPathElm.e1[1] - internPathElm.e0[1]);
                            internPath.crossings[n2 + 1 + n3] = f4 = internPathElm.e0[0] * (1.0f - f5) + internPathElm.e1[0] * f5;
                            if (internPathElm.v01[1] > 0.0) {
                                internPath.crossingTypes[n2 + 1 + n3++] = 1;
                                break;
                            }
                            internPath.crossingTypes[n2 + 1 + n3++] = -1;
                            break;
                        }
                        case 1: {
                            double[] dArray = new double[]{internPathElm.e0[1] - f, 2.0 * internPathElm.v01[1], internPathElm.v012[1]};
                            ADFMathUtils.RootValue rootValue = ADFMathUtils.ADFGetRealQuadraticRoots(dArray);
                            int n4 = rootValue.num;
                            double[] dArray2 = rootValue.roots;
                            while (n4 > 0) {
                                float f6;
                                float f7;
                                if (!((f7 = (float)dArray2[--n4]) >= 0.0f) || !(f7 <= 1.0f)) continue;
                                float f8 = 1.0f - f7;
                                float f9 = (float)(internPathElm.v01[0] + (double)internPathElm.e0[0]);
                                internPath.crossings[n2 + 1 + n3] = f6 = internPathElm.e0[0] * f8 * f8 + 2.0f * f9 * f8 * f7 + internPathElm.e1[0] * f7 * f7;
                                f8 = -2.0f * f7 * (float)(internPathElm.v01[1] + internPathElm.v21[1]) + (float)(2.0 * internPathElm.v01[1]);
                                if (f8 > 0.0f) {
                                    internPath.crossingTypes[n2 + 1 + n3++] = 1;
                                    continue;
                                }
                                if (!(f8 < 0.0f)) continue;
                                internPath.crossingTypes[n2 + 1 + n3++] = -1;
                            }
                            break;
                        }
                    }
                }
                ++n;
            }
            internPath.crossings[n2] = n3;
            if (n3 > 1) {
                boolean bl;
                do {
                    bl = true;
                    n = n3 - 1;
                    for (int i = 0; i < n; ++i) {
                        if (!(internPath.crossings[n2 + 1 + i] > internPath.crossings[n2 + 1 + i + 1])) continue;
                        float f10 = internPath.crossings[n2 + 1 + i];
                        internPath.crossings[n2 + 1 + i] = internPath.crossings[n2 + 1 + i + 1];
                        internPath.crossings[n2 + 1 + i + 1] = f10;
                        short s = internPath.crossingTypes[n2 + 1 + i];
                        internPath.crossingTypes[n2 + 1 + i] = internPath.crossingTypes[n2 + 1 + i + 1];
                        internPath.crossingTypes[n2 + 1 + i + 1] = s;
                        bl = false;
                    }
                } while (!bl);
            }
        }
        int n5 = 0;
        for (n = 0; n < n3 && !(fArray[0] < internPath.crossings[n2 + 1 + n]); ++n) {
            n5 += internPath.crossingTypes[n2 + 1 + n];
        }
        if (n5 == 0) {
            return -f3;
        }
        return f3;
    }

    static float DistFrom2DPathSection(InternPath internPath, float[] fArray, long l) {
        float f;
        float f2;
        float f3;
        InternPathElm internPathElm;
        int n = -1;
        float f4 = fArray[0];
        float f5 = fArray[1];
        float f6 = 4.0f * ADFMathUtils.ADF_ABS(-1.0f);
        float f7 = -1.0f;
        long l2 = internPath.numPathElements;
        if (l2 == 0L) {
            return -1.0f;
        }
        float f8 = f6;
        int n2 = 0;
        while ((long)n2 < l2) {
            internPathElm = internPath.elms[n2];
            if ((long)internPathElm.featureID == l && (f3 = (f2 = 0.5f * (internPathElm.xMin + internPathElm.xMax) - f4) * f2 + (f = 0.5f * (internPathElm.yMin + internPathElm.yMax) - f5) * f) < f8) {
                n = n2;
                f8 = f3;
            }
            ++n2;
        }
        if (f8 == f6) {
            return -1.0f;
        }
        internPathElm = internPath.elms[n];
        long l3 = internPathElm.orientation;
        switch (internPathElm.type) {
            case 0: {
                f7 = ADF.DistFromLine(fArray, internPathElm);
                f8 = f7 * f7;
                break;
            }
            case 1: {
                f7 = ADF.DistFromCurv(fArray, internPathElm);
                f8 = f7 * f7;
            }
        }
        n2 = 0;
        while ((long)n2 < l2) {
            if (n2 != n) {
                internPathElm = internPath.elms[n2];
                if ((long)internPathElm.featureID == l) {
                    f3 = internPathElm.xMin;
                    f2 = internPathElm.xMax;
                    f = internPathElm.yMin;
                    float f9 = internPathElm.yMax;
                    switch (internPathElm.type) {
                        case 0: {
                            float f10;
                            if (ADF.EXCLUDE_PATH_ELEMENT(f8, f4, f5, f3, f2, f, f9) || !((f10 = ADF.DistFromLine(fArray, internPathElm)) * f10 < f8)) break;
                            f7 = f10;
                            f8 = f7 * f7;
                            break;
                        }
                        case 1: {
                            float f10;
                            if (ADF.EXCLUDE_PATH_ELEMENT(f8, f4, f5, f3, f2, f, f9) || !((f10 = ADF.DistFromCurv(fArray, internPathElm)) * f10 < f8)) break;
                            f7 = f10;
                            f8 = f7 * f7;
                        }
                    }
                }
            }
            ++n2;
        }
        if (l3 == 0L) {
            return f7;
        }
        return -f7;
    }

    static float CT_MIN_SQR_DIST_TO_BBOX(float[] fArray, float f, float f2, float f3, float f4) {
        float f5;
        if (fArray[0] <= f) {
            if (fArray[1] <= f3) {
                float f6 = fArray[0] - f;
                float f7 = fArray[1] - f3;
                f5 = f6 * f6 + f7 * f7;
            } else if (fArray[1] >= f4) {
                float f8 = fArray[0] - f;
                float f9 = fArray[1] - f4;
                f5 = f8 * f8 + f9 * f9;
            } else {
                float f10 = fArray[0] - f;
                f5 = f10 * f10;
            }
        } else if (fArray[0] <= f2) {
            if (fArray[1] < f3) {
                float f11 = fArray[1] - f3;
                f5 = f11 * f11;
            } else if (fArray[1] >= f4) {
                float f12 = fArray[1] - f4;
                f5 = f12 * f12;
            } else {
                f5 = 0.0f;
            }
        } else if (fArray[1] <= f3) {
            float f13 = fArray[0] - f2;
            float f14 = fArray[1] - f3;
            f5 = f13 * f13 + f14 * f14;
        } else if (fArray[1] >= f4) {
            float f15 = fArray[0] - f2;
            float f16 = fArray[1] - f4;
            f5 = f15 * f15 + f16 * f16;
        } else {
            float f17 = fArray[0] - f2;
            f5 = f17 * f17;
        }
        return f5;
    }

    static void CT_REMOVE_CHILD(CTNode cTNode, CTNode cTNode2) {
        if (cTNode2 == cTNode.firstChild) {
            cTNode.firstChild = cTNode2.nextSibling;
        } else {
            CTNode cTNode3 = cTNode.firstChild;
            while (cTNode3.nextSibling != cTNode2) {
                cTNode3 = cTNode3.nextSibling;
            }
            cTNode3.nextSibling = cTNode2.nextSibling;
        }
        cTNode2.nextSibling = null;
    }

    static void CTInitClusterTree(InternPath internPath) {
        CTNode cTNode;
        int n = internPath.numPathElements;
        float f = 0.0f;
        InternPathElm[] internPathElmArray = internPath.elms;
        internPath.clusterTreeRoot[0] = cTNode = new CTNode();
        cTNode.firstChild = null;
        cTNode.nextSibling = null;
        cTNode.xMin = 1.0f;
        cTNode.xMax = 0.0f;
        cTNode.yMin = 1.0f;
        cTNode.yMax = 0.0f;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            CTNode cTNode2 = new CTNode();
            internPath.clusterTreeRoot[n2++] = cTNode2;
            cTNode2.pElm = internPathElmArray[i];
            cTNode2.xMin = internPathElmArray[i].xMin;
            cTNode2.yMin = internPathElmArray[i].yMin;
            cTNode2.xMax = internPathElmArray[i].xMax;
            cTNode2.yMax = internPathElmArray[i].yMax;
            cTNode2.firstChild = null;
            cTNode2.nextSibling = cTNode.firstChild;
            cTNode.firstChild = cTNode2;
            cTNode.xMin = ADFMathUtils.ADF_MIN(cTNode.xMin, cTNode2.xMin);
            cTNode.xMax = ADFMathUtils.ADF_MAX(cTNode.xMax, cTNode2.xMax);
            cTNode.yMin = ADFMathUtils.ADF_MIN(cTNode.yMin, cTNode2.yMin);
            cTNode.yMax = ADFMathUtils.ADF_MAX(cTNode.yMax, cTNode2.yMax);
            f += cTNode2.xMax - cTNode2.xMin + cTNode2.yMax - cTNode2.yMin;
        }
        if (n > 6) {
            float f2 = f / (float)(n * 3);
            ADF.CTBuildClusterTree(internPath.clusterTreeRoot, n2, 1L, f2);
        }
    }

    static void CTBuildClusterTree(CTNode[] cTNodeArray, int n, long l, float f) {
        float f2 = f * (float)l;
        CTNode cTNode = cTNodeArray[0];
        CTNode cTNode2 = cTNode.firstChild;
        while (cTNode2 != null) {
            cTNode2.isNew = false;
            cTNode2 = cTNode2.nextSibling;
        }
        cTNode2 = cTNode.firstChild;
        while (cTNode2 != null) {
            float f3 = (cTNode2.xMax + cTNode2.xMin) * 0.5f;
            float f4 = (cTNode2.yMax + cTNode2.yMin) * 0.5f;
            CTNode cTNode3 = null;
            CTNode cTNode4 = cTNode.firstChild;
            float f5 = f2;
            while (cTNode4 != null) {
                float f6;
                float f7;
                float f8;
                float f9;
                float f10;
                if (cTNode4 != cTNode2 && (f10 = (f9 = f3 - (f8 = (cTNode4.xMax + cTNode4.xMin) * 0.5f)) * f9 + (f7 = f4 - (f6 = (cTNode4.yMax + cTNode4.yMin) * 0.5f)) * f7) < f5) {
                    f5 = f10;
                    cTNode3 = cTNode4;
                }
                cTNode4 = cTNode4.nextSibling;
            }
            CTNode cTNode5 = cTNode2.nextSibling;
            if (f5 < f2) {
                if (cTNode3.isNew) {
                    ADF.CT_REMOVE_CHILD(cTNode, cTNode2);
                    cTNode2.nextSibling = cTNode3.firstChild;
                    cTNode3.firstChild = cTNode2;
                    cTNode3.xMin = ADFMathUtils.ADF_MIN(cTNode3.xMin, cTNode2.xMin);
                    cTNode3.xMax = ADFMathUtils.ADF_MAX(cTNode3.xMax, cTNode2.xMax);
                    cTNode3.yMin = ADFMathUtils.ADF_MIN(cTNode3.yMin, cTNode2.yMin);
                    cTNode3.yMax = ADFMathUtils.ADF_MAX(cTNode3.yMax, cTNode2.yMax);
                } else {
                    CTNode cTNode6 = new CTNode();
                    cTNodeArray[n++] = cTNode6;
                    cTNode6.isNew = true;
                    ADF.CT_REMOVE_CHILD(cTNode, cTNode2);
                    if (cTNode5 == cTNode3) {
                        cTNode5 = cTNode3.nextSibling;
                    }
                    ADF.CT_REMOVE_CHILD(cTNode, cTNode3);
                    cTNode3.nextSibling = null;
                    cTNode2.nextSibling = cTNode3;
                    cTNode6.firstChild = cTNode2;
                    cTNode6.xMin = ADFMathUtils.ADF_MIN(cTNode2.xMin, cTNode3.xMin);
                    cTNode6.xMax = ADFMathUtils.ADF_MAX(cTNode2.xMax, cTNode3.xMax);
                    cTNode6.yMin = ADFMathUtils.ADF_MIN(cTNode2.yMin, cTNode3.yMin);
                    cTNode6.yMax = ADFMathUtils.ADF_MAX(cTNode2.yMax, cTNode3.yMax);
                    cTNode6.nextSibling = cTNode.firstChild;
                    cTNode.firstChild = cTNode6;
                }
            }
            cTNode2 = cTNode5;
        }
        long l2 = 0L;
        cTNode2 = cTNode.firstChild;
        while (cTNode2 != null) {
            ++l2;
            cTNode2 = cTNode2.nextSibling;
        }
        if (l + 1L < 3L && l2 > 6L) {
            ADF.CTBuildClusterTree(cTNodeArray, n, l + 1L, f);
        }
    }

    static float CTDistFromClusterTree(InternPath internPath, float[] fArray, IntValue intValue) {
        float f = 4.0f * ADFMathUtils.ADF_ABS(-1.0f);
        Object object = internPath.clusterTreeRoot[0];
        ((CTNode)object).sortThread = null;
        ((CTNode)object).minDistSqr = 0.0f;
        while (object != null && ((CTNode)object).minDistSqr < f) {
            Object object2;
            CTNode cTNode = object;
            object = ((CTNode)object).sortThread;
            if (cTNode.firstChild != null) {
                object2 = cTNode.firstChild;
                while (object2 != null) {
                    if (((CTNode)object2).firstChild == null && ((CTNode)object2).pElm.type == 0) {
                        IntValue intValue2 = new IntValue(0);
                        float f2 = ADF.DistSqrFromLine(fArray, ((CTNode)object2).pElm, intValue2);
                        if (f2 < f) {
                            f = f2;
                            intValue.value = intValue2.value;
                        }
                    } else {
                        float f3;
                        ((CTNode)object2).minDistSqr = f3 = ADF.CT_MIN_SQR_DIST_TO_BBOX(fArray, ((CTNode)object2).xMin, ((CTNode)object2).xMax, ((CTNode)object2).yMin, ((CTNode)object2).yMax);
                        if (f3 < f) {
                            if (object == null || f3 < ((CTNode)object).minDistSqr) {
                                ((CTNode)object2).sortThread = object;
                                object = object2;
                            } else {
                                Object object3 = object;
                                while (((CTNode)object3).sortThread != null && ((CTNode)object3).sortThread.minDistSqr < f3) {
                                    object3 = ((CTNode)object3).sortThread;
                                }
                                ((CTNode)object2).sortThread = ((CTNode)object3).sortThread;
                                ((CTNode)object3).sortThread = object2;
                            }
                        }
                    }
                    object2 = ((CTNode)object2).nextSibling;
                }
                continue;
            }
            object2 = new IntValue(0);
            float f4 = ADF.DistSqrFromCurv(fArray, cTNode.pElm, (IntValue)object2);
            if (!(f4 < f)) continue;
            f = f4;
            intValue.value = ((IntValue)object2).value;
        }
        return f;
    }

    static ADFGlyph SCGenerate(ADFTypeSystem.ADFPath aDFPath, ADFTypeSystem.ADFGenAttrs aDFGenAttrs) {
        long l = aDFGenAttrs.maxLevel;
        SCGenData sCGenData = new SCGenData();
        SCGenCellData sCGenCellData = new SCGenCellData();
        InternPath internPath = ADF.CreateInternPath(aDFPath, aDFGenAttrs);
        if (internPath == null) {
            return null;
        }
        int n = (1 << (int)(l + 1L)) + 1;
        int n2 = n * n;
        float[] fArray = new float[n2];
        for (int i = 0; i < n2; ++i) {
            fArray[i] = -1.0f;
        }
        char[] cArray = new char[n2];
        sCGenData.maxNumScData = 16384;
        sCGenData.scData = new float[sCGenData.maxNumScData];
        sCGenData.internPath = internPath;
        sCGenData.genAttrs = aDFGenAttrs;
        sCGenData.distMap = fArray;
        sCGenData.featureMap = cArray;
        sCGenData.mapSideLen = n;
        sCGenCellData.level = 0L;
        sCGenCellData.xIdx = 0;
        sCGenCellData.yIdx = 0;
        sCGenCellData.dxIdx = sCGenData.mapSideLen - 1 >> 1;
        sCGenCellData.dyIdx = sCGenCellData.dxIdx * n;
        sCGenCellData.halfCellSide = 0.5f;
        sCGenData.numCells = 0;
        sCGenData.numDists = 0;
        ADF.SCSubdivDistField(sCGenData, sCGenCellData);
        ADFGlyph aDFGlyph = new ADFGlyph();
        aDFGlyph.cellsAndDists = new int[sCGenData.numCells + sCGenData.numDists + 1];
        aDFGlyph.numCells = sCGenData.numCells;
        aDFGlyph.charCode = aDFPath.charCode;
        aDFGlyph.ADFUnitsPerEM = internPath.ADFUnitsPerEM;
        aDFGlyph.FUToADFScale = internPath.FUToADFScale;
        aDFGlyph.glyphOriginX = internPath.glyphOffsetX;
        aDFGlyph.glyphOriginY = internPath.glyphOffsetY;
        aDFGlyph.glyphMinX = aDFPath.glyphMinX * aDFGlyph.FUToADFScale + aDFGlyph.glyphOriginX;
        aDFGlyph.glyphMinY = aDFPath.glyphMinY * aDFGlyph.FUToADFScale + aDFGlyph.glyphOriginY;
        aDFGlyph.glyphMaxX = aDFPath.glyphMaxX * aDFGlyph.FUToADFScale + aDFGlyph.glyphOriginX;
        aDFGlyph.glyphMaxY = aDFPath.glyphMaxY * aDFGlyph.FUToADFScale + aDFGlyph.glyphOriginY;
        aDFGlyph.version = ADF_VERSION_NUMBER;
        ADF.ADFUnpackAlgnZones(aDFPath, aDFGlyph);
        int n3 = 0;
        int n4 = n3 + 1;
        int n5 = n3 + sCGenData.numCells;
        ADF.SCBuildADFQuadtree(sCGenData, sCGenCellData, aDFGlyph, n3, new IntValue(n4), new IntValue(n5));
        return aDFGlyph;
    }

    static void SCSubdivDistField(SCGenData sCGenData, SCGenCellData sCGenCellData) {
        long l;
        int n = sCGenCellData.xIdx;
        int n2 = sCGenCellData.yIdx;
        int n3 = sCGenCellData.dxIdx;
        int n4 = sCGenCellData.dyIdx;
        int n5 = n + n3 + n2 + n4;
        ADFTypeSystem.ADFGenAttrs aDFGenAttrs = sCGenData.genAttrs;
        ADF.SCInitCellDVs(sCGenData, sCGenCellData);
        ++sCGenData.numCells;
        if (sCGenCellData.level >= aDFGenAttrs.maxLevel) {
            sCGenData.featureMap[n5] = 65534;
            sCGenData.numDists += 9;
            return;
        }
        float f = 1.4142137f;
        float f2 = f * sCGenCellData.halfCellSide;
        float f3 = sCGenData.distMap[n5];
        if (Math.abs(f3) > f2 + aDFGenAttrs.distEps) {
            sCGenData.featureMap[n5] = 65534;
            sCGenData.numDists += 9;
            return;
        }
        f = ADF.SCGetCellError(sCGenData, sCGenCellData);
        if (f < aDFGenAttrs.maxError) {
            sCGenData.featureMap[n5] = 65534;
            sCGenData.numDists += 9;
            return;
        }
        if (sCGenData.numScData + 24 < sCGenData.maxNumScData && (l = ADF.SCIsSpecialCell(sCGenData, sCGenCellData)) != 0L) {
            sCGenData.numDists = l == 2L ? (sCGenData.numDists += 18) : (sCGenData.numDists += 24);
            return;
        }
        SCGenCellData sCGenCellData2 = new SCGenCellData();
        sCGenCellData2.level = sCGenCellData.level + 1L;
        sCGenCellData2.dxIdx = n3 >> 1;
        sCGenCellData2.dyIdx = n4 >> 1;
        sCGenCellData2.halfCellSide = 0.5f * sCGenCellData.halfCellSide;
        sCGenCellData2.yIdx = n2;
        for (long i = 0L; i < 2L; ++i) {
            sCGenCellData2.xIdx = n;
            for (long j = 0L; j < 2L; ++j) {
                ADF.SCSubdivDistField(sCGenData, sCGenCellData2);
                sCGenCellData2.xIdx += n3;
            }
            sCGenCellData2.yIdx += n4;
        }
    }

    static void SCInitCellDVs(SCGenData sCGenData, SCGenCellData sCGenCellData) {
        float f;
        float f2;
        float[] fArray = new float[2];
        float[] fArray2 = sCGenData.distMap;
        char[] cArray = sCGenData.featureMap;
        float[] fArray3 = sCGenCellData.distVals;
        int n = sCGenCellData.xIdx;
        int n2 = sCGenCellData.yIdx;
        int n3 = sCGenCellData.dxIdx;
        int n4 = sCGenCellData.dyIdx;
        float f3 = sCGenCellData.halfCellSide;
        float f4 = sCGenData.mapSideLen;
        sCGenCellData.x0 = f2 = (float)n / (f4 - 1.0f);
        sCGenCellData.y0 = f = (float)n2 / ((f4 - 1.0f) * f4);
        int n5 = 0;
        int n6 = n2;
        fArray[1] = f;
        for (long i = 0L; i <= 2L; ++i) {
            int n7 = n;
            fArray[0] = f2;
            for (long j = 0L; j <= 2L; ++j) {
                int n8 = n7 + n6;
                if (fArray2[n8] == -1.0f) {
                    IntValue intValue = new IntValue(0);
                    float f5 = ADF.DistFrom2DPath(sCGenData.internPath, fArray, intValue);
                    int n9 = n5++;
                    float f6 = f5;
                    fArray3[n9] = f6;
                    fArray2[n8] = f6;
                    cArray[n8] = (char)intValue.value;
                } else {
                    fArray3[n5++] = fArray2[n8];
                }
                n7 += n3;
                fArray[0] = fArray[0] + f3;
            }
            n6 += n4;
            fArray[1] = fArray[1] + f3;
        }
    }

    static float SCGetCellError(SCGenData sCGenData, SCGenCellData sCGenCellData) {
        float[] fArray = new float[2];
        float[] fArray2 = sCGenData.distMap;
        char[] cArray = sCGenData.featureMap;
        float[] fArray3 = sCGenCellData.distVals;
        int n = sCGenCellData.xIdx;
        int n2 = sCGenCellData.yIdx;
        int n3 = sCGenCellData.dxIdx;
        int n4 = sCGenCellData.dyIdx;
        float f = sCGenCellData.halfCellSide;
        float f2 = sCGenCellData.x0;
        float f3 = sCGenCellData.y0;
        float f4 = 0.0f;
        boolean bl = n3 > 1 && n4 > 1;
        float f5 = 0.25f;
        int n5 = n2 + n4 / 2;
        fArray[1] = f3 + 0.5f * f;
        for (long i = 0L; i < 2L; ++i) {
            float f6 = 0.25f;
            int n6 = n + n3 / 2;
            fArray[0] = f2 + 0.5f * f;
            for (long j = 0L; j < 2L; ++j) {
                float f7;
                IntValue intValue = new IntValue(0);
                float f8 = ADF.GetDistFromBiquadraticCell(fArray3, f6, f5);
                float f9 = ADF.DistFrom2DPath(sCGenData.internPath, fArray, intValue);
                if (bl) {
                    int n7 = n6 + n5;
                    fArray2[n7] = f9;
                    cArray[n7] = (char)intValue.value;
                }
                float f10 = f7 = f8 > f9 ? f8 - f9 : f9 - f8;
                if (f7 > f4) {
                    f4 = f7;
                }
                f6 += 0.5f;
                n6 += n3;
                fArray[0] = fArray[0] + f;
            }
            f5 += 0.5f;
            n5 += n4;
            fArray[1] = fArray[1] + f;
        }
        return f4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static long SCIsSpecialCell(SCGenData sCGenData, SCGenCellData sCGenCellData) {
        float f;
        float f2;
        float f3;
        long l;
        long l2;
        InternCorner internCorner;
        int n;
        int n2;
        int n3;
        char[] cArray = new char[9];
        int n4 = 65535;
        int n5 = 65535;
        int n6 = 65535;
        char[] cArray2 = sCGenData.featureMap;
        float[] fArray = new float[2];
        float[] fArray2 = new float[]{0.0f, 0.0f};
        float[] fArray3 = new float[]{0.0f, 0.0f};
        float[] fArray4 = new float[9];
        float[] fArray5 = new float[9];
        InternPath internPath = sCGenData.internPath;
        int n7 = 0;
        int n8 = sCGenCellData.yIdx;
        for (n3 = 0; n3 <= 2; ++n3) {
            n2 = sCGenCellData.xIdx;
            for (n = 0; n <= 2; ++n) {
                int n9 = cArray2[n2 + n8];
                if (n9 % 2 != 0) {
                    if (n6 == 65535) {
                        n6 = n9;
                    } else if (n9 != n6) {
                        return 0L;
                    }
                } else if (n4 == 65535) {
                    n4 = n9;
                } else if (n9 != n4) {
                    if (n5 == 65535) {
                        n5 = n9;
                    } else if (n9 != n5) {
                        return 0L;
                    }
                }
                cArray[n7++] = n9;
                n2 += sCGenCellData.dxIdx;
            }
            n8 += sCGenCellData.dyIdx;
        }
        if (n6 != 65535) {
            internCorner = internPath.corners[(n6 - 1) / 2];
            if (n5 == 65535) {
                if (n4 == 65535) {
                    n4 = internCorner.sec1ID;
                    n5 = internCorner.sec2ID;
                } else if (n4 == internCorner.sec1ID) {
                    n5 = internCorner.sec2ID;
                } else {
                    if (n4 != internCorner.sec2ID) {
                        return 0L;
                    }
                    n4 = internCorner.sec1ID;
                    n5 = internCorner.sec2ID;
                }
            } else if (n4 == internCorner.sec1ID) {
                if (n5 != internCorner.sec2ID) {
                    return 0L;
                }
            } else {
                if (n4 != internCorner.sec2ID) return 0L;
                if (n5 != internCorner.sec1ID) {
                    return 0L;
                }
                n4 = internCorner.sec1ID;
                n5 = internCorner.sec2ID;
            }
        } else {
            if (n5 == 65535) {
                return 0L;
            }
            internCorner = internPath.corners[n4 / 2];
            if (internCorner.sec1ID == n4 && internCorner.sec2ID == n5) {
                n6 = n4 + 1;
            } else if (internCorner.sec1ID == n5 && internCorner.sec2ID == n4) {
                n6 = n4 + 1;
                n4 = internCorner.sec1ID;
                n5 = internCorner.sec2ID;
            } else {
                internCorner = internPath.corners[n5 / 2];
                if (internCorner.sec1ID == n4 && internCorner.sec2ID == n5) {
                    n6 = n4 + 1;
                } else if (internCorner.sec1ID == n5 && internCorner.sec2ID == n4) {
                    n6 = n5 + 1;
                    n4 = internCorner.sec1ID;
                    n5 = internCorner.sec2ID;
                } else {
                    internCorner = null;
                }
            }
        }
        if (internCorner != null) {
            if (internCorner.type == 1L) {
                l2 = 3L;
                l = 65532L;
            } else {
                l2 = 4L;
                l = 65531L;
            }
            fArray2 = internCorner.t1;
            fArray3 = internCorner.t2;
        } else {
            l2 = 2L;
            l = 65533L;
        }
        float f4 = sCGenCellData.x0;
        float f5 = sCGenCellData.y0;
        float[] fArray6 = sCGenCellData.distVals;
        if (internCorner == null) {
            f3 = sCGenCellData.halfCellSide;
            fArray[1] = f5;
            n7 = 0;
            for (n3 = 0; n3 <= 2; ++n3) {
                fArray[0] = f4;
                for (n = 0; n <= 2; ++n) {
                    if (cArray[n7] == n4) {
                        fArray4[n7] = fArray6[n7];
                        fArray5[n7] = ADF.DistFrom2DPathSection(internPath, fArray, n5);
                    } else {
                        fArray4[n7] = ADF.DistFrom2DPathSection(internPath, fArray, n4);
                        fArray5[n7] = fArray6[n7];
                    }
                    fArray[0] = fArray[0] + f3;
                    ++n7;
                }
                fArray[1] = fArray[1] + f3;
            }
        } else {
            f3 = sCGenCellData.halfCellSide;
            fArray[1] = f5;
            n7 = 0;
            for (n3 = 0; n3 <= 2; ++n3) {
                fArray[0] = f4;
                for (n = 0; n <= 2; ++n) {
                    float f6;
                    long l3 = cArray[n7];
                    if (cArray[n7] == n4) {
                        fArray4[n7] = fArray6[n7];
                        fArray5[n7] = ADF.DistFrom2DPathSection(internPath, fArray, n5);
                    } else if (cArray[n7] == n5) {
                        fArray4[n7] = ADF.DistFrom2DPathSection(internPath, fArray, n4);
                        fArray5[n7] = fArray6[n7];
                    } else {
                        fArray4[n7] = fArray6[n7];
                        fArray5[n7] = fArray6[n7];
                    }
                    f2 = fArray[0] - internCorner.p[0];
                    f = fArray[1] - internCorner.p[1];
                    if (f2 * fArray2[0] + f * fArray2[1] < 0.0f && ADFMathUtils.ADF_ABS(f6 = f * fArray2[0] - f2 * fArray2[1]) < ADFMathUtils.ADF_ABS(fArray4[n7])) {
                        fArray4[n7] = f6;
                    }
                    if (f2 * fArray3[0] + f * fArray3[1] < 0.0f && ADFMathUtils.ADF_ABS(f6 = f2 * fArray3[1] - f * fArray3[0]) < ADFMathUtils.ADF_ABS(fArray5[n7])) {
                        fArray5[n7] = f6;
                    }
                    int n10 = fArray2[0] * f2 + fArray2[1] * f > 0.0f ? 1 : 0;
                    int n11 = fArray3[0] * f2 + fArray3[1] * f > 0.0f ? 1 : 0;
                    int n12 = n10 << 1 | n11;
                    switch (n12) {
                        case 3: {
                            if (!(l3 == (long)n4 ? ADFMathUtils.ADF_ABS(fArray5[n7]) < ADFMathUtils.ADF_ABS(fArray4[n7]) : l3 == (long)n5 && ADFMathUtils.ADF_ABS(fArray4[n7]) < ADFMathUtils.ADF_ABS(fArray5[n7]))) break;
                            return 0L;
                        }
                        case 2: {
                            if (l3 == (long)n4) break;
                            return 0L;
                        }
                        case 1: {
                            if (l3 == (long)n5) break;
                            return 0L;
                        }
                        case 0: {
                            if (l3 == (long)n6) break;
                            return 0L;
                        }
                    }
                    fArray[0] = fArray[0] + f3;
                    ++n7;
                }
                fArray[1] = fArray[1] + f3;
            }
        }
        if (sCGenCellData.dxIdx > 1) {
            float f7 = sCGenData.genAttrs.maxError;
            float f8 = 0.25f;
            n8 = sCGenCellData.yIdx + sCGenCellData.dyIdx / 2;
            fArray[1] = f5 + 0.5f * f3;
            for (n3 = 0; n3 < 2; ++n3) {
                f2 = 0.25f;
                n2 = sCGenCellData.xIdx + sCGenCellData.dxIdx / 2;
                fArray[0] = f4 + 0.5f * f3;
                for (n = 0; n < 2; ++n) {
                    float f9;
                    float f10;
                    float f11;
                    if (internCorner == null) {
                        f = ADF.DistFrom2DPathSection(sCGenData.internPath, fArray, n4);
                        f10 = Math.abs(f - (f11 = ADF.GetDistFromBiquadraticCell(fArray4, f2, f8)));
                        if (f10 > f7) {
                            return 0L;
                        }
                        f = ADF.DistFrom2DPathSection(sCGenData.internPath, fArray, n5);
                        f10 = Math.abs(f - (f9 = ADF.GetDistFromBiquadraticCell(fArray5, f2, f8)));
                        if (f10 > f7) {
                            return 0L;
                        }
                        f = sCGenData.distMap[n2 + n8];
                        if (ADFMathUtils.ADF_ABS(f9) < ADFMathUtils.ADF_ABS(f11)) {
                            f11 = f9;
                        }
                        if ((f10 = Math.abs(f - f11)) > f7) {
                            return 0L;
                        }
                    } else {
                        float f12;
                        float f13 = fArray[0] - internCorner.p[0];
                        float f14 = fArray[1] - internCorner.p[1];
                        float f15 = fArray2[0] * f13 + fArray2[1] * f14;
                        float f16 = fArray3[0] * f13 + fArray3[1] * f14;
                        f = ADF.DistFrom2DPathSection(sCGenData.internPath, fArray, n4);
                        if (f15 <= 0.0f && ADFMathUtils.ADF_ABS(f12 = f14 * fArray2[0] - f13 * fArray2[1]) < ADFMathUtils.ADF_ABS(f)) {
                            f = f12;
                        }
                        if ((f10 = Math.abs(f - (f11 = ADF.GetDistFromBiquadraticCell(fArray4, f2, f8)))) > f7) {
                            return 0L;
                        }
                        f = ADF.DistFrom2DPathSection(sCGenData.internPath, fArray, n5);
                        if (f16 <= 0.0f && ADFMathUtils.ADF_ABS(f12 = f13 * fArray3[1] - f14 * fArray3[0]) < ADFMathUtils.ADF_ABS(f)) {
                            f = f12;
                        }
                        if ((f10 = Math.abs(f - (f9 = ADF.GetDistFromBiquadraticCell(fArray5, f2, f8)))) > f7) {
                            return 0L;
                        }
                        f = sCGenData.distMap[n2 + n8];
                        int n13 = f15 > 0.0f ? 1 : 0;
                        int n14 = f16 > 0.0f ? 1 : 0;
                        int n15 = n13 << 1 | n14;
                        switch (n15) {
                            case 3: {
                                if (!(f9 * f9 - f11 * f11 < 0.0f)) break;
                                f11 = f9;
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 1: {
                                f11 = f9;
                                break;
                            }
                            case 0: {
                                f11 = (float)Math.sqrt(f13 * f13 + f14 * f14);
                                if (l != 65531L) break;
                                f11 *= -1.0f;
                            }
                        }
                        f10 = Math.abs(f - f11);
                        if (f10 > f7) {
                            return 0L;
                        }
                    }
                    f2 += 0.5f;
                    n2 += sCGenCellData.dxIdx;
                    fArray[0] = fArray[0] + f3;
                }
                f8 += 0.5f;
                n8 += sCGenCellData.dyIdx;
                fArray[1] = fArray[1] + f3;
            }
        }
        int n16 = sCGenCellData.xIdx + sCGenCellData.dxIdx + sCGenCellData.yIdx + sCGenCellData.dyIdx;
        sCGenData.distMap[n16] = sCGenData.numScData;
        sCGenData.featureMap[n16] = (char)l;
        int n17 = sCGenData.numScData;
        for (n = 0; n < 9; ++n) {
            sCGenData.scData[n17++] = fArray4[n];
        }
        for (n = 0; n < 9; ++n) {
            sCGenData.scData[n17++] = fArray5[n];
        }
        sCGenData.numScData += 18;
        if (internCorner == null) return l2;
        sCGenData.scData[n17++] = internCorner.p[0];
        sCGenData.scData[n17++] = internCorner.p[1];
        sCGenData.scData[n17++] = fArray2[0];
        sCGenData.scData[n17++] = fArray2[1];
        sCGenData.scData[n17++] = fArray3[0];
        sCGenData.scData[n17++] = fArray3[1];
        sCGenData.numScData += 6;
        return l2;
    }

    static void SCBuildADFQuadtree(SCGenData sCGenData, SCGenCellData sCGenCellData, ADFGlyph aDFGlyph, int n, IntValue intValue, IntValue intValue2) {
        int n2 = sCGenCellData.xIdx;
        int n3 = sCGenCellData.yIdx;
        int n4 = sCGenCellData.dxIdx;
        int n5 = sCGenCellData.dyIdx;
        int n6 = n2 + n4 + n3 + n5;
        char c = sCGenData.featureMap[n6];
        switch (c) {
            case '\ufffe': {
                aDFGlyph.cellsAndDists[n] = ADF.ADF_PACK_CELL_ATTRS(1, intValue2.value);
                int n7 = sCGenCellData.yIdx;
                float[] fArray = sCGenData.distMap;
                float f = 32768.0f;
                int n8 = 0;
                int n9 = 0;
                while (n9 <= 2) {
                    int n10 = sCGenCellData.xIdx;
                    int n11 = 0;
                    while (n11 <= 2) {
                        aDFGlyph.cellsAndDists[intValue2.value + n8++] = (int)(fArray[n10 + n7] * f);
                        ++n11;
                        n10 += sCGenCellData.dxIdx;
                    }
                    ++n9;
                    n7 += sCGenCellData.dyIdx;
                }
                intValue2.value += 9;
                return;
            }
            case '\ufffd': {
                aDFGlyph.cellsAndDists[n] = ADF.ADF_PACK_CELL_ATTRS(2, intValue2.value);
                int n12 = (int)sCGenData.distMap[n6];
                float f = 32768.0f;
                int n13 = 0;
                for (int i = 0; i < 18; ++i) {
                    aDFGlyph.cellsAndDists[intValue2.value + n13++] = (int)(sCGenData.scData[n12 + i] * f);
                }
                intValue2.value += 18;
                return;
            }
            case '\ufffb': 
            case '\ufffc': {
                int n14;
                int n15 = c == '\ufffc' ? 3 : 4;
                aDFGlyph.cellsAndDists[n] = ADF.ADF_PACK_CELL_ATTRS(n15, intValue2.value);
                int n16 = (int)sCGenData.distMap[n6];
                float f = 32768.0f;
                int n17 = 0;
                for (n14 = 0; n14 < 20; ++n14) {
                    aDFGlyph.cellsAndDists[intValue2.value + n17++] = (int)(sCGenData.scData[n16 + n14] * f);
                }
                f = 16384.0f;
                for (n14 = 20; n14 < 24; ++n14) {
                    aDFGlyph.cellsAndDists[intValue2.value + n17++] = (int)(sCGenData.scData[n16 + n14] * f);
                }
                intValue2.value += 24;
                return;
            }
        }
        int n18 = intValue.value;
        aDFGlyph.cellsAndDists[n] = ADF.ADF_PACK_CELL_ATTRS(0, n18);
        intValue.value += 4;
        SCGenCellData sCGenCellData2 = new SCGenCellData();
        sCGenCellData2.level = sCGenCellData.level + 1L;
        sCGenCellData2.dxIdx = n4 >> 1;
        sCGenCellData2.dyIdx = n5 >> 1;
        sCGenCellData2.halfCellSide = 0.5f * sCGenCellData.halfCellSide;
        sCGenCellData2.yIdx = n3;
        for (int i = 0; i < 2; ++i) {
            sCGenCellData2.xIdx = n2;
            for (int j = 0; j < 2; ++j) {
                ADF.SCBuildADFQuadtree(sCGenData, sCGenCellData2, aDFGlyph, n18, intValue, intValue2);
                ++n18;
                sCGenCellData2.xIdx += n4;
            }
            sCGenCellData2.yIdx += n5;
        }
    }

    static void ADFPackAlgnZones(ADFGlyph aDFGlyph, ADFTypeSystem.ADFPath aDFPath) {
        aDFPath.algnZones = new long[2];
        ADFMathUtils.ADFPackF32Result aDFPackF32Result = ADFMathUtils.ADFPackF32(aDFGlyph.xAlgnCoord);
        if (aDFPackF32Result.tooLarge) {
            aDFPackF32Result.packedValue = 0;
        }
        ADFMathUtils.ADF_SERIALIZE_U16(aDFPath.algnZones, 0, 0, 8, aDFPackF32Result.packedValue);
        aDFPackF32Result = ADFMathUtils.ADFPackF32(aDFGlyph.yAlgnCoord);
        if (aDFPackF32Result.tooLarge) {
            aDFPackF32Result.packedValue = 0;
        }
        ADFMathUtils.ADF_SERIALIZE_U16(aDFPath.algnZones, 0, 16, 24, aDFPackF32Result.packedValue);
        aDFPackF32Result = ADFMathUtils.ADFPackF32(aDFGlyph.xRange);
        if (aDFPackF32Result.tooLarge) {
            aDFPackF32Result.packedValue = 0;
        }
        ADFMathUtils.ADF_SERIALIZE_U16(aDFPath.algnZones, 1, 0, 8, aDFPackF32Result.packedValue);
        aDFPackF32Result = ADFMathUtils.ADFPackF32(aDFGlyph.yRange);
        if (aDFPackF32Result.tooLarge) {
            aDFPackF32Result.packedValue = 0;
        }
        ADFMathUtils.ADF_SERIALIZE_U16(aDFPath.algnZones, 1, 16, 24, aDFPackF32Result.packedValue);
        aDFPath.algnZonesMask = ADFMathUtils.ADF_SERIALIZE_U32(aDFGlyph.algnZonesMask);
    }

    public static void ADFUnpackAlgnZones(ADFTypeSystem.ADFPath aDFPath, ADFGlyph aDFGlyph) {
        long l;
        long l2;
        aDFGlyph.algnZonesMask = ADFMathUtils.ADF_DESERIALIZE_U32(aDFPath.algnZonesMask);
        long l3 = aDFGlyph.algnZonesMask & 1;
        long l4 = aDFGlyph.algnZonesMask & 2;
        if (l3 == 0L) {
            aDFGlyph.xRange = 0.0f;
        } else {
            l2 = ADFMathUtils.ADF_DESERIALIZE_U16(aDFPath.algnZones, 0, 0, 8);
            l = ADFMathUtils.ADF_DESERIALIZE_U16(aDFPath.algnZones, 1, 0, 8);
            aDFGlyph.xAlgnCoord = ADFMathUtils.ADFUnpackF32(l2);
            aDFGlyph.xRange = ADFMathUtils.ADFUnpackF32(l);
        }
        if (l4 == 0L) {
            aDFGlyph.yRange = 0.0f;
        } else {
            l2 = ADFMathUtils.ADF_DESERIALIZE_U16(aDFPath.algnZones, 0, 16, 24);
            l = ADFMathUtils.ADF_DESERIALIZE_U16(aDFPath.algnZones, 1, 16, 24);
            aDFGlyph.yAlgnCoord = ADFMathUtils.ADFUnpackF32(l2);
            aDFGlyph.yRange = ADFMathUtils.ADFUnpackF32(l);
        }
    }

    static class SCGenCellData {
        long level;
        int xIdx;
        int yIdx;
        int dxIdx;
        int dyIdx;
        float halfCellSide;
        float[] distVals = new float[9];
        float x0;
        float y0;

        SCGenCellData() {
        }
    }

    static class SCGenData {
        InternPath internPath;
        ADFTypeSystem.ADFGenAttrs genAttrs;
        int mapSideLen;
        float[] distMap;
        char[] featureMap;
        float[] scData;
        int numScData;
        int maxNumScData;
        int numDists;
        int numCells;

        SCGenData() {
        }
    }

    static class InternPath {
        float FUToADFScale;
        float glyphOffsetX;
        float glyphOffsetY;
        float ADFUnitsPerEM;
        int numPathElements;
        InternPathElm[] elms;
        int[] contours;
        InternCorner[] corners;
        int maxGridLines;
        float[] crossings;
        short[] crossingTypes;
        CTNode[] clusterTreeRoot;

        InternPath() {
        }
    }

    static class CTNode {
        boolean isNew;
        float minDistSqr;
        float xMin;
        float yMin;
        float xMax;
        float yMax;
        CTNode firstChild;
        CTNode nextSibling;
        CTNode sortThread;
        InternPathElm pElm = new InternPathElm();

        CTNode() {
        }
    }

    static class InternCorner {
        int sec1ID;
        int sec2ID;
        float[] p = new float[2];
        float[] t1 = new float[2];
        float[] t2 = new float[2];
        long type;

        InternCorner() {
        }
    }

    static class InternPathElm {
        int type;
        float xMin;
        float xMax;
        float yMin;
        float yMax;
        int featureID;
        int e0_ID;
        int e1_ID;
        float[] e0 = new float[2];
        float[] e1 = new float[2];
        double[] v01 = new double[2];
        double[] v21 = new double[2];
        double[] v012 = new double[2];
        double c1;
        double c2;
        double c3;
        long orientation;

        InternPathElm() {
        }
    }

    static class BooleanValue {
        boolean value;

        public BooleanValue(boolean bl) {
            this.value = bl;
        }
    }

    static class IntValue {
        int value;

        public IntValue(int n) {
            this.value = n;
        }
    }

    static class Cell {
        int type;
        int offset;

        Cell() {
        }
    }

    public static class ADFGlyph {
        long version;
        long numCells;
        int[] cellsAndDists;
        long charCode;
        float FUToADFScale;
        float ADFUnitsPerEM;
        float glyphOriginX;
        float glyphOriginY;
        float glyphMinX;
        float glyphMinY;
        float glyphMaxX;
        float glyphMaxY;
        public float xAlgnCoord;
        public float yAlgnCoord;
        public float xRange;
        public float yRange;
        int algnZonesMask;
    }
}

