/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts.flashtype;

import flash.fonts.flashtype.ADF;
import flash.fonts.flashtype.ADFAlgnZones;
import flash.fonts.flashtype.ADFMathUtils;
import flash.fonts.flashtype.ADFTypeSystem;
import flash.fonts.flashtype.FlexADFData;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ADFTest {
    public static void main(String[] stringArray) throws Exception {
        ADFTest.testADFMathUtils();
        ADFTest.testADF();
        ADFTest.generateADFAlgnZones();
    }

    private static void testADFMathUtils() {
        ADFMathUtils.FloatingPointValue floatingPointValue = new ADFMathUtils.FloatingPointValue(0.0);
        ADFMathUtils.frexp(floatingPointValue);
        System.out.println("frexp: " + floatingPointValue.mantissa + " : " + floatingPointValue.exp);
        floatingPointValue = new ADFMathUtils.FloatingPointValue(1.0);
        ADFMathUtils.frexp(floatingPointValue);
        System.out.println("frexp: " + floatingPointValue.mantissa + " : " + floatingPointValue.exp);
        floatingPointValue = new ADFMathUtils.FloatingPointValue(-5.555);
        ADFMathUtils.frexp(floatingPointValue);
        System.out.println("frexp: " + floatingPointValue.mantissa + " : " + floatingPointValue.exp);
        ADFMathUtils.ADFPackF32Result aDFPackF32Result = ADFMathUtils.ADFPackF32(5.555f);
        System.out.println("ADFPackF32: " + aDFPackF32Result.packedValue);
        float f = ADFMathUtils.ADFUnpackF32(aDFPackF32Result.packedValue);
        System.out.println("ADFUnpackF32: " + f);
        aDFPackF32Result = ADFMathUtils.ADFPackF32(1234.5679f);
        System.out.println("ADFPackF32: " + aDFPackF32Result.packedValue);
        f = ADFMathUtils.ADFUnpackF32(aDFPackF32Result.packedValue);
        System.out.println("ADFUnpackF32: " + f);
        ADFMathUtils.RootValue rootValue = ADFMathUtils.ADFGetRealQuadraticRoots(new double[]{1.0, 0.0, -1.0});
        System.out.println("ADFGetRealQuadraticRoots: " + rootValue.num);
        System.out.println("");
    }

    private static void testADF() {
        ADF.ADFGlyph aDFGlyph = new ADF.ADFGlyph();
        aDFGlyph.xAlgnCoord = 20.0f;
        aDFGlyph.xRange = 30.0f;
        aDFGlyph.yAlgnCoord = 40.0f;
        aDFGlyph.yRange = 50.0f;
        aDFGlyph.algnZonesMask = 92345678;
        ADFTypeSystem.ADFPath aDFPath = new ADFTypeSystem.ADFPath();
        ADF.ADFPackAlgnZones(aDFGlyph, aDFPath);
        System.out.println("algnZones: " + aDFPath.algnZones[0] + " : " + aDFPath.algnZones[1]);
        System.out.println("algnZonesMask: " + aDFPath.algnZonesMask);
        ADF.ADFUnpackAlgnZones(aDFPath, aDFGlyph);
        System.out.println("adf.xAlgnCoord = " + aDFGlyph.xAlgnCoord + " : " + "adf.yAlgnCoord = " + aDFGlyph.yAlgnCoord);
        System.out.println("adf.xRange = " + aDFGlyph.xRange + " : adf.yRange = " + aDFGlyph.yRange);
        System.out.println("adf.algnZonesMask = " + aDFGlyph.algnZonesMask);
        System.out.println("");
    }

    private static void createInternPath() throws Exception {
        Object object;
        int n;
        Object object2 = new Object();
        Method method = ADFTest.getFontOutlinesMethod();
        ADFTypeSystem.ADFGenAttrs aDFGenAttrs = new ADFTypeSystem.ADFGenAttrs();
        aDFGenAttrs.maxLevel = 5L;
        aDFGenAttrs.maxError = 2.0E-4f;
        aDFGenAttrs.distEps = 0.0f;
        ADFTypeSystem.ADFPath aDFPath = (ADFTypeSystem.ADFPath)method.invoke(null, object2, new FlexADFData(), new Character('Z'));
        ADF.InternPath internPath = ADF.CreateInternPath(aDFPath, aDFGenAttrs);
        System.out.println("*** InternPath ***");
        System.out.println("ADFUnitsPerEM: " + internPath.ADFUnitsPerEM + ", FUToADFScale: " + internPath.FUToADFScale);
        System.out.println("glyphOffsetX: " + internPath.glyphOffsetX + ", glyphOffsetY: " + internPath.glyphOffsetY);
        System.out.println("maxGridLines: " + internPath.maxGridLines + ", numPathElements: " + internPath.numPathElements);
        for (n = 0; n < internPath.numPathElements; ++n) {
            object = internPath.corners[n];
            if (object == null) continue;
            System.out.println("corner num: " + n + ", type: " + ((ADF.InternCorner)object).type + ", sec1ID: " + ((ADF.InternCorner)object).sec1ID + ", sec2ID: " + ((ADF.InternCorner)object).sec2ID);
            System.out.println("corner p: " + ADFTest.getFloatArrayString(((ADF.InternCorner)object).p));
            System.out.println("corner t1: " + ADFTest.getFloatArrayString(((ADF.InternCorner)object).t1) + " t2: " + ADFTest.getFloatArrayString(((ADF.InternCorner)object).t2));
        }
        System.out.println("contours: " + ADFTest.getIntArrayString(internPath.contours));
        System.out.println("crossings: " + ADFTest.getFloatArrayString(internPath.crossings));
        for (n = 0; n < internPath.numPathElements; ++n) {
            object = internPath.elms[n];
            System.out.println("elm c/featureID: " + ((ADF.InternPathElm)object).c1 + " : " + ((ADF.InternPathElm)object).c2 + " : " + ((ADF.InternPathElm)object).c3 + " : " + ((ADF.InternPathElm)object).featureID);
            System.out.println("elm e_ID: " + ((ADF.InternPathElm)object).e0_ID + " : " + ((ADF.InternPathElm)object).e1_ID);
            System.out.println("elm e0: " + ADFTest.getFloatArrayString(((ADF.InternPathElm)object).e0));
            System.out.println("elm e1: " + ADFTest.getFloatArrayString(((ADF.InternPathElm)object).e1));
        }
        for (n = 0; n < internPath.numPathElements; ++n) {
            object = internPath.clusterTreeRoot[n];
            System.out.println("CTNode minDistSqr: " + ((ADF.CTNode)object).minDistSqr + ", " + ((ADF.CTNode)object).xMin + " : " + ((ADF.CTNode)object).xMax + " : " + ((ADF.CTNode)object).yMin + " : " + ((ADF.CTNode)object).yMax);
        }
        System.out.println("*** end InternPath ***");
    }

    private static void createADF() throws Exception {
        Object object = new Object();
        Method method = ADFTest.getFontOutlinesMethod();
        ADFTypeSystem.ADFGenAttrs aDFGenAttrs = new ADFTypeSystem.ADFGenAttrs();
        aDFGenAttrs.maxLevel = 5L;
        aDFGenAttrs.maxError = 2.0E-4f;
        aDFGenAttrs.distEps = 0.0f;
        ADFTypeSystem.ADFPath aDFPath = (ADFTypeSystem.ADFPath)method.invoke(null, object, new FlexADFData(), new Character('Z'));
        ADF.ADFGlyph aDFGlyph = (ADF.ADFGlyph)ADF.ADFGenerateADF(object, aDFPath, aDFGenAttrs);
        System.out.println("int[] cellArr = new int[" + aDFGlyph.cellsAndDists.length + "];");
        for (int i = 0; i < aDFGlyph.cellsAndDists.length; ++i) {
            System.out.println("cellArr[" + i + "] = " + aDFGlyph.cellsAndDists[i] + ";");
        }
    }

    private static Method getFontOutlinesMethod() {
        Method method = null;
        Method[] methodArray = ADFTest.class.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals("GetFontOutlinesCB")) continue;
            method = methodArray[i];
            break;
        }
        return method;
    }

    static String getFloatArrayString(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fArray.length; ++i) {
            stringBuffer.append(fArray[i]);
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private static String getIntArrayString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private static void generateADFAlgnZones() throws Exception {
        Method method = ADFTest.getFontOutlinesMethod();
        ADFAlgnZones.AlgnZoneState algnZoneState = (ADFAlgnZones.AlgnZoneState)ADFAlgnZones.ADFInitAlgnZoneDetection(null, new FlexADFData(), null, method, null);
        ADFTest.generateADF(algnZoneState, 'A');
        ADFTest.generateADF(algnZoneState, 'B');
        ADFTest.generateADF(algnZoneState, 'H');
        ADFTest.generateADF(algnZoneState, 'L');
        ADFTest.generateADF(algnZoneState, 'Z');
        ADFTest.generateADF(algnZoneState, 'l');
        ADFTest.generateADF(algnZoneState, 'z');
    }

    private static void generateADF(ADFAlgnZones.AlgnZoneState algnZoneState, char c) {
        FlexADFData flexADFData = new FlexADFData();
        ADFTypeSystem.ADFPath aDFPath = ADFTest.GetFontOutlinesCB(null, flexADFData, c);
        ADFAlgnZones.ADFDetectAlgnZones(null, algnZoneState, aDFPath);
        ADF.ADFGlyph aDFGlyph = new ADF.ADFGlyph();
        ADF.ADFUnpackAlgnZones(aDFPath, aDFGlyph);
        System.out.println("ADF align zones for " + c + ": ");
        System.out.println("Generated:       " + aDFPath.algnZones[0] + " : " + aDFPath.algnZones[1] + " : " + aDFGlyph.xAlgnCoord + " : " + aDFGlyph.yAlgnCoord + " : " + aDFGlyph.xRange + " : " + aDFGlyph.yRange);
        ADFTypeSystem.ADFPath aDFPath2 = new ADFTypeSystem.ADFPath();
        aDFPath2.algnZonesMask = 3;
        switch (c) {
            case 'A': {
                aDFPath2.algnZones = new long[]{13915L, 1121845248L};
                break;
            }
            case 'B': {
                aDFPath2.algnZones = new long[]{13924L, 1121861447L};
                break;
            }
            case 'H': {
                aDFPath2.algnZones = new long[]{13954L, 1121861568L};
                break;
            }
            case 'L': {
                aDFPath2.algnZones = new long[]{13915L, 1121845248L};
                break;
            }
            case 'Z': {
                aDFPath2.algnZones = new long[]{13915L, 1121845248L};
                break;
            }
            case 'l': {
                aDFPath2.algnZones = new long[]{13309L, 1108606976L};
                break;
            }
            case 'z': {
                aDFPath2.algnZones = new long[]{13309L, 1108606976L};
            }
        }
        if (aDFPath2.algnZones != null) {
            ADF.ADFUnpackAlgnZones(aDFPath2, aDFGlyph);
            System.out.println("Flash Authoring: " + aDFPath2.algnZones[0] + " : " + aDFPath2.algnZones[1] + " : " + aDFGlyph.xAlgnCoord + " : " + aDFGlyph.yAlgnCoord + " : " + aDFGlyph.xRange + " : " + aDFGlyph.yRange);
        }
        System.out.println("");
    }

    public static ADFTypeSystem.ADFPath GetFontOutlinesCB(Object object, Object object2, char c) {
        ADFTypeSystem.ADFPenCmd aDFPenCmd;
        ADFTypeSystem.ADFPenCmd aDFPenCmd2;
        ADFTypeSystem.ADFPenCmd aDFPenCmd3;
        ADFTypeSystem.ADFPenCmd aDFPenCmd4;
        ADFTypeSystem.ADFPenCmd aDFPenCmd5;
        ADFTypeSystem.ADFPenCmd aDFPenCmd6;
        ADFTypeSystem.ADFPenCmd aDFPenCmd7;
        ADFTypeSystem.ADFPenCmd aDFPenCmd8;
        ADFTypeSystem.ADFPenCmd aDFPenCmd9;
        ADFTypeSystem.ADFPenCmd aDFPenCmd10;
        ADFTypeSystem.ADFPenCmd aDFPenCmd11;
        ADFTypeSystem.ADFPenCmd aDFPenCmd12;
        ADFTypeSystem.ADFPenCmd aDFPenCmd13;
        ADFTypeSystem.ADFPenCmd aDFPenCmd14;
        ADFTypeSystem.ADFPenCmd aDFPenCmd15;
        FlexADFData flexADFData = (FlexADFData)object2;
        if (c == 'A') {
            flexADFData.mPath.fontUnitsPerEM = 20480.0f;
            flexADFData.mPath.charCode = (char)65;
            aDFPenCmd15 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd15.opCode = 0L;
            aDFPenCmd15.x = -30.0f;
            aDFPenCmd15.y = 0.0f;
            aDFPenCmd14 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd14.opCode = 1L;
            aDFPenCmd14.x = 5600.0f;
            aDFPenCmd14.y = 14660.0f;
            aDFPenCmd13 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd13.opCode = 1L;
            aDFPenCmd13.x = 7690.0f;
            aDFPenCmd13.y = 14660.0f;
            aDFPenCmd12 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd12.opCode = 1L;
            aDFPenCmd12.x = 13690.0f;
            aDFPenCmd12.y = 0.0f;
            aDFPenCmd11 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd11.opCode = 1L;
            aDFPenCmd11.x = 11480.0f;
            aDFPenCmd11.y = 0.0f;
            aDFPenCmd10 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd10.opCode = 1L;
            aDFPenCmd10.x = 9770.0f;
            aDFPenCmd10.y = 4440.0f;
            aDFPenCmd9 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd9.opCode = 1L;
            aDFPenCmd9.x = 3640.0f;
            aDFPenCmd9.y = 4440.0f;
            aDFPenCmd8 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd8.opCode = 1L;
            aDFPenCmd8.x = 2030.0f;
            aDFPenCmd8.y = 0.0f;
            aDFPenCmd7 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd7.opCode = 1L;
            aDFPenCmd7.x = -30.0f;
            aDFPenCmd7.y = 0.0f;
            aDFPenCmd6 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd6.opCode = 0L;
            aDFPenCmd6.x = 4200.0f;
            aDFPenCmd6.y = 6020.0f;
            aDFPenCmd5 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd5.opCode = 1L;
            aDFPenCmd5.x = 9170.0f;
            aDFPenCmd5.y = 6020.0f;
            aDFPenCmd4 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd4.opCode = 1L;
            aDFPenCmd4.x = 7640.0f;
            aDFPenCmd4.y = 10080.0f;
            aDFPenCmd3 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd3.opCode = 2L;
            aDFPenCmd3.x = 6600.0f;
            aDFPenCmd3.y = 13120.0f;
            aDFPenCmd3.cx = 6940.0f;
            aDFPenCmd3.cy = 11930.0f;
            aDFPenCmd2 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd2.opCode = 2L;
            aDFPenCmd2.x = 5810.0f;
            aDFPenCmd2.y = 10320.0f;
            aDFPenCmd2.cx = 6320.0f;
            aDFPenCmd2.cy = 11710.0f;
            aDFPenCmd = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd.opCode = 1L;
            aDFPenCmd.x = 4200.0f;
            aDFPenCmd.y = 6020.0f;
            flexADFData.mPath.penCmds = new ArrayList(15);
            flexADFData.mPath.penCmds.add(0, aDFPenCmd15);
            flexADFData.mPath.penCmds.add(1, aDFPenCmd14);
            flexADFData.mPath.penCmds.add(2, aDFPenCmd13);
            flexADFData.mPath.penCmds.add(3, aDFPenCmd12);
            flexADFData.mPath.penCmds.add(4, aDFPenCmd11);
            flexADFData.mPath.penCmds.add(5, aDFPenCmd10);
            flexADFData.mPath.penCmds.add(6, aDFPenCmd9);
            flexADFData.mPath.penCmds.add(7, aDFPenCmd8);
            flexADFData.mPath.penCmds.add(8, aDFPenCmd7);
            flexADFData.mPath.penCmds.add(9, aDFPenCmd6);
            flexADFData.mPath.penCmds.add(10, aDFPenCmd5);
            flexADFData.mPath.penCmds.add(11, aDFPenCmd4);
            flexADFData.mPath.penCmds.add(12, aDFPenCmd3);
            flexADFData.mPath.penCmds.add(13, aDFPenCmd2);
            flexADFData.mPath.penCmds.add(14, aDFPenCmd);
            flexADFData.mPath.glyphMinX = -30.0f;
            flexADFData.mPath.glyphMinY = -0.0f;
            flexADFData.mPath.glyphMaxX = 13690.0f;
            flexADFData.mPath.glyphMaxY = 14660.0f;
            flexADFData.mPath.numContours = 2;
            flexADFData.mPath.numPenCmds = 15L;
        }
        if (c == 'B') {
            flexADFData.mPath.fontUnitsPerEM = 20480.0f;
            flexADFData.mPath.charCode = (char)66;
            aDFPenCmd15 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd15.opCode = 0L;
            aDFPenCmd15.x = 1500.0f;
            aDFPenCmd15.y = 0.0f;
            aDFPenCmd14 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd14.opCode = 1L;
            aDFPenCmd14.x = 1500.0f;
            aDFPenCmd14.y = 14660.0f;
            aDFPenCmd13 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd13.opCode = 1L;
            aDFPenCmd13.x = 7000.0f;
            aDFPenCmd13.y = 14660.0f;
            aDFPenCmd12 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd12.opCode = 2L;
            aDFPenCmd12.x = 9695.0f;
            aDFPenCmd12.y = 14215.0f;
            aDFPenCmd12.cx = 8680.0f;
            aDFPenCmd12.cy = 14660.0f;
            aDFPenCmd11 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd11.opCode = 2L;
            aDFPenCmd11.x = 11285.0f;
            aDFPenCmd11.y = 12845.0f;
            aDFPenCmd11.cx = 10710.0f;
            aDFPenCmd11.cy = 13770.0f;
            aDFPenCmd10 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd10.opCode = 2L;
            aDFPenCmd10.x = 11860.0f;
            aDFPenCmd10.y = 10910.0f;
            aDFPenCmd10.cx = 11860.0f;
            aDFPenCmd10.cy = 11920.0f;
            aDFPenCmd9 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd9.opCode = 2L;
            aDFPenCmd9.x = 11350.0f;
            aDFPenCmd9.y = 9140.0f;
            aDFPenCmd9.cx = 11860.0f;
            aDFPenCmd9.cy = 9970.0f;
            aDFPenCmd8 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd8.opCode = 2L;
            aDFPenCmd8.x = 9810.0f;
            aDFPenCmd8.y = 7800.0f;
            aDFPenCmd8.cx = 10840.0f;
            aDFPenCmd8.cy = 8310.0f;
            aDFPenCmd7 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd7.opCode = 2L;
            aDFPenCmd7.x = 11855.0f;
            aDFPenCmd7.y = 6470.0f;
            aDFPenCmd7.cx = 11140.0f;
            aDFPenCmd7.cy = 7410.0f;
            aDFPenCmd6 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd6.opCode = 2L;
            aDFPenCmd6.x = 12570.0f;
            aDFPenCmd6.y = 4250.0f;
            aDFPenCmd6.cx = 12570.0f;
            aDFPenCmd6.cy = 5530.0f;
            aDFPenCmd5 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd5.opCode = 2L;
            aDFPenCmd5.x = 12135.0f;
            aDFPenCmd5.y = 2335.0f;
            aDFPenCmd5.cx = 12570.0f;
            aDFPenCmd5.cy = 3220.0f;
            aDFPenCmd4 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd4.opCode = 2L;
            aDFPenCmd4.x = 11060.0f;
            aDFPenCmd4.y = 970.0f;
            aDFPenCmd4.cx = 11700.0f;
            aDFPenCmd4.cy = 1450.0f;
            aDFPenCmd3 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd3.opCode = 2L;
            aDFPenCmd3.x = 9455.0f;
            aDFPenCmd3.y = 245.0f;
            aDFPenCmd3.cx = 10420.0f;
            aDFPenCmd3.cy = 490.0f;
            aDFPenCmd2 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd2.opCode = 2L;
            aDFPenCmd2.x = 7090.0f;
            aDFPenCmd2.y = 0.0f;
            aDFPenCmd2.cx = 8490.0f;
            aDFPenCmd2.cy = 0.0f;
            aDFPenCmd = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd.opCode = 1L;
            aDFPenCmd.x = 1500.0f;
            aDFPenCmd.y = 0.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd16 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd16.opCode = 0L;
            aDFPenCmd16.x = 3440.0f;
            aDFPenCmd16.y = 8500.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd17 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd17.opCode = 1L;
            aDFPenCmd17.x = 6610.0f;
            aDFPenCmd17.y = 8500.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd18 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd18.opCode = 2L;
            aDFPenCmd18.x = 8460.0f;
            aDFPenCmd18.y = 8670.0f;
            aDFPenCmd18.cx = 7900.0f;
            aDFPenCmd18.cy = 8500.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd19 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd19.opCode = 2L;
            aDFPenCmd19.x = 9575.0f;
            aDFPenCmd19.y = 9400.0f;
            aDFPenCmd19.cx = 9200.0f;
            aDFPenCmd19.cy = 8890.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd20 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd20.opCode = 2L;
            aDFPenCmd20.x = 9950.0f;
            aDFPenCmd20.y = 10680.0f;
            aDFPenCmd20.cx = 9950.0f;
            aDFPenCmd20.cy = 9910.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd21 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd21.opCode = 2L;
            aDFPenCmd21.x = 9600.0f;
            aDFPenCmd21.y = 11965.0f;
            aDFPenCmd21.cx = 9950.0f;
            aDFPenCmd21.cy = 11410.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd22 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd22.opCode = 2L;
            aDFPenCmd22.x = 8600.0f;
            aDFPenCmd22.y = 12725.0f;
            aDFPenCmd22.cx = 9250.0f;
            aDFPenCmd22.cy = 12520.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd23 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd23.opCode = 2L;
            aDFPenCmd23.x = 6370.0f;
            aDFPenCmd23.y = 12930.0f;
            aDFPenCmd23.cx = 7950.0f;
            aDFPenCmd23.cy = 12930.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd24 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd24.opCode = 1L;
            aDFPenCmd24.x = 3440.0f;
            aDFPenCmd24.y = 12930.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd25 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd25.opCode = 1L;
            aDFPenCmd25.x = 3440.0f;
            aDFPenCmd25.y = 8500.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd26 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd26.opCode = 0L;
            aDFPenCmd26.x = 3440.0f;
            aDFPenCmd26.y = 1730.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd27 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd27.opCode = 1L;
            aDFPenCmd27.x = 7090.0f;
            aDFPenCmd27.y = 1730.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd28 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd28.opCode = 2L;
            aDFPenCmd28.x = 8410.0f;
            aDFPenCmd28.y = 1800.0f;
            aDFPenCmd28.cx = 8030.0f;
            aDFPenCmd28.cy = 1730.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd29 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd29.opCode = 2L;
            aDFPenCmd29.x = 9530.0f;
            aDFPenCmd29.y = 2200.0f;
            aDFPenCmd29.cx = 9080.0f;
            aDFPenCmd29.cy = 1920.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd30 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd30.opCode = 2L;
            aDFPenCmd30.x = 10270.0f;
            aDFPenCmd30.y = 3015.0f;
            aDFPenCmd30.cx = 9980.0f;
            aDFPenCmd30.cy = 2480.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd31 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd31.opCode = 2L;
            aDFPenCmd31.x = 10560.0f;
            aDFPenCmd31.y = 4250.0f;
            aDFPenCmd31.cx = 10560.0f;
            aDFPenCmd31.cy = 3550.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd32 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd32.opCode = 2L;
            aDFPenCmd32.x = 10140.0f;
            aDFPenCmd32.y = 5675.0f;
            aDFPenCmd32.cx = 10560.0f;
            aDFPenCmd32.cy = 5070.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd33 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd33.opCode = 2L;
            aDFPenCmd33.x = 8975.0f;
            aDFPenCmd33.y = 6525.0f;
            aDFPenCmd33.cx = 9720.0f;
            aDFPenCmd33.cy = 6280.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd34 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd34.opCode = 2L;
            aDFPenCmd34.x = 6830.0f;
            aDFPenCmd34.y = 6770.0f;
            aDFPenCmd34.cx = 8230.0f;
            aDFPenCmd34.cy = 6770.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd35 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd35.opCode = 1L;
            aDFPenCmd35.x = 3440.0f;
            aDFPenCmd35.y = 6770.0f;
            ADFTypeSystem.ADFPenCmd aDFPenCmd36 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd36.opCode = 1L;
            aDFPenCmd36.x = 3440.0f;
            aDFPenCmd36.y = 1730.0f;
            flexADFData.mPath.penCmds = new ArrayList(36);
            flexADFData.mPath.penCmds.add(0, aDFPenCmd15);
            flexADFData.mPath.penCmds.add(1, aDFPenCmd14);
            flexADFData.mPath.penCmds.add(2, aDFPenCmd13);
            flexADFData.mPath.penCmds.add(3, aDFPenCmd12);
            flexADFData.mPath.penCmds.add(4, aDFPenCmd11);
            flexADFData.mPath.penCmds.add(5, aDFPenCmd10);
            flexADFData.mPath.penCmds.add(6, aDFPenCmd9);
            flexADFData.mPath.penCmds.add(7, aDFPenCmd8);
            flexADFData.mPath.penCmds.add(8, aDFPenCmd7);
            flexADFData.mPath.penCmds.add(9, aDFPenCmd6);
            flexADFData.mPath.penCmds.add(10, aDFPenCmd5);
            flexADFData.mPath.penCmds.add(11, aDFPenCmd4);
            flexADFData.mPath.penCmds.add(12, aDFPenCmd3);
            flexADFData.mPath.penCmds.add(13, aDFPenCmd2);
            flexADFData.mPath.penCmds.add(14, aDFPenCmd);
            flexADFData.mPath.penCmds.add(15, aDFPenCmd16);
            flexADFData.mPath.penCmds.add(16, aDFPenCmd17);
            flexADFData.mPath.penCmds.add(17, aDFPenCmd18);
            flexADFData.mPath.penCmds.add(18, aDFPenCmd19);
            flexADFData.mPath.penCmds.add(19, aDFPenCmd20);
            flexADFData.mPath.penCmds.add(20, aDFPenCmd21);
            flexADFData.mPath.penCmds.add(21, aDFPenCmd22);
            flexADFData.mPath.penCmds.add(22, aDFPenCmd23);
            flexADFData.mPath.penCmds.add(23, aDFPenCmd24);
            flexADFData.mPath.penCmds.add(24, aDFPenCmd25);
            flexADFData.mPath.penCmds.add(25, aDFPenCmd26);
            flexADFData.mPath.penCmds.add(26, aDFPenCmd27);
            flexADFData.mPath.penCmds.add(27, aDFPenCmd28);
            flexADFData.mPath.penCmds.add(28, aDFPenCmd29);
            flexADFData.mPath.penCmds.add(29, aDFPenCmd30);
            flexADFData.mPath.penCmds.add(30, aDFPenCmd31);
            flexADFData.mPath.penCmds.add(31, aDFPenCmd32);
            flexADFData.mPath.penCmds.add(32, aDFPenCmd33);
            flexADFData.mPath.penCmds.add(33, aDFPenCmd34);
            flexADFData.mPath.penCmds.add(34, aDFPenCmd35);
            flexADFData.mPath.penCmds.add(35, aDFPenCmd36);
            flexADFData.mPath.glyphMinX = 1500.0f;
            flexADFData.mPath.glyphMinY = -0.0f;
            flexADFData.mPath.glyphMaxX = 12570.0f;
            flexADFData.mPath.glyphMaxY = 14660.0f;
            flexADFData.mPath.numContours = 3;
            flexADFData.mPath.numPenCmds = 36L;
        }
        if (c == 'Z') {
            flexADFData.mPath.fontUnitsPerEM = 20480.0f;
            flexADFData.mPath.charCode = (char)90;
            aDFPenCmd15 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd15.opCode = 0L;
            aDFPenCmd15.x = 410.0f;
            aDFPenCmd15.y = 0.0f;
            aDFPenCmd14 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd14.opCode = 1L;
            aDFPenCmd14.x = 410.0f;
            aDFPenCmd14.y = 1800.0f;
            aDFPenCmd13 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd13.opCode = 1L;
            aDFPenCmd13.x = 7920.0f;
            aDFPenCmd13.y = 11190.0f;
            aDFPenCmd12 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd12.opCode = 2L;
            aDFPenCmd12.x = 9440.0f;
            aDFPenCmd12.y = 12930.0f;
            aDFPenCmd12.cx = 8720.0f;
            aDFPenCmd12.cy = 12190.0f;
            aDFPenCmd11 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd11.opCode = 1L;
            aDFPenCmd11.x = 1260.0f;
            aDFPenCmd11.y = 12930.0f;
            aDFPenCmd10 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd10.opCode = 1L;
            aDFPenCmd10.x = 1260.0f;
            aDFPenCmd10.y = 14660.0f;
            aDFPenCmd9 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd9.opCode = 1L;
            aDFPenCmd9.x = 11760.0f;
            aDFPenCmd9.y = 14660.0f;
            aDFPenCmd8 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd8.opCode = 1L;
            aDFPenCmd8.x = 11760.0f;
            aDFPenCmd8.y = 12930.0f;
            aDFPenCmd7 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd7.opCode = 1L;
            aDFPenCmd7.x = 3530.0f;
            aDFPenCmd7.y = 2760.0f;
            aDFPenCmd6 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd6.opCode = 1L;
            aDFPenCmd6.x = 2640.0f;
            aDFPenCmd6.y = 1730.0f;
            aDFPenCmd5 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd5.opCode = 1L;
            aDFPenCmd5.x = 12000.0f;
            aDFPenCmd5.y = 1730.0f;
            aDFPenCmd4 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd4.opCode = 1L;
            aDFPenCmd4.x = 12000.0f;
            aDFPenCmd4.y = 0.0f;
            aDFPenCmd3 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd3.opCode = 1L;
            aDFPenCmd3.x = 410.0f;
            aDFPenCmd3.y = 0.0f;
            flexADFData.mPath.penCmds = new ArrayList(13);
            flexADFData.mPath.penCmds.add(0, aDFPenCmd15);
            flexADFData.mPath.penCmds.add(1, aDFPenCmd14);
            flexADFData.mPath.penCmds.add(2, aDFPenCmd13);
            flexADFData.mPath.penCmds.add(3, aDFPenCmd12);
            flexADFData.mPath.penCmds.add(4, aDFPenCmd11);
            flexADFData.mPath.penCmds.add(5, aDFPenCmd10);
            flexADFData.mPath.penCmds.add(6, aDFPenCmd9);
            flexADFData.mPath.penCmds.add(7, aDFPenCmd8);
            flexADFData.mPath.penCmds.add(8, aDFPenCmd7);
            flexADFData.mPath.penCmds.add(9, aDFPenCmd6);
            flexADFData.mPath.penCmds.add(10, aDFPenCmd5);
            flexADFData.mPath.penCmds.add(11, aDFPenCmd4);
            flexADFData.mPath.penCmds.add(12, aDFPenCmd3);
            flexADFData.mPath.glyphMinX = 410.0f;
            flexADFData.mPath.glyphMinY = -0.0f;
            flexADFData.mPath.glyphMaxX = 12000.0f;
            flexADFData.mPath.glyphMaxY = 14660.0f;
            flexADFData.mPath.numContours = 1;
            flexADFData.mPath.numPenCmds = 13L;
        }
        if (c == 'z') {
            flexADFData.mPath.fontUnitsPerEM = 20480.0f;
            flexADFData.mPath.charCode = (char)122;
            aDFPenCmd15 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd15.opCode = 0L;
            aDFPenCmd15.x = 400.0f;
            aDFPenCmd15.y = 0.0f;
            aDFPenCmd14 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd14.opCode = 1L;
            aDFPenCmd14.x = 400.0f;
            aDFPenCmd14.y = 1460.0f;
            aDFPenCmd13 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd13.opCode = 1L;
            aDFPenCmd13.x = 7160.0f;
            aDFPenCmd13.y = 9220.0f;
            aDFPenCmd12 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd12.opCode = 2L;
            aDFPenCmd12.x = 5130.0f;
            aDFPenCmd12.y = 9160.0f;
            aDFPenCmd12.cx = 6010.0f;
            aDFPenCmd12.cy = 9160.0f;
            aDFPenCmd11 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd11.opCode = 1L;
            aDFPenCmd11.x = 800.0f;
            aDFPenCmd11.y = 9160.0f;
            aDFPenCmd10 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd10.opCode = 1L;
            aDFPenCmd10.x = 800.0f;
            aDFPenCmd10.y = 10620.0f;
            aDFPenCmd9 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd9.opCode = 1L;
            aDFPenCmd9.x = 9480.0f;
            aDFPenCmd9.y = 10620.0f;
            aDFPenCmd8 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd8.opCode = 1L;
            aDFPenCmd8.x = 9480.0f;
            aDFPenCmd8.y = 9430.0f;
            aDFPenCmd7 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd7.opCode = 1L;
            aDFPenCmd7.x = 3730.0f;
            aDFPenCmd7.y = 2690.0f;
            aDFPenCmd6 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd6.opCode = 1L;
            aDFPenCmd6.x = 2620.0f;
            aDFPenCmd6.y = 1460.0f;
            aDFPenCmd5 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd5.opCode = 2L;
            aDFPenCmd5.x = 4890.0f;
            aDFPenCmd5.y = 1550.0f;
            aDFPenCmd5.cx = 3830.0f;
            aDFPenCmd5.cy = 1550.0f;
            aDFPenCmd4 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd4.opCode = 1L;
            aDFPenCmd4.x = 9800.0f;
            aDFPenCmd4.y = 1550.0f;
            aDFPenCmd3 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd3.opCode = 1L;
            aDFPenCmd3.x = 9800.0f;
            aDFPenCmd3.y = 0.0f;
            aDFPenCmd2 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd2.opCode = 1L;
            aDFPenCmd2.x = 400.0f;
            aDFPenCmd2.y = 0.0f;
            flexADFData.mPath.penCmds = new ArrayList(14);
            flexADFData.mPath.penCmds.add(0, aDFPenCmd15);
            flexADFData.mPath.penCmds.add(1, aDFPenCmd14);
            flexADFData.mPath.penCmds.add(2, aDFPenCmd13);
            flexADFData.mPath.penCmds.add(3, aDFPenCmd12);
            flexADFData.mPath.penCmds.add(4, aDFPenCmd11);
            flexADFData.mPath.penCmds.add(5, aDFPenCmd10);
            flexADFData.mPath.penCmds.add(6, aDFPenCmd9);
            flexADFData.mPath.penCmds.add(7, aDFPenCmd8);
            flexADFData.mPath.penCmds.add(8, aDFPenCmd7);
            flexADFData.mPath.penCmds.add(9, aDFPenCmd6);
            flexADFData.mPath.penCmds.add(10, aDFPenCmd5);
            flexADFData.mPath.penCmds.add(11, aDFPenCmd4);
            flexADFData.mPath.penCmds.add(12, aDFPenCmd3);
            flexADFData.mPath.penCmds.add(13, aDFPenCmd2);
            flexADFData.mPath.glyphMinX = 400.0f;
            flexADFData.mPath.glyphMinY = -0.0f;
            flexADFData.mPath.glyphMaxX = 9800.0f;
            flexADFData.mPath.glyphMaxY = 10620.0f;
            flexADFData.mPath.numContours = 1;
            flexADFData.mPath.numPenCmds = 14L;
        }
        if (c == 'L') {
            flexADFData.mPath.fontUnitsPerEM = 20480.0f;
            flexADFData.mPath.charCode = (char)76;
            aDFPenCmd15 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd15.opCode = 0L;
            aDFPenCmd15.x = 1500.0f;
            aDFPenCmd15.y = 0.0f;
            aDFPenCmd14 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd14.opCode = 1L;
            aDFPenCmd14.x = 1500.0f;
            aDFPenCmd14.y = 14660.0f;
            aDFPenCmd13 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd13.opCode = 1L;
            aDFPenCmd13.x = 3440.0f;
            aDFPenCmd13.y = 14660.0f;
            aDFPenCmd12 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd12.opCode = 1L;
            aDFPenCmd12.x = 3440.0f;
            aDFPenCmd12.y = 1730.0f;
            aDFPenCmd11 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd11.opCode = 1L;
            aDFPenCmd11.x = 10660.0f;
            aDFPenCmd11.y = 1730.0f;
            aDFPenCmd10 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd10.opCode = 1L;
            aDFPenCmd10.x = 10660.0f;
            aDFPenCmd10.y = 0.0f;
            aDFPenCmd9 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd9.opCode = 1L;
            aDFPenCmd9.x = 1500.0f;
            aDFPenCmd9.y = 0.0f;
            flexADFData.mPath.penCmds = new ArrayList(7);
            flexADFData.mPath.penCmds.add(0, aDFPenCmd15);
            flexADFData.mPath.penCmds.add(1, aDFPenCmd14);
            flexADFData.mPath.penCmds.add(2, aDFPenCmd13);
            flexADFData.mPath.penCmds.add(3, aDFPenCmd12);
            flexADFData.mPath.penCmds.add(4, aDFPenCmd11);
            flexADFData.mPath.penCmds.add(5, aDFPenCmd10);
            flexADFData.mPath.penCmds.add(6, aDFPenCmd9);
            flexADFData.mPath.glyphMinX = 1500.0f;
            flexADFData.mPath.glyphMinY = -0.0f;
            flexADFData.mPath.glyphMaxX = 10660.0f;
            flexADFData.mPath.glyphMaxY = 14660.0f;
            flexADFData.mPath.numContours = 1;
            flexADFData.mPath.numPenCmds = 7L;
        }
        if (c == 'l') {
            flexADFData.mPath.fontUnitsPerEM = 20480.0f;
            flexADFData.mPath.charCode = (char)108;
            aDFPenCmd15 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd15.opCode = 0L;
            aDFPenCmd15.x = 1310.0f;
            aDFPenCmd15.y = 0.0f;
            aDFPenCmd14 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd14.opCode = 1L;
            aDFPenCmd14.x = 1310.0f;
            aDFPenCmd14.y = 14660.0f;
            aDFPenCmd13 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd13.opCode = 1L;
            aDFPenCmd13.x = 3110.0f;
            aDFPenCmd13.y = 14660.0f;
            aDFPenCmd12 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd12.opCode = 1L;
            aDFPenCmd12.x = 3110.0f;
            aDFPenCmd12.y = 0.0f;
            aDFPenCmd11 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd11.opCode = 1L;
            aDFPenCmd11.x = 1310.0f;
            aDFPenCmd11.y = 0.0f;
            flexADFData.mPath.penCmds = new ArrayList(5);
            flexADFData.mPath.penCmds.add(0, aDFPenCmd15);
            flexADFData.mPath.penCmds.add(1, aDFPenCmd14);
            flexADFData.mPath.penCmds.add(2, aDFPenCmd13);
            flexADFData.mPath.penCmds.add(3, aDFPenCmd12);
            flexADFData.mPath.penCmds.add(4, aDFPenCmd11);
            flexADFData.mPath.glyphMinX = 1310.0f;
            flexADFData.mPath.glyphMinY = -0.0f;
            flexADFData.mPath.glyphMaxX = 3110.0f;
            flexADFData.mPath.glyphMaxY = 14660.0f;
            flexADFData.mPath.numContours = 1;
            flexADFData.mPath.numPenCmds = 5L;
        }
        if (c == 'H') {
            flexADFData.mPath.fontUnitsPerEM = 20480.0f;
            flexADFData.mPath.charCode = (char)72;
            aDFPenCmd15 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd15.opCode = 0L;
            aDFPenCmd15.x = 1640.0f;
            aDFPenCmd15.y = 0.0f;
            aDFPenCmd14 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd14.opCode = 1L;
            aDFPenCmd14.x = 1640.0f;
            aDFPenCmd14.y = 14660.0f;
            aDFPenCmd13 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd13.opCode = 1L;
            aDFPenCmd13.x = 3580.0f;
            aDFPenCmd13.y = 14660.0f;
            aDFPenCmd12 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd12.opCode = 1L;
            aDFPenCmd12.x = 3580.0f;
            aDFPenCmd12.y = 8640.0f;
            aDFPenCmd11 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd11.opCode = 1L;
            aDFPenCmd11.x = 11200.0f;
            aDFPenCmd11.y = 8640.0f;
            aDFPenCmd10 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd10.opCode = 1L;
            aDFPenCmd10.x = 11200.0f;
            aDFPenCmd10.y = 14660.0f;
            aDFPenCmd9 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd9.opCode = 1L;
            aDFPenCmd9.x = 13140.0f;
            aDFPenCmd9.y = 14660.0f;
            aDFPenCmd8 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd8.opCode = 1L;
            aDFPenCmd8.x = 13140.0f;
            aDFPenCmd8.y = 0.0f;
            aDFPenCmd7 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd7.opCode = 1L;
            aDFPenCmd7.x = 11200.0f;
            aDFPenCmd7.y = 0.0f;
            aDFPenCmd6 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd6.opCode = 1L;
            aDFPenCmd6.x = 11200.0f;
            aDFPenCmd6.y = 6910.0f;
            aDFPenCmd5 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd5.opCode = 1L;
            aDFPenCmd5.x = 3580.0f;
            aDFPenCmd5.y = 6910.0f;
            aDFPenCmd4 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd4.opCode = 1L;
            aDFPenCmd4.x = 3580.0f;
            aDFPenCmd4.y = 0.0f;
            aDFPenCmd3 = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd3.opCode = 1L;
            aDFPenCmd3.x = 1640.0f;
            aDFPenCmd3.y = 0.0f;
            flexADFData.mPath.penCmds = new ArrayList(13);
            flexADFData.mPath.penCmds.add(0, aDFPenCmd15);
            flexADFData.mPath.penCmds.add(1, aDFPenCmd14);
            flexADFData.mPath.penCmds.add(2, aDFPenCmd13);
            flexADFData.mPath.penCmds.add(3, aDFPenCmd12);
            flexADFData.mPath.penCmds.add(4, aDFPenCmd11);
            flexADFData.mPath.penCmds.add(5, aDFPenCmd10);
            flexADFData.mPath.penCmds.add(6, aDFPenCmd9);
            flexADFData.mPath.penCmds.add(7, aDFPenCmd8);
            flexADFData.mPath.penCmds.add(8, aDFPenCmd7);
            flexADFData.mPath.penCmds.add(9, aDFPenCmd6);
            flexADFData.mPath.penCmds.add(10, aDFPenCmd5);
            flexADFData.mPath.penCmds.add(11, aDFPenCmd4);
            flexADFData.mPath.penCmds.add(12, aDFPenCmd3);
            flexADFData.mPath.glyphMinX = 1640.0f;
            flexADFData.mPath.glyphMinY = -0.0f;
            flexADFData.mPath.glyphMaxX = 13140.0f;
            flexADFData.mPath.glyphMaxY = 14660.0f;
            flexADFData.mPath.numContours = 1;
            flexADFData.mPath.numPenCmds = 13L;
        }
        return flexADFData.mPath;
    }
}

