/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts.flashtype;

import flash.fonts.flashtype.ADFAlgnZones;
import flash.fonts.flashtype.ADFTypeSystem;
import flash.fonts.flashtype.FlexADFData;
import flash.swf.builder.types.ZoneRecordBuilder;
import flash.swf.tags.ZoneRecord;
import flash.swf.types.CurvedEdgeRecord;
import flash.swf.types.GlyphEntry;
import flash.swf.types.ShapeRecord;
import flash.swf.types.StraightEdgeRecord;
import flash.swf.types.StyleChangeRecord;
import flash.util.Trace;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class FlashTypeZoneRecordBuilder
extends ZoneRecordBuilder {
    private static final String ZONE_STATE = "ZONESTATE";

    public ZoneRecord build(int n) {
        ADFAlgnZones.AlgnZoneState algnZoneState = (ADFAlgnZones.AlgnZoneState)this.fontFace.getProperty(ZONE_STATE);
        if (algnZoneState == null) {
            algnZoneState = this.initializeAlignZoneState(this.fontFace.getFamily());
            this.fontFace.setProperty(ZONE_STATE, algnZoneState);
        }
        return this.createZoneRecord(algnZoneState, (char)n);
    }

    public ZoneRecord createZoneRecord(ADFAlgnZones.AlgnZoneState algnZoneState, char c) {
        ZoneRecord zoneRecord = new ZoneRecord();
        if (c == ' ') {
            zoneRecord.numZoneData = 2;
            zoneRecord.zoneData = new long[]{0L, 0L};
            zoneRecord.zoneMask = 0;
        } else {
            FlexADFData flexADFData = new FlexADFData();
            ADFTypeSystem.ADFPath aDFPath = this.getFontOutline(null, flexADFData, c);
            try {
                ADFAlgnZones.ADFDetectAlgnZones(null, algnZoneState, aDFPath);
            }
            catch (Exception exception) {
                if (Trace.error) {
                    exception.printStackTrace();
                }
                throw new RuntimeException("Could not create ZoneTable for character " + c + " in font " + this.fontAlias);
            }
            if (aDFPath.algnZones == null) {
                zoneRecord.numZoneData = 2;
                zoneRecord.zoneData = new long[]{0L, 0L};
                zoneRecord.zoneMask = 0;
            } else {
                zoneRecord.numZoneData = aDFPath.algnZones.length;
                zoneRecord.zoneData = aDFPath.algnZones;
                zoneRecord.zoneMask = aDFPath.algnZonesMask;
            }
        }
        return zoneRecord;
    }

    public ADFTypeSystem.ADFPath getFontOutline(Object object, Object object2, char c) {
        FlexADFData flexADFData = (FlexADFData)object2;
        GlyphEntry glyphEntry = this.fontBuilder.getGlyph(c);
        if (glyphEntry == null) {
            glyphEntry = this.fontFace.getGlyphEntry(c);
        }
        assert (glyphEntry != null) : "Glyph entry " + c + " not found as expected in map.";
        flexADFData.mPath.fontUnitsPerEM = 20480.0f;
        flexADFData.mPath.charCode = c;
        float f = 10000.0f;
        float f2 = 10000.0f;
        float f3 = -10000.0f;
        float f4 = -10000.0f;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        flexADFData.mPath.penCmds = new ArrayList(glyphEntry.shape.shapeRecords.size() * 2);
        for (ShapeRecord shapeRecord : glyphEntry.shape.shapeRecords) {
            ShapeRecord shapeRecord2;
            if (shapeRecord == null) continue;
            if (shapeRecord instanceof StyleChangeRecord) {
                ADFTypeSystem.ADFPenCmd aDFPenCmd;
                shapeRecord2 = (StyleChangeRecord)shapeRecord;
                if (bl && n3 != n5 && n4 != n6) {
                    aDFPenCmd = new ADFTypeSystem.ADFPenCmd();
                    aDFPenCmd.opCode = 1L;
                    aDFPenCmd.x = n5;
                    aDFPenCmd.y = n6 * -1;
                    flexADFData.mPath.penCmds.add(aDFPenCmd);
                    ++n2;
                }
                n3 = shapeRecord2.moveDeltaX;
                n4 = shapeRecord2.moveDeltaY;
                bl = true;
                n5 = n3;
                n6 = n4;
                aDFPenCmd = new ADFTypeSystem.ADFPenCmd();
                aDFPenCmd.opCode = 0L;
                aDFPenCmd.x = n3;
                aDFPenCmd.y = n4 * -1;
                flexADFData.mPath.penCmds.add(aDFPenCmd);
                ++n;
                ++n2;
            } else if (shapeRecord instanceof StraightEdgeRecord) {
                shapeRecord2 = (StraightEdgeRecord)shapeRecord;
                ADFTypeSystem.ADFPenCmd aDFPenCmd = new ADFTypeSystem.ADFPenCmd();
                aDFPenCmd.opCode = 1L;
                aDFPenCmd.x = n3 += ((StraightEdgeRecord)shapeRecord2).deltaX;
                aDFPenCmd.y = (n4 += ((StraightEdgeRecord)shapeRecord2).deltaY) * -1;
                flexADFData.mPath.penCmds.add(aDFPenCmd);
                ++n2;
            } else if (shapeRecord instanceof CurvedEdgeRecord) {
                shapeRecord2 = (CurvedEdgeRecord)shapeRecord;
                int n7 = n3 + ((CurvedEdgeRecord)shapeRecord2).controlDeltaX;
                int n8 = n4 + ((CurvedEdgeRecord)shapeRecord2).controlDeltaY;
                n3 = n7 + ((CurvedEdgeRecord)shapeRecord2).anchorDeltaX;
                n4 = n8 + ((CurvedEdgeRecord)shapeRecord2).anchorDeltaY;
                ADFTypeSystem.ADFPenCmd aDFPenCmd = new ADFTypeSystem.ADFPenCmd();
                aDFPenCmd.opCode = 2L;
                aDFPenCmd.x = n3;
                aDFPenCmd.y = n4 * -1;
                aDFPenCmd.cx = n7;
                aDFPenCmd.cy = n8 * -1;
                flexADFData.mPath.penCmds.add(aDFPenCmd);
                ++n2;
                if ((float)n7 < f) {
                    f = n7;
                }
                if ((float)n7 > f3) {
                    f3 = n7;
                }
                if ((float)n8 < f2) {
                    f2 = n8;
                }
                if ((float)n8 > f4) {
                    f4 = n8;
                }
            } else assert (false) : "Unknown ShapeRecord: " + shapeRecord.getClass();
            if ((float)n3 < f) {
                f = n3;
            }
            if ((float)n3 > f3) {
                f3 = n3;
            }
            if ((float)n4 < f2) {
                f2 = n4;
            }
            if (!((float)n4 > f4)) continue;
            f4 = n4;
        }
        if (bl && n3 != n5 && n4 != n6) {
            ADFTypeSystem.ADFPenCmd aDFPenCmd = new ADFTypeSystem.ADFPenCmd();
            aDFPenCmd.opCode = 1L;
            aDFPenCmd.x = n5;
            aDFPenCmd.y = n6 * -1;
            flexADFData.mPath.penCmds.add(aDFPenCmd);
            ++n2;
        }
        flexADFData.mPath.glyphMinX = f;
        flexADFData.mPath.glyphMinY = f4 * -1.0f;
        flexADFData.mPath.glyphMaxX = f3;
        flexADFData.mPath.glyphMaxY = f2 * -1.0f;
        flexADFData.mPath.numContours = n;
        flexADFData.mPath.numPenCmds = n2;
        return flexADFData.mPath;
    }

    private ADFAlgnZones.AlgnZoneState initializeAlignZoneState(String string) {
        ADFAlgnZones.AlgnZoneState algnZoneState;
        long l = 0L;
        if (Trace.font) {
            l = System.currentTimeMillis();
        }
        Method method = null;
        Method[] methodArray = this.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals("getFontOutline")) continue;
            method = methodArray[i];
            break;
        }
        try {
            algnZoneState = (ADFAlgnZones.AlgnZoneState)ADFAlgnZones.ADFInitAlgnZoneDetection(null, new FlexADFData(), null, method, this);
        }
        catch (Exception exception) {
            if (Trace.error) {
                exception.printStackTrace();
            }
            throw new RuntimeException("Could not initialize FlashType for font " + string);
        }
        if (Trace.font) {
            Trace.trace("FlashType initialization: " + (System.currentTimeMillis() - l) + "ms");
        }
        return algnZoneState;
    }
}

