/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml;

import flex2.compiler.as3.AbstractSyntaxTreeUtil;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.rep.Script;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.HashSet;
import java.util.List;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.util.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenerator {
    protected static final String BINDABLE = "Bindable".intern();
    protected static final String MX_INTERNAL = StandardDefs.NAMESPACE_MX_INTERNAL_LOCALNAME;
    protected final StandardDefs standardDefs;
    protected Context context;
    protected NodeFactory nodeFactory;
    protected HashSet<String> configNamespaces;
    protected ProgramNode programNode;
    protected boolean generateDocComments;

    protected AbstractGenerator(StandardDefs defs) {
        this.standardDefs = defs;
    }

    protected StatementListNode generateMetaData(StatementListNode programStatementList, List<Script> scripts) {
        StatementListNode result = programStatementList;
        for (Script script : scripts) {
            String text = script.getText();
            int xmlLineNumber = script.getXmlLineNumber();
            List<Node> list = AbstractSyntaxTreeUtil.parse(this.context, this.configNamespaces, text, xmlLineNumber, this.generateDocComments);
            for (Node node : list) {
                if (node instanceof MetaDataNode) {
                    result = this.nodeFactory.statementList(result, node);
                    continue;
                }
                NodeMagic.OnlyMetadataIsAllowed m = new NodeMagic.OnlyMetadataIsAllowed();
                m.setPath(this.getPath());
                m.setLine(this.context.input.getLnNum(node.pos()) + script.getXmlLineNumber() - 1);
                ThreadLocalToolkit.log(m);
            }
        }
        return result;
    }

    protected AttributeListNode generateMxInternalAttribute() {
        MemberExpressionNode mxInternalGetterSelector = AbstractSyntaxTreeUtil.generateResolvedGetterSelector(this.nodeFactory, this.standardDefs.getCorePackage(), MX_INTERNAL);
        ListNode list = this.nodeFactory.list(null, mxInternalGetterSelector);
        return this.nodeFactory.attributeList(list, null);
    }

    protected StatementListNode generateScripts(StatementListNode statementList, List<Script> scripts) {
        StatementListNode result = statementList;
        for (Script script : scripts) {
            String text = script.getText();
            int xmlLineNumber = script.getXmlLineNumber();
            List<Node> list = AbstractSyntaxTreeUtil.parse(this.context, this.configNamespaces, text, xmlLineNumber, this.generateDocComments);
            result.items.addAll(list);
        }
        return result;
    }

    Context getContext() {
        return this.context;
    }

    abstract String getPath();

    public Object getSyntaxTree() {
        return this.programNode;
    }
}

