/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml;

import flex2.compiler.Source;
import flex2.compiler.as3.AbstractSyntaxTreeUtil;
import flex2.compiler.as3.As3Compiler;
import flex2.compiler.as3.BytecodeEmitter;
import flex2.compiler.mxml.AbstractGenerator;
import flex2.compiler.mxml.lang.FrameworkDefs;
import flex2.compiler.mxml.rep.DocumentInfo;
import flex2.compiler.mxml.rep.VariableDeclaration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import macromedia.asc.embedding.ConfigVar;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceGenerator
extends AbstractGenerator {
    private DocumentInfo docInfo;

    public InterfaceGenerator(DocumentInfo docInfo, Set<String> bogusImports, ContextStatics contextStatics, Source source, BytecodeEmitter bytecodeEmitter, ObjectList<ConfigVar> defines) {
        super(docInfo.getStandardDefs());
        this.docInfo = docInfo;
        this.context = AbstractSyntaxTreeUtil.generateContext(contextStatics, source, bytecodeEmitter, defines);
        this.nodeFactory = this.context.getNodeFactory();
        this.configNamespaces = new HashSet();
        StatementListNode configVars = AbstractSyntaxTreeUtil.parseConfigVars(this.context, this.configNamespaces);
        this.programNode = AbstractSyntaxTreeUtil.generateProgram(this.context, configVars, docInfo.getPackageName());
        StatementListNode programStatementList = this.programNode.statements;
        programStatementList = this.generateImports(programStatementList, bogusImports);
        programStatementList = this.generateMetaData(programStatementList, docInfo.getMetadata());
        ClassDefinitionNode classDefinition = this.generateClassDefinition();
        this.programNode.statements = programStatementList = this.nodeFactory.statementList(programStatementList, classDefinition);
        PackageDefinitionNode packageDefinition = this.nodeFactory.finishPackage(this.context, null);
        this.nodeFactory.statementList(programStatementList, packageDefinition);
        As3Compiler.cleanNodeFactory(this.nodeFactory);
    }

    private Set<String> createInterfaceNames() {
        TreeSet<String> result = new TreeSet<String>();
        for (DocumentInfo.NameInfo interfaceName : this.docInfo.getInterfaceNames()) {
            result.add(interfaceName.getName());
        }
        return result;
    }

    private StatementListNode generateBindingManagementVars(StatementListNode statementList) {
        StatementListNode result = statementList;
        Iterator<VariableDeclaration> iterator = FrameworkDefs.bindingManagementVars.iterator();
        int kind = -112;
        while (iterator.hasNext()) {
            VariableDeclaration variableDeclaration = iterator.next();
            QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generateMxInternalQualifiedIdentifier(this.nodeFactory, variableDeclaration.getName(), false);
            VariableDefinitionNode variableDefinition = AbstractSyntaxTreeUtil.generateVariable(this.nodeFactory, this.generateMxInternalAttribute(), qualifiedIdentifier, variableDeclaration.getType(), false, null);
            result = this.nodeFactory.statementList(result, variableDefinition);
        }
        return result;
    }

    private ClassDefinitionNode generateClassDefinition() {
        StatementListNode statementList = null;
        String className = this.docInfo.getClassName();
        FunctionDefinitionNode constructor = AbstractSyntaxTreeUtil.generateConstructor(this.context, className, null, false, null, -1);
        statementList = this.nodeFactory.statementList(statementList, constructor);
        statementList = this.generateInstanceVariables(statementList);
        statementList = this.generateBindingManagementVars(statementList);
        statementList = this.generateScripts(statementList, this.docInfo.getScripts());
        return AbstractSyntaxTreeUtil.generateClassDefinition(this.context, className, this.docInfo.getQualifiedSuperClassName(), this.createInterfaceNames(), statementList);
    }

    private StatementListNode generateImports(StatementListNode statementList, Set<String> bogusImports) {
        StatementListNode result = statementList;
        for (String[] splitImport : this.docInfo.getSplitImportNames()) {
            ImportDirectiveNode importDirective = AbstractSyntaxTreeUtil.generateImport(this.context, splitImport);
            result = this.nodeFactory.statementList(result, importDirective);
        }
        Iterator<DocumentInfo.NameInfo> nameInfoIterator = this.docInfo.getImportNames().iterator();
        while (nameInfoIterator.hasNext()) {
            String name = nameInfoIterator.next().getName();
            ImportDirectiveNode importDirective = AbstractSyntaxTreeUtil.generateImport(this.context, name);
            result = this.nodeFactory.statementList(result, importDirective);
        }
        for (String name : bogusImports) {
            ImportDirectiveNode importDirective = AbstractSyntaxTreeUtil.generateImport(this.context, name);
            result = this.nodeFactory.statementList(result, importDirective);
        }
        return result;
    }

    private StatementListNode generateInstanceVariables(StatementListNode statementList) {
        StatementListNode result = statementList;
        Iterator<DocumentInfo.VarDecl> iterator = this.docInfo.getVarDecls().values().iterator();
        while (iterator.hasNext()) {
            MetaDataNode bindableMetaData = AbstractSyntaxTreeUtil.generateMetaData(this.nodeFactory, BINDABLE);
            result = this.nodeFactory.statementList(result, bindableMetaData);
            DocumentInfo.VarDecl varDecl = iterator.next();
            int position = AbstractSyntaxTreeUtil.lineNumberToPosition(this.nodeFactory, varDecl.line);
            TypeExpressionNode typeExpression = AbstractSyntaxTreeUtil.generateTypeExpression(this.nodeFactory, varDecl.className, true, position);
            VariableDefinitionNode variableDefinition = AbstractSyntaxTreeUtil.generatePublicVariable(this.context, typeExpression, varDecl.name);
            result = this.nodeFactory.statementList(result, variableDefinition);
        }
        return result;
    }

    @Override
    String getPath() {
        return this.docInfo.getPath();
    }
}

