/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.gen;

import flex2.compiler.as3.AbstractSyntaxTreeUtil;
import flex2.compiler.mxml.gen.CodeFragmentList;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.rep.StatesModel;
import flex2.compiler.mxml.rep.init.EventInitializer;
import flex2.compiler.mxml.rep.init.Initializer;
import flex2.compiler.util.NameFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.VariableDefinitionNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatesGenerator {
    public static final String INDENT = "  ".intern();
    private List<StatesModel.Override> bindingsQueue;
    private final StandardDefs standardDefs;
    private static final String _C = "_c".intern();
    private static final String _I = "_i".intern();
    private static final String _FACTORY = "_factory".intern();
    private static final String _R = "_r".intern();
    private static final String ADDEVENTLISTENER = "addEventListener".intern();
    private static final String BINDINGMANAGER = "BindingManager".intern();
    private static final String DEFERREDINSTANCEFROMFUNCTION = "DeferredInstanceFromFunction".intern();
    private static final String EXECUTEBINDINGS = "executeBindings".intern();
    private static final String GETINSTANCE = "getInstance".intern();
    private static final String STATES = "states".intern();

    public StatesGenerator(StandardDefs defs) {
        this.standardDefs = defs;
        this.bindingsQueue = new ArrayList<StatesModel.Override>();
    }

    public CodeFragmentList getStatesInitializerFragments(StatesModel model) {
        CodeFragmentList list = new CodeFragmentList();
        String indent = "\t\t";
        this.genSharedFactories(model, list, indent);
        list.add("\n", 0);
        this.genStates(model, list, indent);
        list.add("\n", 0);
        this.genBindingInitializers(list, indent);
        list.add("\n", 0);
        this.genStateInitializers(model, list, indent);
        list.add("\n", 0);
        this.genImmediateInits(model, list, indent);
        return list;
    }

    public StatementListNode getStatesASTInitializers(StatesModel model, NodeFactory nodeFactory, HashSet<String> configNamespaces, boolean generateDocComments, StatementListNode statementList) {
        StatementListNode results = statementList;
        results = this.genSharedFactoriesAST(model, nodeFactory, statementList);
        results = this.genStatesAST(model, nodeFactory, configNamespaces, generateDocComments, results);
        results = this.genBindingInitializersAST(nodeFactory, results);
        results = this.genStateInitializersAST(model, nodeFactory, configNamespaces, generateDocComments, results);
        results = this.genImmediateInitsAST(model, nodeFactory, results);
        return results;
    }

    private void genSharedFactories(StatesModel model, CodeFragmentList list, String indent) {
        Map<String, StatesModel.SharedObject> shared = model.sharedObjects;
        Iterator<String> iter = shared.keySet().iterator();
        while (iter.hasNext()) {
            StatesModel.SharedObject symbol = shared.get(iter.next());
            String lval = indent + "var " + symbol.name + "_factory:" + NameFormatter.retrieveClassName(this.standardDefs.CLASS_DEFERREDINSTANCEFROMFUNCTION) + " = \n";
            indent = indent + INDENT;
            String suffix = symbol.model.isDeclared() ? "_i" : "_c";
            Boolean isTransient = symbol.model.getIsTransient();
            String rval = indent + "new " + NameFormatter.toDot(this.standardDefs.CLASS_DEFERREDINSTANCEFROMFUNCTION) + "(" + symbol.name + suffix + (isTransient != false ? ", " + symbol.name + "_r" : "") + ");";
            indent = indent.substring(0, indent.length() - INDENT.length());
            list.add(lval, rval, 0);
        }
    }

    private StatementListNode genSharedFactoriesAST(StatesModel model, NodeFactory nodeFactory, StatementListNode statementList) {
        Map<String, StatesModel.SharedObject> shared = model.sharedObjects;
        StatementListNode result = statementList;
        Iterator<String> iter = shared.keySet().iterator();
        while (iter.hasNext()) {
            StatesModel.SharedObject symbol = shared.get(iter.next());
            String varName = (symbol.name + _FACTORY).intern();
            String typeName = NameFormatter.retrieveClassName(DEFERREDINSTANCEFROMFUNCTION);
            String factory = symbol.name + (symbol.model.isDeclared() ? _I : _C);
            String resetFunc = symbol.name + _R;
            MemberExpressionNode memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, factory, true);
            ArgumentListNode callExpressionArgumentList = nodeFactory.argumentList(null, memberExpression);
            if (symbol.model.getIsTransient()) {
                memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, resetFunc, true);
                callExpressionArgumentList = nodeFactory.argumentList(callExpressionArgumentList, memberExpression);
            }
            QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, this.standardDefs.getCorePackage(), typeName, false);
            CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression(qualifiedIdentifier, callExpressionArgumentList);
            callExpression.is_new = true;
            callExpression.setRValue(false);
            MemberExpressionNode ad = nodeFactory.memberExpression(null, callExpression);
            VariableDefinitionNode variableDefinition = AbstractSyntaxTreeUtil.generateVariable(nodeFactory, varName, typeName, false, ad);
            result = nodeFactory.statementList(result, variableDefinition);
        }
        return result;
    }

    private void genBindingInitializers(CodeFragmentList list, String indent) {
        for (StatesModel.Override symbol : this.bindingsQueue) {
            list.add(indent, NameFormatter.toDot(this.standardDefs.CLASS_BINDINGMANAGER), ".executeBindings(this, \"" + symbol.declaration + "\", " + symbol.declaration + ");", 0);
        }
    }

    private StatementListNode genBindingInitializersAST(NodeFactory nodeFactory, StatementListNode statementList) {
        StatementListNode result = statementList;
        for (StatesModel.Override symbol : this.bindingsQueue) {
            QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, this.standardDefs.getBindingPackage(), BINDINGMANAGER, false);
            GetExpressionNode bindExpression = nodeFactory.getExpression(qualifiedIdentifier);
            MemberExpressionNode lvalue = nodeFactory.memberExpression(null, bindExpression);
            ArgumentListNode execArgs = nodeFactory.argumentList(null, nodeFactory.thisExpression(0));
            String decl = symbol.declaration.intern();
            execArgs = nodeFactory.argumentList(execArgs, nodeFactory.literalString(decl, false));
            IdentifierNode rvalIdentifier = nodeFactory.identifier(decl, false);
            GetExpressionNode getExpression = nodeFactory.getExpression(rvalIdentifier);
            MemberExpressionNode rvalue = nodeFactory.memberExpression(null, getExpression);
            execArgs = nodeFactory.argumentList(execArgs, rvalue);
            IdentifierNode bindIdentifier = nodeFactory.identifier(EXECUTEBINDINGS, false);
            CallExpressionNode selector = (CallExpressionNode)nodeFactory.callExpression(bindIdentifier, execArgs);
            selector.setRValue(false);
            MemberExpressionNode base = nodeFactory.memberExpression(lvalue, selector);
            ListNode list = nodeFactory.list(null, base);
            ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement(list);
            result = nodeFactory.statementList(result, expressionStatement);
        }
        return result;
    }

    private void genImmediateInits(StatesModel model, CodeFragmentList list, String indent) {
        List<String> objects = model.earlyInitObjects;
        for (String symbol : objects) {
            String lval = indent + symbol + "_factory.getInstance();\n";
            indent = indent + INDENT;
            list.add(lval, 0);
        }
    }

    private StatementListNode genImmediateInitsAST(StatesModel model, NodeFactory nodeFactory, StatementListNode statementList) {
        StatementListNode result = statementList;
        List<String> objects = model.earlyInitObjects;
        for (String symbol : objects) {
            String identifier = (symbol + "_factory").intern();
            IdentifierNode idNode = nodeFactory.identifier(identifier, false);
            GetExpressionNode getIndexExpression = nodeFactory.getExpression(idNode);
            MemberExpressionNode base = nodeFactory.memberExpression(null, getIndexExpression);
            IdentifierNode getNode = nodeFactory.identifier(GETINSTANCE, false);
            CallExpressionNode selector = (CallExpressionNode)nodeFactory.callExpression(getNode, null);
            selector.setRValue(false);
            MemberExpressionNode memberExpression = nodeFactory.memberExpression(base, selector);
            ListNode list = nodeFactory.list(null, memberExpression);
            ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement(list);
            result = nodeFactory.statementList(result, expressionStatement);
        }
        return result;
    }

    private void genStates(StatesModel model, CodeFragmentList list, String indent) {
        Set<String> states = model.info.getStateNames();
        if (!states.isEmpty()) {
            list.add(indent, "states = [", 0);
            indent = indent + INDENT;
            Iterator<String> iter = states.iterator();
            while (iter.hasNext()) {
                StatesModel.State state = model.stateByName(iter.next());
                if (state == null) continue;
                state.getDefinitionBody(list, indent, this.bindingsQueue);
                if (!iter.hasNext()) continue;
                list.add(indent, ",", 0);
            }
            indent = indent.substring(0, indent.length() - INDENT.length());
            list.add(indent, "];", 0);
        }
    }

    private StatementListNode genStatesAST(StatesModel model, NodeFactory nodeFactory, HashSet<String> configNamespaces, boolean generateDocComments, StatementListNode statementList) {
        StatementListNode result = statementList;
        Set<String> states = model.info.getStateNames();
        if (!states.isEmpty()) {
            ArgumentListNode statesArgumentList = null;
            Iterator<String> iter = states.iterator();
            while (iter.hasNext()) {
                StatesModel.State state = model.stateByName(iter.next());
                if (state == null) continue;
                MemberExpressionNode stateExpression = state.generateDefinitionBody(nodeFactory, configNamespaces, generateDocComments, this.bindingsQueue);
                statesArgumentList = nodeFactory.argumentList(statesArgumentList, stateExpression);
            }
            LiteralArrayNode literalArray = nodeFactory.literalArray(statesArgumentList);
            ArgumentListNode argList = nodeFactory.argumentList(null, literalArray);
            IdentifierNode statesIdentifier = nodeFactory.identifier(STATES, false);
            SetExpressionNode selector = nodeFactory.setExpression(statesIdentifier, argList, false);
            MemberExpressionNode memberExpression = nodeFactory.memberExpression(null, selector);
            ListNode list = nodeFactory.list(null, memberExpression);
            ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement(list);
            result = nodeFactory.statementList(result, expressionStatement);
        }
        return result;
    }

    private void genStateInitializers(StatesModel model, CodeFragmentList list, String indent) {
        Set<String> states = model.info.getStateNames();
        int count = 0;
        Iterator<String> iter = states.iterator();
        while (iter.hasNext()) {
            StatesModel.State state = model.stateByName(iter.next());
            if (state != null) {
                if (state.isDeclared()) {
                    list.add(indent, state.getId() + "= states[" + count + "];", 0);
                }
                Iterator<Initializer> initializers = state.getEvents();
                while (initializers.hasNext()) {
                    EventInitializer ei = (EventInitializer)initializers.next();
                    list.add(indent, "states[" + count + "].addEventListener(\"" + ei.getName() + "\", " + ei.getValueExpr() + " );", 0);
                }
            }
            ++count;
        }
    }

    private StatementListNode genStateInitializersAST(StatesModel model, NodeFactory nodeFactory, HashSet<String> configNamespaces, boolean generateDocComments, StatementListNode statementList) {
        StatementListNode result = statementList;
        Set<String> states = model.info.getStateNames();
        int count = 0;
        Iterator<String> iter = states.iterator();
        while (iter.hasNext()) {
            StatesModel.State state = model.stateByName(iter.next());
            if (state != null) {
                String identifier = state.getId().intern();
                IdentifierNode stateIdentifier = nodeFactory.identifier(identifier, false);
                IdentifierNode statesIdentifier = nodeFactory.identifier(STATES, false);
                LiteralNumberNode numberNode = nodeFactory.literalNumber(count);
                ArgumentListNode getIndexArgList = nodeFactory.argumentList(null, numberNode);
                GetExpressionNode getIndexExpression = nodeFactory.getExpression(getIndexArgList);
                getIndexExpression.setMode(-29);
                GetExpressionNode getStatesExpression = nodeFactory.getExpression(statesIdentifier);
                MemberExpressionNode base = nodeFactory.memberExpression(null, getStatesExpression);
                MemberExpressionNode getExpr = nodeFactory.memberExpression(base, getIndexExpression);
                if (state.isDeclared()) {
                    ArgumentListNode argList = nodeFactory.argumentList(null, getExpr);
                    SetExpressionNode selector = nodeFactory.setExpression(stateIdentifier, argList, false);
                    MemberExpressionNode outer = nodeFactory.memberExpression(null, selector);
                    ListNode list = nodeFactory.list(null, outer);
                    ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement(list);
                    result = nodeFactory.statementList(result, expressionStatement);
                }
                Iterator<Initializer> initializers = state.getEvents();
                while (initializers.hasNext()) {
                    EventInitializer ei = (EventInitializer)initializers.next();
                    IdentifierNode addEventIdentifier = nodeFactory.identifier(ADDEVENTLISTENER, false);
                    LiteralStringNode eventName = nodeFactory.literalString(ei.getName());
                    Node valueNode = ei.generateValueExpr(nodeFactory, configNamespaces, generateDocComments);
                    ArgumentListNode addEventArgs = nodeFactory.argumentList(null, eventName);
                    addEventArgs = nodeFactory.argumentList(addEventArgs, valueNode);
                    CallExpressionNode addListener = (CallExpressionNode)nodeFactory.callExpression(addEventIdentifier, addEventArgs);
                    addListener.setRValue(false);
                    MemberExpressionNode outer = nodeFactory.memberExpression(getExpr, addListener);
                    ListNode list = nodeFactory.list(null, outer);
                    ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement(list);
                    result = nodeFactory.statementList(result, expressionStatement);
                }
            }
            ++count;
        }
        return result;
    }
}

