/*
 * Decompiled with CFR 0.152.
 */
package adobe.asc.authoring.flexInfo;

import adobe.asc.authoring.flexInfo.FlexInfo;
import adobe.asc.authoring.flexInfo.MetadataWarningInfo;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FlexInfoParser {
    protected static final String NS = "http://www.adobe.com/flash/flexinfo/1.0";
    protected static final String ROOT = "flex-info";
    protected static final String METADATA_INFO_LIST = "metadata-info-list";
    protected static final String METADATA_INFO = "metadata-info";
    protected static final String NEED_SDK_WARNING = "need-sdk-warning";
    protected static final String REQUIRED_DEFINITION = "required-definition";
    protected static final String HOIST_FROM_FRAME_SCRIPT = "hoist-from-frame-script";
    protected static final String NAME = "name";
    protected static final String LEVEL = "level";
    protected static final String VARIABLE = "variable";
    protected static final String CLASS = "class";
    protected static final String METHOD = "method";
    protected static final String ALL = "all";
    protected static final String FLEX_COMPONENT_BASE_CLASSES = "flex-component-base-classes";
    protected static final String FLEX_COMPONENT_BASE_CLASS = "flex-component-base-class";
    protected static final String FLEX_CONFIG = "flex-config";
    private final FlexInfo flexInfo;
    private static String[] ENTITY_REPLACE = new String[]{"&", "&amp;", "<", "&lt;", ">", "&gt;", "\"", "&quot;"};

    public FlexInfoParser(FlexInfo flexInfo) {
        this.flexInfo = flexInfo;
    }

    public void parse(String string) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse((InputStream)new FileInputStream(string), (DefaultHandler)new Handler(this, this.flexInfo));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected class FlexConfigTagHandler
    extends TagHandler {
        private StringBuffer flexConfigStr;

        FlexConfigTagHandler(FlexInfo flexInfo) {
            super(FlexInfoParser.this, FlexInfoParser.FLEX_CONFIG, false, flexInfo);
            this.flexConfigStr = new StringBuffer(1024);
            this.flexConfigStr.append('<');
            this.flexConfigStr.append(FlexInfoParser.FLEX_CONFIG);
            this.flexConfigStr.append('>');
        }

        public boolean startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            int n;
            super.startElement(string, string2, string3, attributes);
            this.flexConfigStr.append('<');
            this.flexConfigStr.append(string2);
            int n2 = n = attributes == null ? 0 : attributes.getLength();
            for (int i = 0; i < n; ++i) {
                this.flexConfigStr.append(' ');
                this.flexConfigStr.append(attributes.getLocalName(i));
                this.flexConfigStr.append("=\"");
                int n3 = this.flexConfigStr.length();
                this.flexConfigStr.append(attributes.getValue(i));
                this.xmlEncode(n3);
                this.flexConfigStr.append('\"');
            }
            this.flexConfigStr.append('>');
            return true;
        }

        public boolean endElement(String string, String string2, String string3) throws SAXException {
            this.flexConfigStr.append("</");
            this.flexConfigStr.append(string2);
            this.flexConfigStr.append('>');
            if (!super.endElement(string, string2, string3)) {
                this.flexInfo.setFlexConfigStr(this.flexConfigStr.toString());
                return false;
            }
            return true;
        }

        public void characters(char[] cArray, int n, int n2) {
            if (n2 > 0) {
                int n3 = this.flexConfigStr.length();
                this.flexConfigStr.append(cArray, n, n2);
                this.xmlEncode(n3);
            }
        }

        private void xmlEncode(int n) {
            for (int i = 0; i < ENTITY_REPLACE.length; i += 2) {
                String string = ENTITY_REPLACE[i];
                String string2 = ENTITY_REPLACE[i + 1];
                int n2 = n;
                while ((n2 = this.flexConfigStr.indexOf(string, n2)) >= 0) {
                    this.flexConfigStr.replace(n2, string.length(), string2);
                    ++n2;
                }
            }
        }
    }

    protected class FlexComponentBaseClassesHandler
    extends TagHandler {
        private boolean inFlexComponentBaseClassTag;

        FlexComponentBaseClassesHandler(FlexInfo flexInfo) {
            super(FlexInfoParser.this, FlexInfoParser.FLEX_COMPONENT_BASE_CLASSES, false, flexInfo);
            this.inFlexComponentBaseClassTag = false;
        }

        public boolean startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!super.startElement(string, string2, string3, attributes)) {
                if (string2.equals(FlexInfoParser.FLEX_COMPONENT_BASE_CLASS)) {
                    this.inFlexComponentBaseClassTag = true;
                } else {
                    System.err.println("FlexComponentBaseClassesHandler saw unhandled tag " + string2);
                }
            }
            return true;
        }

        public boolean endElement(String string, String string2, String string3) throws SAXException {
            if (string2.equals(FlexInfoParser.REQUIRED_DEFINITION)) {
                this.inFlexComponentBaseClassTag = false;
                return true;
            }
            return super.endElement(string, string2, string3);
        }

        public void characters(char[] cArray, int n, int n2) {
            if (this.inFlexComponentBaseClassTag) {
                this.flexInfo.addFlexComponentBaseClass(new String(cArray, n, n2));
            }
        }
    }

    protected class NeedSDKWarningHandler
    extends TagHandler {
        private final MetadataWarningInfo warnInfo;
        private boolean inReqDefTag;

        NeedSDKWarningHandler(FlexInfo flexInfo, MetadataWarningInfo metadataWarningInfo) {
            super(FlexInfoParser.this, FlexInfoParser.NEED_SDK_WARNING, false, flexInfo);
            this.warnInfo = metadataWarningInfo;
            this.inReqDefTag = false;
        }

        public boolean startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!super.startElement(string, string2, string3, attributes)) {
                if (string2.equals(FlexInfoParser.REQUIRED_DEFINITION)) {
                    this.inReqDefTag = true;
                } else {
                    System.err.println("NeedSDKWarningHandler saw unhandled tag " + string2);
                }
            }
            return true;
        }

        public boolean endElement(String string, String string2, String string3) throws SAXException {
            if (string2.equals(FlexInfoParser.REQUIRED_DEFINITION)) {
                this.inReqDefTag = false;
                return true;
            }
            return super.endElement(string, string2, string3);
        }

        public void characters(char[] cArray, int n, int n2) {
            if (this.inReqDefTag) {
                this.warnInfo.requiredDefinitions.add(new String(cArray, n, n2));
            }
        }
    }

    protected class MetadataInfoTagHandler
    extends TagHandler {
        private final String metadataName;

        MetadataInfoTagHandler(FlexInfo flexInfo, String string) {
            super(FlexInfoParser.this, FlexInfoParser.METADATA_INFO, false, flexInfo);
            this.metadataName = string;
        }

        public boolean startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!super.startElement(string, string2, string3, attributes)) {
                if (string2.equals(FlexInfoParser.NEED_SDK_WARNING)) {
                    this.myTagHandler = new NeedSDKWarningHandler(this.flexInfo, this.newMetadataWarningInfo(this.getAttribute(string2, FlexInfoParser.LEVEL, attributes)));
                } else if (string2.equals(FlexInfoParser.HOIST_FROM_FRAME_SCRIPT)) {
                    this.flexInfo.addHoistMetadata(this.metadataName);
                } else {
                    System.err.println("MetadataInfoTagHandler saw unhandled tag " + string2);
                }
            }
            return true;
        }

        private MetadataWarningInfo newMetadataWarningInfo(String string) {
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (((String)object).equals(FlexInfoParser.CLASS)) {
                    bl2 = true;
                    continue;
                }
                if (((String)object).equals(FlexInfoParser.METHOD)) {
                    bl3 = true;
                    continue;
                }
                if (((String)object).equals(FlexInfoParser.VARIABLE)) {
                    bl = true;
                    continue;
                }
                if (((String)object).equals(FlexInfoParser.ALL)) {
                    bl = true;
                    bl3 = true;
                    bl2 = true;
                    break;
                }
                System.err.println("Unrecognized token in level attribute of need-sdk-warning tag: " + (String)object);
            }
            object = new MetadataWarningInfo(this.metadataName, bl, bl3, bl2);
            this.flexInfo.getWarnMetadataList().add((MetadataWarningInfo)object);
            return object;
        }
    }

    protected class MetadataInfoListTagHandler
    extends TagHandler {
        MetadataInfoListTagHandler(FlexInfo flexInfo) {
            super(FlexInfoParser.this, FlexInfoParser.METADATA_INFO_LIST, false, flexInfo);
        }

        public boolean startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!super.startElement(string, string2, string3, attributes)) {
                if (string2.equals(FlexInfoParser.METADATA_INFO)) {
                    this.myTagHandler = new MetadataInfoTagHandler(this.flexInfo, this.getAttribute(string2, FlexInfoParser.NAME, attributes));
                } else {
                    System.err.println("MetadataInfoListTagHandler saw unhandled tag " + string2);
                }
            }
            return true;
        }
    }

    protected class TagHandler {
        protected TagHandler myTagHandler = null;
        protected final FlexInfo flexInfo;
        protected final String myTagName;
        protected final boolean allowNested;
        protected int nestCount;
        final /* synthetic */ FlexInfoParser this$0;

        /*
         * WARNING - void declaration
         */
        TagHandler(FlexInfoParser flexInfoParser, String string, boolean bl, FlexInfo flexInfo) {
            void arg3;
            void arg2;
            void arg1;
            void arg0;
            this.this$0 = arg0;
            this.myTagName = arg1;
            this.allowNested = arg2;
            this.flexInfo = arg3;
            this.nestCount = 0;
        }

        public boolean startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.myTagHandler == null) {
                if (!this.allowNested && string2.equals(this.myTagName)) {
                    ++this.nestCount;
                    return true;
                }
                return false;
            }
            this.myTagHandler.startElement(string, string2, string3, attributes);
            return true;
        }

        public boolean endElement(String string, String string2, String string3) throws SAXException {
            if (this.myTagHandler != null) {
                if (!this.myTagHandler.endElement(string, string2, string3)) {
                    this.myTagHandler = null;
                }
                return true;
            }
            if (string2.equals(this.myTagName)) {
                if (!this.allowNested && this.nestCount > 0) {
                    --this.nestCount;
                    return true;
                }
                return false;
            }
            return true;
        }

        public void characters(char[] cArray, int n, int n2) {
            if (this.myTagHandler != null) {
                this.myTagHandler.characters(cArray, n, n2);
            }
        }

        protected String getAttribute(String string, String string2, Attributes attributes) throws SAXException {
            String string3 = attributes.getValue(string2);
            if (string3 == null) {
                throw new SAXException("Tag " + string + " has no attribute " + string2);
            }
            return string3;
        }
    }

    protected class Handler
    extends DefaultHandler {
        private TagHandler myTagHandler;
        protected final FlexInfo flexInfo;
        final /* synthetic */ FlexInfoParser this$0;

        /*
         * WARNING - void declaration
         */
        public Handler(FlexInfoParser flexInfoParser, FlexInfo flexInfo) {
            void arg1;
            void arg0;
            this.this$0 = arg0;
            this.flexInfo = arg1;
            this.myTagHandler = null;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.myTagHandler != null) {
                this.myTagHandler.startElement(string, string2, string3, attributes);
            } else if (!string2.equals(FlexInfoParser.ROOT)) {
                if (string2.equals(FlexInfoParser.METADATA_INFO_LIST)) {
                    this.myTagHandler = this.this$0.new MetadataInfoListTagHandler(this.flexInfo);
                } else if (string2.equals(FlexInfoParser.FLEX_CONFIG)) {
                    this.myTagHandler = this.this$0.new FlexConfigTagHandler(this.flexInfo);
                } else if (string2.equals(FlexInfoParser.FLEX_COMPONENT_BASE_CLASSES)) {
                    this.myTagHandler = this.this$0.new FlexComponentBaseClassesHandler(this.flexInfo);
                } else {
                    System.err.println("Parsing flex info xml, saw unhandled tag " + string2);
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.myTagHandler != null && !this.myTagHandler.endElement(string, string2, string3)) {
                this.myTagHandler = null;
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            if (this.myTagHandler != null) {
                this.myTagHandler.characters(cArray, n, n2);
            }
        }

        public void error(SAXException sAXException) {
            System.err.println("Error parsing flex info xml:");
            sAXException.printStackTrace();
        }

        public void warning(SAXException sAXException) {
            System.err.println("Warning parsing flex info xml:");
            sAXException.printStackTrace();
        }
    }
}

