/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.util.FileUtils;
import flash.util.Trace;
import flex2.compiler.swc.AuthSwc;
import flex2.compiler.swc.AuthSwcDynamicArchive;
import flex2.compiler.swc.AuthSwcLazyReadArchive;
import flex2.compiler.swc.AuthSwcMemoryArchive;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcGroup;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthSwcCache
extends SwcCache {
    public synchronized SwcGroup getSwcGroupFromHashes(String[] stringArray, boolean bl) {
        LinkedHashMap<String, Swc> linkedHashMap = new LinkedHashMap<String, Swc>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Swc swc = this.getSwc(string, bl);
            if (swc == null) continue;
            linkedHashMap.put(string, swc);
        }
        SwcGroup swcGroup = null;
        if (linkedHashMap.size() > 0) {
            swcGroup = new SwcGroup(linkedHashMap);
        }
        return swcGroup;
    }

    private native String getHashForPath(String var1);

    private native byte[] getBytesForHash(String var1);

    @Override
    protected Map<String, Swc> getSwcs(String string) {
        LinkedHashMap<String, Swc> linkedHashMap = new LinkedHashMap<String, Swc>();
        File file = new File(string);
        if (!file.exists()) {
            return linkedHashMap;
        }
        if (!file.isDirectory()) {
            Swc swc = this.getSwc(file);
            if (swc != null) {
                linkedHashMap.put(swc.getLocation(), swc);
            }
        } else {
            File[] fileArray = FileUtils.listFiles((File)file);
            for (int i = 0; i < fileArray.length; ++i) {
                String string2;
                File file2 = fileArray[i];
                if (file2.isDirectory() || !file2.canRead() || (string2 = file2.getName().toLowerCase()).endsWith("-generated.swc") || !string2.endsWith(".swc")) continue;
                try {
                    Swc swc = this.getSwc(file2);
                    if (swc == null) continue;
                    linkedHashMap.put(swc.getLocation(), swc);
                    continue;
                }
                catch (SwcException swcException) {
                    // empty catch block
                }
            }
        }
        return linkedHashMap;
    }

    @Override
    protected Swc getSwc(File file) {
        Swc swc;
        try {
            String string = FileUtils.canonicalPath((File)file);
            String string2 = this.getHashForPath(string);
            swc = (Swc)this.swcLRUCache.get(string2);
            if (swc == null) {
                if (Trace.swc) {
                    Trace.trace((String)new StringBuffer().append("Loading ").append(string).toString());
                }
                AuthSwcDynamicArchive authSwcDynamicArchive = this.lazyRead ? new AuthSwcLazyReadArchive(string, string2) : new AuthSwcDynamicArchive(string, string2);
                swc = new AuthSwc(authSwcDynamicArchive, true);
                if (ThreadLocalToolkit.errorCount() > 0) {
                    swc = null;
                } else if (this.useCache) {
                    this.swcLRUCache.put(string2, swc);
                }
            } else if (Trace.swc) {
                Trace.trace((String)new StringBuffer().append("Loading cached version of ").append(string).toString());
            }
        }
        catch (Exception exception) {
            if (Trace.error) {
                exception.printStackTrace();
            }
            SwcException.SwcNotLoaded swcNotLoaded = new SwcException.SwcNotLoaded(file.getName(), exception);
            ThreadLocalToolkit.log(swcNotLoaded);
            throw swcNotLoaded;
        }
        return swc;
    }

    protected Swc getSwc(String string, boolean bl) {
        Swc swc;
        try {
            swc = (Swc)this.swcLRUCache.get(string);
            if (swc == null) {
                byte[] byArray = this.getBytesForHash(string);
                AuthSwcMemoryArchive authSwcMemoryArchive = new AuthSwcMemoryArchive(byArray, string);
                swc = new AuthSwc(authSwcMemoryArchive, true, bl);
                if (this.useCache) {
                    this.swcLRUCache.put(string, swc);
                }
            }
        }
        catch (Exception exception) {
            SwcException.SwcNotLoaded swcNotLoaded = new SwcException.SwcNotLoaded(string, exception);
            throw swcNotLoaded;
        }
        return swc;
    }
}

