/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flex2.compiler.io.InMemoryFile;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcDynamicArchive;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.zip.ZipEntry;
import flex2.compiler.swc.zip.ZipFile;
import flex2.compiler.util.MimeMappings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;

public class AuthSwcDynamicArchive
extends SwcDynamicArchive
implements SwcArchive {
    protected final String hash;

    public AuthSwcDynamicArchive(String string) {
        super(string);
        this.hash = string;
    }

    public AuthSwcDynamicArchive(String string, String string2) {
        super(string);
        this.hash = string2;
    }

    public AuthSwcDynamicArchive(OutputStream outputStream, String string) {
        super(outputStream, string);
        this.hash = string;
    }

    public AuthSwcDynamicArchive(OutputStream outputStream, String string, String string2) {
        super(outputStream, string);
        this.hash = string2;
    }

    public String getLocation() {
        return this.hash;
    }

    public String getRealPath() {
        return this.path;
    }

    public void load() {
        this.files = new HashMap();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.path);
            Enumeration<ZipEntry> enumeration = zipFile.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                InMemoryFile inMemoryFile = new InMemoryFile(inputStream, zipEntry.getSize(), this.hash + "$" + zipEntry.getName(), MimeMappings.getMimeType(zipEntry.getName()), zipEntry.getTime());
                this.files.put(zipEntry.getName(), inMemoryFile);
            }
        }
        catch (SwcException.UnknownZipFormat unknownZipFormat) {
            throw new SwcException.NotASwcFile(this.path);
        }
        catch (SwcException swcException) {
            throw swcException;
        }
        catch (Exception exception) {
            throw new SwcException.FilesNotRead(exception.getMessage());
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

