/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.zip.ZipEntry;
import flex2.compiler.swc.zip.ZipMemoryFile;
import flex2.compiler.util.MimeMappings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class AuthSwcMemoryArchive
implements SwcArchive {
    protected byte[] data;
    protected String hash;
    protected Map files = new HashMap();

    public AuthSwcMemoryArchive(byte[] byArray, String string) {
        this.data = byArray;
        this.hash = string;
    }

    public String getLocation() {
        return this.hash;
    }

    public void load() {
        ZipMemoryFile zipMemoryFile = null;
        try {
            zipMemoryFile = new ZipMemoryFile(this.data);
            Enumeration enumeration = zipMemoryFile.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                InputStream inputStream = zipMemoryFile.getInputStream(zipEntry);
                InMemoryFile inMemoryFile = new InMemoryFile(inputStream, zipEntry.getSize(), this.hash + "$" + zipEntry.getName(), MimeMappings.getMimeType(zipEntry.getName()), zipEntry.getTime());
                this.files.put(zipEntry.getName(), inMemoryFile);
            }
        }
        catch (SwcException swcException) {
            throw swcException;
        }
        catch (Exception exception) {
            throw new SwcException.FilesNotRead(exception.getMessage());
        }
        finally {
            try {
                if (zipMemoryFile != null) {
                    zipMemoryFile.close();
                }
            }
            catch (IOException iOException) {}
            this.data = null;
        }
    }

    public void save() throws Exception {
    }

    public void close() {
    }

    public Map getFiles() {
        return this.files;
    }

    public VirtualFile getFile(String string) {
        return (VirtualFile)this.files.get(string);
    }

    public void putFile(VirtualFile virtualFile) {
    }

    public void putFile(String string, byte[] byArray, long l) {
    }

    public long getLastModified() {
        return 0L;
    }
}

