/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc.catalog;

import flex2.compiler.swc.AuthSwcComponent;
import flex2.compiler.swc.AuthSwcLibrary;
import flex2.compiler.swc.AuthVersions;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.catalog.CatalogReadElement;
import flex2.compiler.swc.catalog.CatalogReader;
import flex2.compiler.swc.catalog.ReadContext;
import java.io.InputStream;
import org.xml.sax.Attributes;

public class AuthCatalogReader
extends CatalogReader {
    public AuthCatalogReader(InputStream inputStream, Swc swc, SwcArchive swcArchive) {
        super(inputStream, swc, swcArchive);
        this.versions = new AuthVersions();
        this.versionReader = new AuthVersionReader();
        this.componentReader = new AuthComponentReader();
        this.libraryReader = new AuthLibraryReader();
    }

    class AuthLibraryReader
    extends CatalogReader.LibraryReader {
        AuthLibraryReader() {
            super(AuthCatalogReader.this);
        }

        public CatalogReadElement readElement(ReadContext readContext) {
            String string = readContext.getCurrentName();
            if ("library".equals(string)) {
                String string2 = CatalogReader.readAttribute("path", readContext.getCurrentAttributes(), true);
                AuthSwcLibrary authSwcLibrary = new AuthSwcLibrary(AuthCatalogReader.this.swc, string2);
                AuthCatalogReader.this.libraries.put(string2, authSwcLibrary);
                AuthCatalogReader.this.scriptReader.clear();
                AuthCatalogReader.this.scriptReader.currentLibrary = authSwcLibrary;
                return AuthCatalogReader.this.scriptReader;
            }
            AuthCatalogReader.this.handleUnknownRecord("libraries", string);
            return this;
        }
    }

    class AuthComponentReader
    extends CatalogReader.ComponentReader {
        AuthComponentReader() {
            super(AuthCatalogReader.this);
        }

        public CatalogReadElement readElement(ReadContext readContext) {
            String string = readContext.getCurrentName();
            if ("component".equals(string)) {
                AuthSwcComponent authSwcComponent = new AuthSwcComponent();
                Attributes attributes = readContext.getCurrentAttributes();
                authSwcComponent.setClassName(CatalogReader.readAttribute("className", attributes, true));
                authSwcComponent.setName(CatalogReader.readAttribute("name", attributes, false));
                authSwcComponent.setUri(CatalogReader.readAttribute("uri", attributes, false));
                authSwcComponent.setIcon(CatalogReader.readAttribute("icon", attributes, false));
                authSwcComponent.setDocs(CatalogReader.readAttribute("docs", attributes, false));
                authSwcComponent.setPreview(CatalogReader.readAttribute("preview", attributes, false));
                authSwcComponent.setLocation(AuthCatalogReader.this.swc.getLocation());
                authSwcComponent.setToolTip(CatalogReader.readAttribute("tooltip", attributes, false));
                authSwcComponent.setCustomUI(CatalogReader.readAttribute("customUI", attributes, false));
                authSwcComponent.setCustomUIDisplay(CatalogReader.readAttributeLong("customUIDisplay", attributes, false));
                authSwcComponent.setMinimumPlayerVersion(CatalogReader.readAttribute("minimumPlayerVersion", attributes, false));
                AuthCatalogReader.this.components.put(authSwcComponent.getClassName(), authSwcComponent);
                return this;
            }
            AuthCatalogReader.this.handleUnknownRecord("components", string);
            return this;
        }
    }

    class AuthVersionReader
    extends CatalogReader.VersionReader {
        AuthVersionReader() {
            super(AuthCatalogReader.this);
        }

        public CatalogReadElement readElement(ReadContext readContext) {
            String string = readContext.getCurrentName();
            if ("flex".equals(string)) {
                Attributes attributes = readContext.getCurrentAttributes();
                AuthCatalogReader.this.versions.setFlexVersion(CatalogReader.readAttribute("version", attributes, true));
                AuthCatalogReader.this.versions.setFlexBuild(CatalogReader.readAttribute("build", attributes, false));
            } else if ("flash".equals(string)) {
                Attributes attributes = readContext.getCurrentAttributes();
                AuthCatalogReader.this.versions.setFlexVersion(CatalogReader.readAttribute("version", attributes, true));
                AuthCatalogReader.this.versions.setFlexBuild(CatalogReader.readAttribute("build", attributes, false));
                ((AuthVersions)AuthCatalogReader.this.versions).setPlatform(CatalogReader.readAttribute("platform", attributes, false));
            } else if ("swc".equals(string)) {
                Attributes attributes = readContext.getCurrentAttributes();
                AuthCatalogReader.this.versions.setLibVersion(CatalogReader.readAttribute("version", attributes, true));
            }
            return this;
        }
    }
}

