/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc.zip;

import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.zip.RandomAccessMemoryFile;
import flex2.compiler.swc.zip.ZipEntry;
import flex2.compiler.swc.zip.ZipLong;
import flex2.compiler.swc.zip.ZipOutputStream;
import flex2.compiler.swc.zip.ZipShort;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class ZipMemoryFile {
    private Hashtable entries = new Hashtable();
    private Hashtable nameMap = new Hashtable();
    private Hashtable dataOffsets = new Hashtable();
    private String encoding = null;
    private RandomAccessMemoryFile archive;
    private static final int CFH_LEN = 42;
    private static final int MIN_EOCD_SIZE = 22;
    private static final int CFD_LOCATOR_OFFSET = 16;
    private static final long LFH_OFFSET_FOR_FILENAME_LENGTH = 26L;

    public ZipMemoryFile(byte[] byArray) throws IOException {
        this(byArray, null);
    }

    public ZipMemoryFile(byte[] byArray, String string) throws IOException {
        this.encoding = string;
        this.archive = new RandomAccessMemoryFile(byArray);
        this.populateFromCentralDirectory();
        this.resolveLocalFileHeaderData();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void close() throws IOException {
        this.archive.close();
    }

    public Enumeration getEntries() {
        return this.entries.keys();
    }

    public ZipEntry getEntry(String string) {
        return (ZipEntry)this.nameMap.get(string);
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException, SwcException {
        Long l = (Long)this.dataOffsets.get(zipEntry);
        if (l == null) {
            return null;
        }
        BoundedInputStream boundedInputStream = new BoundedInputStream(this, l, zipEntry.getCompressedSize());
        switch (zipEntry.getMethod()) {
            case 0: {
                return boundedInputStream;
            }
            case 8: {
                boundedInputStream.addDummy();
                return new InflaterInputStream(boundedInputStream, new Inflater(true));
            }
        }
        throw new SwcException.UnsupportedZipCompression(zipEntry.getMethod() + "");
    }

    private void populateFromCentralDirectory() throws IOException {
        this.positionAtCentralDirectory();
        byte[] byArray = new byte[42];
        byte[] byArray2 = new byte[4];
        this.archive.readFully(byArray2);
        ZipLong zipLong = new ZipLong(byArray2);
        while (zipLong.equals(ZipOutputStream.CFH_SIG)) {
            this.archive.readFully(byArray);
            int n = 0;
            ZipEntry zipEntry = new ZipEntry();
            ZipShort zipShort = new ZipShort(byArray, n);
            n += 2;
            zipEntry.setPlatform(zipShort.getValue() >> 8 & 0xF);
            zipEntry.setMethod(new ZipShort(byArray, n += 4).getValue());
            zipEntry.setTime(ZipMemoryFile.fromDosTime(new ZipLong(byArray, n += 2)).getTime());
            zipEntry.setCrc(new ZipLong(byArray, n += 4).getValue());
            zipEntry.setCompressedSize(new ZipLong(byArray, n += 4).getValue());
            zipEntry.setSize(new ZipLong(byArray, n += 4).getValue());
            int n2 = new ZipShort(byArray, n += 4).getValue();
            int n3 = new ZipShort(byArray, n += 2).getValue();
            int n4 = new ZipShort(byArray, n += 2).getValue();
            n += 2;
            zipEntry.setInternalAttributes(new ZipShort(byArray, n += 2).getValue());
            zipEntry.setExternalAttributes(new ZipLong(byArray, n += 2).getValue());
            this.entries.put(zipEntry, new Long(new ZipLong(byArray, n += 4).getValue()));
            byte[] byArray3 = new byte[n2];
            this.archive.readFully(byArray3);
            zipEntry.setName(this.getString(byArray3));
            this.nameMap.put(zipEntry.getName(), zipEntry);
            this.archive.skipBytes(n3);
            byte[] byArray4 = new byte[n4];
            this.archive.readFully(byArray4);
            zipEntry.setComment(this.getString(byArray4));
            this.archive.readFully(byArray2);
            zipLong = new ZipLong(byArray2);
        }
    }

    private void positionAtCentralDirectory() throws IOException {
        long l = this.archive.length() - 22L;
        this.archive.seek(l);
        byte[] byArray = ZipOutputStream.EOCD_SIG.getBytes();
        int n = this.archive.read();
        boolean bl = false;
        while (n != -1) {
            if (n == byArray[0] && (n = this.archive.read()) == byArray[1] && (n = this.archive.read()) == byArray[2] && (n = this.archive.read()) == byArray[3]) {
                bl = true;
                break;
            }
            this.archive.seek(--l);
            n = this.archive.read();
        }
        if (!bl) {
            throw new SwcException.UnknownZipFormat("0");
        }
        this.archive.seek(l + 16L);
        byte[] byArray2 = new byte[4];
        this.archive.readFully(byArray2);
        this.archive.seek(new ZipLong(byArray2).getValue());
    }

    private void resolveLocalFileHeaderData() throws IOException {
        Enumeration enumeration = this.getEntries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
            long l = (Long)this.entries.get(zipEntry);
            this.archive.seek(l + 26L);
            byte[] byArray = new byte[2];
            this.archive.readFully(byArray);
            int n = new ZipShort(byArray).getValue();
            this.archive.readFully(byArray);
            int n2 = new ZipShort(byArray).getValue();
            this.archive.skipBytes(n);
            byte[] byArray2 = new byte[n2];
            this.archive.readFully(byArray2);
            zipEntry.setExtra(byArray2);
            this.dataOffsets.put(zipEntry, new Long(l + 26L + 2L + 2L + (long)n + (long)n2));
        }
    }

    protected static Date fromDosTime(ZipLong zipLong) {
        long l = zipLong.getValue();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, (int)(l >> 25 & 0x7FL) + 1980);
        calendar.set(2, (int)(l >> 21 & 0xFL) - 1);
        calendar.set(5, (int)(l >> 16) & 0x1F);
        calendar.set(11, (int)(l >> 11) & 0x1F);
        calendar.set(12, (int)(l >> 5) & 0x3F);
        calendar.set(13, (int)(l << 1) & 0x3E);
        return calendar.getTime();
    }

    protected String getString(byte[] byArray) {
        if (this.encoding == null) {
            return new String(byArray);
        }
        try {
            return new String(byArray, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
    }

    private class BoundedInputStream
    extends InputStream {
        private long remaining;
        private long loc;
        private boolean addDummyByte = false;
        final /* synthetic */ ZipMemoryFile this$0;

        /*
         * WARNING - void declaration
         */
        BoundedInputStream(ZipMemoryFile zipMemoryFile, long l, long l2) {
            void arg1;
            void arg2;
            void arg0;
            this.this$0 = arg0;
            this.remaining = arg2;
            this.loc = arg1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            if (this.remaining-- <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            RandomAccessMemoryFile randomAccessMemoryFile = this.this$0.archive;
            synchronized (randomAccessMemoryFile) {
                this.this$0.archive.seek(this.loc++);
                return this.this$0.archive.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    byArray[n] = 0;
                    return 1;
                }
                return -1;
            }
            if (n2 <= 0) {
                return 0;
            }
            if ((long)n2 > this.remaining) {
                n2 = (int)this.remaining;
            }
            int n3 = -1;
            RandomAccessMemoryFile randomAccessMemoryFile = this.this$0.archive;
            synchronized (randomAccessMemoryFile) {
                this.this$0.archive.seek(this.loc);
                n3 = this.this$0.archive.read(byArray, n, n2);
            }
            if (n3 > 0) {
                this.loc += (long)n3;
                this.remaining -= (long)n3;
            }
            return n3;
        }

        void addDummy() {
            this.addDummyByte = true;
        }
    }
}

