/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.Action;
import flash.swf.Dictionary;
import flash.swf.Header;
import flash.swf.MFUCache;
import flash.swf.Tag;
import flash.swf.TagDecoder;
import flash.swf.TagHandler;
import flash.swf.actions.ConstantPool;
import flash.swf.actions.DefineFunction;
import flash.swf.actions.Push;
import flash.swf.actions.StoreRegister;
import flash.swf.debug.DebugModule;
import flash.swf.debug.LineRecord;
import flash.swf.tags.DefineButton;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DoAction;
import flash.swf.tags.DoInitAction;
import flash.swf.tags.PlaceObject;
import flash.swf.types.ActionList;
import flash.swf.types.ButtonCondAction;
import flash.swf.types.ClipActionRecord;
import flash.swf.types.ClipActions;
import flash.swf.types.TagList;
import flash.util.IntMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MovieMetaData
extends TagHandler {
    private Dictionary dict;
    private Header header;
    public IntMap actions;
    public IntMap modules;
    public IntMap functionNames;
    public IntMap functionSizes;
    public IntMap functionLines;
    public IntMap preciseLines;
    public Map<String, DebugModule> mxml;
    public List<Integer> skipOffsets;
    private String className;
    private String[] pool;
    private static final int[] regClassCall9;
    private static final int[] regClassCall10;
    private static Integer[] codes;
    private static Object dummy;
    private static Object[] registers;

    public MovieMetaData(byte[] swf, byte[] swd) {
        this(new ByteArrayInputStream(swf), new ByteArrayInputStream(swd));
    }

    public MovieMetaData(InputStream swf, InputStream swd) {
        try {
            this.init();
            TagDecoder p = new TagDecoder(swf, swd);
            this.parse(p);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public MovieMetaData(String u) {
        try {
            this.init();
            URL url = new URL(u);
            InputStream in = url.openStream();
            TagDecoder p = new TagDecoder(in, url);
            this.parse(p);
        }
        catch (MalformedURLException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void init() {
        this.actions = new IntMap();
        this.modules = new IntMap();
        this.functionNames = new IntMap();
        this.functionSizes = new IntMap();
        this.functionLines = new IntMap();
        this.preciseLines = new IntMap();
        this.mxml = new HashMap<String, DebugModule>();
        this.pool = null;
        this.skipOffsets = new ArrayList<Integer>();
    }

    private void parse(TagDecoder p) throws IOException {
        p.setKeepOffsets(true);
        p.parse(this);
        Collections.sort(this.skipOffsets);
        this.className = null;
    }

    public DebugModule getDebugModule(int offset) {
        DebugModule d = (DebugModule)this.modules.get(offset);
        if (d == null) {
            return null;
        }
        return d;
    }

    public String getFunctionName(int offset) {
        return (String)this.functionNames.get(offset);
    }

    public Iterator getFunctionLines() {
        return this.preciseLines.iterator();
    }

    public Integer getOpCode(int offset) {
        return (Integer)this.actions.get(offset);
    }

    protected Integer getFunctionLineNumber(int offset) {
        return (Integer)this.functionLines.get(offset);
    }

    protected boolean isFunction(int offset) {
        String s = this.getFunctionName(offset);
        return s != null;
    }

    @Override
    public void setDecoderDictionary(Dictionary dict) {
        this.dict = dict;
    }

    @Override
    public void header(Header h) {
        this.header = h;
    }

    @Override
    public void defineButton(DefineButton tag) {
        String[] temp = this.pool;
        this.collectActions(tag.condActions[0].actionList);
        this.pool = temp;
    }

    @Override
    public void doAction(DoAction tag) {
        String[] temp = this.pool;
        this.collectActions(tag.actionList);
        this.pool = temp;
    }

    @Override
    public void placeObject2(PlaceObject tag) {
        this.collectClipActions(tag.clipActions);
    }

    @Override
    public void placeObject3(PlaceObject tag) {
        this.collectClipActions(tag.clipActions);
    }

    @Override
    public void defineButton2(DefineButton tag) {
        this.collectCondActions(tag.condActions);
    }

    @Override
    public void defineSprite(DefineSprite tag) {
        this.collectSpriteActions(tag.tagList);
    }

    @Override
    public void doInitAction(DoInitAction tag) {
        if (this.header.version > 6 && tag.sprite != null) {
            String __Packages = this.idRef(tag.sprite);
            String string = this.className = __Packages != null && __Packages.startsWith("__Packages") ? __Packages.substring(11) : null;
            if (MovieMetaData.isRegisterClass(tag.actionList)) {
                DebugModule dm = new DebugModule();
                dm.name = "<" + __Packages + ".2>";
                dm.setText("Object.registerClass(" + __Packages + ", " + __Packages + ");");
                dm.bitmap = 1;
                LineRecord lr = new LineRecord(1, dm);
                int startOffset = tag.actionList.getOffset(0);
                dm.addOffset(lr, startOffset);
                tag.actionList.insert(startOffset, lr);
                this.modules.put((int)(Math.random() * 2.147483647E9), dm);
            }
        }
        String[] temp = this.pool;
        this.collectActions(tag.actionList);
        this.pool = temp;
        this.className = null;
    }

    public static final boolean isRegisterClass(ActionList actionList) {
        if (!MovieMetaData.hasLineRecord(actionList)) {
            int[] opcodes;
            if (actionList.size() == 9) {
                opcodes = regClassCall9;
            } else if (actionList.size() == 10) {
                opcodes = regClassCall10;
            } else {
                return false;
            }
            for (int i = 0; i < opcodes.length; ++i) {
                if (actionList.getAction((int)i).code == opcodes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    String idRef(DefineTag tag) {
        return MovieMetaData.idRef(tag, this.dict);
    }

    public static String idRef(DefineTag tag, Dictionary d) {
        if (tag == null) {
            return "-1";
        }
        if (tag.name == null) {
            return String.valueOf(d.getId(tag));
        }
        return tag.name;
    }

    private static final boolean hasLineRecord(ActionList c) {
        if (c == null || c.size() == 0) {
            return true;
        }
        boolean result = false;
        block4: for (int i = 0; i < c.size() && !result; ++i) {
            Action action = c.getAction(i);
            switch (action.code) {
                case 142: 
                case 155: {
                    result = result || MovieMetaData.hasLineRecord(((DefineFunction)action).actionList);
                    continue block4;
                }
                case 257: {
                    result = true;
                }
            }
        }
        return result;
    }

    private void collectSpriteActions(TagList s) {
        int len = s.tags.size();
        block8: for (int i = 0; i < len; ++i) {
            Tag t = s.tags.get(i);
            switch (t.code) {
                case 12: {
                    String[] temp = this.pool;
                    this.collectActions(((DoAction)t).actionList);
                    this.pool = temp;
                    continue block8;
                }
                case 34: {
                    this.collectCondActions(((DefineButton)t).condActions);
                    continue block8;
                }
                case 7: {
                    String[] temp = this.pool;
                    this.collectActions(((DefineButton)t).condActions[0].actionList);
                    this.pool = temp;
                    continue block8;
                }
                case 59: {
                    String[] temp = this.pool;
                    this.collectActions(((DoInitAction)t).actionList);
                    this.pool = temp;
                    continue block8;
                }
                case 39: {
                    this.collectSpriteActions(((DefineSprite)t).tagList);
                    continue block8;
                }
                case 26: {
                    this.collectClipActions(((PlaceObject)t).clipActions);
                }
            }
        }
    }

    private DebugModule findDebugModule(ActionList c) {
        MFUCache modules = new MFUCache();
        for (int i = 0; i < c.size(); ++i) {
            Action a = c.getAction(i);
            DebugModule temp = null;
            switch (a.code) {
                case 142: 
                case 155: {
                    temp = this.findDebugModule(((DefineFunction)a).actionList);
                    break;
                }
                case 257: {
                    if (((LineRecord)a).module == null) break;
                    temp = ((LineRecord)a).module;
                }
            }
            if (temp == null) continue;
            modules.add(temp);
        }
        return modules.topModule;
    }

    private void collectActions(ActionList c) {
        if (c == null) {
            return;
        }
        this.evalActions(c);
        DebugModule d = this.findDebugModule(c);
        String emptyMethodName = null;
        for (int i = 0; i < c.size(); ++i) {
            int ioffset = c.getOffset(i);
            Action a = c.getAction(i);
            if (emptyMethodName != null && emptyMethodName.length() != 0) {
                this.functionNames.put(ioffset, emptyMethodName);
                emptyMethodName = null;
            }
            if (a.code == 257) {
                LineRecord line = (LineRecord)a;
                if (line.module == null) continue;
                d = line.module;
                if (!d.name.endsWith(".mxml")) continue;
                this.mxml.put(d.name, d);
                continue;
            }
            if (a.code >= 256) continue;
            this.actions.put(ioffset, codes[a.code]);
            this.modules.put(ioffset, d);
            switch (a.code) {
                case 142: 
                case 155: {
                    DefineFunction f = (DefineFunction)a;
                    Integer size = new Integer(f.codeSize);
                    if (f.actionList.size() == 0) {
                        emptyMethodName = f.name;
                    } else {
                        int o;
                        int j;
                        Integer lineno = null;
                        for (j = 0; j < f.actionList.size(); ++j) {
                            o = f.actionList.getOffset(j);
                            Action child = f.actionList.getAction(j);
                            if (child.code == 257) {
                                if (lineno == null) {
                                    lineno = new Integer(((LineRecord)child).lineno);
                                }
                                this.preciseLines.put(o, new Integer(((LineRecord)child).lineno));
                            }
                            this.functionNames.put(o, f.name);
                            this.functionSizes.put(o, size);
                        }
                        for (j = 0; j < f.actionList.size(); ++j) {
                            o = f.actionList.getOffset(j);
                            this.functionLines.put(o, lineno);
                        }
                    }
                    this.collectActions(f.actionList);
                }
            }
        }
    }

    private void collectCondActions(ButtonCondAction[] actions) {
        for (int i = 0; i < actions.length; ++i) {
            this.collectActions(actions[i].actionList);
        }
    }

    private void collectClipActions(ClipActions actions) {
        if (actions != null) {
            for (ClipActionRecord record : actions.clipActionRecords) {
                this.collectActions(record.actionList);
            }
        }
    }

    private static Object pop(Stack<Object> stack) {
        return stack.isEmpty() ? null : stack.pop();
    }

    private void evalActions(ActionList c) {
        try {
            MovieMetaData.walkActions(c, this.header.version, this.pool, this.className, this.skipOffsets);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void walkActions(ActionList c, int swfVersion, String[] pool, String className, List<Integer> profileOffsets) {
        if (c == null) {
            return;
        }
        Stack<Object> evalStack = new Stack<Object>();
        HashMap<Object, Object> variables = new HashMap<Object, Object>();
        block62: for (int i = 0; i < c.size(); ++i) {
            int offset = c.getOffset(i);
            Action a = c.getAction(i);
            switch (a.code) {
                case 0: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 128: 
                case 129: 
                case 131: 
                case 138: 
                case 139: 
                case 140: {
                    continue block62;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 33: 
                case 34: 
                case 41: 
                case 49: {
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 18: 
                case 20: 
                case 24: 
                case 48: 
                case 50: 
                case 51: 
                case 54: 
                case 55: {
                    continue block62;
                }
                case 28: {
                    Object key = MovieMetaData.pop(evalStack);
                    if (variables.get(key) == null) {
                        evalStack.push(key);
                        continue block62;
                    }
                    evalStack.push(variables.get(key));
                    continue block62;
                }
                case 21: 
                case 53: {
                    MovieMetaData.pop(evalStack);
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 150: {
                    Push p = (Push)a;
                    Object o = p.value;
                    int type = Push.getTypeCode(o);
                    switch (type) {
                        case 0: {
                            evalStack.push(o);
                            continue block62;
                        }
                        case 2: {
                            evalStack.push("null");
                            continue block62;
                        }
                        case 3: {
                            evalStack.push("undefined");
                            continue block62;
                        }
                        case 4: {
                            evalStack.push(registers[((Byte)o).intValue() & 0xFF]);
                            continue block62;
                        }
                        case 8: 
                        case 9: {
                            evalStack.push(pool[((Number)o).intValue() & 0xFFFF]);
                            continue block62;
                        }
                        case 1: {
                            evalStack.push(o + "F");
                            continue block62;
                        }
                        case 5: 
                        case 6: 
                        case 7: {
                            evalStack.push(o);
                            continue block62;
                        }
                    }
                    evalStack.push("type" + type);
                    continue block62;
                }
                case 157: {
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 23: 
                case 32: 
                case 37: 
                case 38: 
                case 141: 
                case 158: 
                case 159: {
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 40: 
                case 153: {
                    continue block62;
                }
                case 29: {
                    Object key = MovieMetaData.pop(evalStack);
                    Object val = MovieMetaData.pop(evalStack);
                    variables.put(key, val);
                    continue block62;
                }
                case 154: {
                    MovieMetaData.pop(evalStack);
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 35: 
                case 36: {
                    MovieMetaData.pop(evalStack);
                    MovieMetaData.pop(evalStack);
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 39: {
                    MovieMetaData.pop(evalStack);
                    MovieMetaData.pop(evalStack);
                    Object obj = MovieMetaData.pop(evalStack);
                    if (Integer.parseInt(obj.toString()) == 0) continue block62;
                    MovieMetaData.pop(evalStack);
                    MovieMetaData.pop(evalStack);
                    MovieMetaData.pop(evalStack);
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 52: {
                    evalStack.push(dummy);
                    continue block62;
                }
                case 58: {
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 60: {
                    Object val = MovieMetaData.pop(evalStack);
                    Object key = MovieMetaData.pop(evalStack);
                    variables.put(key, val);
                    continue block62;
                }
                case 142: 
                case 155: {
                    int k;
                    Object o;
                    DefineFunction f = (DefineFunction)a;
                    if (swfVersion > 6 && className != null) {
                        if (f.name == null || f.name.length() == 0) {
                            int depth = evalStack.size();
                            if (depth != 0) {
                                o = evalStack.peek();
                                if (o == dummy) {
                                    f.name = "";
                                } else if (o != null) {
                                    f.name = o.toString();
                                }
                            }
                            evalStack.push(dummy);
                        }
                        if ("null".equals(f.name)) {
                            f.name = "";
                        }
                        if (f.name == null || f.name.length() == 0) continue block62;
                        if (!className.endsWith(f.name)) {
                            f.name = className + "." + f.name;
                            continue block62;
                        }
                        f.name = className + ".[constructor]";
                        continue block62;
                    }
                    if (f.name != null && f.name.length() != 0) continue block62;
                    StringBuilder buffer = new StringBuilder();
                    int depth = evalStack.size();
                    for (k = depth - 1; k >= 0 && (o = evalStack.get(k)) != dummy; --k) {
                        if (k == depth - 1) {
                            buffer.append(o);
                            continue;
                        }
                        buffer.insert(0, '.');
                        buffer.insert(0, o);
                    }
                    f.name = buffer.toString();
                    if (f.name != null && f.name.indexOf(".prototype.") == -1) {
                        f.name = "";
                    }
                    evalStack.push(dummy);
                    continue block62;
                }
                case 61: {
                    int k;
                    Object function = MovieMetaData.pop(evalStack);
                    if (profileOffsets != null && "profile".equals(function)) {
                        profileOffsets.add(new Integer(offset - 13));
                        profileOffsets.add(new Integer(offset - 5));
                        profileOffsets.add(new Integer(offset));
                        profileOffsets.add(new Integer(offset + 1));
                    }
                    int n = ((Number)MovieMetaData.pop(evalStack)).intValue();
                    for (k = 0; k < n; ++k) {
                        MovieMetaData.pop(evalStack);
                    }
                    evalStack.push(dummy);
                    continue block62;
                }
                case 62: {
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 63: {
                    continue block62;
                }
                case 64: {
                    MovieMetaData.pop(evalStack);
                    int num = ((Number)MovieMetaData.pop(evalStack)).intValue();
                    for (int k = 0; k < num; ++k) {
                        MovieMetaData.pop(evalStack);
                    }
                    evalStack.push(dummy);
                    continue block62;
                }
                case 59: 
                case 65: 
                case 71: 
                case 72: {
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 66: {
                    int num = ((Number)MovieMetaData.pop(evalStack)).intValue();
                    for (int k = 0; k < num; ++k) {
                        MovieMetaData.pop(evalStack);
                    }
                    evalStack.push(dummy);
                    continue block62;
                }
                case 67: {
                    int num = ((Number)MovieMetaData.pop(evalStack)).intValue() * 2;
                    for (int k = 0; k < num; ++k) {
                        MovieMetaData.pop(evalStack);
                    }
                    evalStack.push(dummy);
                    continue block62;
                }
                case 68: 
                case 69: 
                case 70: 
                case 74: 
                case 75: {
                    continue block62;
                }
                case 135: {
                    StoreRegister r = (StoreRegister)a;
                    MovieMetaData.registers[r.register] = evalStack.peek();
                    continue block62;
                }
                case 73: {
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 76: {
                    evalStack.push(dummy);
                    continue block62;
                }
                case 77: {
                    continue block62;
                }
                case 78: {
                    Object o1 = MovieMetaData.pop(evalStack);
                    Object o2 = MovieMetaData.pop(evalStack);
                    if (pool != null) {
                        try {
                            evalStack.push(pool[Integer.parseInt(o2.toString())] + "." + pool[Integer.parseInt(o1.toString())]);
                        }
                        catch (Exception ex) {
                            if (o1 == dummy || o2 == dummy) {
                                evalStack.push(dummy);
                                continue block62;
                            }
                            evalStack.push(o2 + "." + o1);
                        }
                        continue block62;
                    }
                    evalStack.push(o2 + "." + o1);
                    continue block62;
                }
                case 79: {
                    MovieMetaData.pop(evalStack);
                    MovieMetaData.pop(evalStack);
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 80: 
                case 81: {
                    continue block62;
                }
                case 82: {
                    int k;
                    int n;
                    MovieMetaData.pop(evalStack);
                    MovieMetaData.pop(evalStack);
                    Object obj2 = MovieMetaData.pop(evalStack);
                    if (obj2 instanceof String) {
                        try {
                            n = Integer.parseInt((String)obj2);
                        }
                        catch (NumberFormatException ex) {
                            n = 1;
                        }
                    } else {
                        n = ((Number)obj2).intValue();
                    }
                    for (k = 0; k < n; ++k) {
                        MovieMetaData.pop(evalStack);
                    }
                    evalStack.push(dummy);
                    continue block62;
                }
                case 83: {
                    int k;
                    MovieMetaData.pop(evalStack);
                    MovieMetaData.pop(evalStack);
                    int num = ((Number)MovieMetaData.pop(evalStack)).intValue();
                    for (k = 0; k < num; ++k) {
                        MovieMetaData.pop(evalStack);
                    }
                    evalStack.push(dummy);
                    continue block62;
                }
                case 148: {
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 136: {
                    pool = ((ConstantPool)a).pool;
                    continue block62;
                }
                case 137: {
                    continue block62;
                }
                case 96: 
                case 97: 
                case 99: {
                    continue block62;
                }
                case 98: 
                case 100: 
                case 101: {
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 84: {
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 85: {
                    continue block62;
                }
                case 102: 
                case 103: 
                case 104: {
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 143: {
                    continue block62;
                }
                case 42: {
                    MovieMetaData.pop(evalStack);
                    continue block62;
                }
                case 43: {
                    continue block62;
                }
                case 44: {
                    continue block62;
                }
                case 170: {
                    continue block62;
                }
            }
        }
    }

    static {
        int i;
        regClassCall9 = new int[]{150, 28, 150, 150, 150, 28, 150, 82, 23};
        regClassCall10 = new int[]{136, 150, 28, 150, 150, 150, 28, 150, 82, 23};
        codes = new Integer[256];
        for (i = 0; i < 256; ++i) {
            MovieMetaData.codes[i] = new Integer(i);
        }
        dummy = new Object();
        registers = new Object[256];
        for (i = 0; i < 256; ++i) {
            MovieMetaData.registers[i] = dummy;
        }
    }
}

