/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dom;

import com.ctc.wstx.sw.OutputElementBase;
import com.ctc.wstx.util.BijectiveNsMap;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMOutputElement
extends OutputElementBase {
    private DOMOutputElement mParent;
    private Element mElement;
    private boolean mDefaultNsSet;

    private DOMOutputElement() {
        this.mParent = null;
        this.mElement = null;
        this.mNsMapping = null;
        this.mNsMapShared = false;
        this.mDefaultNsURI = "";
        this.mRootNsContext = null;
        this.mDefaultNsSet = false;
    }

    private DOMOutputElement(DOMOutputElement parent, Element element, BijectiveNsMap ns) {
        super((OutputElementBase)parent, ns);
        this.mParent = parent;
        this.mElement = element;
        this.mNsMapping = ns;
        this.mNsMapShared = ns != null;
        this.mDefaultNsURI = parent.mDefaultNsURI;
        this.mRootNsContext = parent.mRootNsContext;
        this.mDefaultNsSet = false;
    }

    private void relink(DOMOutputElement parent, Element element) {
        super.relink((OutputElementBase)parent);
        this.mParent = parent;
        this.mElement = element;
        parent.appendNode((Node)element);
        this.mDefaultNsSet = false;
    }

    public static DOMOutputElement createRoot() {
        return new DOMOutputElement();
    }

    protected DOMOutputElement createAndAttachChild(Element element) {
        if (this.isRoot()) {
            element.getOwnerDocument().appendChild(element);
        } else {
            this.mElement.appendChild(element);
        }
        return this.createChild(element);
    }

    protected DOMOutputElement createChild(Element element) {
        return new DOMOutputElement(this, element, this.mNsMapping);
    }

    protected DOMOutputElement reuseAsChild(DOMOutputElement parent, Element element) {
        DOMOutputElement poolHead = this.mParent;
        this.relink(parent, element);
        return poolHead;
    }

    protected void addToPool(DOMOutputElement poolHead) {
        this.mParent = poolHead;
    }

    public DOMOutputElement getParent() {
        return this.mParent;
    }

    public boolean isRoot() {
        return this.mParent == null;
    }

    public String getNameDesc() {
        if (this.mElement != null) {
            return this.mElement.getLocalName();
        }
        return "#error";
    }

    public void setDefaultNsUri(String uri) {
        this.mDefaultNsURI = uri;
        this.mDefaultNsSet = true;
    }

    protected void setRootNsContext(NamespaceContext ctxt) {
        String defURI;
        this.mRootNsContext = ctxt;
        if (!this.mDefaultNsSet && (defURI = ctxt.getNamespaceURI("")) != null && defURI.length() > 0) {
            this.mDefaultNsURI = defURI;
        }
    }

    protected void appendNode(Node n) {
        if (this.isRoot()) {
            this.mElement.getOwnerDocument().appendChild(n);
        } else {
            this.mElement.appendChild(n);
        }
    }

    protected void addAttribute(String pname, String value) {
        this.mElement.setAttribute(pname, value);
    }

    protected void addAttribute(String uri, String qname, String value) {
        this.mElement.setAttributeNS(uri, qname, value);
    }

    public void appendChild(Node n) {
        this.mElement.appendChild(n);
    }
}

