/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.io.AsciiReader;
import com.ctc.wstx.io.CharsetNames;
import com.ctc.wstx.io.ISOLatinReader;
import com.ctc.wstx.io.InputBootstrapper;
import com.ctc.wstx.io.InputSourceFactory;
import com.ctc.wstx.io.ReaderBootstrapper;
import com.ctc.wstx.io.StreamBootstrapper;
import com.ctc.wstx.io.UTF32Reader;
import com.ctc.wstx.io.UTF8Reader;
import com.ctc.wstx.io.WstxInputSource;
import com.ctc.wstx.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DefaultInputResolver {
    private DefaultInputResolver() {
    }

    public static WstxInputSource resolveEntity(WstxInputSource parent, URL pathCtxt, String entityName, String publicId, String systemId, XMLResolver customResolver, ReaderConfig cfg, int xmlVersion) throws IOException, XMLStreamException {
        Object source;
        if (pathCtxt == null && (pathCtxt = parent.getSource()) == null) {
            pathCtxt = URLUtil.urlFromCurrentDir();
        }
        if (customResolver != null && (source = customResolver.resolveEntity(publicId, systemId, pathCtxt.toExternalForm(), entityName)) != null) {
            return DefaultInputResolver.sourceFrom((WstxInputSource)parent, (ReaderConfig)cfg, (String)entityName, (int)xmlVersion, (Object)source);
        }
        if (systemId == null) {
            throw new XMLStreamException("Can not resolve " + (entityName == null ? "[External DTD subset]" : "entity '" + entityName + "'") + " without a system id (public id '" + publicId + "')");
        }
        URL url = URLUtil.urlFromSystemId((String)systemId, (URL)pathCtxt);
        return DefaultInputResolver.sourceFromURL((WstxInputSource)parent, (ReaderConfig)cfg, (String)entityName, (int)xmlVersion, (URL)url, (String)publicId);
    }

    public static WstxInputSource resolveEntityUsing(WstxInputSource refCtxt, String entityName, String publicId, String systemId, XMLResolver resolver, ReaderConfig cfg, int xmlVersion) throws IOException, XMLStreamException {
        Object source;
        URL ctxt;
        URL uRL = ctxt = refCtxt == null ? null : refCtxt.getSource();
        if (ctxt == null) {
            ctxt = URLUtil.urlFromCurrentDir();
        }
        return (source = resolver.resolveEntity(publicId, systemId, ctxt.toExternalForm(), entityName)) == null ? null : DefaultInputResolver.sourceFrom((WstxInputSource)refCtxt, (ReaderConfig)cfg, (String)entityName, (int)xmlVersion, (Object)source);
    }

    protected static WstxInputSource sourceFrom(WstxInputSource parent, ReaderConfig cfg, String refName, int xmlVersion, Object o) throws IllegalArgumentException, IOException, XMLStreamException {
        if (o instanceof Source) {
            if (o instanceof StreamSource) {
                return DefaultInputResolver.sourceFromSS((WstxInputSource)parent, (ReaderConfig)cfg, (String)refName, (int)xmlVersion, (StreamSource)((StreamSource)o));
            }
            throw new IllegalArgumentException("Can not use other Source objects than StreamSource: got " + o.getClass());
        }
        if (o instanceof URL) {
            return DefaultInputResolver.sourceFromURL((WstxInputSource)parent, (ReaderConfig)cfg, (String)refName, (int)xmlVersion, (URL)((URL)o), null);
        }
        if (o instanceof InputStream) {
            return DefaultInputResolver.sourceFromIS((WstxInputSource)parent, (ReaderConfig)cfg, (String)refName, (int)xmlVersion, (InputStream)((InputStream)o), null, null);
        }
        if (o instanceof Reader) {
            return DefaultInputResolver.sourceFromR((WstxInputSource)parent, (ReaderConfig)cfg, (String)refName, (int)xmlVersion, (Reader)((Reader)o), null, null);
        }
        if (o instanceof String) {
            return DefaultInputResolver.sourceFromString((WstxInputSource)parent, (ReaderConfig)cfg, (String)refName, (int)xmlVersion, (String)((String)o));
        }
        if (o instanceof File) {
            URL u = ((File)o).toURL();
            return DefaultInputResolver.sourceFromURL((WstxInputSource)parent, (ReaderConfig)cfg, (String)refName, (int)xmlVersion, (URL)u, null);
        }
        throw new IllegalArgumentException("Unrecognized input argument type for sourceFrom(): " + o.getClass());
    }

    public static Reader constructOptimizedReader(ReaderConfig cfg, InputStream in, boolean isXml11, String encoding) throws XMLStreamException {
        UTF8Reader r;
        int inputBufLen = cfg.getInputBufferLength();
        String normEnc = CharsetNames.normalize((String)encoding);
        boolean recycleBuffer = true;
        if (normEnc == "UTF-8") {
            r = new UTF8Reader(cfg, in, cfg.allocFullBBuffer(inputBufLen), 0, 0, recycleBuffer);
        } else if (normEnc == "ISO-8859-1") {
            r = new ISOLatinReader(cfg, in, cfg.allocFullBBuffer(inputBufLen), 0, 0, recycleBuffer);
        } else if (normEnc == "US-ASCII") {
            r = new AsciiReader(cfg, in, cfg.allocFullBBuffer(inputBufLen), 0, 0, recycleBuffer);
        } else if (normEnc.startsWith("UTF-32")) {
            boolean isBE = normEnc == "UTF-32BE";
            r = new UTF32Reader(cfg, in, cfg.allocFullBBuffer(inputBufLen), 0, 0, recycleBuffer, isBE);
        } else {
            try {
                return new InputStreamReader(in, encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new XMLStreamException("[unsupported encoding]: " + ex);
            }
        }
        if (isXml11) {
            r.setXmlCompliancy(272);
        }
        return r;
    }

    private static WstxInputSource sourceFromSS(WstxInputSource parent, ReaderConfig cfg, String refName, int xmlVersion, StreamSource ssrc) throws IOException, XMLStreamException {
        ReaderBootstrapper bs;
        URL url;
        Reader r = ssrc.getReader();
        String pubId = ssrc.getPublicId();
        String sysId = ssrc.getSystemId();
        URL ctxt = parent == null ? null : parent.getSource();
        URL uRL = url = sysId == null || sysId.length() == 0 ? null : URLUtil.urlFromSystemId((String)sysId, (URL)ctxt);
        if (r == null) {
            InputStream in = ssrc.getInputStream();
            if (in == null) {
                if (url == null) {
                    throw new IllegalArgumentException("Can not create Stax reader for a StreamSource -- neither reader, input stream nor system id was set.");
                }
                in = URLUtil.inputStreamFromURL((URL)url);
            }
            bs = StreamBootstrapper.getInstance((String)pubId, (String)sysId, (InputStream)in);
        } else {
            bs = ReaderBootstrapper.getInstance((String)pubId, (String)sysId, (Reader)r, null);
        }
        Reader r2 = bs.bootstrapInput(cfg, false, xmlVersion);
        return InputSourceFactory.constructEntitySource((ReaderConfig)cfg, (WstxInputSource)parent, (String)refName, (InputBootstrapper)bs, (String)pubId, (String)sysId, (int)xmlVersion, (URL)(url == null ? ctxt : url), (Reader)r2);
    }

    private static WstxInputSource sourceFromURL(WstxInputSource parent, ReaderConfig cfg, String refName, int xmlVersion, URL url, String pubId) throws IOException, XMLStreamException {
        InputStream in = URLUtil.inputStreamFromURL((URL)url);
        String sysId = url.toExternalForm();
        StreamBootstrapper bs = StreamBootstrapper.getInstance((String)pubId, (String)sysId, (InputStream)in);
        Reader r = bs.bootstrapInput(cfg, false, xmlVersion);
        return InputSourceFactory.constructEntitySource((ReaderConfig)cfg, (WstxInputSource)parent, (String)refName, (InputBootstrapper)bs, (String)pubId, (String)sysId, (int)xmlVersion, (URL)url, (Reader)r);
    }

    public static WstxInputSource sourceFromString(WstxInputSource parent, ReaderConfig cfg, String refName, int xmlVersion, String refContent) throws IOException, XMLStreamException {
        return DefaultInputResolver.sourceFromR((WstxInputSource)parent, (ReaderConfig)cfg, (String)refName, (int)xmlVersion, (Reader)new StringReader(refContent), null, (String)refName);
    }

    private static WstxInputSource sourceFromIS(WstxInputSource parent, ReaderConfig cfg, String refName, int xmlVersion, InputStream is, String pubId, String sysId) throws IOException, XMLStreamException {
        StreamBootstrapper bs = StreamBootstrapper.getInstance((String)pubId, (String)sysId, (InputStream)is);
        Reader r = bs.bootstrapInput(cfg, false, xmlVersion);
        URL ctxt = parent.getSource();
        if (sysId != null && sysId.length() > 0) {
            ctxt = URLUtil.urlFromSystemId((String)sysId, (URL)ctxt);
        }
        return InputSourceFactory.constructEntitySource((ReaderConfig)cfg, (WstxInputSource)parent, (String)refName, (InputBootstrapper)bs, (String)pubId, (String)sysId, (int)xmlVersion, (URL)ctxt, (Reader)r);
    }

    private static WstxInputSource sourceFromR(WstxInputSource parent, ReaderConfig cfg, String refName, int xmlVersion, Reader r, String pubId, String sysId) throws IOException, XMLStreamException {
        URL ctxt;
        ReaderBootstrapper rbs = ReaderBootstrapper.getInstance((String)pubId, (String)sysId, (Reader)r, null);
        Reader r2 = rbs.bootstrapInput(cfg, false, xmlVersion);
        URL uRL = ctxt = parent == null ? null : parent.getSource();
        if (sysId != null && sysId.length() > 0) {
            ctxt = URLUtil.urlFromSystemId((String)sysId, (URL)ctxt);
        }
        return InputSourceFactory.constructEntitySource((ReaderConfig)cfg, (WstxInputSource)parent, (String)refName, (InputBootstrapper)rbs, (String)pubId, (String)sysId, (int)xmlVersion, (URL)ctxt, (Reader)r2);
    }
}

