/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sr;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.dtd.DTDValidatorBase;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.sr.NsDefaultProvider;
import com.ctc.wstx.util.BaseNsContext;
import com.ctc.wstx.util.StringUtil;
import com.ctc.wstx.util.TextBuffer;
import com.ctc.wstx.util.TextBuilder;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.AttributeInfo;
import org.codehaus.stax2.validation.ValidationContext;
import org.codehaus.stax2.validation.ValidatorPair;
import org.codehaus.stax2.validation.XMLValidationProblem;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;

public abstract class InputElementStack
implements AttributeInfo,
NamespaceContext,
ValidationContext {
    static final int ID_ATTR_NONE = -1;
    protected final ReaderConfig mConfig;
    protected InputProblemReporter mReporter = null;
    protected XMLValidator mValidator = null;
    protected int mIdAttrIndex = -1;

    protected InputElementStack(ReaderConfig cfg) {
        this.mConfig = cfg;
    }

    protected void connectReporter(InputProblemReporter rep) {
        this.mReporter = rep;
    }

    protected XMLValidator addValidator(XMLValidator vld) {
        this.mValidator = this.mValidator == null ? vld : new ValidatorPair(this.mValidator, vld);
        return vld;
    }

    protected abstract void setAutomaticDTDValidator(XMLValidator var1, NsDefaultProvider var2);

    public XMLValidator validateAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return this.addValidator(schema.createValidator((ValidationContext)this));
    }

    public XMLValidator stopValidatingAgainst(XMLValidationSchema schema) throws XMLStreamException {
        XMLValidator[] results = new XMLValidator[2];
        if (ValidatorPair.removeValidator((XMLValidator)this.mValidator, (XMLValidationSchema)schema, (XMLValidator[])results)) {
            XMLValidator found = results[0];
            this.mValidator = results[1];
            found.validationCompleted(false);
            return found;
        }
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidator validator) throws XMLStreamException {
        XMLValidator[] results = new XMLValidator[2];
        if (ValidatorPair.removeValidator((XMLValidator)this.mValidator, (XMLValidator)validator, (XMLValidator[])results)) {
            XMLValidator found = results[0];
            this.mValidator = results[1];
            found.validationCompleted(false);
            return found;
        }
        return null;
    }

    protected boolean reallyValidating() {
        if (this.mValidator == null) {
            return false;
        }
        if (!(this.mValidator instanceof DTDValidatorBase)) {
            return true;
        }
        return ((DTDValidatorBase)this.mValidator).reallyValidating();
    }

    protected abstract AttributeCollector getAttrCollector();

    public abstract BaseNsContext createNonTransientNsContext(Location var1);

    public abstract void push(String var1, String var2);

    public abstract void push(String var1);

    public abstract boolean pop() throws XMLStreamException;

    public abstract int resolveAndValidateElement() throws XMLStreamException;

    public abstract int validateEndElement() throws XMLStreamException;

    public abstract int getAttributeCount();

    public abstract int findAttributeIndex(String var1, String var2);

    public final int getIdAttributeIndex() {
        if (this.mIdAttrIndex >= 0) {
            return this.mIdAttrIndex;
        }
        return this.mValidator == null ? -1 : this.mValidator.getIdAttrIndex();
    }

    public final int getNotationAttributeIndex() {
        return this.mValidator == null ? -1 : this.mValidator.getNotationAttrIndex();
    }

    public abstract String getNamespaceURI(String var1);

    public abstract String getPrefix(String var1);

    public abstract Iterator getPrefixes(String var1);

    public final String getXmlVersion() {
        return this.mConfig.isXml11() ? "1.1" : "1.0";
    }

    public String getAttributeLocalName(int index) {
        return this.getAttrCollector().getLocalName(index);
    }

    public String getAttributeNamespace(int index) {
        return this.getAttrCollector().getURI(index);
    }

    public String getAttributePrefix(int index) {
        return this.getAttrCollector().getPrefix(index);
    }

    public String getAttributeValue(int index) {
        return this.getAttrCollector().getValue(index);
    }

    public String getAttributeValue(String nsURI, String localName) {
        int ix = this.findAttributeIndex(nsURI, localName);
        return ix < 0 ? null : this.getAttributeValue(ix);
    }

    public boolean isNotationDeclared(String name) {
        return false;
    }

    public boolean isUnparsedEntityDeclared(String name) {
        return false;
    }

    public String getBaseUri() {
        return null;
    }

    public abstract QName getCurrentElementName();

    public Location getValidationLocation() {
        return this.mReporter.getLocation();
    }

    public void reportProblem(XMLValidationProblem problem) throws XMLStreamException {
        this.mReporter.reportValidationProblem(problem);
    }

    public abstract int addDefaultAttribute(String var1, String var2, String var3, String var4);

    public abstract boolean isPrefixLocallyDeclared(String var1);

    public abstract void addNsBinding(String var1, String var2);

    public final void validateText(TextBuffer tb, boolean lastTextSegment) throws XMLStreamException {
        tb.validateText(this.mValidator, lastTextSegment);
    }

    public final void validateText(String contents, boolean lastTextSegment) throws XMLStreamException {
        this.mValidator.validateText(contents, lastTextSegment);
    }

    public abstract boolean isNamespaceAware();

    public abstract int getDepth();

    public abstract boolean isEmpty();

    public abstract String getDefaultNsURI();

    public abstract String getNsURI();

    public abstract String getPrefix();

    public abstract String getLocalName();

    public abstract boolean matches(String var1, String var2);

    public abstract String getTopElementDesc();

    public abstract int getTotalNsCount();

    public abstract int getCurrentNsCount();

    public abstract String getLocalNsPrefix(int var1);

    public abstract String getLocalNsURI(int var1);

    public final String getAttributeType(int index) {
        if (index == this.mIdAttrIndex && index >= 0) {
            return "ID";
        }
        return this.mValidator == null ? "CDATA" : this.mValidator.getAttributeType(index);
    }

    protected final void normalizeXmlIdAttr(AttributeCollector ac, int ix) {
        TextBuilder attrBuilder = ac.getAttrBuilder();
        char[] attrCB = attrBuilder.getCharBuffer();
        String normValue = StringUtil.normalizeSpaces((char[])attrCB, (int)attrBuilder.getOffset(ix), (int)attrBuilder.getOffset(ix + 1));
        if (normValue != null) {
            ac.setNormalizedValue(ix, normValue);
        }
    }
}

