/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

import com.ctc.wstx.util.WordResolver;
import java.util.TreeSet;

public final class WordResolver {
    public static final int MAX_WORDS = 8192;
    static final char CHAR_NULL = '\u0000';
    static final int NEGATIVE_OFFSET = 57344;
    static final int MIN_BINARY_SEARCH = 7;
    final char[] mData;
    final String[] mWords;

    private WordResolver(String[] words, char[] index) {
        this.mWords = words;
        this.mData = index;
    }

    public static WordResolver constructInstance(TreeSet wordSet) {
        if (wordSet.size() > 8192) {
            return null;
        }
        return new Builder(wordSet).construct();
    }

    public int size() {
        return this.mWords.length;
    }

    public String find(char[] str, int start, int end) {
        char[] data = this.mData;
        if (data == null) {
            return this.findFromOne(str, start, end);
        }
        int ptr = 0;
        int offset = start;
        block0: do {
            if (offset == end) {
                if (data[ptr + 1] == '\u0000') {
                    return this.mWords[data[ptr + 2] - 57344];
                }
                return null;
            }
            char count = data[ptr++];
            char c = str[offset++];
            if (count < '\u0007') {
                if (data[ptr] == c) {
                    ptr = data[ptr + 1];
                    continue;
                }
                if (data[ptr + 2] == c) {
                    ptr = data[ptr + 3];
                    continue;
                }
                int branchEnd = ptr + (count << 1);
                ptr += 4;
                while (ptr < branchEnd) {
                    if (data[ptr] == c) {
                        ptr = data[ptr + 1];
                        continue block0;
                    }
                    ptr += 2;
                }
                return null;
            }
            int low = 0;
            int high = count - '\u0001';
            while (low <= high) {
                int mid = low + high >> 1;
                int ix = ptr + (mid << 1);
                int diff = data[ix] - c;
                if (diff > 0) {
                    high = mid - 1;
                    continue;
                }
                if (diff < 0) {
                    low = mid + 1;
                    continue;
                }
                ptr = data[ix + 1];
                continue block0;
            }
            return null;
        } while (ptr < 57344);
        String word = this.mWords[ptr - 57344];
        int expLen = end - start;
        if (word.length() != expLen) {
            return null;
        }
        int i = offset - start;
        while (offset < end) {
            if (word.charAt(i) != str[offset]) {
                return null;
            }
            ++i;
            ++offset;
        }
        return word;
    }

    private String findFromOne(char[] str, int start, int end) {
        String word = this.mWords[0];
        int len = end - start;
        if (word.length() != len) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            if (word.charAt(i) == str[start + i]) continue;
            return null;
        }
        return word;
    }

    public String find(String str) {
        char[] data = this.mData;
        if (data == null) {
            String word = this.mWords[0];
            return word.equals(str) ? word : null;
        }
        int ptr = 0;
        int offset = 0;
        int end = str.length();
        block0: do {
            if (offset == end) {
                if (data[ptr + 1] == '\u0000') {
                    return this.mWords[data[ptr + 2] - 57344];
                }
                return null;
            }
            char count = data[ptr++];
            char c = str.charAt(offset++);
            if (count < '\u0007') {
                if (data[ptr] == c) {
                    ptr = data[ptr + 1];
                    continue;
                }
                if (data[ptr + 2] == c) {
                    ptr = data[ptr + 3];
                    continue;
                }
                int branchEnd = ptr + (count << 1);
                ptr += 4;
                while (ptr < branchEnd) {
                    if (data[ptr] == c) {
                        ptr = data[ptr + 1];
                        continue block0;
                    }
                    ptr += 2;
                }
                return null;
            }
            int low = 0;
            int high = count - '\u0001';
            while (low <= high) {
                int mid = low + high >> 1;
                int ix = ptr + (mid << 1);
                int diff = data[ix] - c;
                if (diff > 0) {
                    high = mid - 1;
                    continue;
                }
                if (diff < 0) {
                    low = mid + 1;
                    continue;
                }
                ptr = data[ix + 1];
                continue block0;
            }
            return null;
        } while (ptr < 57344);
        String word = this.mWords[ptr - 57344];
        if (word.length() != str.length()) {
            return null;
        }
        while (offset < end) {
            if (word.charAt(offset) != str.charAt(offset)) {
                return null;
            }
            ++offset;
        }
        return word;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(16 + (this.mWords.length << 3));
        int len = this.mWords.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.mWords[i]);
        }
        return sb.toString();
    }
}

