/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.typed;

import org.codehaus.stax2.ri.typed.ValueEncoderFactory;
import org.codehaus.stax2.typed.Base64Variant;

public final class ValueEncoderFactory {
    static final byte BYTE_SPACE = 32;
    protected TokenEncoder _tokenEncoder = null;
    protected IntEncoder _intEncoder = null;
    protected LongEncoder _longEncoder = null;
    protected FloatEncoder _floatEncoder = null;
    protected DoubleEncoder _doubleEncoder = null;

    public ScalarEncoder getScalarEncoder(String value) {
        if (value.length() > 64) {
            if (this._tokenEncoder == null) {
                this._tokenEncoder = new TokenEncoder();
            }
            this._tokenEncoder.reset(value);
            return this._tokenEncoder;
        }
        return new StringEncoder(value);
    }

    public ScalarEncoder getEncoder(boolean value) {
        return this.getScalarEncoder(value ? "true" : "false");
    }

    public IntEncoder getEncoder(int value) {
        if (this._intEncoder == null) {
            this._intEncoder = new IntEncoder();
        }
        this._intEncoder.reset(value);
        return this._intEncoder;
    }

    public LongEncoder getEncoder(long value) {
        if (this._longEncoder == null) {
            this._longEncoder = new LongEncoder();
        }
        this._longEncoder.reset(value);
        return this._longEncoder;
    }

    public FloatEncoder getEncoder(float value) {
        if (this._floatEncoder == null) {
            this._floatEncoder = new FloatEncoder();
        }
        this._floatEncoder.reset(value);
        return this._floatEncoder;
    }

    public DoubleEncoder getEncoder(double value) {
        if (this._doubleEncoder == null) {
            this._doubleEncoder = new DoubleEncoder();
        }
        this._doubleEncoder.reset(value);
        return this._doubleEncoder;
    }

    public IntArrayEncoder getEncoder(int[] values, int from, int length) {
        return new IntArrayEncoder(values, from, from + length);
    }

    public LongArrayEncoder getEncoder(long[] values, int from, int length) {
        return new LongArrayEncoder(values, from, from + length);
    }

    public FloatArrayEncoder getEncoder(float[] values, int from, int length) {
        return new FloatArrayEncoder(values, from, from + length);
    }

    public DoubleArrayEncoder getEncoder(double[] values, int from, int length) {
        return new DoubleArrayEncoder(values, from, from + length);
    }

    public Base64Encoder getEncoder(Base64Variant v, byte[] data, int from, int length) {
        return new Base64Encoder(v, data, from, from + length);
    }
}

