/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CollatingIterator
implements Iterator {
    private Comparator comparator = null;
    private ArrayList iterators = null;
    private ArrayList values = null;
    private BitSet valueSet = null;
    private int lastReturned = -1;

    public CollatingIterator() {
        this(null, 2);
    }

    public CollatingIterator(Comparator comp) {
        this(comp, 2);
    }

    public CollatingIterator(Comparator comp, int initIterCapacity) {
        this.iterators = new ArrayList(initIterCapacity);
        this.setComparator(comp);
    }

    public CollatingIterator(Comparator comp, Iterator a, Iterator b) {
        this(comp, 2);
        this.addIterator(a);
        this.addIterator(b);
    }

    public CollatingIterator(Comparator comp, Iterator[] iterators) {
        this(comp, iterators.length);
        int i = 0;
        while (i < iterators.length) {
            this.addIterator(iterators[i]);
            ++i;
        }
    }

    public CollatingIterator(Comparator comp, Collection iterators) {
        this(comp, iterators.size());
        Iterator it = iterators.iterator();
        while (it.hasNext()) {
            Iterator item = (Iterator)it.next();
            this.addIterator(item);
        }
    }

    public void addIterator(Iterator iterator) {
        this.checkNotStarted();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iterators.add(iterator);
    }

    public void setIterator(int index, Iterator iterator) throws IndexOutOfBoundsException {
        this.checkNotStarted();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iterators.set(index, iterator);
    }

    public List getIterators() {
        return Collections.unmodifiableList(this.iterators);
    }

    public void setComparator(Comparator comp) {
        this.checkNotStarted();
        this.comparator = comp;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public boolean hasNext() {
        this.start();
        return this.anyValueSet(this.valueSet) || this.anyHasNext(this.iterators);
    }

    public Object next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int leastIndex = this.least();
        if (leastIndex == -1) {
            throw new NoSuchElementException();
        }
        Object val = this.values.get(leastIndex);
        this.clear(leastIndex);
        this.lastReturned = leastIndex;
        return val;
    }

    public void remove() {
        if (-1 == this.lastReturned) {
            throw new IllegalStateException("No value can be removed at present");
        }
        Iterator iter = (Iterator)this.iterators.get(this.lastReturned);
        iter.remove();
    }

    private void start() {
        if (null == this.values) {
            this.values = new ArrayList(this.iterators.size());
            this.valueSet = new BitSet(this.iterators.size());
            int i = 0;
            while (i < this.iterators.size()) {
                this.values.add(null);
                this.valueSet.clear(i);
                ++i;
            }
        }
    }

    private boolean set(int i) {
        Iterator iter = (Iterator)this.iterators.get(i);
        if (iter.hasNext()) {
            this.values.set(i, iter.next());
            this.valueSet.set(i);
            return true;
        }
        this.values.set(i, null);
        this.valueSet.clear(i);
        return false;
    }

    private void clear(int i) {
        this.values.set(i, null);
        this.valueSet.clear(i);
    }

    private void checkNotStarted() throws IllegalStateException {
        if (null != this.values) {
            throw new IllegalStateException("Can't do that after next or hasNext has been called.");
        }
    }

    private int least() throws IllegalStateException {
        int leastIndex = -1;
        Object leastObject = null;
        int i = 0;
        while (i < this.values.size()) {
            if (!this.valueSet.get(i)) {
                this.set(i);
            }
            if (this.valueSet.get(i)) {
                if (leastIndex == -1) {
                    leastIndex = i;
                    leastObject = this.values.get(i);
                } else {
                    Object curObject = this.values.get(i);
                    if (this.comparator.compare(curObject, leastObject) < 0) {
                        leastObject = curObject;
                        leastIndex = i;
                    }
                }
            }
            ++i;
        }
        return leastIndex;
    }

    private boolean anyValueSet(BitSet set) {
        int i = 0;
        while (i < set.size()) {
            if (set.get(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean anyHasNext(ArrayList iters) {
        int i = 0;
        while (i < iters.size()) {
            Iterator iter = (Iterator)iters.get(i);
            if (iter.hasNext()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

