/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.ABCOpCodes;
import adobe.abc.Algorithms;
import adobe.abc.Binding;
import adobe.abc.Block;
import adobe.abc.BuiltinDomain;
import adobe.abc.Domain;
import adobe.abc.Edge;
import adobe.abc.Expr;
import adobe.abc.Handler;
import adobe.abc.LLVMEmitter;
import adobe.abc.Method;
import adobe.abc.Name;
import adobe.abc.Namespace;
import adobe.abc.Nsset;
import adobe.abc.OptimizerConstants;
import adobe.abc.Pair;
import adobe.abc.Symtab;
import adobe.abc.TraceManager;
import adobe.abc.Type;
import adobe.abc.TypeAnalysis;
import adobe.abc.Typeref;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalOptimizer {
    final boolean USE_CALLMETHOD = true;
    final boolean USE_CALLMETHOD_EXACT = true;
    final boolean USE_CONSTRUCTPROP_EXACT = true;
    final boolean STATIC_SUPERS = true;
    final boolean GETPROPCANNUMCONVERT = true;
    final boolean SHOW_CODE = true;
    final boolean SHOW_DOMINATORS = false;
    boolean OUTPUT_DOT = false;
    boolean SHOW_DFG = false;
    boolean STRIP_DEBUG_INFO = false;
    boolean ALLOW_NATIVE_CTORS = false;
    boolean PRESERVE_METHOD_NAMES = !this.STRIP_DEBUG_INFO;
    boolean verbose_mode = false;
    boolean legacy_verifier = false;
    int num_linked_files = 0;
    static final TraceManager tm = null;
    LLVMEmitter m_llvmEmitter;
    static int rtcounter;
    List<Method> ready = new ArrayList<Method>();
    Set<Method> already_processed = new HashSet<Method>();
    static int[] refArgc;

    public boolean useExactStaticCallSites() {
        return this.m_llvmEmitter != null;
    }

    public boolean useExactReturnTypes() {
        return this.m_llvmEmitter != null;
    }

    public boolean useExactSetSlotTypes() {
        return this.m_llvmEmitter != null;
    }

    public boolean emitParameterizedTypes() {
        return this.m_llvmEmitter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] load(String filename) throws IOException {
        FileInputStream in = new FileInputStream(filename);
        try {
            byte[] before = new byte[((InputStream)in).available()];
            ((InputStream)in).read(before);
            byte[] byArray = before;
            return byArray;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    static String unique() {
        return GlobalOptimizer.unique("[]");
    }

    static String unique(String prefix) {
        return prefix + rtcounter++;
    }

    static Namespace uniqueNs(int apiVersion) {
        return Namespace.getVersionedNamespace(8, GlobalOptimizer.unique("ns"), apiVersion);
    }

    static Type OBJECT() {
        return BuiltinDomain.instance().OBJECT();
    }

    static Type FUNCTION() {
        return BuiltinDomain.instance().FUNCTION();
    }

    static Type CLASS() {
        return BuiltinDomain.instance().CLASS();
    }

    static Type ARRAY() {
        return BuiltinDomain.instance().ARRAY();
    }

    static Type INT() {
        return BuiltinDomain.instance().INT();
    }

    static Type UINT() {
        return BuiltinDomain.instance().UINT();
    }

    static Type NUMBER() {
        return BuiltinDomain.instance().NUMBER();
    }

    static Type BOOLEAN() {
        return BuiltinDomain.instance().BOOLEAN();
    }

    static Type STRING() {
        return BuiltinDomain.instance().STRING();
    }

    static Type NAMESPACE() {
        return BuiltinDomain.instance().NAMESPACE();
    }

    static Type XML() {
        return BuiltinDomain.instance().XML();
    }

    static Type XMLLIST() {
        return BuiltinDomain.instance().XMLLIST();
    }

    static Type QNAME() {
        return BuiltinDomain.instance().QNAME();
    }

    static Type NULL() {
        return BuiltinDomain.instance().NULL();
    }

    static Type VOID() {
        return BuiltinDomain.instance().VOID();
    }

    static Type ANY() {
        return BuiltinDomain.instance().ANY();
    }

    void readyType(InputAbc abc, Type t2) {
        if (this.m_llvmEmitter != null) {
            this.m_llvmEmitter.recordType(abc, t2);
        }
        this.readyMethod(t2.init);
        for (Binding b12 : t2.defs.values()) {
            if (b12.method == null) continue;
            this.readyMethod(b12.method);
        }
    }

    void readyMethod(Method m2) {
        GlobalOptimizer.traceEntry("readyMethod");
        GlobalOptimizer.addTraceAttr(m2);
        if (m2.entry != null && !this.already_processed.contains(m2)) {
            if (this.m_llvmEmitter != null) {
                this.m_llvmEmitter.recordMethod(m2);
                if (m2.needActivation() && m2.activation.getType().init != null) {
                    assert (!m2.activation.getType().init.needActivation());
                    this.readyMethod(m2.activation.getType().init);
                }
            }
            GlobalOptimizer.addTraceAttr("process", true);
            this.ready.add(m2);
            this.already_processed.add(m2);
        }
    }

    void optimize(InputAbc a, boolean analyzeOnly) {
        for (Type t2 : a.scripts) {
            this.readyType(a, t2);
        }
        while (!this.ready.isEmpty()) {
            this.optimize(Algorithms.getMethod(this.ready), analyzeOnly);
        }
    }

    int argc(Expr e2) {
        switch (e2.op) {
            case 69: 
            case 70: 
            case 74: 
            case 76: 
            case 78: 
            case 79: {
                return e2.args.length - refArgc[e2.ref.kind] - 1;
            }
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 83: {
                return e2.args.length - 1;
            }
            case 65: {
                return e2.args.length - 2;
            }
            case 86: {
                return e2.args.length;
            }
            case 85: {
                assert (e2.args.length % 2 == 0);
                return e2.args.length / 2;
            }
        }
        assert (false);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] emit(Abc outputAbc, InputAbc a, boolean dumpOutputAbc) throws IOException {
        for (Type s2 : a.scripts) {
            outputAbc.addScript(s2);
        }
        outputAbc.sort();
        String scriptname = a.scriptName();
        byte[] abcBytes = this.emitAbc(outputAbc);
        if (dumpOutputAbc) {
            FileOutputStream out = new FileOutputStream(scriptname + ".abc2");
            try {
                ((OutputStream)out).write(abcBytes);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        return abcBytes;
    }

    byte[] emit(InputAbc a, boolean dumpOutputAbc) throws IOException {
        return this.emit(new Abc(a), a, dumpOutputAbc);
    }

    String boxSetter(Type t2) {
        if (t2 == GlobalOptimizer.INT()) {
            return "Int";
        }
        if (t2 == GlobalOptimizer.UINT()) {
            return "Uint";
        }
        if (t2 == GlobalOptimizer.BOOLEAN()) {
            return "Bool";
        }
        if (t2 == GlobalOptimizer.STRING()) {
            return "String";
        }
        if (t2 == GlobalOptimizer.NAMESPACE()) {
            return "Namespace";
        }
        if (t2 == GlobalOptimizer.NUMBER()) {
            return "Double";
        }
        if (t2.base == null) {
            return "GCObject";
        }
        return "Object";
    }

    byte[] emitAbc(Abc abc) throws IOException {
        AbcWriter w2 = new AbcWriter();
        w2.writeU16(16);
        w2.writeU16(46);
        int pos = w2.size();
        w2.writeU30(abc.intPool.size());
        Iterator<Object> i$ = abc.intPool.values().iterator();
        while (i$.hasNext()) {
            int x2 = i$.next();
            w2.writeU30(x2);
        }
        this.verboseStatus("ints count " + abc.intPool.size() + " size " + (w2.size() - pos));
        pos = w2.size();
        w2.writeU30(abc.uintPool.size());
        i$ = abc.uintPool.values().iterator();
        while (i$.hasNext()) {
            long x3 = (Long)i$.next();
            w2.writeU30((int)x3);
        }
        this.verboseStatus("uints count " + abc.uintPool.size() + " size " + (w2.size() - pos));
        pos = w2.size();
        this.verboseStatus("doubles " + abc.doublePool.size());
        w2.writeU30(abc.doublePool.size());
        i$ = abc.doublePool.values().iterator();
        while (i$.hasNext()) {
            double x4 = (Double)i$.next();
            w2.write64(Double.doubleToLongBits(x4));
        }
        this.verboseStatus("double count " + abc.doublePool.size() + " size " + (w2.size() - pos));
        pos = w2.size();
        w2.writeU30(abc.stringPool.size());
        for (String s2 : abc.stringPool.values()) {
            byte[] b3 = s2.getBytes("UTF-8");
            w2.writeU30(b3.length);
            w2.write(b3);
        }
        this.verboseStatus("strings count " + abc.stringPool.size() + " size " + (w2.size() - pos));
        pos = w2.size();
        w2.writeU30(abc.nsPool.size());
        for (Namespace ns : abc.nsPool.values()) {
            this.emitNamespace(abc, w2, ns);
        }
        this.verboseStatus("ns count " + abc.nsPool.size() + " size " + (w2.size() - pos));
        pos = w2.size();
        w2.writeU30(abc.nssetPool.size());
        for (Nsset nsset : abc.nssetPool.values()) {
            w2.writeU30(nsset.length);
            for (Namespace ns : nsset) {
                w2.writeU30(abc.nsPool.id(ns));
            }
        }
        this.verboseStatus("nsset count " + abc.nssetPool.size() + " size " + (w2.size() - pos));
        pos = w2.size();
        w2.writeU30(abc.namePool.size());
        block15: for (Name n2 : abc.namePool.values()) {
            w2.write(n2.kind);
            switch (n2.kind) {
                case 29: {
                    if (this.emitParameterizedTypes()) {
                        w2.writeU30(abc.namePool.id(n2.getParameterizedTypeName()));
                        w2.writeU30(1);
                        w2.writeU30(abc.namePool.id(n2.getTypeParamName()));
                        continue block15;
                    }
                    throw new IllegalArgumentException("CONSTANT_TypeName is only allowed in an import file.");
                }
                case 7: 
                case 13: {
                    w2.writeU30(abc.nsPool.id(n2.nsset(0)));
                    w2.writeU30(abc.stringPool.id(n2.name));
                    continue block15;
                }
                case 9: 
                case 14: {
                    w2.writeU30(abc.stringPool.id(n2.name));
                    w2.writeU30(abc.nssetPool.id(n2.nsset));
                    continue block15;
                }
                case 15: 
                case 16: {
                    w2.writeU30(abc.stringPool.id(n2.name));
                    continue block15;
                }
                case 27: 
                case 28: {
                    w2.writeU30(abc.nssetPool.id(n2.nsset));
                    continue block15;
                }
                case 17: 
                case 18: {
                    continue block15;
                }
            }
            assert (false);
        }
        this.verboseStatus("name count " + abc.namePool.size() + " size " + (w2.size() - pos));
        pos = w2.size();
        w2.writeU30(abc.nativeMethodPool.size());
        int method_id = 0;
        for (Method m2 : abc.nonNativeMethodPool.values()) {
            this.emitMethod(abc, w2, method_id++, m2);
        }
        if (abc.nativeMethodPool != abc.nonNativeMethodPool) {
            for (Method m2 : abc.nativeMethodPool.values()) {
                this.emitMethod(abc, w2, method_id++, m2);
            }
        }
        w2.writeU30(abc.metaPool.size());
        for (Metadata md : abc.metaPool.values()) {
            this.verboseStatus("Metadata: " + md.name + "(" + abc.stringPool.id(md.name) + ")");
            w2.writeU30(abc.stringPool.id(md.name));
            w2.writeU30(md.attrs.length);
            for (Attr a : md.attrs) {
                w2.writeU30(abc.stringPool.id(a.name()));
            }
            for (Attr a : md.attrs) {
                w2.writeU30(abc.stringPool.id(a.value()));
            }
        }
        w2.writeU30(abc.classes.size());
        for (Type c2 : abc.classes) {
            Type t2 = c2.itype;
            w2.writeU30(abc.namePool.id(t2.getName()));
            w2.writeU30(abc.typeRef(t2.base));
            w2.write(t2.flags);
            if (t2.hasProtectedNs()) {
                w2.writeU30(abc.nsPool.id(t2.protectedNs));
            }
            w2.writeU30(t2.interfaces.length);
            for (Type i2 : t2.interfaces) {
                w2.writeU30(abc.interfaceRef(i2));
            }
            w2.writeU30(abc.methodId(t2.init));
            this.emitTraits(w2, abc, t2);
        }
        for (Type c2 : abc.classes) {
            w2.writeU30(abc.methodId(c2.init));
            this.emitTraits(w2, abc, c2);
        }
        w2.writeU30(abc.scripts.size());
        for (Type s3 : abc.scripts) {
            w2.writeU30(abc.methodId(s3.init));
            this.emitTraits(w2, abc, s3);
        }
        w2.writeU30(abc.bodyCount);
        this.emitBodies(abc, w2, abc.nonNativeMethodPool);
        this.emitBodies(abc, w2, abc.nativeMethodPool);
        return w2.toByteArray();
    }

    void emitNamespace(Abc emitNamespace, AbcWriter w2, Namespace ns) {
        if (ns.isPrivate()) {
            w2.write(5);
            w2.writeU30(0);
        } else {
            w2.write(ns.kind);
            w2.writeU30(emitNamespace.stringPool.id(ns.uri));
        }
    }

    void emitBodies(Abc abc, AbcWriter w2, Algorithms.Pool<Method> pool) throws IOException {
        for (Method m2 : pool.values()) {
            if (m2.entry == null || this.m_llvmEmitter != null && !this.m_llvmEmitter.outputMethodBody(m2)) continue;
            w2.writeU30(m2.emit_id);
            w2.writeU30(m2.max_stack);
            w2.writeU30(m2.local_count);
            if (m2.cx != null && m2.cx.scopes != null) {
                w2.writeU30(m2.cx.scopes.length);
                w2.writeU30(m2.cx.scopes.length + m2.max_scope);
            } else {
                w2.writeU30(0);
                w2.writeU30(m2.max_scope);
            }
            if (this.m_llvmEmitter != null) {
                w2.writeU30(0);
                w2.writeU30(0);
            } else {
                this.emitCode(w2, abc, m2);
            }
            this.emitTraits(w2, abc, m2.activation.t);
        }
    }

    void emitMethod(Abc abc, AbcWriter w2, int method_id, Method m2) {
        m2.emit_id = method_id;
        this.verboseStatus("METHOD " + method_id + " was " + m2.id);
        w2.writeU30(m2.getParams().length - 1);
        w2.writeU30(abc.typeRef(m2.returns));
        int n2 = m2.getParams().length;
        for (int i2 = 1; i2 < n2; ++i2) {
            w2.writeU30(abc.typeRef(m2.getParams()[i2]));
        }
        if (this.PRESERVE_METHOD_NAMES) {
            w2.writeU30(abc.stringPool.id(m2.debugName));
        } else {
            w2.writeU30(0);
        }
        int flags = m2.flags;
        if (this.STRIP_DEBUG_INFO) {
            flags &= 0xFFFFFF7F;
        }
        w2.write(flags);
        if (m2.hasOptional()) {
            w2.writeU30(m2.optional_count);
            for (int j2 = m2.getParams().length - m2.optional_count; j2 < m2.getParams().length; ++j2) {
                int kind = abc.constKind(m2.values[j2]);
                w2.writeU30(abc.constId(kind, m2.values[j2]));
                w2.write(kind);
            }
        }
        if ((flags & 0x80) != 0) {
            for (int i3 = 1; i3 < m2.paramNames.length; ++i3) {
                w2.writeU30(abc.stringPool.id(m2.paramNames[i3].name));
            }
        }
    }

    void emitBlock(AbcWriter out, Block b3, Abc abc) {
        GlobalOptimizer.addTraceAttr("Block", b3);
        block23: for (Expr e2 : b3) {
            if (e2.succ != null) break;
            GlobalOptimizer.traceEntry("Expr", "Expr", e2);
            GlobalOptimizer.addTraceAttr("op", e2.opName());
            GlobalOptimizer.addTraceAttr("pos", out.size());
            out.write(e2.op);
            switch (e2.op) {
                case 50: {
                    out.writeU30(e2.imm[0]);
                    out.writeU30(e2.imm[1]);
                    continue block23;
                }
                case 4: 
                case 5: 
                case 89: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 102: 
                case 104: 
                case 106: 
                case 128: 
                case 134: 
                case 178: {
                    out.writeU30(abc.namePool.id(e2.ref));
                    continue block23;
                }
                case 69: 
                case 70: 
                case 74: 
                case 76: 
                case 78: 
                case 79: {
                    out.writeU30(abc.namePool.id(e2.ref));
                    out.writeU30(this.argc(e2));
                    continue block23;
                }
                case 65: 
                case 66: 
                case 73: 
                case 85: 
                case 86: {
                    out.writeU30(this.argc(e2));
                    continue block23;
                }
                case 98: 
                case 99: {
                    if (e2.imm[0] < 4) {
                        out.rewind(1);
                        out.write((e2.op == 98 ? 208 : 212) + e2.imm[0]);
                        continue block23;
                    }
                }
                case 8: 
                case 90: 
                case 108: 
                case 109: 
                case 146: 
                case 148: 
                case 194: 
                case 195: {
                    out.writeU30(e2.imm[0]);
                    continue block23;
                }
                case 88: {
                    out.writeU30(abc.classId(e2.c));
                    continue block23;
                }
                case 64: {
                    out.writeU30(abc.methodId(e2.m));
                    continue block23;
                }
                case 83: {
                    out.writeU30(this.argc(e2));
                    continue block23;
                }
                case 68: {
                    out.writeU30(abc.methodId(e2.m));
                    out.writeU30(this.argc(e2));
                    continue block23;
                }
                case 37: {
                    out.writeU30(TypeAnalysis.intValue(e2.value));
                    continue block23;
                }
                case 36: {
                    out.write(TypeAnalysis.intValue(e2.value));
                    continue block23;
                }
                case 101: {
                    out.write(e2.imm[0]);
                    continue block23;
                }
                case 6: 
                case 44: {
                    out.writeU30(abc.stringPool.id((String)e2.value));
                    continue block23;
                }
                case 241: {
                    if (this.STRIP_DEBUG_INFO) {
                        throw new RuntimeException("impossible");
                    }
                    out.writeU30(abc.stringPool.id((String)e2.value));
                    continue block23;
                }
                case 49: {
                    out.writeU30(abc.nsPool.id((Namespace)e2.value));
                    continue block23;
                }
                case 45: {
                    out.writeU30(abc.intPool.id(TypeAnalysis.intValue(e2.value)));
                    continue block23;
                }
                case 46: {
                    out.writeU30(abc.uintPool.id(TypeAnalysis.uintValue(e2.value)));
                    continue block23;
                }
                case 47: {
                    out.writeU30(abc.doublePool.id(TypeAnalysis.doubleValue(e2.value)));
                    continue block23;
                }
                case 240: 
                case 242: {
                    if (this.STRIP_DEBUG_INFO) {
                        throw new RuntimeException("impossible");
                    }
                    out.writeU30(e2.imm[0]);
                    continue block23;
                }
                case 239: {
                    if (this.STRIP_DEBUG_INFO) {
                        throw new RuntimeException("impossible");
                    }
                    out.write(e2.imm[0]);
                    out.writeU30(e2.imm[1]);
                    out.write(e2.imm[2]);
                    out.writeU30(e2.imm[3]);
                    continue block23;
                }
            }
            assert (false);
        }
    }

    void emitCode(AbcWriter out, Abc abc, Method m2) throws IOException {
        GlobalOptimizer.addTraceAttr("Method", m2);
        HashMap<Block, Integer> padding = new HashMap<Block, Integer>();
        Algorithms.Deque<Block> code = this.schedule(m2.entry.to);
        HashMap<Block, AbcWriter> writers = new HashMap<Block, AbcWriter>();
        BitSet labels = new BitSet();
        BitSet done = new BitSet();
        for (Block b3 : code) {
            done.set(b3.id);
            for (Edge e2 : b3.succ()) {
                if (!done.get(e2.to.id)) continue;
                labels.set(e2.to.id);
            }
        }
        HashMap<Block, Integer> pos = new HashMap<Block, Integer>();
        HashMap<Block, Integer> blockends = new HashMap<Block, Integer>();
        int code_len = 0;
        Algorithms.ArrayDeque<Block> work = new Algorithms.ArrayDeque<Block>((Collection<Block>)code);
        while (!work.isEmpty()) {
            Block b4 = (Block)work.removeFirst();
            GlobalOptimizer.addTraceAttr("Block", b4);
            GlobalOptimizer.addTraceAttr("pos", code_len);
            pos.put(b4, code_len);
            AbcWriter w2 = new AbcWriter();
            writers.put(b4, w2);
            if (labels.get(b4.id)) {
                GlobalOptimizer.addTraceAttr("hasLabel");
                w2.write(9);
            }
            this.emitBlock(w2, b4, abc);
            code_len += w2.size();
            Expr last = b4.last();
            if (last.succ.length == 0) {
                w2.write(last.op);
                ++code_len;
                GlobalOptimizer.traceEntry("TransferOut", "op", last.opName());
            } else if (this.isJump(last)) {
                GlobalOptimizer.traceEntry("Jump", "target", last.succ[0].to);
                if (work.isEmpty() || last.succ[0].to != work.peekFirst()) {
                    code_len += 4;
                    padding.put(b4, 4);
                    GlobalOptimizer.addTraceAttr("fallThrough", false);
                } else {
                    GlobalOptimizer.addTraceAttr("fallThrough", true);
                }
            } else if (this.isBranch(last)) {
                if (work.isEmpty() || last.succ[0].to != work.peekFirst()) {
                    code_len += 8;
                    padding.put(b4, 8);
                } else {
                    code_len += 4;
                    padding.put(b4, 4);
                }
            } else {
                assert (last.op == 27);
                int switch_size = 1 + out.sizeOfU30(last.succ.length) + 3 * last.succ.length;
                code_len += switch_size;
                padding.put(b4, switch_size);
            }
            blockends.put(b4, code_len);
        }
        out.writeU30(code_len);
        int code_start = out.size();
        GlobalOptimizer.traceEntry("WriteCode", "Start", code_start);
        for (Block b5 : code) {
            GlobalOptimizer.addTraceAttr("Block", b5);
            GlobalOptimizer.addTraceAttr("postorder", b5.postorder);
            GlobalOptimizer.addTraceAttr("startPos", out.size());
            GlobalOptimizer.addTraceAttr("offset", out.size() - code_start);
            ((AbcWriter)writers.get(b5)).writeTo(out);
            if (!padding.containsKey(b5)) continue;
            Expr last = b5.last();
            GlobalOptimizer.addTraceAttr(last);
            GlobalOptimizer.addTraceAttr("op", last.opName());
            GlobalOptimizer.addTraceAttr("padding", padding.get(b5));
            if (this.isBranch(last)) {
                GlobalOptimizer.addTraceAttr("isBranch");
                this.emitBranch(out, last.op, last.succ[1].to, code_start, pos);
                padding.put(b5, (Integer)padding.get(b5) - 4);
            }
            if ((Integer)padding.get(b5) == 4) {
                GlobalOptimizer.traceEntry("ImpliedJump");
                GlobalOptimizer.addTraceAttr("EdgeId", last.succ[0].id);
                this.emitBranch(out, 16, last.succ[0].to, code_start, pos);
            }
            if (last.op != 27) continue;
            this.emitLookupswitch(out, last, code_start, pos);
        }
        int valid_handlers_count = 0;
        for (Handler h2 : m2.handlers) {
            if (h2.entry == null) continue;
            ++valid_handlers_count;
        }
        out.writeU30(valid_handlers_count);
        for (Handler h2 : m2.handlers) {
            if (null == h2.entry) continue;
            int from = code_len;
            int to = 0;
            for (Block b6 : code) {
                for (Edge x2 : b6.xsucc) {
                    if (x2.to != h2.entry) continue;
                    if ((Integer)pos.get(b6) < from) {
                        from = (Integer)pos.get(b6);
                    }
                    if ((Integer)blockends.get(b6) <= to) continue;
                    to = (Integer)blockends.get(b6);
                }
            }
            out.writeU30(from);
            out.writeU30(to);
            int off = (Integer)pos.get(h2.entry);
            this.verboseStatus("handler " + h2.entry + " [" + from + "," + to + ")->" + off);
            out.writeU30(off);
            out.writeU30(abc.typeRef(h2.type));
            if (h2.name != null) {
                out.writeU30(abc.namePool.id(h2.name));
                continue;
            }
            out.writeU30(0);
        }
    }

    void emitBranch(AbcWriter out, int op, Block target, int code_start, Map<Block, Integer> pos) {
        GlobalOptimizer.traceEntry("emitBranch");
        GlobalOptimizer.addTraceAttr("op", Expr.opName(op));
        GlobalOptimizer.addTraceAttr("target", target);
        out.write(op);
        int to = code_start + pos.get(target);
        int from = out.size() + 3;
        GlobalOptimizer.addTraceAttr("to", to);
        GlobalOptimizer.addTraceAttr("from", from);
        GlobalOptimizer.addTraceAttr("offset", to - from);
        out.writeS24(to - from);
    }

    void emitLookupswitch(AbcWriter out, Expr insn_switch, int code_start, Map<Block, Integer> pos) {
        int base_loc = out.size();
        GlobalOptimizer.addTraceAttr("baseLoc", base_loc);
        out.write(27);
        int case_size = insn_switch.succ.length - 2;
        GlobalOptimizer.addTraceAttr("case_size", case_size);
        int default_target = code_start + pos.get(insn_switch.succ[case_size + 1].to) - base_loc;
        GlobalOptimizer.traceEntry("default", "target", default_target);
        GlobalOptimizer.addTraceAttr("Block", insn_switch.succ[case_size + 1].to);
        out.writeS24(default_target);
        out.writeU30(case_size);
        for (int i2 = 0; i2 <= case_size; ++i2) {
            int case_target = code_start + pos.get(insn_switch.succ[i2].to) - base_loc;
            GlobalOptimizer.traceEntry("case", "target", case_target);
            GlobalOptimizer.addTraceAttr("Block", insn_switch.succ[i2].to);
            out.writeS24(case_target);
        }
    }

    void emitTraits(AbcWriter out, Abc abc, Type t2) {
        Symtab<Binding> defs = t2.defs;
        out.writeU30(defs.size());
        for (Binding b3 : defs.values()) {
            out.writeU30(abc.namePool.id(b3.getName()));
            out.write(b3.flags_kind);
            switch (b3.kind()) {
                case 0: 
                case 6: {
                    if (t2.base == null || 0 == t2.base.slotCount) {
                        out.writeU30(b3.slot);
                    } else {
                        out.write(0);
                    }
                    out.writeU30(abc.typeRef(b3.type));
                    if (!b3.defaultValueChanged()) {
                        out.writeU30(0);
                        break;
                    }
                    int kind = abc.constKind(b3.value());
                    int id = abc.constId(kind, b3.value());
                    out.writeU30(id);
                    if (id == 0) break;
                    out.write(kind);
                    break;
                }
                case 4: {
                    out.writeU30(b3.slot);
                    out.writeU30(abc.classId(b3.type.t));
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    out.writeU30(b3.slot);
                    out.writeU30(abc.methodId(b3.method));
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (!b3.hasMetadata()) continue;
            assert (b3.md.length > 0);
            out.writeU30(b3.md.length);
            for (Metadata md : b3.md) {
                out.writeU30(abc.metaPool.id(md));
            }
        }
    }

    void optimize(Method m2, boolean analyzeOnly) {
        this.verboseStatus("OPTIMIZE " + m2.id + " " + m2.getName());
        if (m2.entry == null) {
            return;
        }
        GlobalOptimizer.addTraceAttr("Method", m2);
        this.printMethod(m2, "BEFORE OPT");
        if (this.OUTPUT_DOT) {
            this.dot("-before", m2);
        }
        this.sccp(m2);
        if (this.OUTPUT_DOT) {
            this.dot("-after-sccp", m2);
        }
        if (analyzeOnly) {
            return;
        }
        this.dvn(m2);
        if (this.cfgopt(m2)) {
            this.printMethod(m2, "AFTER CFGOPT");
            this.sccp(m2);
            this.dvn(m2);
        }
        this.fold(m2);
        this.printMethod(m2, "AFTER FOLD");
        this.insert_casts(m2);
        this.remove_phi(m2);
        if (this.OUTPUT_DOT) {
            this.dot("-after", m2);
        }
        if (this.legacy_verifier) {
            this.appeaseLegacyVerifier(m2);
            if (this.OUTPUT_DOT) {
                this.dot("-appeased", m2);
            }
        }
        this.computeFrameCounts(m2);
        if (this.verbose_mode) {
            this.printabc(this.schedule(m2.entry.to));
        }
    }

    void fold(Method m2) {
        Algorithms.Deque<Block> code = Algorithms.dfs(m2.entry.to);
        Algorithms.EdgeMap<Expr> uses = Algorithms.findUses(code);
        for (Block b3 : code) {
            for (Expr e2 : b3) {
                switch (e2.op) {
                    case 17: 
                    case 18: {
                        Expr a02 = e2.args[0];
                        if (!this.containsOnly((Collection)uses.get(a02), (Object)e2)) break;
                        if (a02.op == 150) {
                            this.subsume_arg(e2, e2.op == 17 ? 18 : 17, uses);
                            break;
                        }
                        if (a02.op == 118) {
                            this.subsume_arg(e2, e2.op, uses);
                            break;
                        }
                        if (a02.op == 176) {
                            this.subsume_arg(e2, e2.op == 17 ? 24 : 15, uses);
                            break;
                        }
                        if (a02.op == 175) {
                            this.subsume_arg(e2, e2.op == 17 ? 23 : 14, uses);
                            break;
                        }
                        if (a02.op == 173) {
                            this.subsume_arg(e2, e2.op == 17 ? 21 : 12, uses);
                            break;
                        }
                        if (a02.op == 174) {
                            this.subsume_arg(e2, e2.op == 17 ? 22 : 13, uses);
                            break;
                        }
                        if (a02.op != 172) break;
                        this.subsume_arg(e2, e2.op == 17 ? 25 : 26, uses);
                        break;
                    }
                    case 102: {
                        Expr a02 = e2.args[0];
                        if (!this.containsOnly((Collection)uses.get(a02), (Object)e2) || a02.op != 93 || a02.args.length != 0 || e2.args.length != 1) break;
                        e2.op = 96;
                        e2.args = OptimizerConstants.noexprs;
                        e2.scopes = a02.scopes;
                        a02.setPure();
                        e2.flags |= a02.flags & 8 | a02.flags & 2;
                    }
                }
            }
        }
    }

    int findPhiArg(Expr phi, Edge e2) {
        int n2 = phi.pred.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!phi.pred[i2].equals(e2)) continue;
            return i2;
        }
        assert (false);
        return -1;
    }

    boolean sameExScope(Block b12, Block b22) {
        if (b12 == b22) {
            return true;
        }
        Edge[] xs1 = b12.xsucc;
        Edge[] xs2 = b22.xsucc;
        if (xs1.length != xs2.length) {
            return false;
        }
        int n2 = xs1.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Edge e1 = xs1[i2];
            Edge e2 = xs2[i2];
            if (e1.to == e2.to && e1.handler == e2.handler) continue;
            return false;
        }
        return true;
    }

    boolean cfgopt(Method m2) {
        boolean changed;
        Algorithms.Deque<Block> code = Algorithms.dfs(m2.entry.to);
        Algorithms.SetMap<Block, Edge> pred = Algorithms.allpreds(code);
        boolean changedout = false;
        do {
            changed = false;
            block1: for (Block b3 : code) {
                Block taken;
                Expr last = b3.last();
                if (this.isJump(last) && this.sameExScope(b3, taken = last.succ[0].to)) {
                    Edge s2 = last.succ[0];
                    if (this.containsOnly((Collection)pred.get(taken), (Object)s2) && !taken.must_isolate_block) {
                        assert (taken.first().op != 257);
                        this.verboseStatus("STRAIGHTEN " + s2);
                        b3.remove(last);
                        b3.addAll(taken);
                        for (Edge edge : taken.succ()) {
                            edge.from = b3;
                        }
                        changed = true;
                        this.printabc(b3, new PrintWriter(System.out));
                        break;
                    }
                    Expr first = taken.first();
                    if (first.op == 72 || first.op == 71) {
                        Expr[] exprArray;
                        this.verboseStatus("PRUNE " + b3 + "->" + s2);
                        last.op = first.op;
                        if (first.op == 71) {
                            exprArray = OptimizerConstants.noexprs;
                        } else {
                            Expr[] exprArray2 = new Expr[1];
                            exprArray = exprArray2;
                            exprArray2[0] = first.args[0];
                        }
                        last.args = exprArray;
                        last.succ = OptimizerConstants.noedges;
                        changed = true;
                        break;
                    }
                    if (first.op == 257 && taken.size() == 2) {
                        Expr r2 = taken.last();
                        if (r2.op == 72 && r2.args[0] == first) {
                            this.verboseStatus("PRUNE " + b3 + "->" + s2);
                            int i2 = this.findPhiArg(first, last.succ[0]);
                            last.op = r2.op;
                            last.args = new Expr[]{first.args[i2]};
                            last.succ = OptimizerConstants.noedges;
                            first.removePhiInput(i2);
                            changed = true;
                            break;
                        }
                    }
                }
                if (this.isBranch(last)) {
                    Edge out = last.succ[1];
                    Expr cond = last.args[0];
                    taken = out.to;
                    if (last.args.length == 1 && taken.size() == 2) {
                        Expr phi = taken.first();
                        if (phi.op == 257) {
                            int i3;
                            Expr br2 = taken.last();
                            if ((br2.op == 17 || br2.op == 18) && phi.args[i3 = this.findPhiArg(phi, out)] == cond) {
                                Edge before = br2.op == last.op ? br2.succ[1] : br2.succ[0];
                                this.verboseStatus("SKIPTEST old " + out + " new " + before);
                                phi.removePhiInput(i3);
                                this.copyTargetPhi(phi, cond, before, out);
                                changed = true;
                                break;
                            }
                        }
                    }
                    if (pred.get(last.succ[0].to).size() > 1 && pred.get(taken).size() == 1) {
                        this.invert(last);
                        changed = true;
                        break;
                    }
                }
                for (Edge edge : last.succ) {
                    if (!this.skip(edge)) continue;
                    changed = true;
                    break block1;
                }
            }
            if (!changed) continue;
            this.dce(m2);
            code = Algorithms.dfs(m2.entry.to);
            pred = Algorithms.allpreds(code);
            changedout = true;
        } while (changed);
        return changedout;
    }

    boolean skip(Edge edge) {
        Block to = edge.to;
        Expr j2 = to.last();
        if (to.size() == 1 && this.isJump(j2)) {
            this.verboseStatus("SKIP " + j2.succ[0]);
            this.copyTarget(j2.succ[0], edge);
            return true;
        }
        return false;
    }

    void invert(Expr br2) {
        this.verboseStatus("INVERT " + br2);
        switch (br2.op) {
            case 17: {
                br2.op = 18;
                break;
            }
            case 18: {
                br2.op = 17;
                break;
            }
            case 12: {
                br2.op = 21;
                break;
            }
            case 13: {
                br2.op = 22;
                break;
            }
            case 14: {
                br2.op = 23;
                break;
            }
            case 15: {
                br2.op = 24;
                break;
            }
            case 19: {
                br2.op = 20;
                break;
            }
            case 20: {
                br2.op = 19;
                break;
            }
            case 21: {
                br2.op = 12;
                break;
            }
            case 22: {
                br2.op = 13;
                break;
            }
            case 23: {
                br2.op = 14;
                break;
            }
            case 24: {
                br2.op = 15;
                break;
            }
            case 25: {
                br2.op = 26;
                break;
            }
            case 26: {
                br2.op = 25;
            }
        }
        Edge e0 = br2.succ[0];
        Edge e1 = br2.succ[1];
        e0.label = 1;
        e1.label = 0;
        br2.succ[0] = e1;
        br2.succ[1] = e0;
    }

    int ifoper(int op) {
        switch (op) {
            default: {
                assert (false);
                return 0;
            }
            case 12: 
            case 21: {
                return 173;
            }
            case 13: 
            case 22: {
                return 174;
            }
            case 14: 
            case 23: {
                return 175;
            }
            case 15: 
            case 24: {
                return 176;
            }
            case 19: 
            case 20: {
                return 171;
            }
            case 25: 
            case 26: 
        }
        return 172;
    }

    void copyTarget(Edge before, Edge after) {
        after.to = before.to;
        for (Expr e2 : before.to) {
            if (e2.op != 257) continue;
            e2.append(e2.args[this.findPhiArg(e2, before)], after);
        }
    }

    void copyTargetPhi(Expr phi, Expr a, Edge before, Edge after) {
        after.to = before.to;
        for (Expr e2 : before.to) {
            if (e2.op != 257) break;
            Expr phiArg = e2.args[this.findPhiArg(e2, before)];
            e2.append(phiArg == phi ? a : phiArg, after);
        }
    }

    private <T> boolean containsOnly(Collection<T> c2, T elem) {
        return c2.size() == 1 && c2.contains(elem);
    }

    boolean equiv(Expr[] a, Expr[] b3) {
        if (a == null || b3 == null) {
            return false;
        }
        if (a.length != b3.length) {
            return false;
        }
        for (int i2 = 0; i2 < a.length; ++i2) {
            if (this.equiv(a[i2], b3[i2])) continue;
            return false;
        }
        return true;
    }

    boolean equiv(Expr a, Expr b3) {
        if (a == b3) {
            return true;
        }
        if (a != null && b3 != null && a.op == b3.op) {
            switch (a.op) {
                case 32: 
                case 33: 
                case 38: 
                case 39: 
                case 40: 
                case 208: 
                case 209: 
                case 210: 
                case 211: {
                    return true;
                }
                case 36: 
                case 37: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 49: {
                    return a.value.equals(b3.value);
                }
                case 98: 
                case 256: {
                    return a.imm[0] == b3.imm[0];
                }
                case 100: {
                    return a.scopes.length == 0 && b3.scopes.length == 0 || a.scopes.length > 0 && b3.scopes.length > 0 && this.equiv(a.scopes[0], b3.scopes[0]);
                }
                case 95: {
                    return a.ref.compareTo(b3.ref) == 0;
                }
            }
        }
        return false;
    }

    private void makeCopy(Expr e2, Expr a, Algorithms.EdgeMap<Expr> uses) {
        assert (e2 != a);
        e2.op = 42;
        if (uses != null) {
            Algorithms.removeUses(e2, uses);
        }
        e2.scopes = OptimizerConstants.noexprs;
        e2.args = OptimizerConstants.noexprs;
        e2.locals = new Expr[]{a};
        e2.setPure();
        if (uses != null) {
            Algorithms.addUses(e2, uses);
        }
    }

    private void makeCopy(Expr e2, Expr a) {
        this.makeCopy(e2, a, null);
    }

    private void replaceArgWith(SccpContext ctx, Expr e2, int n2, Expr a) {
        ctx.removeUse(e2, e2.args[n2]);
        e2.args[n2] = a;
        ctx.addUse(e2, a);
        ctx.commit();
    }

    private void replaceArgsWith(SccpContext ctx, Expr e2, Expr[] newargs) {
        for (Expr a : e2.args) {
            ctx.removeUse(e2, a);
        }
        e2.args = newargs;
        for (Expr a : newargs) {
            ctx.addUse(e2, a);
        }
        ctx.commit();
    }

    private void shimExprArg(SccpContext ctx, Expr e2, int op, int argNo) {
        Block b3 = ctx.getBlock(e2);
        Expr newExpr = new Expr(ctx.getMethod(), op, e2.args[argNo]);
        b3.insertExpr(e2, newExpr);
        ctx.addExpr(b3, newExpr);
        for (Expr a : e2.args) {
            ctx.removeUse(e2, a);
        }
        e2.args[argNo] = newExpr;
        for (Expr a : e2.args) {
            ctx.addUse(e2, a);
        }
        ctx.commit();
    }

    void makeNop(Expr e2, Algorithms.EdgeMap<Expr> uses) {
        Algorithms.removeUses(e2, uses);
        e2.op = 2;
        e2.scopes = OptimizerConstants.noexprs;
        e2.locals = OptimizerConstants.noexprs;
        e2.args = e2.locals;
        e2.setPure();
    }

    Expr dvn_find(Expr e2, Block b3, Map<Block, Block> idom) {
        do {
            for (Expr a : b3) {
                if (a == e2) break;
                if (!this.equiv(a, e2)) continue;
                return a;
            }
        } while ((b3 = idom.get(b3)) != null);
        return null;
    }

    void dvn(Method m2) {
        boolean changed;
        Algorithms.Deque<Block> code = Algorithms.dfs(m2.entry.to);
        Map<Block, Block> idom = Algorithms.idoms(code, Algorithms.preds(code));
        do {
            changed = false;
            for (Block b3 : code) {
                for (Expr e2 : b3) {
                    Expr a = this.dvn_find(e2, b3, idom);
                    if (a == null) continue;
                    this.makeCopy(e2, a);
                    changed = true;
                }
            }
            if (!changed) continue;
            this.dce(m2);
        } while (changed);
    }

    boolean constify(Binding b3, SccpContext ctx, Expr e2, Object v2) {
        if (GlobalOptimizer.isConst(b3) && this.constify(e2, v2)) {
            Expr push = Expr.createWithValue(ctx.getMethod(), e2.op, e2.value);
            ctx.getBlock(e2).insertExpr(e2, push);
            e2.ref = b3.type.getType().getName();
            e2.op = e2.ref.equals(GlobalOptimizer.ANY().getName()) ? 130 : 128;
            e2.args = new Expr[]{push};
            ctx.addExpr(ctx.getBlock(e2), push);
            ctx.addUse(e2, push);
            ctx.commit();
            return true;
        }
        return false;
    }

    boolean constify(Expr e2, Object v2) {
        if (v2 != null && v2 != OptimizerConstants.BOTTOM && e2.value == null && !this.hasSideEffect(e2)) {
            if (v2 instanceof Integer) {
                int i2 = TypeAnalysis.intValue(v2);
                e2.op = i2 == (byte)i2 ? 36 : (i2 == (short)i2 ? 37 : 45);
            } else if (v2 instanceof Long) {
                e2.op = 46;
            } else if (v2 instanceof Number) {
                double d2 = TypeAnalysis.doubleValue(v2);
                e2.op = Double.isNaN(d2) ? 40 : 47;
            } else if (v2 instanceof Boolean) {
                e2.op = v2 == Boolean.TRUE ? 38 : 39;
            } else if (v2 instanceof Namespace) {
                e2.op = 49;
            } else if (v2 == OptimizerConstants.UNDEFINED) {
                e2.op = 33;
            } else if (v2 == GlobalOptimizer.NULL()) {
                assert (!e2.onScope());
                e2.op = 32;
            } else {
                assert (v2 instanceof String);
                e2.op = 44;
            }
            e2.pred = OptimizerConstants.noedges;
            e2.locals = OptimizerConstants.noexprs;
            e2.scopes = OptimizerConstants.noexprs;
            e2.args = e2.scopes;
            e2.value = v2;
            return true;
        }
        return false;
    }

    boolean jumpify(Expr e2, Set<Edge> reached) {
        Edge taken = null;
        for (Edge s2 : e2.succ) {
            if (!reached.contains(s2)) continue;
            if (taken == null) {
                taken = s2;
                continue;
            }
            if (s2 == taken) continue;
            taken = null;
            break;
        }
        if (taken != null) {
            e2.op = 16;
            e2.args = OptimizerConstants.noexprs;
            e2.succ = new Edge[]{taken};
            return true;
        }
        return false;
    }

    boolean makeConvert(Expr e2, Type t2, int op, Map<Expr, Typeref> types) {
        e2.op = op;
        e2.args = new Expr[]{e2.args[1]};
        e2.flags = OptimizerConstants.flagTable[op];
        if (TypeAnalysis.type(types, e2.args[0]).isPrimitive()) {
            e2.setPure();
        }
        return true;
    }

    boolean convertify(Expr e2, Binding b02, Type t0, Map<Expr, Typeref> types) {
        if (b02.type != null && e2.args.length == 2) {
            if (b02.type.t.itype == GlobalOptimizer.NUMBER()) {
                return this.makeConvert(e2, GlobalOptimizer.NUMBER(), 117, types);
            }
            if (b02.type.t.itype == GlobalOptimizer.INT()) {
                return this.makeConvert(e2, GlobalOptimizer.INT(), 115, types);
            }
            if (b02.type.t.itype == GlobalOptimizer.UINT()) {
                return this.makeConvert(e2, GlobalOptimizer.UINT(), 116, types);
            }
            if (b02.type.t.itype == GlobalOptimizer.STRING()) {
                return this.makeConvert(e2, GlobalOptimizer.STRING(), 112, types);
            }
            if (b02.type.t.itype == GlobalOptimizer.BOOLEAN()) {
                return this.makeConvert(e2, GlobalOptimizer.BOOLEAN(), 118, types);
            }
            if (t0 != GlobalOptimizer.NULL() && (t0.isDerivedFrom(b02.type.t.itype) || t0 == b02.type.t.itype)) {
                return this.makeConvert(e2, b02.type.t.itype, 128, types);
            }
        }
        return false;
    }

    Expr unwrapScope(Expr e2, int i2, Algorithms.EdgeMap<Expr> uses) {
        boolean needUsesUpdate = false;
        Algorithms.removeUses(e2, uses);
        while (e2.scopes[i2].op == 257) {
            if (!needUsesUpdate) {
                Algorithms.removeUses(e2, uses);
                needUsesUpdate = true;
            }
            assert (e2.scopes[i2].args != null && e2.scopes[i2].args[0] != null);
            e2.scopes[i2] = e2.scopes[i2].args[0];
        }
        if (needUsesUpdate) {
            Algorithms.addUses(e2, uses);
        }
        assert (e2.scopes[i2].onScope());
        return e2.scopes[i2].args[0];
    }

    static Type[] copyOf(Type[] in, int newlen) {
        Type[] out = new Type[newlen];
        if (newlen > in.length) {
            newlen = in.length;
        }
        System.arraycopy(in, 0, out, 0, newlen);
        return out;
    }

    static boolean[] copyOf(boolean[] in, int newlen) {
        boolean[] out = new boolean[newlen];
        if (newlen > in.length) {
            newlen = in.length;
        }
        System.arraycopy(in, 0, out, 0, newlen);
        return out;
    }

    static Typeref[] copyOf(Typeref[] in, int newlen) {
        Typeref[] out = new Typeref[newlen];
        if (newlen > in.length) {
            newlen = in.length;
        }
        System.arraycopy(in, 0, out, 0, newlen);
        return out;
    }

    static Expr[] copyOf(Expr[] in, int newlen) {
        Expr[] out = new Expr[newlen];
        if (newlen > in.length) {
            newlen = in.length;
        }
        System.arraycopy(in, 0, out, 0, newlen);
        return out;
    }

    static Edge[] copyOf(Edge[] in, int newlen) {
        Edge[] out = new Edge[newlen];
        if (newlen > in.length) {
            newlen = in.length;
        }
        System.arraycopy(in, 0, out, 0, newlen);
        return out;
    }

    Expr createExprForValue(Method m2, Object o2) {
        Expr result;
        if (o2 == Boolean.FALSE) {
            result = Expr.createWithValue(m2, 39, Boolean.FALSE);
        } else if (o2 == Boolean.TRUE) {
            result = Expr.createWithValue(m2, 38, Boolean.TRUE);
        } else if (o2 == GlobalOptimizer.NULL()) {
            result = Expr.createWithValue(m2, 32, GlobalOptimizer.NULL());
        } else if (o2 == OptimizerConstants.UNDEFINED) {
            result = Expr.createWithValue(m2, 33, OptimizerConstants.UNDEFINED);
        } else if (o2 instanceof String) {
            result = Expr.createWithValue(m2, 44, (String)o2);
        } else if (o2 instanceof Integer) {
            result = Expr.createWithValue(m2, 45, (Integer)o2);
        } else if (o2 instanceof Long) {
            result = Expr.createWithValue(m2, 46, (Long)o2);
        } else if (o2 instanceof Double) {
            result = Expr.createWithValue(m2, Double.isNaN((Double)o2) ? 40 : 47, (Double)o2);
        } else if (o2 instanceof Namespace) {
            result = Expr.createWithValue(m2, 49, (Namespace)o2);
        } else {
            assert (false);
            return null;
        }
        return result;
    }

    boolean throwsArgumentError(Expr e2, Method m2) {
        assert (e2 != null);
        assert (m2 != null);
        return e2.args.length < m2.params.length - m2.optional_count || e2.args.length > m2.params.length && !m2.needsRest() && !m2.needsArguments();
    }

    void makeStaticCallSiteExact(Method m2, Block b3, SccpContext sccpCtx, Expr e2, Map<Expr, Typeref> types) {
        Expr arg;
        int i2;
        if (m2 == null) {
            m2 = sccpCtx.getMethod();
        } else assert (sccpCtx == null);
        if (b3 == null) {
            b3 = sccpCtx.getBlock(e2);
        } else assert (sccpCtx == null);
        Method callee = e2.m;
        assert (!this.throwsArgumentError(e2, callee));
        LinkedList<Expr> helperExprs = new LinkedList<Expr>();
        Expr[] origArgs = e2.args;
        e2.args = new Expr[callee.params.length + (callee.needsRest() || callee.needsArguments() ? 3 : 0)];
        for (int i3 = origArgs.length; i3 < callee.params.length; ++i3) {
            Object v2 = callee.values != null && callee.values.length > i3 && callee.values[i3] != null ? callee.values[i3] : OptimizerConstants.UNDEFINED;
            Expr ve = this.createExprForValue(m2, v2);
            helperExprs.add(ve);
            e2.args[i3] = ve;
            if (sccpCtx == null) continue;
            sccpCtx.addUse(e2, ve);
            sccpCtx.addExpr(b3, ve);
        }
        int firstCoercedArg = 1;
        for (i2 = 0; i2 < firstCoercedArg; ++i2) {
            arg = origArgs[i2];
            if (callee.params[i2].t == GlobalOptimizer.ANY() || callee.params[i2].t == GlobalOptimizer.OBJECT() || callee.params[i2].t == GlobalOptimizer.ARRAY()) {
                Expr upcast = new Expr(m2, 261, arg);
                upcast.castType = types != null && types.get(arg) != null && types.get((Object)arg).nullable && !callee.params[i2].nullable ? callee.params[i2].nullable() : callee.params[i2];
                e2.args[i2] = upcast;
                helperExprs.add(upcast);
                if (sccpCtx == null) continue;
                sccpCtx.removeUse(e2, arg);
                sccpCtx.addUse(upcast, arg);
                sccpCtx.addUse(e2, upcast);
                sccpCtx.addExpr(b3, upcast);
                continue;
            }
            e2.args[i2] = arg;
        }
        for (i2 = firstCoercedArg; i2 < callee.params.length; ++i2) {
            arg = i2 < origArgs.length ? origArgs[i2] : e2.args[i2];
            Expr coerce = new Expr(m2, 128, arg);
            if (callee.params[i2].t == GlobalOptimizer.ANY()) {
                coerce.op = 130;
            } else {
                coerce.ref = callee.params[i2].t.name;
            }
            helperExprs.add(coerce);
            Expr upcast = new Expr(m2, 261, coerce);
            upcast.castType = callee.params[i2];
            helperExprs.add(upcast);
            e2.args[i2] = upcast;
            if (sccpCtx == null) continue;
            sccpCtx.removeUse(e2, arg);
            sccpCtx.addUse(coerce, arg);
            sccpCtx.addUse(upcast, coerce);
            sccpCtx.addUse(e2, upcast);
            sccpCtx.addExpr(b3, coerce);
            sccpCtx.addExpr(b3, upcast);
        }
        if (callee.needsRest()) {
            Expr rest;
            if (callee.params.length < origArgs.length) {
                int naCount = origArgs.length - callee.params.length;
                Expr[] naArgs = new Expr[naCount];
                System.arraycopy(origArgs, callee.params.length, naArgs, 0, naCount);
                rest = new Expr(m2, 86, naArgs);
                if (sccpCtx != null) {
                    for (Expr na : naArgs) {
                        sccpCtx.removeUse(e2, na);
                        sccpCtx.addUse(rest, na);
                    }
                }
            } else {
                rest = new Expr(m2, 86, new Expr[0]);
            }
            Expr argv = new Expr(m2, 263, rest);
            Expr argc = new Expr(m2, 264, rest);
            helperExprs.add(rest);
            helperExprs.add(argv);
            helperExprs.add(argc);
            e2.args[callee.params.length] = argv;
            e2.args[callee.params.length + 1] = argc;
            e2.args[callee.params.length + 2] = rest;
            if (sccpCtx != null) {
                sccpCtx.addUse(e2, rest);
                sccpCtx.addUse(e2, argv);
                sccpCtx.addUse(e2, argc);
                sccpCtx.addUse(argv, rest);
                sccpCtx.addUse(argc, rest);
                sccpCtx.addExpr(b3, rest);
                sccpCtx.addExpr(b3, argv);
                sccpCtx.addExpr(b3, argc);
            }
        } else if (callee.needsArguments()) {
            Expr[] naArgs = new Expr[origArgs.length - 1];
            System.arraycopy(origArgs, 1, naArgs, 0, origArgs.length - 1);
            Expr arguments = new Expr(m2, 86, naArgs);
            Expr argv = new Expr(m2, 263, arguments);
            Expr argc = new Expr(m2, 264, arguments);
            helperExprs.add(arguments);
            helperExprs.add(argv);
            helperExprs.add(argc);
            e2.args[callee.params.length] = argv;
            e2.args[callee.params.length + 1] = argc;
            e2.args[callee.params.length + 2] = arguments;
            if (sccpCtx != null) {
                for (Expr na : naArgs) {
                    sccpCtx.removeUse(e2, na);
                    sccpCtx.addUse(arguments, na);
                }
                sccpCtx.addUse(e2, arguments);
                sccpCtx.addUse(e2, argv);
                sccpCtx.addUse(e2, argc);
                sccpCtx.addUse(argv, arguments);
                sccpCtx.addUse(argc, arguments);
                sccpCtx.addExpr(b3, arguments);
                sccpCtx.addExpr(b3, argv);
                sccpCtx.addExpr(b3, argc);
            }
            Expr setCallee = new Expr(m2, 262);
            setCallee.args = new Expr[]{arguments, e2.args[0]};
            if (sccpCtx != null) {
                sccpCtx.addUse(setCallee, setCallee.args[0]);
                sccpCtx.addUse(setCallee, setCallee.args[1]);
                sccpCtx.addExpr(b3, setCallee);
            }
            helperExprs.add(setCallee);
        }
        if (helperExprs.size() > 0) {
            b3.insertExprs(e2, helperExprs);
        }
        if (sccpCtx != null) {
            sccpCtx.commit();
        }
    }

    void sccp(Method m2) {
        GlobalOptimizer.addTraceAttr("Method", m2);
        TreeMap<Expr, Object> values = new TreeMap<Expr, Object>();
        TreeMap<Expr, Typeref> types = new TreeMap<Expr, Typeref>();
        TreeSet<Edge> reached = new TreeSet<Edge>();
        Algorithms.Deque<Block> code = Algorithms.dfs(m2.entry.to);
        Algorithms.EdgeMap<Expr> uses = Algorithms.findUses(code);
        this.sccp_analyze(m2, uses, values, types, reached);
        if (this.verbose_mode) {
            this.verboseStatus("REACHED " + reached);
            this.verboseStatus("TYPES " + types);
        }
        this.sccp_cfgopt(values, types, reached);
        this.dce(m2);
        code = Algorithms.dfs(m2.entry.to);
        uses = Algorithms.findUses(code);
        this.sccp_modify(m2, code, uses, values, types);
        this.dce(m2);
        this.prop_null(m2, types);
        if (this.m_llvmEmitter != null) {
            this.m_llvmEmitter.recordMethodTypes(m2, types);
            this.m_llvmEmitter.recordMethodUses(m2, uses);
        }
    }

    void sccp_modify(Method m2, Algorithms.Deque<Block> code, Algorithms.EdgeMap<Expr> uses, Map<Expr, Object> values, Map<Expr, Typeref> types) {
        TreeMap<Expr, Block> blocks = new TreeMap<Expr, Block>();
        Algorithms.ExprWorkQueue work = new Algorithms.ExprWorkQueue(uses);
        for (Block b3 : code) {
            for (Expr e2 : b3) {
                work.add(e2);
                blocks.put(e2, b3);
                assert (b3.hasExpr(e2));
            }
        }
        while (!work.isEmpty()) {
            Expr e3 = Algorithms.getExpr(work);
            this.sccp_modify(m2, blocks, uses, values, types, e3, work);
        }
    }

    void prop_null(Method m2, Map<Expr, Typeref> types) {
        this.prop_null(m2.entry.to, types, new HashSet<Block>(), new HashSet<Expr>());
    }

    void prop_null(Block b3, Map<Expr, Typeref> types, Set<Block> visited, Set<Expr> nullChecked) {
        HashSet<Expr> ncc;
        if (visited.contains(b3)) {
            return;
        }
        visited.add(b3);
        for (Edge succ : b3.xsucc) {
            ncc = new HashSet<Expr>();
            ncc.addAll(nullChecked);
            this.prop_null(succ.to, types, visited, ncc);
        }
        for (Expr e2 : b3.exprs) {
            e2.resetFlags(4096);
            if (!e2.isNullCheck()) continue;
            Expr a02 = e2.args[0];
            while (a02.op == 42) {
                a02 = a02.locals[0];
            }
            if (nullChecked.contains(a02)) {
                e2.clearNullCheck();
                continue;
            }
            nullChecked.add(a02);
        }
        for (Edge succ : b3.succ()) {
            ncc = new HashSet();
            ncc.addAll(nullChecked);
            this.prop_null(succ.to, types, visited, ncc);
        }
    }

    void sccp_cfgopt(Map<Expr, Object> values, Map<Expr, Typeref> types, Set<Edge> reached) {
        TreeSet<Block> blocks = new TreeSet<Block>();
        for (Edge e2 : reached) {
            blocks.add(e2.to);
        }
        for (Block b3 : blocks) {
            for (Expr e3 : b3) {
                if (e3.op == 257) {
                    for (int j2 = e3.pred.length - 1; j2 >= 0; --j2) {
                        Edge p2 = e3.pred[j2];
                        if (reached.contains(p2)) continue;
                        e3.removePhiInput(j2);
                    }
                    continue;
                }
                if (e3.succ != null) {
                    if (e3.succ.length <= 1 || this.jumpify(e3, reached) || e3.op != 27 || b3.size() != 2) continue;
                    Expr phi = b3.first();
                    if (phi.op != 257 || e3.args[0] != phi) continue;
                    for (int i2 = phi.args.length - 1; i2 >= 0; --i2) {
                        Object v2 = values.get(phi.args[i2]);
                        if (!(v2 instanceof Number)) continue;
                        int j3 = TypeAnalysis.intValue(v2);
                        Edge in = phi.pred[i2];
                        Edge out = e3.succ[j3];
                        this.copyTarget(out, in);
                        phi.removePhiInput(i2);
                    }
                    continue;
                }
                if (!e3.isOper() || !e3.onStack()) continue;
                boolean pure = true;
                for (Expr a : e3.args) {
                    if (TypeAnalysis.type(types, a).isPrimitive()) continue;
                    pure = false;
                }
                for (Expr a : e3.locals) {
                    if (TypeAnalysis.type(types, a).isPrimitive()) continue;
                    pure = false;
                }
                if (e3.op == 119 && values.get(e3.args[0]) == GlobalOptimizer.NULL()) {
                    pure = false;
                }
                if (!(e3.op != 120 && e3.op != 89 || BuiltinDomain.instance().isXmlBase(TypeAnalysis.type(types, e3.args[0])))) {
                    pure = false;
                }
                if (e3.op == 179 || e3.op == 177) {
                    pure = false;
                }
                if (pure && e3.op == 180 && types.get((Object)e3.args[1]).nullable) {
                    pure = false;
                }
                if (pure) {
                    e3.setPure();
                }
                this.constify(e3, values.get(e3));
            }
        }
    }

    boolean subsume_arg(Expr e2, int op, Algorithms.EdgeMap<Expr> uses) {
        e2.op = op;
        Expr a = e2.args[0];
        e2.flags |= a.flags & 0xA;
        a.setPure();
        uses.get(a).remove(e2);
        for (Expr x2 : e2.args = GlobalOptimizer.copyOf(a.args, a.args.length)) {
            uses.get(x2).add(e2);
        }
        return true;
    }

    private FindScopeResult findScope(Expr e2, Method m2, Map<Expr, Typeref> types) {
        Binding b3;
        Object st;
        int i2;
        int base = e2.scopes.length == 0 ? 1 : 0;
        for (i2 = e2.scopes.length - 1; i2 >= base; --i2) {
            st = TypeAnalysis.type(types, e2.scopes[i2]);
            b3 = ((Type)st).find(e2.ref);
            if (b3 != null) {
                return new FindScopeResult(types.get(e2.scopes[i2]), e2.scopes[i2], i2);
            }
            if (e2.scopes[i2].op != 28) continue;
            return null;
        }
        assert (i2 < 0);
        for (i2 = m2.cx.scopes.length - 1; i2 >= 1; --i2) {
            st = m2.cx.scopes[i2].t;
            b3 = ((Type)st).find(e2.ref);
            if (b3 != null) {
                return new FindScopeResult(m2.cx.scopes[i2], i2);
            }
            if (!m2.cx.withScopes[i2]) continue;
            return null;
        }
        assert (i2 < 1);
        st = m2.domain().getNamedScript(e2.ref);
        return st == null ? null : new FindScopeResult((Typeref)st, m2.domain().getDefinitionName(e2.ref));
    }

    /*
     * Unable to fully structure code
     */
    void sccp_modify(Method m, Map<Expr, Block> blocks, Algorithms.EdgeMap<Expr> uses, Map<Expr, Object> values, Map<Expr, Typeref> types, Expr e, Algorithms.ExprWorkQueue work) {
        ctx = new SccpContext(m, blocks, uses, values, types, work);
        this.sccp_rename(uses, e, e.args);
        this.sccp_rename(uses, e, e.locals);
        block30: do {
            changed = false;
            switch (e.op) {
                case 88: {
                    c = e.c;
                    c.scopes = GlobalOptimizer.copyOf(m.cx.scopes, m.cx.scopes.length + e.scopes.length);
                    c.withScopes = GlobalOptimizer.copyOf(m.cx.withScopes, m.cx.withScopes.length + e.scopes.length);
                    i = m.cx.scopes.length;
                    for (Expr s : e.scopes) {
                        c.withScopes[i] = s.op == 28;
                        c.scopes[i++] = types.get(s);
                    }
                    this.readyType(m.abc, c);
                    t = c.itype;
                    t.scopes = GlobalOptimizer.copyOf(c.scopes, c.scopes.length + 1);
                    t.withScopes = GlobalOptimizer.copyOf(c.withScopes, c.withScopes.length + 1);
                    t.scopes[c.scopes.length] = c.ref.nonnull();
                    this.readyType(m.abc, t);
                    ** GOTO lbl601
                }
                case 64: {
                    f = e.m;
                    t = new Type(m.getName(), GlobalOptimizer.FUNCTION());
                    t.scopes = GlobalOptimizer.copyOf(m.cx.scopes, m.cx.scopes.length + e.scopes.length);
                    t.withScopes = GlobalOptimizer.copyOf(m.cx.withScopes, m.cx.withScopes.length + e.scopes.length);
                    i = m.cx.scopes.length;
                    for (Expr s : e.scopes) {
                        t.withScopes[i] = s.op == 28;
                        t.scopes[i++] = types.get(s);
                    }
                    f.cx = t;
                    this.readyMethod(f);
                    ** GOTO lbl601
                }
                case 109: {
                    if (this.useExactSetSlotTypes()) {
                        slotValue = e.args[1];
                        slotValueType = TypeAnalysis.type(types, slotValue);
                        obj = e.args[0];
                        objType = TypeAnalysis.type(types, obj);
                        slotType = objType.getSlotType(slotId = e.imm[0]);
                        if (slotType.getType() != slotValueType) {
                            coerce = this.upcast(slotValue, m, slotType.getType());
                            newSlotValue = new Expr(m, 261, coerce);
                            newSlotValue.castType = slotType;
                            ctx.removeUse(e, slotValue);
                            ctx.addUse(coerce, slotValue);
                            ctx.addUse(newSlotValue, coerce);
                            ctx.addUse(e, newSlotValue);
                            setSlotBlock = ctx.getBlock(e);
                            e.args[1] = newSlotValue;
                            ctx.addExprAndInsertBefore(setSlotBlock, e, coerce);
                            ctx.addExprAndInsertBefore(setSlotBlock, e, newSlotValue);
                            changed = true;
                            ctx.commit();
                        }
                    }
                    ** GOTO lbl601
                }
                case 71: {
                    if (this.useExactReturnTypes()) {
                        e.op = 72;
                        loadUndefined = Expr.createWithValue(m, 33, OptimizerConstants.UNDEFINED);
                        ctx.addUse(e, loadUndefined);
                        e.args = new Expr[1];
                        e.args[0] = loadUndefined;
                        returnBlock = ctx.getBlock(e);
                        ctx.addExprAndInsertBefore(returnBlock, e, loadUndefined);
                        ctx.commit();
                        changed = true;
                        break;
                    }
                    ** GOTO lbl601
                }
                case 72: {
                    if (!this.useExactReturnTypes()) {
                        if (TypeAnalysis.type(types, e.args[0]) == GlobalOptimizer.VOID()) {
                            e.op = 71;
                            e.args = OptimizerConstants.noexprs;
                        } else {
                            t0 = TypeAnalysis.type(types, e.args[0]);
                            if (t0.extendsOrIsBase(m.returns.t)) {
                                a0 = e.args[0];
                                if (m.returns.t == GlobalOptimizer.INT() && a0.op == 115) {
                                    uses.get(a0).remove(e);
                                    a0 = e.args[0] = a0.args[0];
                                    uses.get(a0).add(e);
                                }
                            }
                        }
                    } else {
                        argTyperef = types.get(e.args[0]);
                        if (!GlobalOptimizer.$assertionsDisabled && argTyperef == null) {
                            throw new AssertionError();
                        }
                        if (m.returns.getType() != argTyperef.getType()) {
                            coerce = this.upcast(e.args[0], m, m.returns.getType());
                            newArg = new Expr(m, 261, coerce);
                            newArg.castType = m.returns;
                            ctx.removeUse(e, e.args[0]);
                            ctx.addUse(coerce, e.args[0]);
                            ctx.addUse(newArg, coerce);
                            ctx.addUse(e, newArg);
                            returnBlock = ctx.getBlock(e);
                            e.args[0] = newArg;
                            ctx.addExprAndInsertBefore(returnBlock, e, coerce);
                            ctx.addExprAndInsertBefore(returnBlock, e, newArg);
                            ctx.commit();
                            changed = true;
                        }
                    }
                    ** GOTO lbl601
                }
                case 100: {
                    if (m.cx.scopes.length == 0) {
                        this.makeCopy(e, this.unwrapScope(e, 0, uses), uses);
                        changed = true;
                    }
                    ** GOTO lbl601
                }
                case 101: {
                    this.makeCopy(e, this.unwrapScope(e, 0, uses), uses);
                    changed = true;
                    ** GOTO lbl601
                }
                case 179: {
                    t1 = TypeAnalysis.type(types, e.args[1]);
                    if (t1.itype != null && m.domain().containsNamedType(t1.itype)) {
                        e.op = 178;
                        e.ref = t1.itype.getName();
                        e.args = new Expr[]{e.args[0]};
                        e.clearPx();
                        changed = true;
                    }
                    ** GOTO lbl601
                }
                case 178: {
                    if (m.domain().containsNamedType(e.ref)) {
                        e.clearPx();
                    }
                    ** GOTO lbl601
                }
                case 134: {
                    toType = m.domain().resolveTypeName((Name)e.ref, null).ref;
                    if (!GlobalOptimizer.$assertionsDisabled && toType == null) {
                        throw new AssertionError();
                    }
                    fromType = types.get(e.args[0]);
                    if (GlobalOptimizer.asTypeIsCopy(toType, fromType)) {
                        this.makeCopy(e, e.args[0], uses);
                        changed = true;
                    }
                    ** GOTO lbl601
                }
                case 28: 
                case 48: {
                    if (!types.get((Object)e.args[0]).nullable) {
                        e.clearPx();
                    }
                    ** GOTO lbl601
                }
                case 44: 
                case 49: {
                    b = ctx.getBlock(e);
                    canBeMoved = false;
                    for (Expr prec : b) {
                        if (prec == e) break;
                        if (prec.op == 257 || prec.op == 44 || prec.op == 49) continue;
                        canBeMoved = true;
                        break;
                    }
                    if (canBeMoved) {
                        b.remove(e);
                        f = b.firstNonPhi();
                        if (f == null) {
                            b.appendExpr(e);
                        } else {
                            b.insertExprAfter(f, e);
                        }
                    }
                    ** GOTO lbl601
                }
                case 128: {
                    a0 = e.args[0];
                    t = types.get(e);
                    argTypeRef = types.get(a0);
                    if (t == argTypeRef) {
                        this.makeCopy(e, a0, uses);
                        changed = true;
                    } else if (argTypeRef.getType().isDerivedFrom(t.getType())) {
                        e.op = 261;
                        e.ref = null;
                        e.castType = t;
                        changed = true;
                    } else {
                        v0 = values.get(a0);
                        if (!GlobalOptimizer.$assertionsDisabled && v0 == GlobalOptimizer.NULL() && !argTypeRef.nullable) {
                            throw new AssertionError();
                        }
                        if (v0 == GlobalOptimizer.NULL() && t.nullable && t.getType() != GlobalOptimizer.VOID()) {
                            this.makeCopy(e, a0, uses);
                            changed = true;
                        } else {
                            ct = t.getType();
                            if (!GlobalOptimizer.$assertionsDisabled && !ct.extendsOrIsBase(m.domain().getNamedType(e.ref, true)) && ct != GlobalOptimizer.NULL()) {
                                throw new AssertionError();
                            }
                            newOp = 0;
                            if (ct == GlobalOptimizer.OBJECT()) {
                                newOp = 137;
                            } else if (ct == GlobalOptimizer.UINT()) {
                                newOp = 116;
                            } else if (ct == GlobalOptimizer.INT()) {
                                newOp = 115;
                            } else if (ct == GlobalOptimizer.NUMBER()) {
                                newOp = 117;
                            } else if (ct == GlobalOptimizer.STRING()) {
                                newOp = 133;
                            } else if (ct == GlobalOptimizer.BOOLEAN()) {
                                newOp = 118;
                            } else if (ct == GlobalOptimizer.ANY()) {
                                newOp = 130;
                            }
                            if (newOp != 0) {
                                e.op = newOp;
                                e.clearEffect();
                                e.ref = null;
                                e.imm = null;
                                changed = true;
                            }
                        }
                    }
                    ** GOTO lbl601
                }
                case 93: 
                case 94: {
                    fsr = this.findScope(e, m, types);
                    definitionName = fsr != null ? fsr.definitionName() : null;
                    v0 = soe = fsr != null ? fsr.scopeObjectExpr() : null;
                    if (soe != null) {
                        this.makeCopy(e, soe);
                        changed = true;
                    } else if (definitionName != null) {
                        e.op = 95;
                        e.flags = OptimizerConstants.flagTable[e.op];
                        for (Expr s : e.scopes) {
                            uses.get(s).remove(e);
                        }
                        e.scopes = OptimizerConstants.noexprs;
                        e.ref = definitionName;
                        changed = true;
                    } else if (fsr != null && (sot = fsr.scopeObjectType()) != null && fsr.scopeIndex() > 0) {
                        e.op = 103;
                        e.flags = OptimizerConstants.flagTable[e.op];
                        e.imm = new int[]{fsr.scopeIndex()};
                        changed = true;
                    }
                    ** GOTO lbl601
                }
                case 4: 
                case 102: {
                    t0 = types.get(e.args[0]);
                    if (e.op == 4) {
                        t0 = t0.t.base.ref.exact();
                    }
                    if (e.op == 102 && t0.t.isInterface() && (b0 = t0.findGetOnInterface(e.ref)) != null && GlobalOptimizer.isGetter(b0)) {
                        m0 = b0.method;
                        if (!this.throwsArgumentError(e, m0)) {
                            e.op = 77;
                            e.ref = b0.getName();
                            e.m = m0;
                            if (this.useExactStaticCallSites()) {
                                this.makeStaticCallSiteExact(null, null, ctx, e, types);
                            }
                            changed = true;
                        }
                    } else if (!BuiltinDomain.instance().isXmlBase(t0.getType())) {
                        bind = t0.findGet(e.ref);
                        if (GlobalOptimizer.isSlot(bind)) {
                            e.clearEffect();
                            if (!t0.nullable) {
                                e.clearPx();
                            }
                            e.ref = bind.getName();
                            if (bind.hasSlot()) {
                                if (!this.constify(bind, ctx, e, values.get(e))) {
                                    e.op = 108;
                                    e.imm = new int[]{bind.slot};
                                }
                                changed = true;
                            }
                        } else if (e.op == 4 && GlobalOptimizer.isGetter(bind) || e.op == 102 && !GlobalOptimizer.methodFromObjectOrClass(bind) && GlobalOptimizer.isGetter(bind) && (TypeAnalysis.type(types, e.args[0]).isFinal() || bind.isFinal())) {
                            m0 = bind.method;
                            if (!this.throwsArgumentError(e, m0)) {
                                e.op = 68;
                                e.m = m0;
                                if (this.useExactStaticCallSites()) {
                                    this.makeStaticCallSiteExact(null, null, ctx, e, types);
                                }
                                changed = true;
                            }
                        } else if (e.op == 102 && GlobalOptimizer.isGetter(bind) && bind.hasSlot()) {
                            m0 = ctx.getType((Expr)e.args[0]).t.findMethod((int)bind.slot).method;
                            if (!this.throwsArgumentError(e, m0)) {
                                e.op = 67;
                                e.imm = new int[]{bind.slot};
                                e.m = m0;
                                if (this.useExactStaticCallSites()) {
                                    this.makeStaticCallSiteExact(null, null, ctx, e, types);
                                }
                                changed = true;
                            }
                        } else if (bind != null && !e.ref.equals(bind.getName())) {
                            e.ref = bind.getName();
                            changed = true;
                        }
                    }
                    ** GOTO lbl601
                }
                case 104: {
                    t0 = TypeAnalysis.type(types, e.args[0]);
                    v1 = values.get(e.args[1]);
                    bind = t0.find(e.ref);
                    if (bind != null && (!GlobalOptimizer.isConst(bind) || m == t0.init && t0.isLocalBinding(bind.getName()))) {
                        e.ref = bind.getName();
                        if (GlobalOptimizer.isConst(bind) && bind.value() != null && bind.value().equals(v1)) {
                            this.makeNop(e, uses);
                            changed = true;
                        } else if (GlobalOptimizer.isSlot(bind) && bind.hasSlot() && !GlobalOptimizer.isClass(bind)) {
                            e.op = 109;
                            e.imm = new int[]{bind.slot};
                            changed = true;
                        }
                    }
                    ** GOTO lbl601
                }
                case 5: 
                case 97: {
                    t0 = types.get(e.args[0]);
                    if (e.op == 5) {
                        t0 = t0.t.base.ref.exact();
                    }
                    if (e.op == 97 && t0.t.isInterface() && (b0 = t0.findSetOnInterface(e.ref)) != null && GlobalOptimizer.isSetter(b0)) {
                        m0 = b0.method;
                        if (!this.throwsArgumentError(e, m0)) {
                            e.op = 77;
                            e.ref = b0.getName();
                            e.m = m0;
                            if (this.useExactStaticCallSites()) {
                                this.makeStaticCallSiteExact(null, null, ctx, e, types);
                            }
                            changed = true;
                        }
                    } else if (!BuiltinDomain.instance().isXmlBase(t0.getType())) {
                        bind = t0.findSet(e.ref);
                        if (GlobalOptimizer.isSlot(bind)) {
                            e.ref = bind.getName();
                            if (bind.hasSlot() && !GlobalOptimizer.isConst(bind) && !GlobalOptimizer.isClass(bind)) {
                                e.op = 109;
                                e.imm = new int[]{bind.slot};
                                changed = true;
                            }
                        } else if (e.op == 5 && GlobalOptimizer.isSetter(bind) || e.op == 97 && !GlobalOptimizer.methodFromObjectOrClass(bind) && GlobalOptimizer.isSetter(bind) && (TypeAnalysis.type(types, e.args[0]).isFinal() || bind.isFinal())) {
                            m0 = bind.method;
                            if (!this.throwsArgumentError(e, m0)) {
                                e.op = 68;
                                e.m = m0;
                                if (this.useExactStaticCallSites()) {
                                    this.makeStaticCallSiteExact(null, null, ctx, e, types);
                                }
                                changed = true;
                            }
                        } else if (e.op == 97 && GlobalOptimizer.isSetter(bind) && bind.hasSlot()) {
                            m0 = ctx.getType((Expr)e.args[0]).t.findMethod((int)bind.slot).method;
                            if (!this.throwsArgumentError(e, m0)) {
                                e.op = 67;
                                e.imm = new int[]{bind.slot};
                                e.m = m0;
                                if (this.useExactStaticCallSites()) {
                                    this.makeStaticCallSiteExact(null, null, ctx, e, types);
                                }
                                changed = true;
                            }
                        } else if (bind != null && !e.ref.equals(bind.getName())) {
                            e.ref = bind.getName();
                            changed = true;
                        }
                    }
                    ** GOTO lbl601
                }
                case 69: 
                case 70: 
                case 74: 
                case 76: 
                case 78: 
                case 79: {
                    t0 = types.get(e.args[0]);
                    if (e.op == 69 || e.op == 78) {
                        t0 = t0.t.base.ref.exact();
                    }
                    if (e.op != 70 && e.op != 79 || !t0.t.isInterface() || (b0 = t0.findGetOnInterface(e.ref)) == null || b0.isGetter() && b0.method.returns == GlobalOptimizer.FUNCTION().ref) ** GOTO lbl358
                    m0 = b0.method;
                    if (!this.throwsArgumentError(e, m0)) {
                        e.op = 77;
                        e.ref = b0.getName();
                        e.m = m0;
                        if (this.useExactStaticCallSites()) {
                            this.makeStaticCallSiteExact(null, null, ctx, e, types);
                        }
                        changed = true;
                    }
                    ** GOTO lbl601
lbl358:
                    // 1 sources

                    b0 = t0.findGet(e.ref);
                    if (b0 == null) ** GOTO lbl406
                    if (e.op != 74 || b0.kind() != 4 || !GlobalOptimizer.isSlot(b0) || GlobalOptimizer.isNativeClass(b0)) ** GOTO lbl368
                    init = b0.type.t.itype.init;
                    if (init.params[0].t.isPrimitive() || this.throwsArgumentError(e, init)) ** GOTO lbl368
                    e.m = init;
                    e.imm = new int[]{b0.slot};
                    if (this.useExactStaticCallSites()) {
                        this.makeStaticCallSiteExact(null, null, ctx, e, types);
                    }
                    ** GOTO lbl601
lbl368:
                    // 2 sources

                    e.ref = b0.getName();
                    if (e.op != 70 && e.op != 79 || !GlobalOptimizer.isMethod(b0)) ** GOTO lbl394
                    if (!t0.getType().isPrimitive() || e.args.length != 1 || !e.ref.equals(b0.abc.domain().AS3_TOSTRING) || TypeAnalysis.type(types, e) != GlobalOptimizer.STRING()) ** GOTO lbl375
                    e.op = 112;
                    e.setPure();
                    changed = true;
                    ** GOTO lbl406
lbl375:
                    // 1 sources

                    if (!t0.getType().isFinal() && !b0.isFinal() || GlobalOptimizer.methodFromObjectOrClass(b0)) ** GOTO lbl384
                    m0 = b0.method;
                    if (this.throwsArgumentError(e, m0)) ** GOTO lbl601
                    e.op = 68;
                    e.m = m0;
                    if (this.useExactStaticCallSites()) {
                        this.makeStaticCallSiteExact(null, null, ctx, e, types);
                    }
                    changed = true;
                    ** GOTO lbl406
lbl384:
                    // 1 sources

                    if (!b0.hasSlot()) ** GOTO lbl406
                    m0 = ctx.getType((Expr)e.args[0]).t.findMethod((int)b0.slot).method;
                    if (this.throwsArgumentError(e, m0) || t0 == GlobalOptimizer.OBJECT().ref) ** GOTO lbl601
                    e.op = 67;
                    e.imm = new int[]{b0.slot};
                    e.m = m0;
                    if (this.useExactStaticCallSites()) {
                        this.makeStaticCallSiteExact(null, null, ctx, e, types);
                    }
                    changed = true;
                    ** GOTO lbl406
lbl394:
                    // 1 sources

                    if (e.op != 70 || !GlobalOptimizer.isClass(b0)) ** GOTO lbl398
                    if (e.args.length > 1) {
                        changed |= this.convertify(e, b0, types.get((Object)e.args[1]).t, types);
                    }
                    ** GOTO lbl406
lbl398:
                    // 1 sources

                    if (e.op != 69 && e.op != 78 || !GlobalOptimizer.isMethod(b0)) ** GOTO lbl406
                    m0 = b0.method;
                    if (this.throwsArgumentError(e, m0)) ** GOTO lbl601
                    e.op = 68;
                    e.m = m0;
                    if (this.useExactStaticCallSites()) {
                        this.makeStaticCallSiteExact(null, null, ctx, e, types);
                    }
                    changed = true;
lbl406:
                    // 8 sources

                    if (uses.get(e).isEmpty()) {
                        if (e.op == 69) {
                            e.op = 78;
                        }
                        if (e.op == 70) {
                            e.op = 79;
                        }
                    }
                    ** GOTO lbl601
                }
                case 112: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 130: 
                case 133: 
                case 137: {
                    t = TypeAnalysis.type(types, e);
                    a0 = e.args[0];
                    t0 = TypeAnalysis.type(types, a0);
                    if (t == t0) {
                        this.makeCopy(e, a0, uses);
                        changed = true;
                    } else if (e.op == 137) {
                        if (values.get(e) == GlobalOptimizer.NULL()) {
                            e.op = 32;
                            e.imm = null;
                            e.args = OptimizerConstants.noexprs;
                            e.value = GlobalOptimizer.NULL();
                            e.flags = OptimizerConstants.flagTable[32];
                            changed = true;
                        }
                    } else if (e.op == 115) {
                        if (a0.op == 116) {
                            this.replaceArgWith(ctx, e, 0, a0.args[0]);
                            changed = true;
                        } else {
                            has2IntArgs = false;
                            strictHas2IntArgs = false;
                            if (a0.args.length == 2 && ((ta0 = TypeAnalysis.type(types, a0.args[0])) == GlobalOptimizer.INT() || ta0 == GlobalOptimizer.UINT())) {
                                ta1 = TypeAnalysis.type(types, a0.args[1]);
                                has2IntArgs = ta1 == GlobalOptimizer.INT() || ta1 == GlobalOptimizer.UINT();
                                v1 = strictHas2IntArgs = ta0 == GlobalOptimizer.INT() && ta1 == GlobalOptimizer.INT();
                            }
                            if (a0.op == 117) {
                                ta0 = TypeAnalysis.type(types, a0.args[0]);
                                if (ta0 == GlobalOptimizer.INT()) {
                                    this.makeCopy(e, a0.args[0]);
                                    changed = true;
                                } else if (ta0 == GlobalOptimizer.UINT()) {
                                    this.replaceArgWith(ctx, e, 0, a0.args[0]);
                                    changed = true;
                                }
                            } else if (a0.op == 144) {
                                e.op = 196;
                                this.replaceArgWith(ctx, e, 0, a0.args[0]);
                                changed = true;
                            } else if (a0.op == 147) {
                                e.op = 193;
                                this.replaceArgWith(ctx, e, 0, a0.args[0]);
                                changed = true;
                            } else if (a0.op == 145) {
                                e.op = 192;
                                this.replaceArgWith(ctx, e, 0, a0.args[0]);
                                changed = true;
                            } else if (a0.op == 160 && has2IntArgs) {
                                this.replaceArgsWith(ctx, e, new Expr[]{a0.args[0], a0.args[1]});
                                e.op = 197;
                                changed = true;
                            } else if (a0.op == 161 && has2IntArgs) {
                                this.replaceArgsWith(ctx, e, new Expr[]{a0.args[0], a0.args[1]});
                                e.op = 198;
                                changed = true;
                            } else if (a0.op == 162 && strictHas2IntArgs) {
                                this.replaceArgsWith(ctx, e, new Expr[]{a0.args[0], a0.args[1]});
                                e.op = 199;
                                changed = true;
                            }
                        }
                    } else if (e.op == 116) {
                        switch (a0.op) {
                            case 117: 
                            case 144: 
                            case 145: 
                            case 147: 
                            case 160: 
                            case 161: 
                            case 162: {
                                this.shimExprArg(ctx, e, 115, 0);
                                changed = true;
                                break;
                            }
                        }
                    }
                    ** GOTO lbl601
                }
                case 58: 
                case 59: 
                case 60: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 197: 
                case 198: 
                case 199: {
                    a0 = e.args[0];
                    a1 = e.args[1];
                    t0 = TypeAnalysis.type(types, a0);
                    t1 = TypeAnalysis.type(types, a1);
                    if (GlobalOptimizer.INT() != t0) {
                        this.shimExprArg(ctx, e, 115, 0);
                        changed = true;
                    }
                    if (GlobalOptimizer.INT() != t1) {
                        this.shimExprArg(ctx, e, 115, 1);
                        changed = true;
                    }
                    ** GOTO lbl601
                }
                case 61: 
                case 62: {
                    a1 = e.args[1];
                    t1 = TypeAnalysis.type(types, a1);
                    if (GlobalOptimizer.INT() != t1) {
                        this.shimExprArg(ctx, e, 115, 1);
                        changed = true;
                    }
                    ** GOTO lbl601
                }
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 80: 
                case 81: 
                case 82: 
                case 151: 
                case 192: 
                case 193: 
                case 196: {
                    a0 = e.args[0];
                    t0 = TypeAnalysis.type(types, a0);
                    if (GlobalOptimizer.INT() != t0) {
                        this.shimExprArg(ctx, e, 115, 0);
                        changed = true;
                    }
                    ** GOTO lbl601
                }
                case 161: {
                    v1 = values.get(e.args[1]);
                    if (TypeAnalysis.doubleValue(v1) == 1.0) {
                        e.args = new Expr[]{e.args[0]};
                        e.op = 147;
                        changed = true;
                    } else if (TypeAnalysis.doubleValue(v1) == -1.0) {
                        e.args = new Expr[]{e.args[0]};
                        e.op = 145;
                        changed = true;
                    }
                    ** GOTO lbl601
                }
                case 160: {
                    t = TypeAnalysis.type(types, e);
                    v0 = values.get(e.args[0]);
                    v1 = values.get(e.args[1]);
                    if (t.numeric) {
                        if (TypeAnalysis.doubleValue(v0) == 1.0) {
                            e.args = new Expr[]{e.args[1]};
                            e.op = 145;
                            changed = true;
                        } else if (TypeAnalysis.doubleValue(v1) == 1.0) {
                            e.args = new Expr[]{e.args[0]};
                            e.op = 145;
                            changed = true;
                        } else if (TypeAnalysis.doubleValue(v0) == -1.0) {
                            e.args = new Expr[]{e.args[1]};
                            e.op = 147;
                            changed = true;
                        } else if (TypeAnalysis.doubleValue(v1) == -1.0) {
                            e.args = new Expr[]{e.args[0]};
                            e.op = 147;
                            changed = true;
                        }
                    } else if (t == GlobalOptimizer.STRING()) {
                        if ("".equals(v0)) {
                            e.args = new Expr[]{e.args[1]};
                            e.op = 112;
                            changed = true;
                        } else if ("".equals(v1)) {
                            e.args = new Expr[]{e.args[0]};
                            e.op = 112;
                            changed = true;
                        }
                    }
                    ** GOTO lbl601
                }
                case 257: {
                    phiTyperef = types.get(e);
                    if (!GlobalOptimizer.$assertionsDisabled && phiTyperef == null) {
                        throw new AssertionError();
                    }
                    newArgs = new Expr[e.args.length];
                    i = 0;
                    changedArg = false;
                    for (Expr arg : e.args) {
                        argTyperef = types.get(arg);
                        if (!GlobalOptimizer.$assertionsDisabled && argTyperef == null) {
                            throw new AssertionError();
                        }
                        if (argTyperef.getType() != phiTyperef.getType()) {
                            if (Expr.isLegalUpCast(phiTyperef, argTyperef)) {
                                newArgs[i] = new Expr(m, 261, arg);
                                newArgs[i].castType = phiTyperef;
                                if (!GlobalOptimizer.$assertionsDisabled && !newArgs[i].isLegalUpCast(argTyperef)) {
                                    throw new AssertionError();
                                }
                            } else {
                                newArgs[i] = new Expr(m, 128, phiTyperef.getType().getName(), arg);
                            }
                            newArgs[i].setPure();
                            ctx.removeUse(e, arg);
                            ctx.addUse(newArgs[i], arg);
                            ctx.addUse(e, newArgs[i]);
                            argBlock = ctx.getBlock(arg);
                            argBlock.insertExprAfter(arg, newArgs[i]);
                            ctx.addExpr(argBlock, newArgs[i]);
                            changedArg = true;
                        } else {
                            newArgs[i] = arg;
                        }
                        ++i;
                    }
                    if (changedArg) {
                        e.args = newArgs;
                        ctx.commit();
                        for (Expr arg : e.args) {
                            if (!GlobalOptimizer.$assertionsDisabled && types.get(e).getType() != types.get(arg).getType()) {
                                throw new AssertionError();
                            }
                        }
                        changed = true;
                    }
                }
lbl601:
                // 67 sources

                default: {
                    if (!changed) continue block30;
                    work.addAll((Collection<Expr>)uses.get(e));
                }
            }
        } while (changed);
    }

    void sccp_rename(Algorithms.EdgeMap<Expr> uses, Expr e2, Expr[] args) {
        GlobalOptimizer.addTraceAttr(e2);
        for (int i2 = args.length - 1; i2 >= 0; --i2) {
            Expr a = args[i2];
            if (a.op != 42) continue;
            uses.get(a).remove(e2);
            a = args[i2] = a.locals[0];
            GlobalOptimizer.traceEntry("renamedLocal");
            GlobalOptimizer.addTraceAttr(a);
            uses.get(a).add(e2);
        }
    }

    Map<Expr, Typeref> verify_types(Method m2, Algorithms.Deque<Block> code, Map<Block, Block> idom) {
        Algorithms.EdgeMap<Expr> uses = Algorithms.findUses(code);
        TreeMap<Expr, Typeref> types = new TreeMap<Expr, Typeref>();
        Algorithms.ExprWorkQueue work = new Algorithms.ExprWorkQueue(uses);
        for (Block b3 : code) {
            work.addAll(b3.exprs);
        }
        do {
            Typeref tref;
            Expr e2;
            if (!(e2 = Algorithms.getExpr(work)).onStack() && !e2.inLocal() && !e2.onScope() && e2.op != 257 || (tref = this.verify_eval(m2, e2, types, idom)).equals(types.get(e2))) continue;
            types.put(e2, tref);
            work.addAll((Collection<Expr>)uses.get(e2));
        } while (!work.isEmpty());
        return types;
    }

    void sccp_analyze(Method m2, Algorithms.EdgeMap<Expr> uses, Map<Expr, Object> values, Map<Expr, Typeref> types, Set<Edge> reached) {
        GlobalOptimizer.addTraceAttr("Method", m2);
        TreeSet<Edge> flowWork = new TreeSet<Edge>();
        Algorithms.ExprWorkQueue ssaWork = new Algorithms.ExprWorkQueue(uses);
        TreeSet<Expr> ready = new TreeSet<Expr>();
        flowWork.add(m2.entry);
        block0: while (true) {
            if (!flowWork.isEmpty()) {
                Edge edge = Algorithms.getEdge(flowWork);
                if (reached.contains(edge)) continue;
                reached.add(edge);
                Block b3 = edge.to;
                ready.addAll(b3.exprs);
                ssaWork.addAll(b3.exprs);
                Edge[] arr$ = b3.xsucc;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block0;
                    Edge x2 = arr$[i$];
                    flowWork.add(x2);
                    ++i$;
                }
            }
            while (!ssaWork.isEmpty()) {
                Expr e2 = Algorithms.getExpr(ssaWork);
                if (!ready.contains(e2)) continue;
                GlobalOptimizer.addTraceAttr("Expr", e2);
                this.sccp_eval(m2, e2, values, types, flowWork, ssaWork, uses);
            }
            if (flowWork.isEmpty()) break;
        }
    }

    void insert_casts(Method m2) {
        Algorithms.Deque<Block> code = Algorithms.dfs(m2.entry.to);
        Algorithms.SetMap<Block, Edge> pred = Algorithms.preds(code);
        Map<Block, Block> idom = Algorithms.idoms(code, pred);
        m2.verifier_types = this.verify_types(m2, code, idom);
        for (Block b3 : code) {
            for (Expr e2 : b3) {
                if (e2.op != 257) continue;
                Typeref etype = m2.verifier_types.get(e2);
                for (int i2 = e2.args.length - 1; i2 >= 0; --i2) {
                    Expr a = e2.args[i2];
                    Edge p2 = e2.pred[i2];
                    if (a.onScope()) continue;
                    Typeref atype = m2.verifier_types.get(a);
                    if (!(this.isLoop(p2, idom) ? !etype.equals(atype) : etype.t.isAtom() != atype.t.isAtom()) || etype.t == atype.t && etype.nullable) continue;
                    this.verboseStatus("MISSING CAST " + a + " " + atype + "->" + etype + " on " + p2);
                    if (this.isCritical(p2, pred)) {
                        GlobalOptimizer.split(p2, m2, pred);
                        p2 = e2.pred[i2];
                    }
                    Expr upcast = this.upcast(a, m2, etype.t);
                    this.append(p2, upcast);
                    e2.args[i2] = upcast;
                }
            }
        }
        this.verboseStatus("VERIFY TYPES " + m2.verifier_types);
    }

    Expr upcast(Expr a, Method m2, Type t2) {
        if (t2 == GlobalOptimizer.ANY()) {
            return new Expr(m2, 130, a);
        }
        if (t2 == GlobalOptimizer.OBJECT()) {
            return new Expr(m2, 137, a);
        }
        return new Expr(m2, 128, t2.getName(), a);
    }

    void sccp_eval(Method m2, Expr e2, Map<Expr, Object> values, Map<Expr, Typeref> types, Set<Edge> flowWork, Algorithms.ExprWorkQueue ssaWork, Algorithms.EdgeMap<Expr> uses) {
        Object v2 = null;
        Object tref = null;
        if (e2.op == 257) {
            for (Expr a : e2.args) {
                Object av2 = values.get(a);
                if (av2 == null) continue;
                if (v2 == null) {
                    v2 = av2;
                } else if (!av2.equals(v2)) {
                    v2 = OptimizerConstants.BOTTOM;
                }
                Typeref aref = types.get(a);
                if (tref == null) {
                    tref = aref;
                    continue;
                }
                if (((Typeref)tref).equals(aref)) continue;
                tref = this.typeMeet((Typeref)tref, aref);
            }
        } else {
            for (Expr a : e2.args) {
                if (values.containsKey(a)) continue;
                return;
            }
            for (Expr a : e2.scopes) {
                if (values.containsKey(a)) continue;
                return;
            }
            for (Expr a : e2.locals) {
                if (values.containsKey(a)) continue;
                return;
            }
            v2 = OptimizerConstants.BOTTOM;
            tref = GlobalOptimizer.ANY().ref;
            switch (e2.op) {
                default: {
                    System.err.println("unhandled op:" + e2.op + ":" + e2.opName());
                    assert (false);
                }
                case 6: 
                case 7: 
                case 30: 
                case 35: 
                case 65: 
                case 89: 
                case 260: {
                    break;
                }
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    tref = GlobalOptimizer.VOID().ref;
                    break;
                }
                case 31: 
                case 53: 
                case 54: 
                case 55: 
                case 80: 
                case 81: 
                case 82: {
                    tref = GlobalOptimizer.INT().ref;
                    break;
                }
                case 56: 
                case 57: {
                    tref = GlobalOptimizer.NUMBER().ref;
                    break;
                }
                case 119: {
                    tref = types.get(e2.args[0]).nonnull();
                    v2 = values.get(e2.args[0]);
                    break;
                }
                case 113: 
                case 114: {
                    tref = GlobalOptimizer.STRING().ref.exactnonnull();
                    break;
                }
                case 90: {
                    tref = m2.handlers[e2.imm[0]].activation;
                    break;
                }
                case 85: {
                    tref = GlobalOptimizer.OBJECT().ref.exactnonnull();
                    break;
                }
                case 86: {
                    tref = GlobalOptimizer.ARRAY().ref.exactnonnull();
                    break;
                }
                case 87: {
                    tref = m2.activation;
                    break;
                }
                case 100: {
                    if (m2.cx.scopes.length > 0) {
                        tref = m2.cx.scopes[0];
                        break;
                    }
                    v2 = values.get(e2.scopes[0]);
                    tref = types.get(e2.scopes[0]);
                    break;
                }
                case 101: {
                    v2 = values.get(e2.scopes[0]);
                    tref = types.get(e2.scopes[0]);
                    if (tref == null) {
                        tref = GlobalOptimizer.ANY().ref;
                    }
                    break;
                }
                case 88: {
                    tref = e2.c.ref.exactnonnull();
                    break;
                }
                case 64: {
                    tref = GlobalOptimizer.FUNCTION().ref.exactnonnull();
                    break;
                }
                case 95: {
                    if (m2.domain().isNamedScript(e2.ref)) {
                        tref = m2.domain().getNamedScript(e2.ref);
                    }
                    break;
                }
                case 93: 
                case 94: 
                case 103: {
                    FindScopeResult fsr = this.findScope(e2, m2, types);
                    if (fsr != null) {
                        Expr scopeObjExpr = fsr.scopeObjectExpr();
                        if (scopeObjExpr != null) {
                            v2 = values.get(scopeObjExpr);
                        }
                        tref = fsr.scopeObjectType();
                    }
                    break;
                }
                case 96: {
                    Binding b3;
                    Binding b4;
                    int i2;
                    Typeref stref = null;
                    for (i2 = e2.scopes.length - 1; i2 >= 0; --i2) {
                        Type st = TypeAnalysis.type(types, e2.scopes[i2]);
                        b4 = st.find(e2.ref);
                        if (b4 != null) {
                            stref = types.get(e2.scopes[i2]);
                            break;
                        }
                        if (e2.scopes[i2].op != 28) continue;
                        stref = GlobalOptimizer.OBJECT().ref;
                        break;
                    }
                    if (i2 < 0) {
                        for (i2 = m2.cx.scopes.length - 1; i2 >= 1; --i2) {
                            Type st = m2.cx.scopes[i2].t;
                            b4 = st.find(e2.ref);
                            if (b4 != null) {
                                stref = m2.cx.scopes[i2];
                                break;
                            }
                            if (!m2.cx.withScopes[i2]) continue;
                            stref = GlobalOptimizer.OBJECT().ref;
                            break;
                        }
                        if (i2 < 1) {
                            Typeref st = m2.domain().getNamedScript(e2.ref);
                            stref = st != null ? st : (m2.cx.scopes.length > 0 ? m2.cx.scopes[0] : types.get(e2.scopes[0]));
                        }
                    }
                    if (GlobalOptimizer.isSlot(b3 = stref.t.findGet(e2.ref))) {
                        tref = b3.type;
                        if (GlobalOptimizer.isConst(b3) && b3.defaultValueChanged()) {
                            v2 = b3.value();
                        }
                    } else {
                        if (GlobalOptimizer.isMethod(b3)) {
                            tref = GlobalOptimizer.FUNCTION().ref.exactnonnull();
                            break;
                        }
                        if (GlobalOptimizer.isGetter(b3)) {
                            tref = b3.method.returns;
                        }
                    }
                    break;
                }
                case 66: {
                    tref = GlobalOptimizer.OBJECT().ref.nonnull();
                    break;
                }
                case 74: {
                    Type ot = TypeAnalysis.type(types, e2.args[0]);
                    Binding b5 = ot.findGet(e2.ref);
                    if (b5 != null && b5.type != null && b5.type.t.itype != null) {
                        tref = b5.type.t.itype.ref.exactnonnull();
                    }
                    break;
                }
                case 69: 
                case 70: 
                case 76: {
                    Binding b02;
                    Type ot = TypeAnalysis.type(types, e2.args[0]);
                    if (e2.op == 70 && ot.isInterface() && (b02 = ot.findGetOnInterface(e2.ref)) != null) {
                        if (b02.isMethod()) {
                            tref = b02.method.returns;
                            break;
                        }
                        if (b02.isGetter()) {
                            if (b02.method.returns == GlobalOptimizer.FUNCTION().ref) {
                                tref = GlobalOptimizer.ANY().ref;
                                break;
                            }
                            tref = b02.method.returns;
                            break;
                        }
                        if (b02.isSetter()) {
                            assert (b02.method.returns == GlobalOptimizer.VOID().ref);
                            tref = b02.method.returns;
                            break;
                        }
                        throw new RuntimeException("Interface " + ot + " must contain only methods, getters or setters ");
                    }
                    Binding b6 = ot.findGet(e2.ref);
                    if (GlobalOptimizer.isMethod(b6)) {
                        tref = b6.method.returns;
                        break;
                    }
                    if (GlobalOptimizer.isSlot(b6) && b6.type != null) {
                        if (b6.type.t.itype == GlobalOptimizer.INT()) {
                            tref = GlobalOptimizer.INT().ref;
                            if (e2.args.length > 1) {
                                v2 = TypeAnalysis.eval_convert_i(values.get(e2.args[1]));
                            }
                        } else if (b6.type.t.itype == GlobalOptimizer.UINT()) {
                            tref = GlobalOptimizer.UINT().ref;
                            if (e2.args.length > 1) {
                                v2 = TypeAnalysis.eval_convert_u(values.get(e2.args[1]));
                            }
                        } else if (b6.type.t.itype == GlobalOptimizer.STRING()) {
                            tref = GlobalOptimizer.STRING().ref.exactnonnull();
                            if (e2.args.length > 1 && !(values.get(e2.args[1]) instanceof Number)) {
                                v2 = TypeAnalysis.eval_convert_s(values.get(e2.args[1]));
                            }
                        } else if (b6.type.t.itype == GlobalOptimizer.BOOLEAN()) {
                            tref = GlobalOptimizer.BOOLEAN().ref;
                            if (e2.args.length > 1) {
                                v2 = TypeAnalysis.eval_convert_b(values.get(e2.args[1]));
                            }
                        } else if (b6.type.t.itype == GlobalOptimizer.NUMBER()) {
                            tref = GlobalOptimizer.NUMBER().ref;
                            if (e2.args.length > 1) {
                                v2 = TypeAnalysis.eval_convert_d(values.get(e2.args[1]));
                            }
                        }
                    }
                    break;
                }
                case 83: {
                    Typeref parameterType = types.get(e2.args[1]);
                    if (parameterType.exact) {
                        Expr parameterizedTypeClosure = e2.args[0];
                        Typeref parameterizedType = types.get(parameterizedTypeClosure);
                        if (parameterizedType.t.itype != null) {
                            Name parameterizedTypeName = parameterizedType.t.itype.getName();
                            Name parameterTypeName = parameterType.t.itype.getName();
                            Name parameterizedTypeInstanceName = new Name(parameterizedTypeName, parameterTypeName);
                            tref = m2.domain().resolveCType((Name)parameterizedTypeInstanceName).ref.exactnonnull();
                        }
                    }
                    break;
                }
                case 67: 
                case 68: 
                case 77: {
                    tref = e2.m.returns;
                    break;
                }
                case 256: {
                    if (e2.imm[0] == 0) {
                        tref = m2.getParams()[e2.imm[0]].nonnull();
                        break;
                    }
                    if (e2.imm[0] < m2.getParams().length) {
                        tref = m2.getParams()[e2.imm[0]];
                        break;
                    }
                    if (m2.needsArguments() || m2.needsRest() && e2.imm[0] == m2.getParams().length) {
                        tref = GlobalOptimizer.ARRAY().ref.exactnonnull();
                        break;
                    }
                    tref = GlobalOptimizer.VOID().ref;
                    break;
                }
                case 258: {
                    tref = m2.handlers[e2.imm[0]].type;
                    break;
                }
                case 108: {
                    Object t0 = TypeAnalysis.type(types, e2.args[0]);
                    tref = ((Type)t0).getSlotType(e2.imm[0]);
                    break;
                }
                case 4: 
                case 102: {
                    Type t1;
                    Binding b03;
                    Object t0 = TypeAnalysis.type(types, e2.args[0]);
                    if (e2.op == 102 && ((Type)t0).isInterface() && (b03 = ((Type)t0).findGetOnInterface(e2.ref)) != null && b03.isGetter()) {
                        tref = b03.method.returns;
                        break;
                    }
                    if (e2.op == 102 && ((Type)t0).isParameterizedTypeInstance() && e2.args.length == 2 && ((t1 = TypeAnalysis.type(types, e2.args[1])) == GlobalOptimizer.INT() || t1 == GlobalOptimizer.UINT())) {
                        tref = ((Type)t0).typeParameters()[0].ref;
                        break;
                    }
                    Binding b7 = ((Type)t0).findGet(e2.ref);
                    if (GlobalOptimizer.isSlot(b7)) {
                        tref = b7.type;
                        if (GlobalOptimizer.isConst(b7) && b7.defaultValueChanged()) {
                            v2 = b7.value();
                        }
                    } else {
                        if (GlobalOptimizer.isMethod(b7)) {
                            tref = GlobalOptimizer.FUNCTION().ref.exactnonnull();
                            break;
                        }
                        if (GlobalOptimizer.isGetter(b7)) {
                            tref = b7.method.returns;
                            break;
                        }
                        if (e2.op == 102) {
                            Type tc = null;
                            Iterator i$ = uses.get(e2).iterator();
                            while (i$.hasNext()) {
                                Expr eu = (Expr)i$.next();
                                while (eu.op == 42) {
                                    eu = eu.locals[0];
                                }
                                Type tu = this.opCoercesArgsToType(eu.op);
                                if (tc == null) {
                                    tc = tu;
                                } else if (tu != null) {
                                    Typeref tr = this.typeMerge(tu.ref, tc.ref);
                                    Type type = tc = tr == null ? null : tr.t;
                                }
                                if (tu != null && tc != null) continue;
                                tc = null;
                                break;
                            }
                            if (tc == GlobalOptimizer.INT() || tc == GlobalOptimizer.UINT() || tc == GlobalOptimizer.NUMBER()) {
                                tref = tc.ref;
                            }
                        }
                    }
                    break;
                }
                case 33: {
                    v2 = e2.value;
                    tref = GlobalOptimizer.VOID().ref;
                    break;
                }
                case 32: {
                    v2 = e2.value;
                    tref = GlobalOptimizer.NULL().ref;
                    break;
                }
                case 38: 
                case 39: {
                    v2 = e2.value;
                    tref = GlobalOptimizer.BOOLEAN().ref;
                    break;
                }
                case 36: 
                case 37: 
                case 45: {
                    v2 = e2.value;
                    tref = GlobalOptimizer.INT().ref;
                    break;
                }
                case 46: {
                    v2 = e2.value;
                    tref = GlobalOptimizer.UINT().ref;
                    break;
                }
                case 44: {
                    v2 = e2.value;
                    tref = GlobalOptimizer.STRING().ref.exactnonnull();
                    break;
                }
                case 40: 
                case 47: {
                    v2 = e2.value;
                    tref = GlobalOptimizer.NUMBER().ref;
                    break;
                }
                case 49: {
                    v2 = e2.value;
                    tref = GlobalOptimizer.NAMESPACE().ref.exactnonnull();
                    break;
                }
                case 16: {
                    flowWork.add(e2.succ[0]);
                    return;
                }
                case 27: {
                    int i2;
                    Object v1 = values.get(e2.args[0]);
                    if (v1 == OptimizerConstants.BOTTOM) {
                        for (Edge s2 : e2.succ) {
                            flowWork.add(s2);
                        }
                    } else {
                        i2 = TypeAnalysis.intValue(v1);
                        if (i2 < 0 || i2 >= e2.succ.length - 1) {
                            i2 = e2.succ.length - 1;
                        }
                        flowWork.add(e2.succ[i2]);
                    }
                    return;
                }
                case 17: 
                case 18: {
                    Object v1 = values.get(e2.args[0]);
                    if (v1 == OptimizerConstants.BOTTOM) {
                        flowWork.add(e2.succ[0]);
                        flowWork.add(e2.succ[1]);
                    } else if (e2.op == 18) {
                        flowWork.add(e2.succ[TypeAnalysis.booleanValue(v1) ? 0 : 1]);
                    } else if (e2.op == 17) {
                        flowWork.add(e2.succ[TypeAnalysis.booleanValue(v1) ? 1 : 0]);
                    }
                    return;
                }
                case 28: 
                case 48: {
                    v2 = values.get(e2.args[0]);
                    tref = types.get(e2.args[0]).nonnull();
                    break;
                }
                case 118: {
                    tref = GlobalOptimizer.BOOLEAN().ref;
                    v2 = TypeAnalysis.eval_convert_b(values.get(e2.args[0]));
                    break;
                }
                case 150: {
                    tref = GlobalOptimizer.BOOLEAN().ref;
                    Object v0 = values.get(e2.args[0]);
                    if (v0 != OptimizerConstants.BOTTOM) {
                        v2 = TypeAnalysis.booleanValue(v0) ? Boolean.FALSE : Boolean.TRUE;
                    }
                    break;
                }
                case 50: 
                case 106: 
                case 171: 
                case 172: 
                case 177: 
                case 179: 
                case 180: {
                    tref = GlobalOptimizer.BOOLEAN().ref;
                    break;
                }
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    tref = GlobalOptimizer.BOOLEAN().ref;
                    Object v0 = values.get(e2.args[0]);
                    Object v1 = values.get(e2.args[1]);
                    if (v0.equals(OptimizerConstants.NAN) || v0 == OptimizerConstants.UNDEFINED || v1.equals(OptimizerConstants.NAN) || v1 == OptimizerConstants.UNDEFINED) {
                        v2 = Boolean.FALSE;
                        break;
                    }
                    if (v0 != OptimizerConstants.BOTTOM && v1 != OptimizerConstants.BOTTOM) {
                        v2 = e2.op == 173 ? TypeAnalysis.lessthan(v0, v1) == Boolean.TRUE : (e2.op == 174 ? TypeAnalysis.lessthan(v1, v0) == Boolean.FALSE : (e2.op == 175 ? TypeAnalysis.lessthan(v1, v0) == Boolean.TRUE : TypeAnalysis.lessthan(v0, v1) == Boolean.FALSE));
                    }
                    break;
                }
                case 42: {
                    assert (e2.locals.length == 1);
                    assert (e2.locals[0] != null);
                    tref = types.get(e2.locals[0]);
                    v2 = values.get(e2.locals[0]);
                    break;
                }
                case 112: {
                    tref = GlobalOptimizer.STRING().ref.exactnonnull();
                    if (!(values.get(e2.args[0]) instanceof Number)) {
                        v2 = TypeAnalysis.eval_convert_s(values.get(e2.args[0]));
                    }
                    break;
                }
                case 133: {
                    tref = TypeAnalysis.eval_coerce_s(types.get(e2.args[0]));
                    if (!(values.get(e2.args[0]) instanceof Number)) {
                        v2 = TypeAnalysis.eval_coerce_s(values.get(e2.args[0]));
                    }
                    break;
                }
                case 137: {
                    Object t0 = types.get(e2.args[0]);
                    tref = TypeAnalysis.eval_coerce_o((Typeref)t0);
                    v2 = TypeAnalysis.eval_coerce_o(values.get(e2.args[0]), ((Typeref)t0).t);
                    break;
                }
                case 130: {
                    tref = GlobalOptimizer.ANY().ref;
                    break;
                }
                case 128: {
                    Object t0 = types.get(e2.args[0]);
                    Object v0 = values.get(e2.args[0]);
                    Type t2 = m2.domain().resolveTypeName(e2.ref, null);
                    assert (t2 != null);
                    if (t2 == GlobalOptimizer.STRING()) {
                        tref = TypeAnalysis.eval_coerce_s((Typeref)t0);
                        if (!(v0 instanceof Number)) {
                            v2 = TypeAnalysis.eval_coerce_s(v0);
                        }
                        break;
                    }
                    if (t2 == GlobalOptimizer.OBJECT()) {
                        tref = TypeAnalysis.eval_coerce_o((Typeref)t0);
                        v2 = TypeAnalysis.eval_coerce_o(v0, ((Typeref)t0).t);
                        break;
                    }
                    if (t2 == GlobalOptimizer.INT()) {
                        tref = t2.ref;
                        v2 = TypeAnalysis.eval_convert_i(v0);
                        break;
                    }
                    if (t2 == GlobalOptimizer.UINT()) {
                        tref = t2.ref;
                        v2 = TypeAnalysis.eval_convert_u(v0);
                        break;
                    }
                    if (t2 == GlobalOptimizer.NUMBER()) {
                        tref = t2.ref;
                        v2 = TypeAnalysis.eval_convert_d(v0);
                        break;
                    }
                    if (t2 == GlobalOptimizer.BOOLEAN()) {
                        tref = t2.ref;
                        v2 = TypeAnalysis.eval_convert_b(v0);
                        break;
                    }
                    if (((Typeref)t0).t.extendsOrIsBase(t2)) {
                        tref = t0;
                        v2 = v0;
                        break;
                    }
                    if (((Typeref)t0).t == GlobalOptimizer.NULL() || ((Typeref)t0).t == GlobalOptimizer.VOID()) {
                        tref = GlobalOptimizer.NULL().ref;
                        break;
                    }
                    tref = t2.ref;
                    break;
                }
                case 264: {
                    tref = GlobalOptimizer.INT().ref;
                    break;
                }
                case 263: {
                    tref = GlobalOptimizer.ANY().ref;
                    break;
                }
                case 261: {
                    Expr arg = e2.args[0];
                    Typeref argTyperef = types.get(arg);
                    assert (argTyperef != null);
                    assert (e2.isLegalUpCast(argTyperef));
                    assert (e2.castType != null);
                    tref = e2.castType;
                    v2 = values.get(arg);
                    break;
                }
                case 178: {
                    m2.domain().resolveTypeName(e2.ref, null);
                    tref = GlobalOptimizer.BOOLEAN().ref;
                    break;
                }
                case 134: {
                    Typeref toType = m2.domain().resolveTypeName((Name)e2.ref, null).ref;
                    Typeref fromType = types.get(e2.args[0]);
                    assert (fromType != null);
                    if (GlobalOptimizer.asTypeIsCopy(toType, fromType)) {
                        tref = fromType;
                        v2 = values.get(e2.args[0]);
                        break;
                    }
                    if (toType.getType() == BuiltinDomain.instance().VOID()) {
                        assert (((Typeref)tref).getType() == BuiltinDomain.instance().ANY());
                    } else if (!toType.getType().isNumeric()) {
                        tref = toType.nullable();
                    }
                    break;
                }
                case 135: {
                    Typeref t1 = types.get(e2.args[1]);
                    if (t1.t.itype != null) {
                        if (t1.t.itype.atom || t1.t.itype.numeric) {
                            tref = GlobalOptimizer.OBJECT().ref;
                            break;
                        }
                        tref = t1.t.itype.ref;
                        break;
                    }
                    tref = GlobalOptimizer.ANY().ref;
                    break;
                }
                case 149: {
                    Type t0 = TypeAnalysis.type(types, e2.args[0]);
                    if (t0 == GlobalOptimizer.INT() || t0 == GlobalOptimizer.UINT() || t0 == GlobalOptimizer.NUMBER()) {
                        v2 = "number";
                    } else if (t0 == GlobalOptimizer.STRING()) {
                        v2 = "string";
                    } else if (t0.extendsOrIsBase(GlobalOptimizer.XML()) || t0.extendsOrIsBase(GlobalOptimizer.XMLLIST())) {
                        v2 = "xml";
                    } else if (t0 == GlobalOptimizer.VOID()) {
                        v2 = "undefined";
                    } else if (t0 == GlobalOptimizer.BOOLEAN()) {
                        v2 = "boolean";
                    } else if (t0.extendsOrIsBase(GlobalOptimizer.FUNCTION())) {
                        v2 = "function";
                    } else if (t0 != GlobalOptimizer.OBJECT() && t0.extendsOrIsBase(GlobalOptimizer.OBJECT())) {
                        v2 = "object";
                    }
                    tref = GlobalOptimizer.STRING().ref.exactnonnull();
                    break;
                }
                case 160: {
                    Expr a02 = e2.args[0];
                    Expr a12 = e2.args[1];
                    Typeref t0 = types.get(a02);
                    Typeref t1 = types.get(a12);
                    Object v0 = values.get(a02);
                    Object v1 = values.get(a12);
                    if (t0.t == GlobalOptimizer.STRING() && !t0.nullable || t1.t == GlobalOptimizer.STRING() && !t1.nullable) {
                        tref = GlobalOptimizer.STRING().ref.exactnonnull();
                        if (!t0.t.numeric && !t1.t.numeric && v0 != OptimizerConstants.BOTTOM && v1 != OptimizerConstants.BOTTOM) {
                            v2 = TypeAnalysis.stringValue(v0) + TypeAnalysis.stringValue(v1);
                        }
                        break;
                    }
                    if (t0.t.numeric && t1.t.numeric) {
                        tref = GlobalOptimizer.NUMBER().ref;
                        if (v0 instanceof Number && v1 instanceof Number) {
                            v2 = TypeAnalysis.doubleValue(v0) + TypeAnalysis.doubleValue(v1);
                        }
                        break;
                    }
                    tref = GlobalOptimizer.OBJECT().ref.nonnull();
                    break;
                }
                case 163: {
                    tref = GlobalOptimizer.NUMBER().ref;
                    Object v0 = values.get(e2.args[0]);
                    Object v1 = values.get(e2.args[1]);
                    if (v0 instanceof Number && v1 instanceof Number) {
                        v2 = TypeAnalysis.doubleValue(v0) / TypeAnalysis.doubleValue(v1);
                    }
                    break;
                }
                case 144: 
                case 145: 
                case 147: 
                case 161: 
                case 162: 
                case 164: {
                    tref = GlobalOptimizer.NUMBER().ref;
                    break;
                }
                case 117: {
                    tref = GlobalOptimizer.NUMBER().ref;
                    v2 = TypeAnalysis.eval_convert_d(values.get(e2.args[0]));
                    break;
                }
                case 115: {
                    tref = GlobalOptimizer.INT().ref;
                    v2 = TypeAnalysis.eval_convert_i(values.get(e2.args[0]));
                    break;
                }
                case 116: {
                    tref = GlobalOptimizer.UINT().ref;
                    v2 = TypeAnalysis.eval_convert_u(values.get(e2.args[0]));
                    break;
                }
                case 169: {
                    tref = GlobalOptimizer.INT().ref;
                    Object v0 = values.get(e2.args[0]);
                    Object v1 = values.get(e2.args[1]);
                    if (v0 instanceof Number && v1 instanceof Number) {
                        v2 = TypeAnalysis.intValue(v0) | TypeAnalysis.intValue(v1);
                    }
                    break;
                }
                case 168: {
                    tref = GlobalOptimizer.INT().ref;
                    Object v0 = values.get(e2.args[0]);
                    Object v1 = values.get(e2.args[1]);
                    if (v0 instanceof Number && v1 instanceof Number) {
                        v2 = TypeAnalysis.intValue(v0) & TypeAnalysis.intValue(v1);
                    }
                    break;
                }
                case 151: 
                case 165: 
                case 166: 
                case 170: 
                case 192: 
                case 193: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 259: {
                    tref = GlobalOptimizer.INT().ref;
                    break;
                }
                case 167: {
                    tref = GlobalOptimizer.UINT().ref;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 29: 
                case 71: 
                case 72: 
                case 73: 
                case 78: 
                case 79: 
                case 97: 
                case 104: 
                case 109: 
                case 120: 
                case 239: 
                case 240: 
                case 241: 
                case 242: 
                case 243: 
                case 262: {
                    return;
                }
            }
        }
        assert (tref != null && ((Typeref)tref).t != null);
        if (((Typeref)tref).t == GlobalOptimizer.VOID()) {
            v2 = OptimizerConstants.UNDEFINED;
        } else if (((Typeref)tref).t == GlobalOptimizer.NULL()) {
            v2 = GlobalOptimizer.NULL();
        }
        if (v2 != null && !v2.equals(values.get(e2))) {
            values.put(e2, v2);
            ssaWork.addAll((Collection<Expr>)uses.get(e2));
        }
        if (!((Typeref)tref).equals(types.get(e2))) {
            types.put(e2, (Typeref)tref);
            ssaWork.addAll((Collection<Expr>)uses.get(e2));
        }
    }

    Typeref verify_eval(Method m2, Expr e2, Map<Expr, Typeref> types, Map<Block, Block> idom) {
        Object tref = null;
        if (e2.op == 257) {
            boolean loop = false;
            for (int i2 = e2.args.length - 1; i2 >= 0; --i2) {
                Expr a = e2.args[i2];
                loop |= this.isLoop(e2.pred[i2], idom);
                Typeref aref = types.get(a);
                if (aref == null) continue;
                if (tref == null) {
                    tref = aref;
                    continue;
                }
                if (((Typeref)tref).equals(aref)) continue;
                tref = TypeAnalysis.mdb((Typeref)tref, aref);
            }
            if (null == tref) {
                tref = GlobalOptimizer.ANY().ref;
            }
            if (loop) {
                tref = ((Typeref)tref).t.ref;
            }
        } else {
            tref = GlobalOptimizer.ANY().ref;
            for (Expr a : e2.args) {
                if (types.containsKey(a)) continue;
                return tref;
            }
            for (Expr a : e2.scopes) {
                if (types.containsKey(a)) continue;
                return tref;
            }
            for (Expr a : e2.locals) {
                if (types.containsKey(a)) continue;
                return tref;
            }
            switch (e2.op) {
                default: {
                    assert (false);
                }
                case 4: 
                case 30: 
                case 35: 
                case 65: 
                case 89: 
                case 260: {
                    tref = GlobalOptimizer.ANY().ref;
                    break;
                }
                case 119: {
                    tref = types.get(e2.args[0]);
                    break;
                }
                case 113: 
                case 114: {
                    tref = GlobalOptimizer.STRING().ref.exactnonnull();
                    break;
                }
                case 90: {
                    tref = m2.handlers[e2.imm[0]].activation;
                    break;
                }
                case 85: {
                    tref = GlobalOptimizer.OBJECT().ref.exactnonnull();
                    break;
                }
                case 86: {
                    tref = GlobalOptimizer.ARRAY().ref.exactnonnull();
                    break;
                }
                case 87: {
                    tref = m2.activation;
                    break;
                }
                case 100: {
                    if (m2.cx.scopes.length > 0) {
                        tref = m2.cx.scopes[0];
                        break;
                    }
                    tref = types.get(e2.scopes[0].args[0]);
                    break;
                }
                case 101: {
                    tref = types.get(e2.scopes[0].args[0]);
                    break;
                }
                case 88: {
                    tref = e2.c.ref.exactnonnull();
                    break;
                }
                case 64: {
                    tref = GlobalOptimizer.FUNCTION().ref.exactnonnull();
                    break;
                }
                case 95: {
                    if (!m2.domain().isNamedScript(e2.ref)) break;
                    tref = m2.domain().getNamedScript(e2.ref);
                    break;
                }
                case 93: 
                case 94: {
                    int i3;
                    for (i3 = e2.scopes.length - 1; i3 >= 0; --i3) {
                        Type st = TypeAnalysis.type(types, e2.scopes[i3]);
                        Binding b3 = st.find(e2.ref);
                        if (b3 != null) {
                            tref = types.get(e2.scopes[i3]);
                            break;
                        }
                        if (e2.scopes[i3].op != 28) continue;
                        tref = GlobalOptimizer.OBJECT().ref;
                        break;
                    }
                    if (i3 >= 0) break;
                    for (i3 = m2.cx.scopes.length - 1; i3 >= 1; --i3) {
                        Type st = m2.cx.scopes[i3].t;
                        Binding b4 = st.find(e2.ref);
                        if (b4 != null) {
                            tref = m2.cx.scopes[i3];
                            break;
                        }
                        if (!m2.cx.withScopes[i3]) continue;
                        tref = GlobalOptimizer.OBJECT().ref;
                        break;
                    }
                    if (i3 >= 1) break;
                    Typeref st = m2.domain().getNamedScript(e2.ref);
                    if (st != null) {
                        tref = st;
                        break;
                    }
                    if (m2.cx.scopes.length > 0) {
                        tref = m2.cx.scopes[0];
                        break;
                    }
                    tref = types.get(e2.scopes[0]);
                    break;
                }
                case 96: {
                    Binding b5;
                    int i4;
                    Typeref stref = null;
                    for (i4 = e2.scopes.length - 1; i4 >= 0; --i4) {
                        Type st = TypeAnalysis.type(types, e2.scopes[i4]);
                        b5 = st.find(e2.ref);
                        if (b5 != null) {
                            stref = types.get(e2.scopes[i4]);
                            break;
                        }
                        if (e2.scopes[i4].op != 28) continue;
                        stref = GlobalOptimizer.OBJECT().ref;
                        break;
                    }
                    if (i4 < 0) {
                        for (i4 = m2.cx.scopes.length - 1; i4 >= 1; --i4) {
                            Type st = m2.cx.scopes[i4].t;
                            b5 = st.find(e2.ref);
                            if (b5 != null) {
                                stref = m2.cx.scopes[i4];
                                break;
                            }
                            if (!m2.cx.withScopes[i4]) continue;
                            stref = GlobalOptimizer.OBJECT().ref;
                            break;
                        }
                        if (i4 < 1) {
                            Typeref st = m2.domain().getNamedScript(e2.ref);
                            stref = st != null ? st : (m2.cx.scopes.length > 0 ? m2.cx.scopes[0] : types.get(e2.scopes[0]));
                        }
                    }
                    Binding b6 = stref.t.findGet(e2.ref);
                    tref = this.verify_eval_getproperty((Typeref)tref, b6);
                    break;
                }
                case 66: {
                    Type base_type = TypeAnalysis.type(types, e2.args[0]);
                    if (base_type.itype != null) {
                        tref = base_type.itype.ref.nonnull();
                        break;
                    }
                    tref = base_type.ref.nonnull();
                    break;
                }
                case 74: {
                    Type ot = TypeAnalysis.type(types, e2.args[0]);
                    Binding b7 = ot.findGet(e2.ref);
                    if (b7 == null || b7.type == null || b7.type.t.itype == null) break;
                    tref = b7.type.t.itype.ref.exactnonnull();
                    break;
                }
                case 70: 
                case 76: {
                    Type ot = TypeAnalysis.type(types, e2.args[0]);
                    Binding b8 = ot.findGet(e2.ref);
                    if (GlobalOptimizer.isMethod(b8)) {
                        tref = b8.method.returns;
                        break;
                    }
                    if (!GlobalOptimizer.isSlot(b8) || b8.type == null || b8.type.t.itype == null) break;
                    tref = b8.type.t.itype.ref;
                    break;
                }
                case 69: {
                    Type ot = m2.cx.base;
                    Binding b9 = ot.findGet(e2.ref);
                    if (!GlobalOptimizer.isMethod(b9)) break;
                    tref = b9.method.returns;
                    break;
                }
                case 83: {
                    tref = types.get(e2.args[0]).nonnull();
                    break;
                }
                case 68: {
                    tref = e2.m.returns;
                    break;
                }
                case 256: {
                    if (e2.imm[0] == 0) {
                        tref = m2.getParams()[e2.imm[0]].nonnull();
                        break;
                    }
                    if (e2.imm[0] < m2.getParams().length) {
                        tref = m2.getParams()[e2.imm[0]];
                        break;
                    }
                    if (m2.needsArguments() || m2.needsRest() && e2.imm[0] == m2.getParams().length) {
                        tref = GlobalOptimizer.ARRAY().ref.exactnonnull();
                        break;
                    }
                    tref = GlobalOptimizer.VOID().ref;
                    break;
                }
                case 258: {
                    tref = m2.handlers[e2.imm[0]].type;
                    break;
                }
                case 108: {
                    Object t0 = TypeAnalysis.type(types, e2.args[0]);
                    tref = ((Type)t0).getSlotType(e2.imm[0]);
                    break;
                }
                case 102: {
                    Object t0 = TypeAnalysis.type(types, e2.args[0]);
                    Binding b10 = ((Type)t0).findGet(e2.ref);
                    tref = this.verify_eval_getproperty((Typeref)tref, b10);
                    break;
                }
                case 8: {
                    tref = GlobalOptimizer.ANY().ref;
                    break;
                }
                case 33: {
                    tref = GlobalOptimizer.VOID().ref;
                    break;
                }
                case 32: {
                    tref = GlobalOptimizer.NULL().ref;
                    break;
                }
                case 49: {
                    tref = GlobalOptimizer.NAMESPACE().ref.exactnonnull();
                    break;
                }
                case 28: 
                case 48: {
                    tref = types.get(e2.args[0]).nonnull();
                    break;
                }
                case 38: 
                case 39: 
                case 50: 
                case 106: 
                case 118: 
                case 150: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    tref = GlobalOptimizer.BOOLEAN().ref;
                    break;
                }
                case 44: 
                case 112: {
                    tref = GlobalOptimizer.STRING().ref.exactnonnull();
                    break;
                }
                case 133: {
                    Object t0 = types.get(e2.args[0]);
                    tref = new Typeref(GlobalOptimizer.STRING(), ((Typeref)t0).nullable);
                    break;
                }
                case 137: {
                    Object t0 = types.get(e2.args[0]);
                    tref = new Typeref(GlobalOptimizer.OBJECT(), ((Typeref)t0).nullable);
                    break;
                }
                case 130: {
                    Object t0 = types.get(e2.args[0]);
                    tref = new Typeref(GlobalOptimizer.ANY(), ((Typeref)t0).nullable);
                    break;
                }
                case 128: {
                    tref = m2.domain().getNamedType((Name)e2.ref, (boolean)true).ref;
                    break;
                }
                case 134: {
                    Object t0 = types.get(e2.args[0]);
                    Type t2 = m2.domain().getNamedType(e2.ref, true);
                    if (!((Typeref)t0).t.extendsOrIsBase(t2) || ((Typeref)t0).t.isAtom() != t2.isAtom()) {
                        tref = t2.ref;
                        break;
                    }
                    tref = t0;
                    break;
                }
                case 135: {
                    Typeref t1 = types.get(e2.args[1]);
                    if (t1.t.itype != null) {
                        if (t1.t.itype.atom || t1.t.itype.numeric) {
                            tref = GlobalOptimizer.OBJECT().ref;
                            break;
                        }
                        tref = t1.t.itype.ref;
                        break;
                    }
                    tref = GlobalOptimizer.ANY().ref;
                    break;
                }
                case 149: {
                    tref = GlobalOptimizer.STRING().ref.exactnonnull();
                    break;
                }
                case 160: {
                    Expr a02 = e2.args[0];
                    Expr a12 = e2.args[1];
                    Typeref t0 = types.get(a02);
                    Typeref t1 = types.get(a12);
                    if (t0.t == GlobalOptimizer.STRING() || t1.t == GlobalOptimizer.STRING()) {
                        tref = GlobalOptimizer.STRING().ref.exactnonnull();
                        break;
                    }
                    if (t0.t.numeric && t1.t.numeric) {
                        tref = GlobalOptimizer.NUMBER().ref;
                        break;
                    }
                    tref = GlobalOptimizer.OBJECT().ref.nonnull();
                    break;
                }
                case 40: 
                case 47: 
                case 117: 
                case 144: 
                case 145: 
                case 147: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    tref = GlobalOptimizer.NUMBER().ref;
                    break;
                }
                case 31: 
                case 36: 
                case 37: 
                case 45: 
                case 115: 
                case 151: 
                case 165: 
                case 166: 
                case 168: 
                case 169: 
                case 170: 
                case 192: 
                case 193: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 259: {
                    tref = GlobalOptimizer.INT().ref;
                    break;
                }
                case 46: 
                case 116: 
                case 167: {
                    tref = GlobalOptimizer.UINT().ref;
                }
            }
        }
        assert (tref != null && ((Typeref)tref).t != null);
        return tref;
    }

    private static boolean asTypeIsCopy(Typeref toType, Typeref fromTypeRef) {
        if (Expr.isLegalUpCast(toType, fromTypeRef)) {
            return true;
        }
        if (toType.getType() == BuiltinDomain.instance().NUMBER()) {
            Type fromType = fromTypeRef.getType();
            if (fromType == BuiltinDomain.instance().UINT()) {
                return true;
            }
            if (fromType == BuiltinDomain.instance().INT()) {
                return true;
            }
        }
        return false;
    }

    private Typeref verify_eval_getproperty(Typeref tref, Binding b3) {
        if (GlobalOptimizer.isSlot(b3)) {
            tref = b3.type;
        } else if (GlobalOptimizer.isMethod(b3)) {
            tref = GlobalOptimizer.ANY().ref;
        } else if (GlobalOptimizer.isGetter(b3)) {
            tref = b3.method.returns;
        }
        return tref;
    }

    boolean isCritical(Edge e2, Algorithms.SetMap<Block, Edge> pred) {
        return e2.from.succ().length > 1 && pred.get(e2.to).size() > 1;
    }

    public static Edge split(Edge e2, Method m2, Algorithms.SetMap<Block, Edge> pred) {
        assert (e2.handler == null);
        Expr j2 = new Expr(m2, 16);
        Block d2 = new Block(m2, -1);
        Block to = e2.to;
        Edge e22 = new Edge(m2, d2, 0, to);
        j2.succ = new Edge[]{e22};
        d2.add(j2);
        e2.to = d2;
        pred.get(d2).add(e2);
        pred.get(to).remove(e2);
        pred.get(to).add(e22);
        GlobalOptimizer.replacePred(to, e2, e22);
        return e22;
    }

    public static void replacePred(Block b3, Edge before, Edge after) {
        for (Expr e2 : b3) {
            if (e2.op != 257) continue;
            int n2 = e2.pred.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (e2.pred[i2] != before) continue;
                e2.pred[i2] = after;
            }
        }
    }

    Expr append(Edge edge, Expr e2) {
        edge.from.appendExpr(e2);
        return e2;
    }

    Expr prepend(Edge edge, Expr e2) {
        Algorithms.Deque<Expr> exprs = edge.from.exprs;
        exprs.addFirst(e2);
        return e2;
    }

    Expr setlocal(Method m2, int i2, Expr a) {
        return new Expr(m2, 99, -1, i2, new Expr[]{a}, 1, 1);
    }

    Expr getlocal(Method m2, int i2) {
        return new Expr(m2, 98, -1, i2);
    }

    Expr dup(Method m2, Expr e2) {
        Expr dup = new Expr(m2, 42);
        dup.locals = new Expr[]{e2};
        return dup;
    }

    void remove_phi(Method m2) {
        ConflictGraph conflicts;
        TreeMap<Block, Algorithms.Deque<Expr>> exprs;
        TreeMap<Integer, Integer> locals;
        Algorithms.SetMap<Block, Edge> pred;
        Algorithms.Deque<Block> code;
        block10: {
            code = Algorithms.dfs(m2.entry.to);
            pred = Algorithms.preds(code);
            locals = new TreeMap<Integer, Integer>();
            exprs = new TreeMap<Block, Algorithms.Deque<Expr>>();
            conflicts = new ConflictGraph();
            this.printMethod(m2, "BEFORE SCHED");
            GlobalOptimizer.addTraceAttr(m2);
            if (m2.needsArguments() || m2.needsRest()) {
                int rest = m2.getParams().length;
                for (Expr e2 : m2.entry.to) {
                    if (e2.op != 256 || e2.imm[0] != rest) continue;
                    break block10;
                }
                m2.flags &= 0xFFFFFFFA;
                m2.flags |= 0x10;
                this.verboseStatus("IGNORE_REST for " + m2.getName());
            }
        }
        int max_local = m2.getParams().length - 1;
        this.sched_greedy(m2, code, locals, pred, exprs, conflicts);
        this.alloc_locals(code, locals, conflicts, m2.fixedLocals);
        TreeSet<Edge> splits = new TreeSet<Edge>();
        for (Block b3 : code) {
            for (Expr e3 : b3) {
                if (e3.op != 257) break;
                if (!locals.containsKey(e3.id)) continue;
                GlobalOptimizer.addTraceAttr(e3);
                int lhs = (Integer)locals.get(e3.id);
                for (int i2 = e3.args.length - 1; i2 >= 0; --i2) {
                    GlobalOptimizer.traceEntry("PhiInput");
                    GlobalOptimizer.addTraceAttr("i", i2);
                    GlobalOptimizer.addTraceAttr(e3.args[i2]);
                    int rhs = (Integer)locals.get(e3.args[i2].id);
                    if (lhs == rhs) continue;
                    Edge p2 = e3.pred[i2];
                    if (!splits.contains(p2)) {
                        GlobalOptimizer.split(p2, m2, pred);
                        p2 = e3.pred[i2];
                        splits.add(p2);
                    }
                    GlobalOptimizer.traceEntry("copyPhiInput");
                    GlobalOptimizer.addTraceAttr("lhs", lhs);
                    GlobalOptimizer.addTraceAttr("rhs", rhs);
                    Expr get = this.getlocal(m2, rhs);
                    this.prepend(p2, get);
                    this.append(p2, this.setlocal(m2, lhs, get));
                }
            }
            b3.exprs = (Algorithms.Deque)exprs.get(b3);
            for (Expr e3 : b3.exprs) {
                int loc = max_local;
                if (e3.op == 98 || e3.op == 99) {
                    loc = e3.imm[0] = ((Integer)locals.get(e3.imm[0])).intValue();
                } else if (e3.op == 50) {
                    int loc0 = (Integer)locals.get(e3.locals[0].id);
                    int loc1 = (Integer)locals.get(e3.locals[1].id);
                    e3.imm = new int[]{loc0, loc1};
                    int n2 = loc = loc0 > loc1 ? loc0 : loc1;
                }
                if (loc <= max_local) continue;
                max_local = loc;
            }
        }
        m2.local_count = max_local + 1;
        this.cfgopt(m2);
        this.printMethod(m2, "AFTER SCHED");
    }

    void computeFrameCounts(Method m2) {
        Algorithms.Deque<Block> code = Algorithms.dfs(m2.entry.to);
        int max_stack = 0;
        int max_scope = 0;
        TreeMap<Block, Integer> stkin = new TreeMap<Block, Integer>();
        TreeMap<Block, Integer> scpin = new TreeMap<Block, Integer>();
        stkin.put(m2.entry.to, 0);
        scpin.put(m2.entry.to, 0);
        for (Block b3 : code) {
            int stkdepth = (Integer)stkin.get(b3);
            int scpdepth = (Integer)scpin.get(b3);
            for (Expr e2 : b3) {
                assert (!e2.isSynthetic());
                assert (stkdepth >= e2.args.length);
                stkdepth -= e2.args.length;
                if (e2.onStack()) {
                    ++stkdepth;
                }
                if (stkdepth > max_stack) {
                    max_stack = stkdepth;
                }
                assert (scpdepth >= e2.scopes.length);
                if (e2.op == 29) {
                    --scpdepth;
                } else if (e2.onScope()) {
                    ++scpdepth;
                }
                if (scpdepth <= max_scope) continue;
                max_scope = scpdepth;
            }
            for (Edge s2 : b3.succ()) {
                this.update_depth(s2.to, stkdepth, stkin, scpdepth, scpin);
            }
            for (Edge s2 : b3.xsucc) {
                this.update_depth(s2.to, 1, stkin, 0, scpin);
            }
        }
        m2.max_stack = max_stack;
        m2.max_scope = max_scope;
    }

    private void appeaseLegacyVerifier(Method m2) {
        BitSet active;
        LocalVarState block_state;
        GlobalOptimizer.addTraceAttr(m2);
        Algorithms.Deque<Block> code = this.schedule(m2.entry.to);
        Algorithms.SetMap<Block, Edge> pred = Algorithms.preds(code);
        HashSet<Edge> single_path_to_exit = new HashSet<Edge>();
        Map<Block, LocalVarState> reg_state_by_block = this.getLocalVarState(m2);
        TypeConstraintMap constraints = new TypeConstraintMap();
        for (Block b3 : code) {
            this.verboseStatus("Building constraints for " + b3);
            block_state = reg_state_by_block.get(b3);
            assert (block_state != null);
            active = block_state.getActiveVariables();
            for (Edge s2 : b3.succ()) {
                if (this.singlePathToExit(s2, pred, single_path_to_exit)) continue;
                Block successor = s2.to;
                LocalVarState to_state = reg_state_by_block.get(successor);
                assert (to_state != null);
                TypeConstraints tc = constraints.getConstraints(s2);
                BitSet to_livein = to_state.getLivein();
                block2: for (Integer r2 : Algorithms.foreach(active)) {
                    if (to_livein.get(r2) || m2.fixedLocals.values().contains(r2)) continue;
                    if (to_state.def.get(r2) || to_state.killed_vars.get(r2)) {
                        Iterator i$ = pred.get(successor).iterator();
                        while (i$.hasNext()) {
                            Edge p2 = (Edge)i$.next();
                            assert (p2 != null);
                            boolean needs_kill = pred.get(successor).size() > 1;
                            if (!needs_kill) continue;
                            tc.addKill(r2);
                            continue block2;
                        }
                        continue;
                    }
                    tc.addKill(r2);
                }
            }
            BitSet livein = block_state.getLivein();
            for (Integer r3 : Algorithms.foreach(livein)) {
                LocalVarState from_state;
                Edge p3;
                Typeref consensus_type = block_state.getInitialType(r3);
                assert (consensus_type != null);
                Iterator i$ = pred.get(b3).iterator();
                while (i$.hasNext()) {
                    p3 = (Edge)i$.next();
                    from_state = reg_state_by_block.get(p3.from);
                    assert (from_state != null);
                    consensus_type = this.typeMeet(consensus_type, from_state.getFinalType(r3));
                }
                i$ = pred.get(b3).iterator();
                while (i$.hasNext()) {
                    p3 = (Edge)i$.next();
                    from_state = reg_state_by_block.get(p3.from);
                    assert (from_state != null);
                    TypeConstraints tc = constraints.getConstraints(p3);
                    if (block_state.hard_coercions[r3] != null) {
                        tc.addCoercion(r3, block_state.hard_coercions[r3]);
                        continue;
                    }
                    if (!this.needsCoercion(m2, consensus_type, from_state.getFinalType(r3), b3.is_backwards_branch_target)) continue;
                    tc.addCoercion(r3, consensus_type);
                }
            }
        }
        for (Block b3 : code) {
            block_state = reg_state_by_block.get(b3);
            assert (block_state != null);
            active = block_state.getActiveVariables();
            TypeConstraints source_block_constraints = null;
            for (Integer r4 : Algorithms.foreach(active)) {
                TypeConstraints first_constraint = null;
                boolean all_constraints_agree = true;
                for (Edge s3 : b3.succ()) {
                    TypeConstraints tc = constraints.getConstraints(s3);
                    if (null == first_constraint) {
                        first_constraint = tc;
                    }
                    if (!(all_constraints_agree = first_constraint.agreesWith(tc, r4))) break;
                }
                if (!all_constraints_agree) continue;
                if (null == source_block_constraints) {
                    source_block_constraints = new TypeConstraints(null);
                }
                for (Edge s3 : b3.succ()) {
                    source_block_constraints.takeConstraintFrom((TypeConstraints)constraints.get(s3), r4);
                }
            }
            if (source_block_constraints == null) continue;
            this.fixConstraints(m2, b3, source_block_constraints, block_state);
        }
        for (Block b3 : code) {
            for (Edge p4 : b3.succ()) {
                TypeConstraints tc = constraints.getConstraints(p4);
                if ((tc == null || tc.killregs.size() <= 0) && tc.coercions.size() <= 0) continue;
                GlobalOptimizer.split(p4, m2, pred);
                p4.to.must_isolate_block = true;
                this.fixConstraints(m2, p4.to, tc, null);
            }
        }
    }

    boolean singlePathToExit(Edge s2, Algorithms.SetMap<Block, Edge> pred, Set<Edge> known_single_paths) {
        Block b3 = s2.to;
        if (pred.get(b3).size() > 1) {
            return false;
        }
        if (known_single_paths.contains(s2)) {
            return true;
        }
        boolean single_path = false;
        if (b3.succ() == OptimizerConstants.noedges) {
            single_path = true;
        } else {
            Edge s_prime;
            Edge[] arr$ = b3.succ();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (single_path = this.singlePathToExit(s_prime = arr$[i$], pred, known_single_paths)); ++i$) {
            }
        }
        if (single_path) {
            known_single_paths.add(s2);
        }
        return single_path;
    }

    boolean needsCoercion(Method m2, Typeref to_ty, Typeref from_ty, boolean backwards_branch) {
        if (to_ty.equals(from_ty) || this.ignoreTypeConflict(m2, to_ty, from_ty)) {
            return false;
        }
        if (this.isNumericType(from_ty) && this.isNumericType(to_ty)) {
            return false;
        }
        Typeref merged_type = this.typeMerge(to_ty, from_ty);
        boolean needs_coercion = null == merged_type ? true : (backwards_branch ? true : !to_ty.t.isMachineCompatible(merged_type.t));
        return needs_coercion;
    }

    private boolean isNumericType(Typeref ty) {
        return ty.t.numeric;
    }

    boolean ignoreTypeConflict(Method m2, Typeref to_ty, Typeref from_ty) {
        boolean result = to_ty.t.getName().name.startsWith("global") && from_ty.t.getName().name.startsWith("global");
        return result |= from_ty.t.equals(m2.activation.t) && to_ty.t.equals(m2.activation.t);
    }

    void fixConstraints(Method m2, Block b3, TypeConstraints bc2, LocalVarState block_state) {
        this.verboseStatus("fixConstraints " + b3);
        HashMap<Expr, Expr> coerce_in_place = new HashMap<Expr, Expr>();
        if (block_state != null) {
            HashSet<Integer> coerced_locals = new HashSet<Integer>(bc2.coercions.keySet());
            for (Integer r2 : coerced_locals) {
                Expr generator;
                if (block_state.read_after_def.get(r2) || (generator = (Expr)block_state.generating_exprs.get(r2)) == null) continue;
                coerce_in_place.put(generator, this.coerceExpr(m2, bc2.coercions.get((Object)r2).t, generator));
                bc2.coercions.remove(r2);
            }
            if (!coerce_in_place.isEmpty()) {
                Algorithms.ArrayDeque<Expr> replaced_exprs = new Algorithms.ArrayDeque<Expr>();
                while (!b3.exprs.isEmpty()) {
                    Expr ex = b3.exprs.removeFirst();
                    if (coerce_in_place.containsKey(ex)) {
                        replaced_exprs.add((Expr)coerce_in_place.get(ex));
                        coerce_in_place.remove(ex);
                    }
                    replaced_exprs.add(ex);
                }
                assert (coerce_in_place.isEmpty());
                b3.exprs = replaced_exprs;
            }
        }
        Expr last = b3.succ().length > 0 ? b3.exprs.removeLast() : null;
        for (Integer regnum : bc2.coercions.keySet()) {
            Expr void_expr;
            Typeref ty = bc2.coercions.get(regnum);
            if (ty.equals(GlobalOptimizer.VOID().ref)) {
                void_expr = Expr.createWithValue(m2, 33, OptimizerConstants.UNDEFINED);
                b3.exprs.add(void_expr);
                b3.exprs.add(this.setlocal(m2, regnum, void_expr));
            }
            if (ty.equals(GlobalOptimizer.NULL().ref)) {
                void_expr = Expr.createWithValue(m2, 32, GlobalOptimizer.NULL());
                b3.exprs.add(void_expr);
                b3.exprs.add(this.setlocal(m2, regnum, void_expr));
            } else {
                Expr getlocal = this.getlocal(m2, regnum);
                b3.exprs.add(getlocal);
                Expr coerce_expr = this.coerceExpr(m2, ty.t, getlocal);
                b3.exprs.add(coerce_expr);
                b3.exprs.add(this.setlocal(m2, regnum, coerce_expr));
            }
            this.verboseStatus("\tlocal " + regnum);
        }
        for (Integer k2 : bc2.killregs) {
            b3.exprs.add(new Expr(m2, 8, -1, k2));
            this.verboseStatus("kill " + k2);
        }
        if (last != null) {
            b3.exprs.add(last);
        }
    }

    Expr coerceExpr(Method m2, Type t2, Expr a) {
        Expr result = null;
        assert (t2 != null);
        result = GlobalOptimizer.ANY().equals(t2) ? new Expr(m2, 130, a) : (GlobalOptimizer.VOID().equals(t2) ? Expr.createWithValue(m2, 33, OptimizerConstants.UNDEFINED) : (GlobalOptimizer.NULL().equals(t2) ? Expr.createWithValue(m2, 32, GlobalOptimizer.NULL()) : (GlobalOptimizer.INT().equals(t2) ? new Expr(m2, 115, a) : (GlobalOptimizer.OBJECT().equals(t2) ? new Expr(m2, 137, a) : (GlobalOptimizer.STRING().equals(t2) ? new Expr(m2, 133, a) : new Expr(m2, 128, t2.getName(), a))))));
        this.verboseStatus("coerceExpr " + this.formatExpr(result));
        return result;
    }

    void alloc_locals(Algorithms.Deque<Block> code, Map<Integer, Integer> locals, ConflictGraph conflicts, Map<Expr, Integer> fixed_locals) {
        for (Block b3 : code) {
            for (Expr e2 : b3) {
                if (!locals.containsKey(e2.id)) continue;
                this.alloc1(e2, conflicts, locals);
                if (!fixed_locals.containsKey(e2) || locals.get(e2.id) == -1) continue;
                fixed_locals.put(e2, locals.get(e2.id));
            }
        }
        for (Block b3 : code) {
            for (Expr e2 : b3) {
                if (!locals.containsKey(e2.id)) continue;
                this.alloc2(e2, conflicts, locals);
                if (!fixed_locals.containsKey(e2) || locals.get(e2.id) == -1) continue;
                fixed_locals.put(e2, locals.get(e2.id));
            }
        }
        this.verboseStatus("CONFLICTS " + conflicts);
        this.verboseStatus("LOCALS " + locals);
    }

    void update_depth(Block b3, int stkdepth, Map<Block, Integer> stkin, int scpdepth, Map<Block, Integer> scpin) {
        if (stkin.containsKey(b3)) {
            assert (stkin.get(b3) == stkdepth);
        } else {
            stkin.put(b3, stkdepth);
        }
        if (!scpin.containsKey(b3)) {
            scpin.put(b3, scpdepth);
        }
    }

    void allocate(int id, int loc, Map<Integer, Integer> locals, ConflictGraph conflicts) {
        GlobalOptimizer.traceEntry("allocate");
        GlobalOptimizer.addTraceAttr("id", id);
        GlobalOptimizer.addTraceAttr("loc", loc);
        assert (locals.get(id) == -1 && loc != -1);
        locals.put(id, loc);
        for (int j2 : conflicts.get(id)) {
            assert (locals.get(j2) != loc);
        }
    }

    void alloc1(Expr e2, ConflictGraph conflicts, Map<Integer, Integer> locals) {
        if (locals.get(e2.id) != -1) {
            return;
        }
        BitSet used = new BitSet();
        for (int i2 : conflicts.get(e2.id)) {
            if (locals.get(i2) == -1) continue;
            used.set(locals.get(i2));
        }
        int loc = -1;
        if (e2.locals.length == 1 && e2.inLocal() && locals.containsKey(e2.locals[0].id) && (loc = locals.get(e2.locals[0].id).intValue()) != -1) {
            assert (!used.get(loc));
            this.allocate(e2.id, loc, locals, conflicts);
        }
        if (e2.op != 257) {
            return;
        }
        for (Expr a : e2.args) {
            if (!locals.containsKey(a.id) || (loc = locals.get(a.id).intValue()) == -1 || used.get(loc)) continue;
            this.allocate(e2.id, loc, locals, conflicts);
            break;
        }
        if (loc == -1) {
            loc = 0;
            while (used.get(loc)) {
                ++loc;
            }
            this.allocate(e2.id, loc, locals, conflicts);
        }
        block3: for (Expr a : e2.args) {
            if (locals.get(a.id) != -1) continue;
            for (int j2 : conflicts.get(a.id)) {
                if (locals.get(j2) != loc) continue;
                continue block3;
            }
            this.allocate(a.id, loc, locals, conflicts);
        }
    }

    void alloc2(Expr e2, ConflictGraph conflicts, Map<Integer, Integer> locals) {
        int loc;
        if (locals.get(e2.id) != -1) {
            return;
        }
        BitSet used = new BitSet();
        for (int i2 : conflicts.get(e2.id)) {
            if (locals.get(i2) == -1) continue;
            used.set(locals.get(i2));
        }
        assert (e2.locals.length != 1 || !e2.inLocal() || !locals.containsKey(e2.locals[0].id) || locals.get(e2.locals[0].id) == -1);
        if (e2.args.length != 0 && locals.containsKey(e2.args[0].id) && (loc = locals.get(e2.args[0].id).intValue()) != -1 && !used.get(loc)) {
            GlobalOptimizer.addTraceAttr("MayUseLoc", loc);
            this.allocate(e2.id, loc, locals, conflicts);
            return;
        }
        loc = 0;
        while (used.get(loc)) {
            ++loc;
        }
        this.allocate(e2.id, loc, locals, conflicts);
    }

    Map<Block, LocalVarState> getLocalVarState(Method m2) {
        TreeMap<Block, LocalVarState> result = new TreeMap<Block, LocalVarState>();
        TreeMap<Block, Typeref[]> frames_by_block = new TreeMap<Block, Typeref[]>();
        Algorithms.Deque<Block> code = this.schedule(m2.entry.to);
        Typeref[] frame_state = new Typeref[m2.local_count];
        System.arraycopy(m2.getParams(), 0, frame_state, 0, m2.getParams().length);
        for (int i2 = m2.getParams().length; i2 < frame_state.length; ++i2) {
            frame_state[i2] = GlobalOptimizer.ANY().ref;
        }
        this.verboseStatus("FRAME_STATE");
        for (Block b3 : code) {
            if (frames_by_block.containsKey(b3)) {
                frame_state = (Typeref[])frames_by_block.get(b3);
            }
            frame_state = this.buildLocalState(m2, b3, frame_state, result, frames_by_block);
        }
        this.computeLiveout(code, result);
        return result;
    }

    Typeref[] buildLocalState(Method m2, Block b3, Typeref[] frame_state, Map<Block, LocalVarState> local_map, Map<Block, Typeref[]> states_by_block) {
        LocalVarState block_state = local_map.get(b3);
        if (null == block_state) {
            block_state = new LocalVarState(m2, b3, frame_state);
            local_map.put(b3, block_state);
            switch (b3.exprs.peekLast().op) {
                default: {
                    break;
                }
                case 27: {
                    for (Edge p2 : b3.succ()) {
                        this.checkTarget(b3, p2.to, block_state.fs_out, states_by_block);
                    }
                    break;
                }
                case 16: {
                    this.checkTarget(b3, b3.succ()[0].to, block_state.fs_out, states_by_block);
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    this.checkTarget(b3, b3.succ()[1].to, block_state.fs_out, states_by_block);
                }
            }
        }
        return local_map.get((Object)b3).fs_out;
    }

    void checkTarget(Block branching_block, Block target_block, Typeref[] current_frame_state, Map<Block, Typeref[]> frames_by_block) {
        if (!frames_by_block.containsKey(target_block)) {
            this.verboseStatus("    .. checkTarget(" + branching_block + "->" + target_block + ") copying frame state");
            Typeref[] target_frame = new Typeref[current_frame_state.length];
            System.arraycopy(current_frame_state, 0, target_frame, 0, current_frame_state.length);
            frames_by_block.put(target_block, target_frame);
        } else {
            Typeref[] previous_state = frames_by_block.get(target_block);
            this.verboseStatus("    .. checkTarget(" + branching_block + "->" + target_block + ") merging frame state");
            for (int i2 = 0; i2 < previous_state.length; ++i2) {
                Typeref merged_type = this.typeMeet(previous_state[i2], current_frame_state[i2]);
                previous_state[i2] = target_block.is_backwards_branch_target ? merged_type.nullable() : merged_type;
            }
        }
        this.dumpFrameState(current_frame_state);
    }

    void dumpFrameState(Typeref[] fs_out) {
        if (this.verbose_mode) {
            StringBuffer frame_state_buffer = new StringBuffer();
            frame_state_buffer.append("\tLocals: ");
            for (int i2 = 0; i2 < fs_out.length; ++i2) {
                frame_state_buffer.append(fs_out[i2].toString());
                frame_state_buffer.append(" ");
            }
            this.verboseStatus(frame_state_buffer);
        }
    }

    void computeLiveout(Algorithms.Deque<Block> code, Map<Block, LocalVarState> live_map) {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Block b3 : code) {
                LocalVarState current_state = live_map.get(b3);
                BitSet next_liveout = new BitSet();
                for (Edge p2 : b3.succ()) {
                    next_liveout.or(live_map.get(p2.to).getLivein());
                }
                for (Edge x2 : b3.xsucc) {
                    next_liveout.or(live_map.get(x2.to).getLivein());
                }
                changed |= current_state.mergeLiveout(next_liveout);
            }
        }
    }

    boolean hasStackEffect(Expr e2) {
        if (e2 == null || e2.op == 256) {
            return true;
        }
        return e2.onStack() || e2.args.length > 0;
    }

    Typeref typeMerge(Typeref t1, Typeref t2) {
        Typeref result = null;
        Type merged_type = this.typeMeet(t1.t, t2.t);
        if (!merged_type.equals(GlobalOptimizer.ANY()) || t1.t.equals(GlobalOptimizer.ANY()) && t2.t.equals(GlobalOptimizer.ANY())) {
            result = new Typeref(merged_type, t1.nullable || t2.nullable);
        }
        return result;
    }

    Typeref typeMeet(Typeref t1, Typeref t2) {
        Typeref result = null;
        Type merged_type = this.typeMeet(t1.t, t2.t);
        result = new Typeref(merged_type, t1.nullable | t2.nullable);
        return result;
    }

    Type typeMeet(Type t1, Type t2) {
        if (t1.equals(t2)) {
            return t1;
        }
        if (this.isNumericType(t1.ref) && this.isNumericType(t2.ref)) {
            return GlobalOptimizer.NUMBER();
        }
        if (GlobalOptimizer.VOID().equals(t1) || GlobalOptimizer.NULL().equals(t1)) {
            return t2;
        }
        if (GlobalOptimizer.VOID().equals(t2) || GlobalOptimizer.NULL().equals(t2)) {
            return t1;
        }
        Type common_base = TypeAnalysis.mdb((Typeref)t1.ref, (Typeref)t2.ref).t;
        return common_base;
    }

    Type opCoercesArgsToType(int op) {
        switch (op) {
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 80: 
            case 81: 
            case 82: 
            case 115: 
            case 131: 
            case 151: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 192: 
            case 193: 
            case 196: 
            case 197: 
            case 198: 
            case 199: {
                return GlobalOptimizer.INT();
            }
            case 116: {
                return GlobalOptimizer.UINT();
            }
            case 144: 
            case 145: 
            case 147: 
            case 161: 
            case 162: 
            case 164: {
                return GlobalOptimizer.NUMBER();
            }
        }
        return null;
    }

    ConflictGraph sched_greedy(Method m2, Algorithms.Deque<Block> code, Map<Integer, Integer> locals, Algorithms.SetMap<Block, Edge> pred, Map<Block, Algorithms.Deque<Expr>> exprs, ConflictGraph cg) {
        GlobalOptimizer.addTraceAttr(m2);
        Algorithms.SetMap<Block, Expr> liveout = new Algorithms.SetMap<Block, Expr>();
        TreeMap<Block, Algorithms.Deque<Expr>> stkout = new TreeMap<Block, Algorithms.Deque<Expr>>();
        HashMap<Block, Algorithms.LinkedDeque<Object>> listings = new HashMap<Block, Algorithms.LinkedDeque<Object>>();
        PriorityQueue<Block> work = new PriorityQueue<Block>(code.size(), new Comparator<Block>(){

            @Override
            public int compare(Block b12, Block b22) {
                return b12.postorder - b22.postorder;
            }
        });
        work.addAll(code);
        while (!work.isEmpty()) {
            Block b3 = (Block)work.remove();
            while (work.peek() == b3) {
                work.remove();
            }
            TreeSet<Expr> live = new TreeSet<Expr>();
            Algorithms.ArrayDeque<Expr> in = new Algorithms.ArrayDeque<Expr>((Collection<Expr>)b3.exprs);
            Algorithms.ArrayDeque<Expr> stk = new Algorithms.ArrayDeque<Expr>();
            Algorithms.ArrayDeque<Expr> scp = new Algorithms.ArrayDeque<Expr>();
            Algorithms.LinkedDeque<Object> verbose = new Algorithms.LinkedDeque<Object>();
            Algorithms.LinkedDeque<Expr> out = new Algorithms.LinkedDeque<Expr>();
            TreeSet out_of_order = new TreeSet();
            GlobalOptimizer.addTraceAttr(b3);
            live.addAll((Collection<Expr>)liveout.get(b3));
            live.addAll(b3.getLiveOut());
            live.addAll(m2.fixedLocals.keySet());
            for (Expr l2 : live) {
                locals.put(l2.id, l2.op == 256 ? l2.imm[0] : -1);
            }
            exprs.put(b3, out);
            listings.put(b3, verbose);
            TreeSet<Expr> phis = new TreeSet<Expr>();
            while (!in.isEmpty() || !stk.isEmpty()) {
                Expr e2;
                while (!stk.isEmpty() && this.hasStackEffect((Expr)in.peekLast())) {
                    this.showstate(live, stk, scp, verbose);
                    e2 = this.remove_dup(stk, m2, out, verbose);
                    GlobalOptimizer.addTraceAttr(e2);
                    GlobalOptimizer.addTraceAttr("formattedExpr", this.formatExpr(e2));
                    if (e2.inLocal() || e2.op == 257 || e2 != in.peekLast() || stk.contains(e2)) {
                        GlobalOptimizer.addTraceAttr(e2);
                        if (e2.inLocal()) {
                            GlobalOptimizer.addTraceAttr("inLocal");
                        } else if (e2.op == 257) {
                            GlobalOptimizer.addTraceAttr("OP_phi");
                        } else if (e2 != in.peekLast()) {
                            GlobalOptimizer.addTraceAttr("stackMismatch", e2.toString() + " != last Expr: " + this.formatExpr((Expr)in.peekLast()));
                        } else if (stk.contains(e2)) {
                            GlobalOptimizer.addTraceAttr("stackOverload", "stk.contains(" + e2.toString() + ")");
                        }
                        this.issue_load(e2, m2, out, verbose, live, locals);
                        continue;
                    }
                    if (live.contains(e2)) {
                        GlobalOptimizer.traceEntry("DefineLiveExpr", e2);
                        this.define(e2, live, cg);
                        this.issue_store(e2, m2, out, verbose, stk);
                        GlobalOptimizer.traceEntry("PushBack", e2);
                        stk.add(e2);
                        continue;
                    }
                    if (e2.op == 258) {
                        assert (stk.isEmpty());
                        while (!stk.isEmpty()) {
                            this.loadTOS(m2, stk, scp, out, verbose, live, locals);
                        }
                        verbose.addFirst(in.removeLast());
                        continue;
                    }
                    GlobalOptimizer.traceEntry("IssueExpr", e2);
                    this.issue_expr((Expr)in.removeLast(), m2, out, verbose, stk, live, locals);
                }
                if (in.isEmpty()) continue;
                this.showstate(live, stk, scp, verbose);
                e2 = (Expr)in.removeLast();
                GlobalOptimizer.addTraceAttr(e2);
                GlobalOptimizer.addTraceAttr("formattedExpr", this.formatExpr(e2));
                if (out_of_order.contains(e2)) {
                    GlobalOptimizer.traceEntry("IssuedOutOfOrder", e2);
                    continue;
                }
                if (e2.op == 257) {
                    this.issue_phi(e2, verbose, phis, live, cg);
                    continue;
                }
                if (e2.op == 256) {
                    verbose.addFirst(e2);
                    if (!live.contains(e2)) continue;
                    this.define(e2, live, cg);
                    continue;
                }
                if (live.contains(e2)) {
                    GlobalOptimizer.traceEntry("LiveExpr");
                    GlobalOptimizer.addTraceAttr(e2);
                    this.define(e2, live, cg);
                    if (e2.onStack()) {
                        GlobalOptimizer.traceEntry("StoreLiveExprFromStack ", e2);
                        this.issue_store(e2, m2, out, verbose, stk);
                        GlobalOptimizer.traceEntry("PushBackOnStack", e2);
                        in.add(e2);
                        continue;
                    }
                    if (e2.inLocal()) {
                        GlobalOptimizer.traceEntry("IssueExprFromLocal", e2);
                        this.issue_expr(e2, m2, out, verbose, stk, live, locals);
                        continue;
                    }
                    if (e2.onScope()) {
                        GlobalOptimizer.traceEntry("IssueScopeExpr", e2);
                        this.issue_expr(e2, m2, out, verbose, stk, live, locals);
                        continue;
                    }
                    assert (false);
                    continue;
                }
                if (e2.op == 258) {
                    this.issue_pop(m2, out, verbose, e2);
                    verbose.addFirst(e2);
                    continue;
                }
                GlobalOptimizer.addTraceAttr(e2);
                if (e2.onStack()) {
                    GlobalOptimizer.traceEntry("StackPop", e2);
                    this.issue_pop(m2, out, verbose, e2);
                }
                this.issue_expr(e2, m2, out, verbose, stk, live, locals);
            }
            this.fwd_state(m2, locals, pred, liveout, stkout, work, b3, live, stk, scp, verbose, out, phis);
        }
        this.verboseStatus("STK_LIVEOUT " + liveout);
        this.verboseStatus("CONFLICTS " + cg);
        for (Block b4 : code) {
            this.verboseStatus("");
            this.verboseStatus(b4);
            for (Object o2 : (Algorithms.Deque)listings.get(b4)) {
                if (o2 instanceof Expr) {
                    this.print((Expr)o2);
                    continue;
                }
                this.verboseStatus(o2);
            }
        }
        return cg;
    }

    static void traceEntry(String traceTag) {
        if (tm == null) {
            return;
        }
        tm.traceEntry(traceTag);
    }

    static void traceEntry(String traceTag, String attrValue) {
        if (tm == null) {
            return;
        }
        tm.traceEntry(traceTag, attrValue);
    }

    static void traceEntry(String traceTag, String attrName, String attrValue) {
        if (tm == null) {
            return;
        }
        tm.traceEntry(traceTag, attrName, attrValue);
    }

    static void traceEntry(String traceTag, String attrName, Object attrValue) {
        if (tm == null) {
            return;
        }
        tm.traceEntry(traceTag);
        GlobalOptimizer.addTraceAttr(attrName, attrValue);
    }

    static void traceEntry(String traceTag, int attrValue) {
        if (tm == null) {
            return;
        }
        tm.traceEntry(traceTag, attrValue);
    }

    static void traceEntry(String traceTag, Expr expr) {
        if (tm == null) {
            return;
        }
        GlobalOptimizer.traceEntry(traceTag);
        GlobalOptimizer.addTraceAttr(expr);
    }

    static void addTraceAttr(String attrName) {
        if (tm == null) {
            return;
        }
        tm.addAttr(attrName, "true");
    }

    static void addTraceAttr(Object o2) {
        if (tm == null) {
            return;
        }
        if (null == o2) {
            return;
        }
        if (o2 instanceof Block) {
            GlobalOptimizer.addTraceAttr("Block", o2);
        } else if (o2 instanceof Edge) {
            GlobalOptimizer.addTraceAttr("Edge", o2);
        } else if (o2 instanceof Expr) {
            GlobalOptimizer.addTraceAttr("Expr", o2);
        } else if (o2 instanceof Method) {
            GlobalOptimizer.addTraceAttr("Method", o2);
        } else {
            GlobalOptimizer.addTraceAttr(o2.getClass().getSimpleName(), o2);
        }
    }

    static void addTraceAttr(String attrName, Object attr) {
        if (tm == null) {
            return;
        }
        tm.addAttr(attrName, attr);
        if (attr != null && (attrName.equalsIgnoreCase("Expr") || attrName.equalsIgnoreCase("Method") || attrName.equalsIgnoreCase("Block"))) {
            tm.addAttr("HashCode", Integer.toHexString(attr.hashCode()));
        }
    }

    static void addTraceAttr(String attrName, int attr) {
        if (tm == null) {
            return;
        }
        tm.addAttr(attrName, attr);
    }

    static void addTraceAttr(String attrName, String attr) {
        if (tm == null) {
            return;
        }
        tm.addAttr(attrName, attr);
    }

    void showstate(Set<Expr> live, Algorithms.Deque<Expr> stk, Algorithms.Deque<Expr> scp, Algorithms.Deque<Object> verbose) {
        verbose.addFirst("              live " + live + " stk " + stk);
        if (!scp.isEmpty()) {
            verbose.addFirst("              scp  " + scp);
        }
    }

    Expr remove_dup(Algorithms.Deque<Expr> stk, Method m2, Algorithms.Deque<Expr> out, Algorithms.Deque<Object> verbose) {
        Expr e2 = stk.removeLast();
        while (e2 == stk.peekLast()) {
            this.issue_dup(stk.removeLast(), m2, out, verbose);
        }
        return e2;
    }

    void try_dup(Algorithms.Deque<Expr> stk, Method m2, Algorithms.Deque<Expr> out, Algorithms.Deque<Object> verbose) {
        if (stk.size() > 2) {
            Expr e2 = stk.removeLast();
            while (e2 == stk.peekLast()) {
                this.issue_dup(stk.removeLast(), m2, out, verbose);
            }
            stk.add(e2);
        }
    }

    void issue_phi(Expr e2, Algorithms.Deque<Object> verbose, Set<Expr> phis, Set<Expr> live, ConflictGraph cg) {
        GlobalOptimizer.addTraceAttr(e2);
        GlobalOptimizer.addTraceAttr("live", live.contains(e2));
        verbose.addFirst(e2);
        phis.add(e2);
        if (live.contains(e2)) {
            for (Expr l2 : live) {
                if (l2 == e2) continue;
                GlobalOptimizer.traceEntry("conflict");
                GlobalOptimizer.addTraceAttr(e2);
                GlobalOptimizer.addTraceAttr("conflictsWith", l2);
                cg.add(l2, e2);
            }
        }
    }

    ConflictGraph sched_lazy(Method m2, Algorithms.Deque<Block> code, Map<Integer, Integer> locals, Algorithms.SetMap<Block, Edge> pred, Map<Block, Algorithms.Deque<Expr>> exprs, ConflictGraph cg) {
        Algorithms.SetMap<Block, Expr> liveout = new Algorithms.SetMap<Block, Expr>();
        TreeMap<Block, Algorithms.Deque<Expr>> stkout = new TreeMap<Block, Algorithms.Deque<Expr>>();
        HashMap<Block, Algorithms.LinkedDeque<Object>> listings = new HashMap<Block, Algorithms.LinkedDeque<Object>>();
        PriorityQueue<Block> work = new PriorityQueue<Block>(code.size(), new Comparator<Block>(){

            @Override
            public int compare(Block b12, Block b22) {
                return b12.postorder - b22.postorder;
            }
        });
        work.addAll(code);
        while (!work.isEmpty()) {
            Block b3 = (Block)work.remove();
            while (work.peek() == b3) {
                work.remove();
            }
            TreeSet<Expr> live = new TreeSet<Expr>();
            Algorithms.ArrayDeque<Expr> in = new Algorithms.ArrayDeque<Expr>((Collection<Expr>)b3.exprs);
            Algorithms.ArrayDeque<Expr> stk = new Algorithms.ArrayDeque<Expr>();
            Algorithms.ArrayDeque<Expr> scp = new Algorithms.ArrayDeque<Expr>();
            Algorithms.LinkedDeque<Object> verbose = new Algorithms.LinkedDeque<Object>();
            Algorithms.LinkedDeque<Expr> out = new Algorithms.LinkedDeque<Expr>();
            if (stkout.containsKey(b3)) {
                stk.addAll((Collection)stkout.get(b3));
            }
            live.addAll((Collection<Expr>)liveout.get(b3));
            for (Expr l2 : live) {
                locals.put(l2.id, l2.op == 256 ? l2.imm[0] : -1);
            }
            exprs.put(b3, out);
            listings.put(b3, verbose);
            TreeSet<Expr> phis = new TreeSet<Expr>();
            while (!in.isEmpty()) {
                this.showstate(live, stk, scp, verbose);
                Expr e2 = (Expr)in.removeLast();
                if (e2.op == 257) {
                    this.issue_phi(e2, verbose, phis, live, cg);
                    continue;
                }
                assert (phis.isEmpty());
                boolean onstack = false;
                while (stk.contains(e2)) {
                    onstack = true;
                    Expr f2 = this.remove_dup(stk, m2, out, verbose);
                    if (f2 == e2 && !stk.contains(e2)) continue;
                    this.issue_load(f2, m2, out, verbose, live, locals);
                }
                if (e2.op == 256) {
                    if (onstack) {
                        this.issue_load(e2, m2, out, verbose, live, locals);
                    }
                    verbose.addFirst(e2);
                    if (!live.contains(e2)) continue;
                    this.define(e2, live, cg);
                    continue;
                }
                if (live.contains(e2)) {
                    if (e2.op == 258) {
                        while (!stk.isEmpty()) {
                            this.loadTOS(m2, stk, scp, out, verbose, live, locals);
                        }
                    }
                    this.define(e2, live, cg);
                    if (onstack) {
                        stk.add(e2);
                    }
                    this.issue_store(e2, m2, out, verbose, stk);
                    in.add(e2);
                    continue;
                }
                if (e2.op == 258) {
                    if (!stk.isEmpty()) {
                        while (!stk.isEmpty()) {
                            this.loadTOS(m2, stk, scp, out, verbose, live, locals);
                        }
                        in.add(e2);
                        if (!onstack) continue;
                        stk.add(e2);
                        continue;
                    }
                    if (!onstack) {
                        this.issue_pop(m2, out, verbose, e2);
                    }
                    verbose.addFirst(e2);
                    continue;
                }
                if (!onstack && e2.onStack()) {
                    this.issue_pop(m2, out, verbose, e2);
                }
                this.issue_expr(e2, m2, out, verbose, stk, live, locals);
            }
            this.fwd_state(m2, locals, pred, liveout, stkout, work, b3, live, stk, scp, verbose, out, phis);
        }
        this.verboseStatus("SCHED LIVEOUT " + liveout);
        this.verboseStatus("SCHED STKOUT " + stkout);
        this.verboseStatus("SCHED CONFLICTS " + cg);
        for (Block b4 : code) {
            this.verboseStatus("");
            this.verboseStatus(b4);
            for (Object o2 : (Algorithms.Deque)listings.get(b4)) {
                if (o2 instanceof Expr) {
                    this.print((Expr)o2);
                    continue;
                }
                this.verboseStatus(o2);
            }
        }
        return cg;
    }

    void loadTOS(Method m2, Algorithms.Deque<Expr> stk, Algorithms.Deque<Expr> scp, Algorithms.Deque<Expr> out, Algorithms.Deque<Object> verbose, Set<Expr> live, Map<Integer, Integer> locals) {
        this.showstate(live, stk, scp, verbose);
        Expr e2 = stk.removeLast();
        if (e2 == stk.peekLast()) {
            this.issue_dup(e2, m2, out, verbose);
        } else {
            this.issue_load(e2, m2, out, verbose, live, locals);
        }
    }

    void fwd_state(Method m2, Map<Integer, Integer> locals, Algorithms.SetMap<Block, Edge> pred, Algorithms.SetMap<Block, Expr> liveout, Map<Block, Algorithms.Deque<Expr>> stkout, PriorityQueue<Block> work, Block b3, Set<Expr> live, Algorithms.Deque<Expr> stk, Algorithms.Deque<Expr> scp, Algorithms.Deque<Object> verbose, Algorithms.Deque<Expr> out, Set<Expr> phis) {
        Block f2;
        Edge p2;
        TreeMap<Block, Algorithms.Deque<Expr>> stkout2 = new TreeMap<Block, Algorithms.Deque<Expr>>(stkout);
        Iterator i$ = pred.get(b3).iterator();
        while (i$.hasNext()) {
            p2 = (Edge)i$.next();
            f2 = p2.from;
            Algorithms.Deque<Expr> stk2 = this.clone_stk(phis, stk, p2);
            if (!stkout2.containsKey(f2)) {
                stkout2.put(f2, stk2);
                continue;
            }
            int prefix = this.stacks_equal(stk2, stkout2.get(f2));
            assert (stk.size() >= prefix);
            while (stk.size() > prefix) {
                this.loadTOS(m2, stk, scp, out, verbose, live, locals);
            }
        }
        this.showstate(live, stk, scp, verbose);
        i$ = pred.get(b3).iterator();
        while (i$.hasNext()) {
            p2 = (Edge)i$.next();
            f2 = p2.from;
            Set<Expr> live2 = this.clone_live(phis, live, p2);
            if (liveout.get(f2).addAll(live2)) {
                work.add(f2);
            }
            Algorithms.Deque<Expr> stk2 = this.clone_stk(phis, stk, p2);
            if (!stkout.containsKey(f2)) {
                stkout.put(f2, stk2);
                continue;
            }
            int prefix = this.stacks_equal(stk2, stkout.get(f2));
            assert (stk2.size() == prefix && stkout.get(f2).size() >= prefix);
            if (stkout.get(f2).size() <= prefix) continue;
            stkout.put(f2, stk2);
            work.add(f2);
            for (Edge s2 : f2.succ()) {
                if (s2.to == b3) continue;
                work.add(s2.to);
            }
        }
    }

    Set<Expr> clone_live(Set<Expr> phis, Set<Expr> live, Edge p2) {
        if (phis.isEmpty() || live.isEmpty()) {
            return live;
        }
        TreeSet<Expr> copy = new TreeSet<Expr>();
        for (Expr e2 : live) {
            copy.add(phis.contains(e2) ? e2.args[this.findPhiArg(e2, p2)] : e2);
        }
        return copy;
    }

    Algorithms.Deque<Expr> clone_stk(Set<Expr> phis, Algorithms.Deque<Expr> stk, Edge p2) {
        if (phis.isEmpty() || stk.isEmpty()) {
            return stk;
        }
        Algorithms.ArrayDeque<Expr> copy = new Algorithms.ArrayDeque<Expr>();
        for (Expr e2 : stk) {
            copy.add(phis.contains(e2) ? e2.args[this.findPhiArg(e2, p2)] : e2);
        }
        return copy;
    }

    int stacks_equal(Algorithms.Deque<Expr> stk1, Algorithms.Deque<Expr> stk2) {
        int i2 = 0;
        Iterator i1 = stk1.iterator();
        Iterator i22 = stk2.iterator();
        while (i1.hasNext() && i22.hasNext()) {
            if (i1.next() != i22.next()) {
                return i2;
            }
            ++i2;
        }
        return i2;
    }

    void define(Expr e2, Set<Expr> live, ConflictGraph cg) {
        GlobalOptimizer.addTraceAttr(e2);
        live.remove(e2);
        for (Expr l2 : live) {
            cg.add(e2, l2);
            GlobalOptimizer.traceEntry("conflict");
            GlobalOptimizer.addTraceAttr(e2);
            GlobalOptimizer.addTraceAttr("conflictsWith", l2);
        }
    }

    void issue_expr(Expr e2, Method m2, Algorithms.Deque<Expr> out, Algorithms.Deque<Object> verbose, Algorithms.Deque<Expr> stk, Set<Expr> live, Map<Integer, Integer> locals) {
        GlobalOptimizer.addTraceAttr(e2);
        if (!e2.isSynthetic()) {
            out.addFirst(e2);
        }
        verbose.addFirst(e2);
        for (Expr a : e2.args) {
            GlobalOptimizer.traceEntry("PushArg", "Expr", a);
            stk.add(a);
        }
        for (Expr a : e2.locals) {
            GlobalOptimizer.traceEntry("UseLocal", "Expr", a);
            this.use(a, live, locals);
        }
        this.try_dup(stk, m2, out, verbose);
    }

    void issue_store(Expr e2, Method m2, Algorithms.Deque<Expr> out, Algorithms.Deque<Object> verbose, Algorithms.Deque<Expr> stk) {
        Expr set = this.setlocal(m2, e2.id, e2);
        GlobalOptimizer.addTraceAttr("setlocalExpr", this.formatExpr(set));
        out.addFirst(set);
        verbose.addFirst(set);
        GlobalOptimizer.traceEntry("Push", this.formatExpr(e2));
        stk.add(e2);
    }

    void issue_dup(Expr e2, Method m2, Algorithms.Deque<Expr> out, Algorithms.Deque<Object> verbose) {
        Expr dup = this.dup(m2, e2);
        out.addFirst(dup);
        GlobalOptimizer.traceEntry("issue_dup", dup);
        verbose.addFirst(dup);
    }

    void issue_pop(Method m2, Algorithms.Deque<Expr> out, Algorithms.Deque<Object> verbose, Expr a) {
        Expr pop = new Expr(m2, 41, a);
        out.addFirst(pop);
        verbose.addFirst(pop);
    }

    void issue_load(Expr e2, Method m2, Algorithms.Deque<Expr> out, Algorithms.Deque<Object> verbose, Set<Expr> live, Map<Integer, Integer> locals) {
        this.use(e2, live, locals);
        Expr get = this.getlocal(m2, e2.id);
        out.addFirst(get);
        GlobalOptimizer.traceEntry("issue_load", get);
        verbose.addFirst(get);
    }

    void use(Expr e2, Set<Expr> live, Map<Integer, Integer> locals) {
        GlobalOptimizer.traceEntry("use");
        GlobalOptimizer.addTraceAttr(e2);
        live.add(e2);
        locals.put(e2.id, e2.op == 256 ? e2.imm[0] : -1);
        GlobalOptimizer.addTraceAttr("locals_entry", locals.get(e2.id));
    }

    void rename(Expr e2, Expr[] args, Map<Expr, Expr> map, Algorithms.EdgeMap<Expr> ssaSucc) {
        GlobalOptimizer.addTraceAttr(e2);
        int n2 = args.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Expr a = args[i2];
            while (map.containsKey(a)) {
                ssaSucc.get(a).remove(e2);
                GlobalOptimizer.traceEntry("renamedArg");
                GlobalOptimizer.addTraceAttr("i", i2);
                GlobalOptimizer.addTraceAttr("orig", args[i2]);
                a = args[i2] = map.get(a);
                a.is_live_out = a.onStack() || a.inLocal();
                GlobalOptimizer.addTraceAttr("new", args[i2]);
                ssaSucc.get(a).add(e2);
            }
        }
    }

    void cp(Algorithms.Deque<Block> code) {
        Algorithms.EdgeMap<Expr> uses = Algorithms.findUses(code);
        HashMap<Expr, Expr> map = new HashMap<Expr, Expr>();
        Algorithms.ExprWorkQueue work = new Algorithms.ExprWorkQueue(uses);
        for (Block b3 : code) {
            if (b3.must_isolate_block) continue;
            for (Expr e2 : b3) {
                if (e2.op != 257 && e2.op != 42) continue;
                work.add(e2);
            }
        }
        while (!work.isEmpty()) {
            Expr e3 = Algorithms.getExpr(work);
            this.rename(e3, e3.args, map, uses);
            this.rename(e3, e3.scopes, map, uses);
            this.rename(e3, e3.locals, map, uses);
            if (e3.op == 42) {
                map.put(e3, e3.locals[0]);
                work.addAll((Collection<Expr>)uses.get(e3));
                continue;
            }
            if (e3.op != 257) continue;
            assert (e3.args.length == e3.pred.length);
            for (int j2 = e3.pred.length - 1; j2 >= 0; --j2) {
                if (code.contains(e3.pred[j2].from)) continue;
                e3.removePhiInput(j2);
            }
            Expr a = null;
            for (int j3 = e3.pred.length - 1; j3 >= 0; --j3) {
                if (e3.args[j3] == e3 || e3.args[j3] == a) continue;
                if (a == null) {
                    a = e3.args[j3];
                    continue;
                }
                a = null;
                break;
            }
            if (a == null || map.get(e3) == a) continue;
            map.put(e3, a);
            work.addAll((Collection<Expr>)uses.get(e3));
            e3.clearEffect();
        }
        for (Block b3 : code) {
            for (Expr e2 : b3.exprs) {
                if (!e2.is_live_out) continue;
                b3.addLiveOut(e2);
            }
        }
    }

    boolean hasSideEffect(Expr e2) {
        return e2.isPx() || e2.hasEffect();
    }

    void schedule_loop(Block b3, Algorithms.EdgeMap<Block> loops, Algorithms.Deque<Block> scheduled) {
        Object loop = loops.get(b3);
        for (Block lb : Algorithms.dfs(b3)) {
            if (scheduled.contains(lb) || !loop.contains(lb)) continue;
            scheduled.add(lb);
            if (!loops.containsKey(lb)) continue;
            this.schedule_loop(lb, loops, scheduled);
        }
    }

    Algorithms.Deque<Block> schedule(Block entry) {
        Algorithms.Deque<Block> code = Algorithms.dfs(entry);
        Algorithms.ArrayDeque<Block> scheduled = new Algorithms.ArrayDeque<Block>();
        Algorithms.SetMap<Block, Edge> pred = Algorithms.preds(code);
        Map<Block, Block> idom = Algorithms.idoms(code, pred);
        Algorithms.EdgeMap<Block> loops = this.findLoops(code, idom, pred);
        if (!loops.isEmpty()) {
            this.verboseStatus("LOOPS " + loops);
        }
        for (Block b3 : code) {
            if (!scheduled.contains(b3)) {
                scheduled.add(b3);
            }
            if (!loops.containsKey(b3)) continue;
            this.schedule_loop(b3, loops, scheduled);
        }
        Algorithms.ArrayDeque<Block> branch_analysis = new Algorithms.ArrayDeque<Block>();
        branch_analysis.addAll(scheduled);
        HashSet<Block> already_seen = new HashSet<Block>();
        while (branch_analysis.size() > 1) {
            Block b4 = (Block)branch_analysis.removeFirst();
            Expr last = b4.last();
            Block next = (Block)branch_analysis.peekFirst();
            if (this.isBranch(last) && last.succ[0].to != next && last.succ[1].to == next) {
                this.invert(last);
            }
            already_seen.add(b4);
            b4.is_backwards_branch_target = false;
            for (Edge s2 : b4.succ()) {
                s2.is_backwards_branch = already_seen.contains(s2.to);
                s2.to.is_backwards_branch_target |= s2.is_backwards_branch;
            }
        }
        if (this.verbose_mode) {
            for (Block b5 : code) {
                if (!b5.is_backwards_branch_target) continue;
                this.verboseStatus(".. backwards branch target:" + b5);
            }
        }
        return scheduled;
    }

    boolean isJump(Expr e2) {
        return e2.op == 16;
    }

    boolean isBranch(Expr e2) {
        return e2.succ != null && e2.succ.length == 2 && e2.op != 27;
    }

    boolean isLoop(Edge e2, Map<Block, Block> idom) {
        return e2.isBackedge() && Algorithms.dominates(e2.to, e2.from, idom);
    }

    Algorithms.EdgeMap<Block> findLoops(Algorithms.Deque<Block> code) {
        Algorithms.SetMap<Block, Edge> pred = Algorithms.preds(code);
        return this.findLoops(code, Algorithms.idoms(code, pred), pred);
    }

    Algorithms.EdgeMap<Block> findLoops(Algorithms.Deque<Block> code, Map<Block, Block> idom, Algorithms.SetMap<Block, Edge> pred) {
        Algorithms.EdgeMap<Block> loops = new Algorithms.EdgeMap<Block>();
        for (Block b3 : code) {
            for (Edge s2 : b3.succ()) {
                if (!this.isLoop(s2, idom)) continue;
                this.verboseStatus("backedge " + s2);
                Block h2 = s2.to;
                Object loop = loops.get(h2);
                TreeSet<Block> work = new TreeSet<Block>();
                Iterator i$ = pred.get(h2).iterator();
                while (i$.hasNext()) {
                    Edge p2 = (Edge)i$.next();
                    if (!this.isLoop(p2, idom) || loop.contains(p2.from) || p2.from == h2) continue;
                    loop.add(p2.from);
                    work.add(p2.from);
                }
                while (!work.isEmpty()) {
                    Block x2 = Algorithms.getBlock(work);
                    Iterator i$2 = pred.get(x2).iterator();
                    while (i$2.hasNext()) {
                        Edge p3 = (Edge)i$2.next();
                        if (p3.from == h2 || loop.contains(p3.from)) continue;
                        loop.add(p3.from);
                        work.add(p3.from);
                    }
                }
            }
        }
        return loops;
    }

    void dce_mark(BitSet used, Expr e2) {
        if (used.get(e2.id)) {
            return;
        }
        used.set(e2.id);
        for (Expr a : e2.args) {
            this.dce_mark(used, a);
        }
        for (Expr a : e2.scopes) {
            this.dce_mark(used, a);
        }
        for (Expr a : e2.locals) {
            this.dce_mark(used, a);
        }
    }

    void dce(Method m2) {
        Algorithms.Deque<Block> code = Algorithms.dfs(m2.entry.to);
        this.cp(code);
        BitSet marked = new BitSet();
        for (Block b3 : code) {
            for (Expr e2 : b3) {
                if (!this.hasSideEffect(e2)) continue;
                this.dce_mark(marked, e2);
            }
        }
        for (Block b3 : code) {
            Iterator<Expr> i2 = b3.iterator();
            while (i2.hasNext()) {
                if (marked.get(i2.next().id)) continue;
                i2.remove();
            }
        }
    }

    String format(char op, Object[] a, char cp) {
        if (a == null) {
            return "";
        }
        StringBuilder s2 = new StringBuilder();
        s2.append(op);
        for (Object o2 : a) {
            s2.append(o2).append(' ');
        }
        if (a.length > 0) {
            s2.setCharAt(s2.length() - 1, cp);
        } else {
            s2.append(cp);
        }
        return s2.toString();
    }

    static boolean isSlot(Binding b3) {
        return b3 != null ? b3.isSlot() : false;
    }

    static boolean isConst(Binding b3) {
        return b3 != null ? b3.isConst() : false;
    }

    static boolean isClass(Binding b3) {
        return b3 != null ? b3.isClass() : false;
    }

    static boolean isMethod(Binding b3) {
        return b3 != null ? b3.isMethod() : false;
    }

    static boolean isGetter(Binding b3) {
        return b3 != null ? b3.isGetter() : false;
    }

    static boolean isSetter(Binding b3) {
        return b3 != null ? b3.isSetter() : false;
    }

    static boolean methodFromObjectOrClass(Binding b3) {
        return b3 != null ? b3.methodFromObjectOrClass() : false;
    }

    static boolean isClassWithCustomConstruct(Binding b3) {
        if (GlobalOptimizer.isClass(b3)) {
            for (Metadata md : b3.md) {
                if (!md.name.equals("native")) continue;
                for (Attr attr : md.attrs) {
                    if (!attr.name().equals("customconstruct") || !attr.value().equals("true")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static boolean isNativeClass(Binding b3) {
        if (GlobalOptimizer.isClass(b3)) {
            for (Metadata md : b3.md) {
                if (!md.name.equals("native")) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isLive(int i2, Method m2, int scopep) {
        return i2 < scopep || i2 >= m2.local_count + m2.max_scope;
    }

    Block createBlock(Method m2, Edge edge, Map<Block, FrameState> states, Expr[] frame, int pos, int sp, int scopep) {
        Block b3 = new Block(m2, pos);
        GlobalOptimizer.addTraceAttr("Block", b3);
        FrameState state = new FrameState(frame, sp, scopep);
        if (edge != null) {
            edge.to = b3;
            GlobalOptimizer.traceEntry("Edge");
            GlobalOptimizer.addTraceAttr("to", b3);
        }
        for (int i2 = 0; i2 < sp; ++i2) {
            if (!GlobalOptimizer.isLive(i2, m2, scopep) || frame[i2] == null) continue;
            Expr e2 = new Expr(m2, 257);
            if (edge != null) {
                e2.args = new Expr[]{frame[i2]};
                e2.pred = new Edge[]{edge};
            }
            state.frame[i2] = e2;
            b3.add(state.frame[i2]);
        }
        this.traceFrame("NewBlockFrame", m2, frame, scopep, sp);
        states.put(b3, state);
        return b3;
    }

    void merge(Method m2, Edge edge, Map<Integer, Block> blocks, Map<Block, FrameState> states, int pos, Expr[] frame, int sp, int scopep) {
        GlobalOptimizer.addTraceAttr("Edge", edge);
        if (!blocks.containsKey(pos)) {
            Block b3 = this.createBlock(m2, edge, states, frame, pos, sp, scopep);
            blocks.put(pos, b3);
        } else if (edge != null) {
            edge.to = blocks.get(pos);
            this.mergeFrameStates(m2, edge, states, frame, sp, scopep);
        }
    }

    void mergeFrameStates(Method m2, Edge edge, Map<Block, FrameState> states, Expr[] frame, int sp, int scopep) {
        FrameState target = states.get(edge.to);
        assert (target.sp == sp);
        assert (target.scopep == scopep);
        for (int i2 = 0; i2 < sp; ++i2) {
            if (!GlobalOptimizer.isLive(i2, m2, scopep) || frame[i2] == target.frame[i2] || target.frame[i2] == null) continue;
            assert (frame[i2] != null && target.frame[i2].op == 257);
            target.frame[i2].append(frame[i2], edge);
        }
    }

    void xmerge(Method m2, Edge edge, Map<Integer, Block> blocks, Map<Block, FrameState> states, int pos, Expr[] frame, int sp, int scopep) {
        scopep = m2.local_count;
        sp = scopep + m2.max_scope;
        Handler h2 = edge.handler;
        if (h2.entry == null) {
            GlobalOptimizer.addTraceAttr("firstTime");
            Block hb = h2.entry = this.createBlock(m2, edge, states, frame, pos, sp, scopep);
            Expr xarg = new Expr(m2, 258, -1, edge.label);
            hb.add(xarg);
            Expr jump = new Expr(m2, 16);
            hb.add(jump);
            jump.succ = new Edge[]{new Edge(m2, hb, 0, blocks.get(pos))};
            Expr[] hframe = states.get((Object)hb).frame;
            hframe[sp] = xarg;
            GlobalOptimizer.traceEntry("HandlerBlock");
            GlobalOptimizer.addTraceAttr("Block", hb);
            GlobalOptimizer.addTraceAttr("Edge", edge);
            this.traceFrame("Frame", m2, frame, scopep, sp);
            this.merge(m2, jump.succ[0], blocks, states, pos, hframe, sp + 1, scopep);
        } else {
            GlobalOptimizer.addTraceAttr("notFirstTime");
            edge.to = h2.entry;
            this.mergeFrameStates(m2, edge, states, frame, sp, scopep);
        }
    }

    void traceFrame(String desc, Method m2, Expr[] frame, int scopep, int sp) {
        int i2 = 0;
        for (i2 = 0; i2 < m2.local_count; ++i2) {
            GlobalOptimizer.traceEntry("Local");
            GlobalOptimizer.addTraceAttr("number", i2);
            GlobalOptimizer.addTraceAttr("value", frame[i2]);
        }
        GlobalOptimizer.addTraceAttr("scopep", scopep);
        while (i2 < scopep) {
            GlobalOptimizer.traceEntry("Scope");
            GlobalOptimizer.addTraceAttr("index", i2);
            GlobalOptimizer.addTraceAttr("value", frame[i2]);
            ++i2;
        }
        GlobalOptimizer.addTraceAttr("sp", sp);
        for (i2 = m2.local_count + m2.max_scope; i2 < sp; ++i2) {
            GlobalOptimizer.traceEntry("Operand");
            GlobalOptimizer.addTraceAttr("index", i2);
            GlobalOptimizer.addTraceAttr("value", frame[i2]);
        }
    }

    static Expr[] capture(Expr[] frame, int top, int len) {
        Expr[] args = new Expr[len];
        System.arraycopy(frame, top - len, args, 0, len);
        GlobalOptimizer.addTraceAttr("stackPtr", top);
        GlobalOptimizer.addTraceAttr("len", len);
        for (int i2 = 0; i2 < len; ++i2) {
            GlobalOptimizer.traceEntry("PopStack");
            GlobalOptimizer.addTraceAttr(args[i2]);
        }
        return args;
    }

    void print(Expr e2) {
        if (!this.verbose_mode) {
            return;
        }
        PrintWriter pw = new PrintWriter(System.out);
        this.printssa(e2, pw);
        pw.flush();
    }

    void printabc(Expr e2, PrintWriter out) {
        if (this.verbose_mode) {
            out.println(this.formatExprAsAbc(e2));
        }
    }

    String formatExprAsAbc(Expr e2) {
        StringBuilder s2 = new StringBuilder();
        s2.append("    " + e2.opName());
        if (e2.imm != null) {
            s2.append('<');
            for (int i2 : e2.imm) {
                s2.append(i2).append(',');
            }
            s2.setCharAt(s2.length() - 1, '>');
        }
        if (e2.succ != null) {
            s2.append(this.format('[', e2.succ, ']'));
        }
        if (e2.value != null) {
            s2.append(" ");
            s2.append(this.formatObject(e2.value));
        }
        if (e2.ref != null) {
            s2.append(" ");
            s2.append(e2.ref);
        }
        return s2.toString();
    }

    void printssa(Expr e2, PrintWriter out) {
        out.println(this.formatExpr(e2));
    }

    String formatExpr(Expr e2) {
        if (null == e2) {
            return "null";
        }
        StringBuffer outBuffer = new StringBuffer();
        outBuffer.append(e2.toString());
        if (e2.onStack() || e2.inLocal() || e2.onScope()) {
            outBuffer.append(" =");
        } else {
            outBuffer.append("  ");
        }
        if (e2.value == null) {
            outBuffer.append(" " + e2.opName());
        }
        if (e2.imm != null) {
            outBuffer.append('<');
            for (int i2 : e2.imm) {
                outBuffer.append(i2).append(',');
            }
            outBuffer.setCharAt(outBuffer.length() - 1, '>');
        }
        if (e2.args.length > 0) {
            outBuffer.append(this.format('(', e2.args, ')'));
        }
        if (e2.locals.length > 0) {
            outBuffer.append(this.format('(', e2.locals, ')'));
        }
        if (e2.scopes.length > 0) {
            outBuffer.append(this.format('{', e2.scopes, '}'));
        }
        if (e2.pred.length > 0) {
            outBuffer.append(this.format('[', e2.pred, ']'));
        }
        if (e2.succ != null) {
            outBuffer.append(this.format('[', e2.succ, ']'));
        }
        if (e2.value != null) {
            outBuffer.append(this.formatObject(e2.value));
        }
        if (e2.ref != null) {
            outBuffer.append(" " + e2.ref);
        }
        return outBuffer.toString();
    }

    void print(Object value, PrintWriter out) {
        out.print(this.formatObject(value));
    }

    String formatObject(Object value) {
        if (value instanceof String) {
            return " \"" + ((String)value).replace("\n", "\\n").replace("\r", "\\r") + "\"";
        }
        return " " + value;
    }

    void printMethod(Method m2, String banner) {
        if (!this.verbose_mode) {
            return;
        }
        PrintWriter pw = new PrintWriter(System.out);
        pw.println();
        pw.println();
        pw.println(banner);
        pw.println("\t" + m2.getName() + " local_count=" + m2.local_count + " max_stack=" + m2.max_stack + " max_scope=" + m2.max_scope);
        Algorithms.Deque<Block> blocks = Algorithms.dfs(m2.entry.to);
        pw.println(blocks);
        for (Block b3 : blocks) {
            this.print(b3, pw);
        }
        pw.println();
        pw.flush();
    }

    void printabc(Algorithms.Deque<Block> blocks) {
        if (!this.verbose_mode) {
            return;
        }
        this.verboseStatus(blocks);
        PrintWriter pw = new PrintWriter(System.out);
        for (Block b3 : blocks) {
            this.printabc(b3, pw);
        }
        pw.flush();
    }

    void print(Block b3, PrintWriter pw) {
        pw.println();
        this.printssa(b3, pw);
    }

    void printabc(Block b3, PrintWriter out) {
        out.println();
        out.println(b3);
        if (b3.xsucc.length > 0) {
            out.println(Arrays.toString(b3.xsucc));
        }
        for (Expr s2 : b3) {
            this.printabc(s2, out);
        }
    }

    void printssa(Block b3, PrintWriter out) {
        out.println(b3);
        if (b3.xsucc.length > 0) {
            out.println(Arrays.toString(b3.xsucc));
        }
        for (Expr s2 : b3) {
            this.printssa(s2, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dot(String suffix, Method m2) {
        if (m2.entry.to.succ().length == 0) {
            return;
        }
        try {
            PrintWriter out = new PrintWriter(new FileWriter(m2.getName() + suffix + ".dot"));
            try {
                Algorithms.Deque<Block> code = Algorithms.dfs(m2.entry.to);
                out.println("digraph {");
                out.println("compound=true;");
                out.println("label=\"" + m2.getName() + suffix + "\";");
                out.println("labelloc=top;");
                out.println("fontsize=10;");
                if (this.SHOW_DFG) {
                    out.println("ranksep=.1; nodesep=.1;");
                    out.println("node [shape=plaintext,width=.05,height=.05,fontsize=12];");
                } else {
                    out.println("ranksep=.25; nodesep=.25;");
                    out.println("node [shape=box,width=.1,height=.1,fontsize=12];");
                }
                out.println("edge [arrowsize=.5,fontsize=8,labelfontsize=8];");
                for (Block b3 : code) {
                    if (this.SHOW_DFG) {
                        this.dot_dfg(b3, out);
                        continue;
                    }
                    this.dot(b3, out);
                }
                out.println("}");
            }
            finally {
                out.close();
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    void dot(Block b3, PrintWriter out) {
        LabelWriter w2 = new LabelWriter(new StringWriter());
        this.printssa(b3, (PrintWriter)w2);
        String attr = "label=\"" + w2 + "\"";
        out.println(b3 + " [" + attr + "];");
        for (Edge e2 : b3.succ()) {
            this.dot(e2, out);
        }
        for (Edge e2 : b3.xsucc) {
            this.dot(e2, out);
        }
    }

    void dot_dfg(Block b3, PrintWriter out) {
        LabelWriter w2 = new LabelWriter(new StringWriter());
        w2.print(b3);
        String attr = "label=\"" + w2 + "\"; labeljust=l";
        out.println("subgraph cluster" + b3 + " { " + attr + ";");
        Expr n2 = null;
        Iterator<Expr> i2 = b3.iterator();
        if (i2.hasNext()) {
            n2 = i2.next();
        }
        while (n2 != null) {
            Expr e2 = n2;
            w2 = new LabelWriter(new StringWriter());
            this.printssa(e2, (PrintWriter)w2);
            out.print("E" + e2.id + " [label=\"" + w2 + "\"];");
            if (i2.hasNext()) {
                n2 = i2.next();
                out.print("E" + e2.id + " -> E" + n2.id + " [style=invisible,arrowhead=none,weight=4];");
                continue;
            }
            n2 = null;
        }
        out.println("}");
        for (Expr e3 : b3) {
            for (Expr expr : e3.args) {
                out.print("E" + expr.id + " -> E" + e3.id + " [color=green];");
            }
            for (Expr expr : e3.locals) {
                out.print("E" + expr.id + " -> E" + e3.id + " [color=green];");
            }
            for (Expr expr : e3.scopes) {
                out.print("E" + expr.id + " -> E" + e3.id + " [color=grey,style=dashed];");
            }
            if (!e3.isPx()) continue;
            for (Comparable<Expr> comparable : b3.xsucc) {
                out.print("E" + e3.id + " -> E" + ((Edge)comparable).to.first().id + " [weight=2,style=dashed,color=red];");
            }
        }
        for (Edge s2 : b3.succ()) {
            Expr e4 = b3.last();
            int n3 = s2 == b3.last().succ[0] ? 4 : 2;
            out.print("E" + e4.id + " -> E" + s2.to.first().id + " [weight=" + n3 + "];");
        }
    }

    void dot(Edge e2, PrintWriter out) {
        ArrayList<String> attrs = new ArrayList<String>();
        if (e2.isThrowEdge()) {
            attrs.add("style=dashed");
        } else {
            if (e2.isBackedge()) {
                attrs.add("tailport=w,headport=w");
            }
            if (e2.label == 0) {
                attrs.add("weight=2");
            } else {
                attrs.add("taillabel=\"" + e2.label + "\"");
            }
        }
        out.println(e2.from + " -> " + e2.to + " " + attrs + ";");
    }

    void verboseStatus(String msg) {
        if (this.verbose_mode) {
            System.out.println(msg);
        }
    }

    void verboseStatus(Object o2) {
        if (this.verbose_mode) {
            System.out.println(o2.toString());
        }
    }

    static {
        refArgc = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1};
    }

    class AbcWriter
    extends ByteArrayOutputStream {
        AbcWriter() {
        }

        void rewind(int n2) {
            this.count -= n2;
        }

        void writeU16(int i2) {
            this.write(i2);
            this.write(i2 >> 8);
        }

        void writeS24(int i2) {
            this.writeU16(i2);
            this.write(i2 >> 16);
        }

        void write64(long i2) {
            this.writeS24((int)i2);
            this.writeS24((int)(i2 >> 24));
            this.writeU16((int)(i2 >> 48));
        }

        void writeU30(int v2) {
            if (v2 < 128 && v2 >= 0) {
                this.write(v2);
            } else if (v2 < 16384 && v2 >= 0) {
                this.write(v2 & 0x7F | 0x80);
                this.write(v2 >> 7);
            } else if (v2 < 0x200000 && v2 >= 0) {
                this.write(v2 & 0x7F | 0x80);
                this.write(v2 >> 7 | 0x80);
                this.write(v2 >> 14);
            } else if (v2 < 0x10000000 && v2 >= 0) {
                this.write(v2 & 0x7F | 0x80);
                this.write(v2 >> 7 | 0x80);
                this.write(v2 >> 14 | 0x80);
                this.write(v2 >> 21);
            } else {
                this.write(v2 & 0x7F | 0x80);
                this.write(v2 >> 7 | 0x80);
                this.write(v2 >> 14 | 0x80);
                this.write(v2 >> 21 | 0x80);
                this.write(v2 >> 28);
            }
        }

        int sizeOfU30(int v2) {
            if (v2 < 128 && v2 >= 0) {
                return 1;
            }
            if (v2 < 16384 && v2 >= 0) {
                return 2;
            }
            if (v2 < 0x200000 && v2 >= 0) {
                return 3;
            }
            if (v2 < 0x10000000 && v2 >= 0) {
                return 4;
            }
            return 5;
        }
    }

    class Reader {
        int pos;
        byte[] abc;

        Reader(int pos, byte[] abc) {
            this.pos = pos;
            this.abc = abc;
        }

        Reader(Reader r2) {
            this(r2.pos, r2.abc);
        }

        int readU8() {
            return 0xFF & this.abc[this.pos++];
        }

        int readU16() {
            return this.readU8() | this.readU8() << 8;
        }

        int readS24() {
            return this.readU16() | (byte)this.readU8() << 16;
        }

        int readU30() {
            int result = this.readU8();
            if (0 == (result & 0x80)) {
                return result;
            }
            if (0 == ((result = result & 0x7F | this.readU8() << 7) & 0x4000)) {
                return result;
            }
            if (0 == ((result = result & 0x3FFF | this.readU8() << 14) & 0x200000)) {
                return result;
            }
            if (0 == ((result = result & 0x1FFFFF | this.readU8() << 21) & 0x10000000)) {
                return result;
            }
            return result & 0xFFFFFFF | this.readU8() << 28;
        }

        double readDouble() {
            return Double.longBitsToDouble((long)this.readU16() | (long)this.readU16() << 16 | (long)this.readU16() << 32 | (long)this.readU16() << 48);
        }
    }

    class ErrorConstants {
        public static final int kGetScopeObjectBoundsError = 1019;
        public static final int kStackOverflowError = 1023;

        ErrorConstants() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TypeConstraints
    implements Comparable<Object> {
        Set<Integer> killregs = new TreeSet<Integer>();
        Map<Integer, Typeref> coercions = new HashMap<Integer, Typeref>();
        Edge path;
        Block dest_block;

        TypeConstraints(Edge path) {
            this.path = path;
            if (path != null) {
                this.dest_block = path.to;
            }
        }

        void takeConstraintFrom(TypeConstraints tc, Integer r2) {
            if (this.killregs.contains(r2)) {
                assert (tc.killregs.contains(r2));
                tc.killregs.remove(r2);
            } else if (this.coercions.containsKey(r2)) {
                assert (tc.coercions.containsKey(r2) && tc.coercions.get((Object)r2).t.isMachineCompatible(this.coercions.get((Object)r2).t));
                tc.coercions.remove(r2);
            } else if (tc.killregs.contains(r2)) {
                this.killregs.add(r2);
                tc.killregs.remove(r2);
            } else if (tc.coercions.containsKey(r2)) {
                this.coercions.put(r2, tc.coercions.get(r2));
                tc.coercions.remove(r2);
            } else {
                throw new IllegalStateException("neither constraint set contains local " + r2);
            }
        }

        boolean agreesWith(TypeConstraints tc, Integer r2) {
            if (this.killregs.contains(r2)) {
                return tc.killregs.contains(r2);
            }
            if (this.coercions.containsKey(r2)) {
                return tc.coercions.containsKey(r2) && this.coercions.get((Object)r2).t.isMachineCompatible(tc.coercions.get((Object)r2).t);
            }
            return false;
        }

        void addKill(int reg) {
            assert (!this.coercions.containsKey(reg));
            this.killregs.add(reg);
        }

        void addCoercion(int reg, Typeref ty) {
            assert (!this.coercions.containsKey(reg) && !this.killregs.contains(reg));
            this.coercions.put(reg, ty);
        }

        public boolean equals(Object o2) {
            return 0 == this.compareTo(o2);
        }

        @Override
        public int compareTo(Object arg0) {
            if (!(arg0 instanceof TypeConstraints)) {
                return -1;
            }
            TypeConstraints other = (TypeConstraints)arg0;
            if (this.dest_block.id != other.dest_block.id) {
                return this.dest_block.id > other.dest_block.id ? 1 : -1;
            }
            if (this.killregs.size() > other.killregs.size()) {
                return 1;
            }
            if (other.killregs.size() > this.killregs.size()) {
                return -1;
            }
            if (this.coercions.size() > other.coercions.size()) {
                return 1;
            }
            if (other.coercions.size() > this.coercions.size()) {
                return -1;
            }
            for (Integer x2 : this.killregs) {
                if (other.killregs.contains(x2)) continue;
                return 1;
            }
            for (Integer y2 : other.killregs) {
                if (this.killregs.contains(y2)) continue;
                return -1;
            }
            for (Integer r2 : this.coercions.keySet()) {
                Typeref this_ctype = this.coercions.get(r2);
                Typeref other_ctype = other.coercions.get(r2);
                if (null == other_ctype) {
                    return 1;
                }
                if (this_ctype.equals(other_ctype)) continue;
                return this_ctype.hashCode() > other_ctype.hashCode() ? 1 : -1;
            }
            for (Integer o_r : other.coercions.keySet()) {
                if (this.coercions.containsKey(o_r)) continue;
                return -1;
            }
            return 0;
        }
    }

    class LocalVarState {
        Typeref[] fs_out;
        Typeref[] fs_in;
        Typeref[] hard_coercions;
        private BitSet liveout = new BitSet();
        private BitSet killed_vars = new BitSet();
        private BitSet def = new BitSet();
        private BitSet ue_vars = new BitSet();
        private BitSet read_after_def = new BitSet();
        private Map<Integer, Expr> generating_exprs = new HashMap<Integer, Expr>();
        private boolean conservative_verifier_rules;
        private Method m;
        private Block b;

        LocalVarState(Method m2, Block b3, Typeref[] initial_frame_state) {
            this.conservative_verifier_rules = b3.is_backwards_branch_target;
            this.fs_in = new Typeref[initial_frame_state.length];
            if (!this.conservative_verifier_rules) {
                System.arraycopy(initial_frame_state, 0, this.fs_in, 0, initial_frame_state.length);
            } else {
                int i2;
                for (i2 = 0; i2 < m2.local_count; ++i2) {
                    this.fs_in[i2] = initial_frame_state[i2].nullable();
                }
                for (i2 = m2.local_count + m2.max_scope; i2 < this.fs_in.length; ++i2) {
                    this.fs_in[i2] = initial_frame_state[i2].nullable();
                }
            }
            this.fs_out = new Typeref[initial_frame_state.length];
            System.arraycopy(this.fs_in, 0, this.fs_out, 0, this.fs_in.length);
            this.hard_coercions = new Typeref[initial_frame_state.length];
            this.m = m2;
            this.b = b3;
            Typeref[] saved_fs = null;
            if (GlobalOptimizer.this.verbose_mode) {
                GlobalOptimizer.this.verboseStatus(b3);
                StringBuffer verbose_succ = new StringBuffer();
                verbose_succ.append("\tsucc: ");
                for (Edge p2 : b3.succ()) {
                    verbose_succ.append(p2);
                    verbose_succ.append(" ");
                }
                GlobalOptimizer.this.verboseStatus(verbose_succ);
                GlobalOptimizer.this.dumpFrameState(this.fs_out);
                saved_fs = new Typeref[initial_frame_state.length];
                System.arraycopy(this.fs_out, 0, saved_fs, 0, this.fs_out.length);
            }
            block14: for (Expr e2 : b3.exprs) {
                if (GlobalOptimizer.this.verbose_mode) {
                    GlobalOptimizer.this.verboseStatus(GlobalOptimizer.this.formatExprAsAbc(e2));
                }
                switch (e2.op) {
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: {
                        this.uses(e2.op - 208);
                        break;
                    }
                    case 98: {
                        this.uses(e2.imm[0]);
                        break;
                    }
                    case 212: 
                    case 213: 
                    case 214: 
                    case 215: {
                        this.defines(e2.op - 212, e2);
                        break;
                    }
                    case 99: {
                        this.defines(e2.imm[0], e2);
                        break;
                    }
                    case 50: {
                        this.uses(e2.imm[0]);
                        this.uses(e2.imm[1]);
                        this.expectsType(e2.imm[0], GlobalOptimizer.ANY().ref);
                        this.expectsType(e2.imm[1], GlobalOptimizer.INT().ref);
                        this.hard_coercions[e2.imm[0]] = GlobalOptimizer.ANY().ref;
                        this.defines(e2.imm[0], e2);
                        break;
                    }
                    case 8: {
                        this.setKilled(e2.imm[0]);
                        break;
                    }
                    case 146: 
                    case 148: 
                    case 194: 
                    case 195: {
                        this.uses(e2.imm[0]);
                        break;
                    }
                    case 108: 
                    case 109: {
                        Expr stem = e2.args[0];
                        if (!stem.inLocal()) break;
                        this.expectsType(stem.imm[0], m2.verifier_types.get(stem));
                        break;
                    }
                    case 30: 
                    case 35: {
                        break;
                    }
                    default: {
                        assert (!e2.inLocal());
                        break;
                    }
                }
                if (!GlobalOptimizer.this.verbose_mode) continue;
                for (int i3 = 0; i3 < this.fs_out.length; ++i3) {
                    if (saved_fs[i3] == this.fs_out[i3]) continue;
                    GlobalOptimizer.this.dumpFrameState(this.fs_out);
                    System.arraycopy(this.fs_out, 0, saved_fs, 0, this.fs_out.length);
                    continue block14;
                }
            }
        }

        private void expectsType(int i2, Typeref expected_type) {
            if (!this.def.get(i2) && !this.fs_in[i2].t.equals(expected_type.t)) {
                GlobalOptimizer.this.verboseStatus("\texpectsType " + i2 + " " + expected_type);
                this.fs_in[i2] = this.fs_out[i2] = expected_type;
            }
        }

        public Typeref getInitialType(int reg) {
            return this.fs_in[reg];
        }

        public Typeref getFinalType(int reg) {
            return this.fs_out[reg];
        }

        public BitSet getKilled() {
            return (BitSet)this.killed_vars.clone();
        }

        private boolean mergeLiveout(BitSet next_liveout) {
            boolean result;
            next_liveout.or(this.liveout);
            boolean bl2 = result = !this.liveout.equals(next_liveout);
            if (result) {
                this.liveout = next_liveout;
            }
            return result;
        }

        BitSet getLivein() {
            BitSet result = (BitSet)this.liveout.clone();
            result.andNot(this.def);
            result.or(this.ue_vars);
            return result;
        }

        BitSet getActiveVariables() {
            BitSet result = this.getLivein();
            result.or(this.def);
            if (this.b.equals(this.m.entry.to)) {
                for (int i2 = 0; i2 < this.m.getParams().length; ++i2) {
                    result.set(i2);
                }
            }
            result.andNot(this.killed_vars);
            return result;
        }

        BitSet getLiveout() {
            return (BitSet)this.liveout.clone();
        }

        BitSet getDefined() {
            return (BitSet)this.def.clone();
        }

        private void uses(int varnum) {
            if (!this.def.get(varnum)) {
                if (!this.isAPriori(varnum)) {
                    this.ue_vars.set(varnum);
                }
            } else {
                this.read_after_def.set(varnum);
            }
        }

        private boolean isAPriori(int varnum) {
            return this.b.equals(this.m.entry.to) && varnum < this.m.getParams().length;
        }

        private void defines(int varnum, Expr generating_expr) {
            this.fs_out[varnum] = this.definingType(generating_expr);
            this.def.set(varnum);
            this.generating_exprs.put(varnum, generating_expr);
            this.killed_vars.clear(varnum);
            this.read_after_def.clear(varnum);
        }

        private Typeref definingType(Expr e2) {
            Typeref result = null;
            if (50 == e2.op) {
                result = GlobalOptimizer.ANY().ref;
            } else if (99 == e2.op) {
                Expr value = e2.args[0];
                result = 98 == value.op ? this.fs_out[value.imm[0]] : GlobalOptimizer.this.verify_eval(this.m, value, this.m.verifier_types, null);
            } else assert (false);
            assert (result != null);
            return result;
        }

        public void setKilled(int varnum) {
            assert (!this.killed_vars.get(varnum));
            this.killed_vars.set(varnum);
            this.generating_exprs.remove(varnum);
        }
    }

    static class LabelWriter
    extends PrintWriter {
        StringWriter w;

        LabelWriter(StringWriter w2) {
            super(w2);
            this.w = w2;
        }

        public void println() {
            this.print("\\l");
            this.flush();
        }

        public void print(String s2) {
            super.print(s2.replace("\"", "''").replace("\u0278", "&phi;"));
        }

        public String toString() {
            return this.w.toString();
        }
    }

    static class FrameState {
        Expr[] frame;
        int sp;
        int scopep;

        public FrameState(Expr[] frame, int sp, int scopep) {
            this.frame = new Expr[frame.length];
            this.sp = sp;
            this.scopep = scopep;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TypeConstraintMap
    extends HashMap<Edge, TypeConstraints> {
        private static final long serialVersionUID = 1903880092224622848L;

        TypeConstraintMap() {
        }

        TypeConstraints getConstraints(Edge key) {
            TypeConstraints result = (TypeConstraints)this.get(key);
            if (null == result) {
                result = new TypeConstraints(key);
                this.put(key, result);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConflictGraph {
        Map<Integer, Set<Integer>> conflicts = new TreeMap<Integer, Set<Integer>>();

        ConflictGraph() {
        }

        void add(Expr e1, Expr e2) {
            this.get(e1.id).add(e2.id);
            this.get(e2.id).add(e1.id);
        }

        boolean contains(Expr a, Expr b3) {
            return this.conflicts.containsKey(a.id) && this.conflicts.get(a.id).contains(b3.id);
        }

        public String toString() {
            return String.valueOf(this.conflicts);
        }

        Set<Integer> get(int i2) {
            Set<Integer> s2 = this.conflicts.get(i2);
            if (s2 == null) {
                s2 = new TreeSet<Integer>();
                this.conflicts.put(i2, s2);
            }
            return s2;
        }
    }

    private static final class FindScopeResult {
        private final Typeref m_scopeObjType;
        private final Expr m_scopeObjExpr;
        private final Name m_definitionName;
        private final Integer m_scopeIndex;

        private FindScopeResult(Typeref sot, Expr soe, Name definitionName, Integer methodScopeIndex) {
            this.m_scopeObjType = sot;
            this.m_scopeObjExpr = soe;
            this.m_definitionName = definitionName;
            this.m_scopeIndex = methodScopeIndex;
        }

        FindScopeResult(Typeref sot) {
            this(sot, null, null, -1);
        }

        FindScopeResult(Typeref sot, Expr soe, int scopeIndex) {
            this(sot, soe, null, scopeIndex);
        }

        FindScopeResult(Typeref sot, Name definitionName) {
            this(sot, null, definitionName, 0);
        }

        FindScopeResult(Typeref sot, int methodScopeIndex) {
            this(sot, null, null, methodScopeIndex);
        }

        Name definitionName() {
            return this.m_definitionName;
        }

        Typeref scopeObjectType() {
            return this.m_scopeObjType;
        }

        Expr scopeObjectExpr() {
            return this.m_scopeObjExpr;
        }

        int scopeIndex() {
            assert (this.m_scopeIndex != null);
            return this.m_scopeIndex;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SccpContext {
        private Method _m;
        private Map<Expr, Block> _blocks;
        private Algorithms.EdgeMap<Expr> _uses;
        private Map<Expr, Object> _values;
        private Map<Expr, Typeref> _types;
        private Algorithms.ExprWorkQueue _work;
        private List<Op> _ops = new LinkedList<Op>();
        private Set<Pair<Block, Expr>> _exprs = new HashSet<Pair<Block, Expr>>();

        public SccpContext(Method m2, Map<Expr, Block> blocks, Algorithms.EdgeMap<Expr> uses, Map<Expr, Object> values, Map<Expr, Typeref> types, Algorithms.ExprWorkQueue work) {
            this._m = m2;
            this._blocks = blocks;
            this._uses = uses;
            this._values = values;
            this._types = types;
            this._work = work;
        }

        public void commit() {
            for (Op op : this._ops) {
                op.exec();
            }
            this._ops.clear();
            TreeSet blocksTouched = new TreeSet();
            Algorithms.ExprWorkQueue ssaWork = new Algorithms.ExprWorkQueue(this._uses);
            for (Pair<Block, Expr> p2 : this._exprs) {
                blocksTouched.add(p2.fst);
                assert (((Block)p2.fst).hasExpr((Expr)p2.snd));
                this._blocks.put((Expr)p2.snd, (Block)p2.fst);
                ssaWork.add((Expr)p2.snd);
                this._work.add((Expr)p2.snd);
            }
            this._exprs.clear();
            TreeSet<Edge> flowWork = new TreeSet<Edge>();
            while (!ssaWork.isEmpty()) {
                Expr we = Algorithms.getExpr(ssaWork);
                GlobalOptimizer.this.sccp_eval(this._m, we, this._values, this._types, flowWork, ssaWork, this._uses);
            }
        }

        public Method getMethod() {
            return this._m;
        }

        public Typeref getType(Expr e2) {
            return this._types.get(e2);
        }

        public Block getBlock(Expr e2) {
            return this._blocks.get(e2);
        }

        public void removeUse(Expr user, Expr e2) {
            this._ops.add(new UseRemoval(user, e2));
        }

        public void addUse(Expr user, Expr e2) {
            this._ops.add(new UseAddition(user, e2));
        }

        public void addExprAndInsertBefore(Block b3, Expr before, Expr e2) {
            b3.insertExpr(before, e2);
            this._exprs.add(new Pair<Block, Expr>(b3, e2));
        }

        public void addExpr(Block b3, Expr e2) {
            this._exprs.add(new Pair<Block, Expr>(b3, e2));
        }

        class UseAddition
        extends Op {
            private Expr _user;
            private Expr _e;

            public UseAddition(Expr user, Expr e2) {
                this._user = user;
                this._e = e2;
            }

            public void exec() {
                SccpContext.this._uses.get(this._e).add(this._user);
            }
        }

        class UseRemoval
        extends Op {
            private Expr _user;
            private Expr _e;

            public UseRemoval(Expr user, Expr e2) {
                this._user = user;
                this._e = e2;
            }

            public void exec() {
                SccpContext.this._uses.get(this._e).remove(this._user);
            }
        }

        abstract class Op {
            Op() {
            }

            public abstract void exec();
        }
    }

    static class IndentingPrintWriter
    extends PrintWriter {
        int indent;

        IndentingPrintWriter(Writer w2) {
            super(w2);
        }

        public void println() {
            super.println();
            for (int i2 = 0; i2 < this.indent; ++i2) {
                this.print("    ");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Abc {
        final Algorithms.Pool<Integer> intPool = new Algorithms.Pool(1);
        final Algorithms.Pool<Long> uintPool = new Algorithms.Pool(1);
        final Algorithms.Pool<Double> doublePool = new Algorithms.Pool(1);
        final Algorithms.Pool<String> stringPool;
        final Algorithms.Pool<Namespace> nsPool = new Algorithms.Pool(1);
        final Algorithms.Pool<Nsset> nssetPool = new Algorithms.Pool(1);
        final Algorithms.Pool<Name> namePool;
        final Algorithms.Pool<Method> nonNativeMethodPool;
        final Algorithms.Pool<Method> nativeMethodPool;
        final Algorithms.Pool<Metadata> metaPool = new Algorithms.Pool(0);
        int bodyCount;
        boolean haveNatives;
        final List<Type> scripts;
        List<Type> classes;
        private final Comparator<Type> m_compareScripts;
        private final Comparator<Type> m_compareClasses;

        private Algorithms.Pool<Name> createNamePool() {
            return new Algorithms.Pool<Name>(1, new Algorithms.Pool.Policy<Name>(){

                @Override
                public boolean isValueForId0(Name value) {
                    return value.isAny();
                }
            });
        }

        private Algorithms.Pool<Name> createNamePool(Comparator<Name> nameComparator) {
            return new Algorithms.Pool<Name>(1, nameComparator, new Algorithms.Pool.Policy<Name>(){

                @Override
                public boolean isValueForId0(Name value) {
                    return value.isAny();
                }
            });
        }

        public Abc(InputAbc iabc) {
            iabc.oabc = this;
            this.stringPool = new Algorithms.Pool(1);
            this.nonNativeMethodPool = new Algorithms.Pool(0);
            this.nativeMethodPool = new Algorithms.Pool(0);
            this.scripts = new ArrayList<Type>();
            this.classes = new ArrayList<Type>();
            this.m_compareScripts = null;
            this.m_compareClasses = null;
            this.namePool = this.createNamePool();
        }

        public Abc(InputAbc iabc, Comparator<Method> nonNativeMethodComparator) {
            iabc.oabc = this;
            this.stringPool = new Algorithms.Pool(1);
            this.nonNativeMethodPool = new Algorithms.Pool<Method>(0, nonNativeMethodComparator);
            this.nativeMethodPool = new Algorithms.Pool(0);
            this.scripts = new ArrayList<Type>();
            this.classes = new ArrayList<Type>();
            this.m_compareScripts = null;
            this.m_compareClasses = null;
            this.namePool = this.createNamePool();
        }

        public Abc(InputAbc iabc, Comparator<String> stringComparator, Comparator<Name> nameComparator, Comparator<Method> methodComparator, Comparator<Type> compareScripts, Comparator<Type> compareClasses) {
            iabc.oabc = this;
            this.stringPool = new Algorithms.Pool<String>(1, stringComparator);
            this.nonNativeMethodPool = new Algorithms.Pool<Method>(0, methodComparator);
            this.nativeMethodPool = this.nonNativeMethodPool;
            this.scripts = new ArrayList<Type>();
            this.classes = new ArrayList<Type>();
            this.m_compareScripts = compareScripts;
            this.m_compareClasses = compareClasses;
            this.namePool = this.createNamePool(nameComparator);
        }

        int typeRef(Typeref tref) {
            return this.typeRef(tref.t);
        }

        int typeRef(Type t2) {
            if (t2 == GlobalOptimizer.ANY()) {
                return 0;
            }
            if (t2.emitAsAny()) {
                GlobalOptimizer.this.verboseStatus("Emitting: " + t2 + " as any");
                return 0;
            }
            return this.namePool.id(t2.getName());
        }

        Algorithms.Pool<Method> poolFor(Method m2) {
            assert (m2.abc.oabc == this);
            return m2.isNative() ? this.nativeMethodPool : this.nonNativeMethodPool;
        }

        int methodId(Method m2) {
            return this.poolFor(m2).id(m2);
        }

        void addScript(Type s2) {
            this.addMethod(s2.init);
            this.addTraits(s2.defs);
            this.scripts.add(s2);
        }

        void addClass(Type c2) {
            Type t2 = c2.itype;
            this.addName(t2.getName());
            if (t2.base != GlobalOptimizer.NULL()) {
                this.addTypeRef(t2.base);
            }
            if (t2.hasProtectedNs()) {
                this.addNamespace(t2.protectedNs);
            }
            for (Type i2 : t2.interfaces) {
                this.addInterfaceRef(i2);
            }
            this.addMethod(t2.init);
            this.addTraits(t2.defs);
            this.addMethod(c2.init);
            this.addTraits(c2.defs);
            this.classes.add(c2);
        }

        int classId(Type c2) {
            return this.classes.indexOf(c2);
        }

        int scriptId(Type c2) {
            return this.scripts.indexOf(c2);
        }

        void addTraits(Symtab<Binding> defs) {
            for (Binding b3 : defs.values()) {
                this.addName(b3.getName());
                switch (b3.kind()) {
                    case 4: {
                        this.addClass(b3.type.t);
                        break;
                    }
                    case 0: 
                    case 6: {
                        this.addTypeRef(b3.type);
                        if (b3.value() == null) break;
                        this.addConst(b3.value());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        this.addMethod(b3.method);
                    }
                }
                if (!b3.hasMetadata()) continue;
                for (Metadata md : b3.md) {
                    this.addMetadata(md);
                }
            }
        }

        void addMetadata(Metadata md) {
            if (this.metaPool.add(md) == 1) {
                this.stringPool.add(md.name);
                for (Attr a : md.attrs) {
                    this.stringPool.add(a.name());
                    this.stringPool.add(a.value());
                }
            }
        }

        void addConst(Object value) {
            if (value instanceof Integer) {
                this.intPool.add(TypeAnalysis.intValue(value));
            } else if (value instanceof Long) {
                this.uintPool.add(TypeAnalysis.uintValue(value));
            } else if (value instanceof Double) {
                this.doublePool.add(TypeAnalysis.doubleValue(value));
            } else if (value instanceof String) {
                this.stringPool.add((String)value);
            } else if (value instanceof Namespace) {
                this.addNamespace((Namespace)value);
            }
        }

        int constId(int kind, Object value) {
            switch (kind) {
                case 3: {
                    return this.intPool.id(TypeAnalysis.intValue(value));
                }
                case 4: {
                    return this.uintPool.id(TypeAnalysis.uintValue(value));
                }
                case 1: {
                    if (value == GlobalOptimizer.NULL()) {
                        return 0;
                    }
                    return this.stringPool.id((String)value);
                }
                case 6: {
                    return this.doublePool.id(TypeAnalysis.doubleValue(value));
                }
                case 8: {
                    if (value == GlobalOptimizer.NULL()) {
                        return 0;
                    }
                    return this.nsPool.id((Namespace)value);
                }
                case 11: {
                    return 11;
                }
                case 10: {
                    return 10;
                }
                case 12: {
                    return 12;
                }
            }
            return 0;
        }

        int constKind(Object value) {
            if (value instanceof Integer) {
                return 3;
            }
            if (value instanceof Long) {
                return 4;
            }
            if (value instanceof Double) {
                return 6;
            }
            if (value instanceof String) {
                return 1;
            }
            if (value instanceof Namespace) {
                return ((Namespace)value).kind;
            }
            if (value == Boolean.TRUE) {
                return 11;
            }
            if (value == Boolean.FALSE) {
                return 10;
            }
            if (value == OptimizerConstants.UNDEFINED) {
                return 0;
            }
            if (value == GlobalOptimizer.NULL()) {
                return 12;
            }
            return 0;
        }

        void addNamespace(Namespace ns) {
            if (ns != null && this.nsPool.add(ns) == 1 && !ns.isPrivate()) {
                this.stringPool.add(ns.uri);
            }
        }

        void addNsset(Nsset nsset) {
            if (this.nssetPool.add(nsset) == 1) {
                for (Namespace ns : nsset) {
                    this.addNamespace(ns);
                }
            }
        }

        void addName(Name n2) {
            if (this.namePool.add(n2) == 1) {
                switch (n2.kind) {
                    case 9: 
                    case 14: {
                        this.addNsset(n2.nsset);
                        this.stringPool.add(n2.name);
                        break;
                    }
                    case 7: 
                    case 13: {
                        this.addNamespace(n2.nsset(0));
                        this.stringPool.add(n2.name);
                        break;
                    }
                    case 15: 
                    case 16: {
                        this.stringPool.add(n2.name);
                        break;
                    }
                    case 27: 
                    case 28: {
                        this.addNsset(n2.nsset);
                    }
                }
                if (n2.isParameterizedTypeName()) {
                    this.addName(n2.getParameterizedTypeName());
                    this.addName(n2.getTypeParamName());
                }
            }
        }

        void addTypeRef(Typeref tref) {
            this.addTypeRef(tref.t);
        }

        void addTypeRef(Type t2) {
            if (t2 != GlobalOptimizer.ANY() && !t2.emitAsAny()) {
                this.addName(t2.getName());
            }
        }

        void addInterfaceRef(Type t2) {
            this.addName(t2.getName());
        }

        void addMethod(Method m2) {
            int i2;
            if (m2.abc.oabc != this) {
                return;
            }
            if (this.poolFor(m2).add(m2) > 1) {
                return;
            }
            if (m2.entry != null && (GlobalOptimizer.this.m_llvmEmitter == null || GlobalOptimizer.this.m_llvmEmitter.outputMethodBody(m2))) {
                ++this.bodyCount;
            }
            this.addTypeRef(m2.returns.t);
            int n2 = m2.getParams().length;
            for (i2 = 1; i2 < n2; ++i2) {
                this.addTypeRef(m2.getParams()[i2]);
            }
            if (m2.hasOptional()) {
                for (Object v2 : m2.values) {
                    if (v2 == null) continue;
                    this.addConst(v2);
                }
            }
            if (!GlobalOptimizer.this.STRIP_DEBUG_INFO && m2.hasParamNames()) {
                for (i2 = 1; i2 < m2.paramNames.length; ++i2) {
                    this.addName(m2.paramNames[i2]);
                }
            }
            if (GlobalOptimizer.this.PRESERVE_METHOD_NAMES) {
                this.addConst(m2.debugName);
            }
            for (Handler t2 : m2.handlers) {
                if (t2.name != null) {
                    this.addName(t2.name);
                }
                this.addTypeRef(t2.type);
            }
            this.haveNatives |= m2.isNative();
            if (m2.entry == null) {
                return;
            }
            for (Block b3 : Algorithms.dfs(m2.entry.to)) {
                for (Expr e2 : b3) {
                    switch (e2.op) {
                        case 239: {
                            if (GlobalOptimizer.this.STRIP_DEBUG_INFO || e2.imm[0] != 1) break;
                            this.addConst(e2.value);
                            break;
                        }
                        case 241: {
                            if (GlobalOptimizer.this.STRIP_DEBUG_INFO) break;
                            this.addConst(e2.value);
                            break;
                        }
                        case 6: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 49: {
                            this.addConst(e2.value);
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 69: 
                        case 70: 
                        case 74: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 89: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 102: 
                        case 104: 
                        case 106: 
                        case 128: 
                        case 134: 
                        case 178: {
                            this.addName(e2.ref);
                            break;
                        }
                        case 64: 
                        case 68: {
                            this.addMethod(e2.m);
                        }
                    }
                }
            }
            if (m2.needActivation()) {
                this.addTraits(m2.activation.t.defs);
                if (m2.activation.t.init != null) {
                    this.addMethod(m2.activation.t.init);
                }
            }
        }

        void sort() {
            TreeSet<Type> cs;
            GlobalOptimizer.this.verboseStatus("NAMES RANK " + this.namePool.refsString());
            this.intPool.sort();
            this.uintPool.sort();
            this.doublePool.sort();
            this.stringPool.sort();
            this.nsPool.sort();
            this.nssetPool.sort();
            this.namePool.sort();
            this.metaPool.sort();
            this.nonNativeMethodPool.sort();
            if (this.nativeMethodPool != this.nonNativeMethodPool) {
                this.nativeMethodPool.countFrom = this.nonNativeMethodPool.size();
                this.nativeMethodPool.sort();
            }
            GlobalOptimizer.this.verboseStatus("NAMES " + this.namePool.values());
            if (this.m_compareClasses != null) {
                cs = new TreeSet<Type>(this.m_compareClasses);
                cs.addAll(this.classes);
                this.classes.clear();
                this.classes.addAll(cs);
            } else if (GlobalOptimizer.this.legacy_verifier) {
                this.classes = new Algorithms.TopologicalSort<Type>().toplogicalSort(this.classes, new Algorithms.TopologicalSort.DependencyChecker<Type>(){

                    @Override
                    public boolean depends(Type dep, Type parent) {
                        return dep.itype.isDerivedFrom(parent.itype);
                    }
                });
            } else {
                cs = new TreeSet<Type>(new Comparator<Type>(){

                    @Override
                    public int compare(Type a, Type b3) {
                        if (a == b3) {
                            return 0;
                        }
                        if (b3.itype.extendsOrIsBase(a.itype)) {
                            return -1;
                        }
                        return 1;
                    }
                });
                cs.addAll(this.classes);
                this.classes.clear();
                this.classes.addAll(cs);
            }
            if (this.m_compareScripts != null) {
                TreeSet<Type> ss = new TreeSet<Type>(this.m_compareScripts);
                ss.addAll(this.scripts);
                this.scripts.clear();
                this.scripts.addAll(ss);
            }
        }

        public int interfaceRef(Type t2) {
            return this.namePool.id(t2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Attr
    implements Comparable<Object> {
        private final String m_name;
        private String m_value;

        Attr(String name) {
            this.m_name = name != null ? name : "";
        }

        @Override
        public int compareTo(Object o2) {
            Attr a = (Attr)o2;
            if (this == a) {
                return 0;
            }
            int d2 = this.m_name.compareTo(a.m_name);
            if (d2 != 0) {
                return d2;
            }
            d2 = this.m_value.compareTo(a.m_value);
            if (d2 != 0) {
                return d2;
            }
            return 0;
        }

        public String name() {
            return this.m_name;
        }

        public String value() {
            return this.m_value;
        }

        public void setValue(String v2) {
            this.m_value = v2 != null ? v2 : "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Metadata
    implements Comparable<Object> {
        String name;
        Attr[] attrs;

        Metadata() {
        }

        @Override
        public int compareTo(Object o2) {
            Metadata md = (Metadata)o2;
            if (this == md) {
                return 0;
            }
            int d2 = md.name.compareTo(this.name);
            if (d2 != 0) {
                return d2;
            }
            d2 = this.attrs.length - md.attrs.length;
            if (d2 != 0) {
                return d2;
            }
            int n2 = this.attrs.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                d2 = this.attrs[i2].compareTo(md.attrs[i2]);
                if (d2 == 0) continue;
                return d2;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InputAbc {
        String[] strings;
        int[] ints;
        long[] uints;
        double[] doubles;
        Namespace[] namespaces;
        Nsset[] nssets;
        Name[] names;
        Method[] methods;
        Metadata[] metadata;
        Type[] classes;
        Type[] scripts;
        int id;
        Abc oabc;
        byte[] sha1;
        private final Set<Type> m_typesInABC;
        private int[] m_methodpos;
        private byte[] m_abcBytes;
        public String src_filename;
        private Reader abcreader;
        private final Domain m_domain;
        private final IIDManager m_iidMgr;

        InputAbc(Domain d2, int id, IIDManager iidMgr) {
            this.m_domain = d2;
            this.m_typesInABC = new HashSet<Type>();
            this.m_methodpos = null;
            this.id = id;
            this.m_iidMgr = iidMgr;
        }

        private Type resolveTypeName(int id) {
            if (0 == id) {
                return GlobalOptimizer.ANY();
            }
            return this.m_domain.resolveTypeName(this.names[id], GlobalOptimizer.OBJECT());
        }

        int readAbc(String src_file) throws IOException {
            byte[] file_buffer = GlobalOptimizer.load(src_file);
            this.readAbc(file_buffer);
            return file_buffer.length;
        }

        private String resolveString(int i2) {
            if (i2 > 0 && i2 < this.strings.length) {
                return this.strings[i2];
            }
            throw new Error("Invalid string pool index.");
        }

        private Object resolveStringObject(int i2) {
            if (i2 == 0) {
                return GlobalOptimizer.NULL();
            }
            return this.resolveString(i2);
        }

        private Namespace resolveNamespace(int i2) {
            if (i2 > 0 && i2 < this.namespaces.length) {
                return this.namespaces[i2];
            }
            throw new Error("Invalid namespace pool index.");
        }

        private Object resolveNamespaceObject(int i2) {
            if (i2 == 0) {
                return GlobalOptimizer.NULL();
            }
            return this.resolveNamespace(i2);
        }

        void readAbc(byte[] abc) throws IOException {
            int i2;
            int i3;
            int i4;
            try {
                MessageDigest sha1Digest = MessageDigest.getInstance("SHA");
                sha1Digest.update(abc);
                this.sha1 = sha1Digest.digest();
            }
            catch (NoSuchAlgorithmException e2) {
                System.err.println("Couldn't SHA1");
                throw new Error(e2.getMessage());
            }
            this.m_abcBytes = abc;
            this.abcreader = new Reader(0, abc);
            if (this.abcreader.readU16() != 16 || this.abcreader.readU16() != 46) {
                throw new RuntimeException("not an abc file");
            }
            this.ints = new int[this.abcreader.readU30() + 1];
            int n2 = this.ints.length - 1;
            for (i4 = 1; i4 < n2; ++i4) {
                this.ints[i4] = this.abcreader.readU30();
            }
            this.uints = new long[this.abcreader.readU30() + 1];
            n2 = this.uints.length - 1;
            for (i4 = 1; i4 < n2; ++i4) {
                this.uints[i4] = 0xFFFFFFFFL & (long)this.abcreader.readU30();
            }
            this.doubles = new double[this.abcreader.readU30() + 1];
            n2 = this.doubles.length - 1;
            for (i4 = 1; i4 < n2; ++i4) {
                this.doubles[i4] = this.abcreader.readDouble();
            }
            this.strings = new String[this.abcreader.readU30() + 1];
            this.strings[0] = null;
            n2 = this.strings.length - 1;
            for (i4 = 1; i4 < n2; ++i4) {
                int len = this.abcreader.readU30();
                this.strings[i4] = new String(abc, this.abcreader.pos, len, "UTF-8");
                this.abcreader.pos += len;
            }
            this.namespaces = new Namespace[this.abcreader.readU30() + 1];
            this.namespaces[0] = null;
            n2 = this.namespaces.length - 1;
            for (i4 = 1; i4 < n2; ++i4) {
                int kind = this.abcreader.readU8();
                String uri = this.strings[this.abcreader.readU30()];
                this.namespaces[i4] = Namespace.getNamespaceFromVersionedURI(kind, uri, this.domain());
            }
            this.nssets = new Nsset[this.abcreader.readU30() + 1];
            n2 = this.nssets.length - 1;
            for (i4 = 1; i4 < n2; ++i4) {
                this.nssets[i4] = new Nsset(new Namespace[this.abcreader.readU30()]);
                int m2 = this.nssets[i4].length;
                for (int j2 = 0; j2 < m2; ++j2) {
                    this.nssets[i4].nsset[j2] = this.resolveNamespace(this.abcreader.readU30());
                }
            }
            this.names = new Name[this.abcreader.readU30() + 1];
            HashMap<Integer, Integer> nameIdToPos = new HashMap<Integer, Integer>();
            int n3 = this.names.length - 1;
            for (i3 = 1; i3 < n3; ++i3) {
                nameIdToPos.put(i3, this.abcreader.pos);
                this.readName(this.abcreader, null);
            }
            n3 = this.names.length - 1;
            for (i3 = 1; i3 < n3; ++i3) {
                Reader nameReader = new Reader((Integer)nameIdToPos.get(i3), this.abcreader.abc);
                this.names[i3] = this.readName(nameReader, nameIdToPos);
            }
            this.methods = new Method[this.abcreader.readU30()];
            this.m_methodpos = new int[this.methods.length];
            n2 = this.methods.length;
            for (i2 = 0; i2 < n2; ++i2) {
                this.methods[i2] = this.readMethod(this.abcreader, this.m_methodpos, i2);
            }
            this.metadata = new Metadata[this.abcreader.readU30()];
            n2 = this.metadata.length;
            for (i2 = 0; i2 < n2; ++i2) {
                this.metadata[i2] = this.readMetadata(this.abcreader);
            }
            Type[] instances = new Type[this.abcreader.readU30()];
            n3 = instances.length;
            for (i3 = 0; i3 < n3; ++i3) {
                instances[i3] = this.readInstance(this.abcreader);
            }
            this.classes = new Type[instances.length];
            n3 = this.classes.length;
            for (i3 = 0; i3 < n3; ++i3) {
                this.classes[i3] = this.readClass(this.abcreader, instances[i3]);
            }
            this.scripts = new Type[this.abcreader.readU30()];
            n3 = this.scripts.length;
            for (i3 = 0; i3 < n3; ++i3) {
                this.scripts[i3] = this.readScript(this.abcreader, i3);
            }
        }

        void readBodies() {
            int n2 = this.abcreader.readU30();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.readBody(this.abcreader);
            }
            this.abcreader = null;
        }

        public void propagateMethodFlagsDownHelper(Type t2) {
            if (t2.base == null) {
                return;
            }
            if (t2.isInterface()) {
                return;
            }
            for (Binding b3 : t2.defs.values()) {
                if (!GlobalOptimizer.isMethod(b3) && !GlobalOptimizer.isGetter(b3) && !GlobalOptimizer.isSetter(b3) || b3.method == null || b3.method.needsArguments()) continue;
                Type.checkNeedsArgumentsAndUpdatePath(t2, b3.method, b3.getName());
            }
        }

        public void propagateMethodFlagsDown() {
            for (Type t2 : this.m_typesInABC) {
                this.propagateMethodFlagsDownHelper(t2);
            }
            this.m_typesInABC.clear();
        }

        public void resolveTypes() {
            for (Type t2 : this.m_typesInABC) {
                this.resolveType(t2);
            }
            int n2 = this.methods.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.resolveSignatureType(new Reader(this.m_methodpos[i2], this.m_abcBytes), this.methods[i2]);
            }
            this.m_abcBytes = null;
            this.m_methodpos = null;
            this.sealBindings();
        }

        public void sealBindings() {
            for (Type t2 : this.m_typesInABC) {
                if (t2.isInterface()) continue;
                t2.sealOptimistically();
            }
            for (Type t2 : this.m_typesInABC) {
                if (t2.isInterface()) continue;
                t2.clearInvalidBaseSealings();
            }
        }

        private boolean allowEarlyBinding(Type t2) {
            t2 = t2.base;
            while (t2 != null && t2.slotCount > 0) {
                if (!this.m_typesInABC.contains(t2) && t2.slotCount > 0) {
                    return false;
                }
                t2 = t2.base;
            }
            return true;
        }

        void propagateMethodFlagsUpHelper(Type t2, Binding b3) {
            assert (b3.method != null);
            if (b3.method.needsArguments()) {
                Type.setNeedsArgumentsUptoRoot(t2, b3.getName());
            }
        }

        void resolveType(Type t2) {
            if (t2.resolved()) {
                return;
            }
            if (t2.base != null) {
                this.resolveType(t2.base);
            }
            if (t2.isInterface()) {
                t2.markResolved();
                return;
            }
            int nBaseSlots = t2.base != null ? t2.base.slotCount : 0;
            int nBaseDispIds = t2.base != null ? t2.base.dispIdCount : 0;
            int currSlotCount = nBaseSlots;
            int currDispIdCount = nBaseDispIds;
            boolean allowEaryBinding = this.allowEarlyBinding(t2);
            BitSet usedSlotIds = new BitSet();
            for (Binding b3 : t2.defs.values()) {
                Binding b02;
                int slotPairOffset;
                if (GlobalOptimizer.isSlot(b3)) {
                    int newSlotId;
                    if (!GlobalOptimizer.isClass(b3)) {
                        this.resolveSlotType(b3);
                    }
                    if ((newSlotId = b3.slot) == 0 || !allowEaryBinding) {
                        newSlotId = ++currSlotCount;
                    }
                    if (currSlotCount < newSlotId) {
                        currSlotCount = newSlotId;
                    }
                    usedSlotIds.set(newSlotId);
                    b3.slot = newSlotId;
                    if (b3.slot > nBaseSlots) continue;
                    String errorStr = t2.name.format() + "::" + b3.getName().format() + " has a slot id(" + String.valueOf(b3.slot) + ") less than the slot count of the base class(" + String.valueOf(nBaseSlots) + ").";
                    throw new Error(errorStr);
                }
                if (GlobalOptimizer.isMethod(b3)) {
                    Binding b03;
                    this.propagateMethodFlagsUpHelper(t2, b3);
                    assert (b3.slot == 0);
                    Binding binding = b03 = t2.base != null ? t2.base.findOverride(b3.getName()) : null;
                    if (b03 != null) {
                        assert (b03.isMethod());
                        b3.slot = b03.slot;
                        continue;
                    }
                    b3.slot = ++currDispIdCount;
                    continue;
                }
                if (!GlobalOptimizer.isGetter(b3) && !GlobalOptimizer.isSetter(b3)) continue;
                this.propagateMethodFlagsUpHelper(t2, b3);
                if (b3.slot != 0) continue;
                int peerSlotDelta = GlobalOptimizer.isGetter(b3) ? -1 : 1;
                int n2 = slotPairOffset = GlobalOptimizer.isGetter(b3) ? 0 : 1;
                if (b3.peer != null && b3.peer.slot != 0) {
                    int mySlot = b3.peer.slot + peerSlotDelta;
                    assert (b3.peer.isGetter() || b3.peer.isSetter());
                    assert (b3.slot == 0 || b3.slot == mySlot);
                    b3.slot = mySlot;
                    continue;
                }
                Binding binding = b02 = t2.base != null ? t2.base.findOverride(b3.getName()) : null;
                if (b02 != null) {
                    assert (b02.isGetter() || b02.isSetter());
                    b3.slot = b3.isGetter() == b02.isGetter() ? b02.slot : b02.slot + peerSlotDelta;
                } else {
                    b3.slot = ++currDispIdCount + slotPairOffset;
                    ++currDispIdCount;
                }
                if (b3.peer == null) continue;
                int peerSlot = b3.slot - peerSlotDelta;
                assert (b3.isGetter() ^ b3.peer.isGetter());
                assert (b3.isSetter() ^ b3.peer.isSetter());
                assert (b3.peer.slot == 0 || b3.peer.slot == peerSlot);
                b3.peer.slot = peerSlot;
            }
            t2.slotCount = currSlotCount;
            t2.dispIdCount = currDispIdCount;
            t2.markResolved();
        }

        Metadata readMetadata(Reader p2) {
            int j2;
            Metadata md = new Metadata();
            md.name = this.resolveString(p2.readU30());
            md.attrs = new Attr[p2.readU30()];
            Attr[] attrs = md.attrs;
            int n2 = attrs.length;
            for (j2 = 0; j2 < n2; ++j2) {
                attrs[j2] = new Attr(this.strings[p2.readU30()]);
            }
            n2 = attrs.length;
            for (j2 = 0; j2 < n2; ++j2) {
                attrs[j2].setValue(this.strings[p2.readU30()]);
            }
            return md;
        }

        void resolveSignatureType(Reader p2, Method m2) {
            m2.returns = this.resolveTypeName((int)p2.readU30()).ref;
            for (int j2 = 1; j2 < m2.getParams().length; ++j2) {
                int idx = p2.readU30();
                Type ptype = this.resolveTypeName(idx);
                assert (ptype != null);
                m2.getParams()[j2] = ptype.ref.nullable();
            }
            p2.readU30();
            p2.readU8();
            if (m2.hasOptional()) {
                int first_optional_param;
                m2.optional_count = p2.readU30();
                m2.values = new Object[m2.getParams().length];
                for (int j3 = first_optional_param = m2.getParams().length - m2.optional_count; j3 < m2.getParams().length; ++j3) {
                    m2.values[j3] = this.readArgDefault(p2);
                    assert (m2.values[j3] != null);
                }
            }
        }

        void readBody(Reader p2) {
            Method m2 = this.methods[p2.readU30()];
            GlobalOptimizer.addTraceAttr("method", m2);
            m2.max_stack = p2.readU30();
            m2.local_count = p2.readU30();
            m2.max_scope = -(p2.readU30() - p2.readU30());
            m2.code_len = p2.readU30();
            Reader pcode = new Reader(p2);
            p2.pos += m2.code_len;
            this.readCode(m2, pcode, p2);
            Type act = Type.newActivationType();
            m2.activation = act.ref.nonnull();
            act.base = GlobalOptimizer.ANY();
            if (m2.getName() != null) {
                act.name = m2.getName().append(" activation");
            }
            this.readTraits(p2, act);
        }

        Method readMethod(Reader p2, int[] methodpos, int i2) {
            Method m2 = new Method(i2, this);
            int param_count = p2.readU30();
            m2.params = new Typeref[param_count + 1];
            m2.getParams()[0] = GlobalOptimizer.ANY().ref;
            methodpos[i2] = p2.pos;
            p2.readU30();
            for (int j2 = 1; j2 <= param_count; ++j2) {
                p2.readU30();
            }
            int nameIndex = p2.readU30();
            m2.debugName = nameIndex != 0 ? this.resolveString(nameIndex) : "";
            m2.name = this.m_domain.createNameWithPublicNamespace(m2.debugName);
            m2.flags = p2.readU8();
            if (m2.hasOptional()) {
                int optional_count = p2.readU30();
                assert (optional_count > 0);
                for (int j3 = 0; j3 < optional_count; ++j3) {
                    p2.readU30();
                    p2.readU8();
                }
            }
            if (m2.hasParamNames()) {
                m2.paramNames = new Name[param_count + 1];
                for (int j4 = 1; j4 <= param_count; ++j4) {
                    int paramNameIndex = p2.readU30();
                    String paramNameStr = paramNameIndex != 0 ? this.resolveString(paramNameIndex) : "";
                    m2.paramNames[j4] = this.m_domain.createNameWithPublicNamespace(paramNameStr);
                }
            }
            return m2;
        }

        private Name readNameImpl(Reader p2, Map<Integer, Integer> nameIdToPos) {
            int kind = p2.readU8();
            switch (kind) {
                default: {
                    throw new RuntimeException("Unknown name kind: " + kind);
                }
                case 29: {
                    int index = p2.readU30();
                    int count = p2.readU30();
                    assert (count == 1);
                    Integer[] typeParamIndexes = new Integer[count];
                    for (int i2 = 0; i2 < count; ++i2) {
                        typeParamIndexes[i2] = p2.readU30();
                    }
                    if (nameIdToPos != null) {
                        int parameterizedTypeNameIndex = nameIdToPos.get(index);
                        Reader nameReader = new Reader(parameterizedTypeNameIndex, p2.abc);
                        Name parameterizedTypeName = this.readName(nameReader, nameIdToPos);
                        Name[] paramTypeNames = new Name[count];
                        for (int i3 = 0; i3 < count; ++i3) {
                            int typeParamIndex = typeParamIndexes[i3];
                            if (typeParamIndex != 0) {
                                nameReader.pos = nameIdToPos.get(typeParamIndex);
                                paramTypeNames[i3] = this.readName(nameReader, nameIdToPos);
                                continue;
                            }
                            paramTypeNames[i3] = Name.ANY(this.m_domain.PUBLIC);
                        }
                        return new Name(parameterizedTypeName, paramTypeNames[0]);
                    }
                    return null;
                }
                case 7: 
                case 13: {
                    return new Name(kind, this.namespaces[p2.readU30()], this.strings[p2.readU30()]);
                }
                case 9: 
                case 14: {
                    return new Name(kind, this.strings[p2.readU30()], this.nssets[p2.readU30()]);
                }
                case 15: 
                case 16: {
                    return new Name(kind, GlobalOptimizer.uniqueNs(this.m_domain.api), this.strings[p2.readU30()]);
                }
                case 27: 
                case 28: {
                    return new Name(kind, GlobalOptimizer.unique(), this.nssets[p2.readU30()]);
                }
                case 17: 
                case 18: 
            }
            return new Name(kind, this.m_domain.api);
        }

        private Name readName(Reader p2, Map<Integer, Integer> nameIdToPos) {
            Name result = this.readNameImpl(p2, nameIdToPos);
            assert (result == null || !result.isAny());
            return result;
        }

        void readTraits(Reader p2, Type t2) {
            this.m_typesInABC.add(t2);
            t2.defs = new Symtab();
            int count = p2.readU30();
            for (int i2 = 0; i2 < count; ++i2) {
                Name name = this.names[p2.readU30()];
                Binding b3 = new Binding(p2.readU8(), name, this);
                Binding old = t2.defs.get(name);
                while (old != null && old.peer != null) {
                    old = old.peer;
                }
                if (old != null) {
                    old.peer = b3;
                }
                t2.defs.put(name, b3);
                int slot = p2.readU30();
                b3.id = p2.readU30();
                switch (b3.kind()) {
                    case 0: 
                    case 4: 
                    case 6: {
                        if (GlobalOptimizer.isClass(b3)) {
                            b3.type = this.classes[b3.id].ref.exactnonnull();
                            b3.setValue(GlobalOptimizer.NULL());
                            this.m_domain.addNamedType(name, b3.type.getType().itype);
                        } else {
                            this.readSlotDefault(p2, b3);
                            b3.type = GlobalOptimizer.ANY().ref;
                        }
                        b3.slot = slot;
                        if (b3.slot > count) {
                            String errorStr = t2.name.format() + "::" + name.format() + " has a slot id(" + String.valueOf(b3.slot) + ") larger than the name count(" + String.valueOf(count) + ").";
                            throw new Error(errorStr);
                        }
                        if (old != null) {
                            String errorStr = t2.name.format() + " alread has a binding named:" + name.format();
                            throw new Error(errorStr);
                        }
                        if (!t2.isInterface()) break;
                        String errorStr = t2.name.format() + " is an interface and can not have slots:" + name.format();
                        throw new Error(errorStr);
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        b3.slot = 0;
                        Method m2 = b3.method = this.methods[b3.id];
                        m2.cx = t2;
                        m2.getParams()[0] = t2.ref.nonnull();
                        m2.kind = GlobalOptimizer.isMethod(b3) ? Method.Kind.FUNCTION : (GlobalOptimizer.isGetter(b3) ? Method.Kind.GET : Method.Kind.SET);
                        m2.name = name;
                        if (!t2.isInterface()) break;
                        name.iid = m2.iid = this.m_iidMgr.createIID();
                        break;
                    }
                    default: {
                        System.err.println("illegal trait kind " + b3.kind() + " at offset " + p2.pos);
                        assert (false);
                        break;
                    }
                }
                if (!b3.hasMetadata()) continue;
                b3.md = new Metadata[p2.readU30()];
                int m3 = b3.md.length;
                for (int j2 = 0; j2 < m3; ++j2) {
                    b3.md[j2] = this.metadata[p2.readU30()];
                }
            }
        }

        void readSlotDefault(Reader p2, Binding b3) {
            int i2 = p2.readU30();
            if (i2 != 0) {
                int kind = p2.readU8();
                b3.setValue(this.defaultValue(kind, i2));
            }
        }

        Object readArgDefault(Reader p2) {
            int i2 = p2.readU30();
            int kind = p2.readU8();
            Object v2 = this.defaultValue(kind, i2);
            return v2;
        }

        private Object defaultValue(int kind, int i2) {
            switch (kind) {
                case 10: {
                    return Boolean.FALSE;
                }
                case 11: {
                    return Boolean.TRUE;
                }
                case 12: {
                    return GlobalOptimizer.NULL();
                }
                case 0: {
                    return OptimizerConstants.UNDEFINED;
                }
                case 1: {
                    return this.resolveStringObject(i2);
                }
                case 3: {
                    return this.ints[i2];
                }
                case 4: {
                    return this.uints[i2];
                }
                case 6: {
                    return this.doubles[i2];
                }
                case 5: 
                case 8: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    return this.resolveNamespaceObject(i2);
                }
            }
            assert (false);
            return null;
        }

        void resolveSlotType(Binding b3) {
            b3.type = this.resolveTypeName((int)b3.id).ref;
            if (b3.value() == null) {
                b3.setValue(b3.type.t.defaultValue);
            }
        }

        Type readScript(Reader p2, int i2) {
            Typeref sref;
            assert (GlobalOptimizer.OBJECT() != null);
            Type s2 = new Type(this.m_domain.createNameWithPublicNamespace("global" + i2), GlobalOptimizer.OBJECT());
            Method init = s2.init = this.methods[p2.readU30()];
            init.cx = s2;
            init.getParams()[0] = sref = s2.ref.exactnonnull();
            init.name = s2.getName();
            init.kind = Method.Kind.INIT;
            this.readTraits(p2, s2);
            for (Binding b3 : s2.defs.values()) {
                this.m_domain.addNamedScript(b3.getName(), sref);
            }
            s2.setFinal();
            return s2;
        }

        Type readClass(Reader p2, Type it) {
            assert (GlobalOptimizer.CLASS() != null);
            Type c2 = new Type(it.getName().append("$"), GlobalOptimizer.CLASS());
            c2.itype = it;
            Method init = c2.init = this.methods[p2.readU30()];
            init.cx = c2;
            init.getParams()[0] = c2.ref.nonnull();
            init.name = c2.getName();
            init.kind = Method.Kind.INIT;
            this.readTraits(p2, c2);
            c2.setFinal();
            return c2;
        }

        Type readInstance(Reader p2) {
            int nameId = p2.readU30();
            Name iname = this.names[nameId];
            Type base = this.resolveTypeName(p2.readU30());
            Type t2 = new Type(iname, base);
            BuiltinDomain.instance().baseTypes.add(t2.base);
            t2.flags = p2.readU8();
            if (t2.hasProtectedNs()) {
                t2.protectedNs = this.namespaces[p2.readU30()];
            }
            t2.interfaces = new Type[p2.readU30()];
            int n2 = t2.interfaces.length;
            for (int j2 = 0; j2 < n2; ++j2) {
                t2.interfaces[j2] = this.resolveTypeName(p2.readU30());
            }
            t2.init = this.methods[p2.readU30()];
            if (t2.init.isNative() && !GlobalOptimizer.this.ALLOW_NATIVE_CTORS) {
                throw new RuntimeException("Constructors can't be native: " + t2);
            }
            t2.init.cx = t2;
            t2.init.getParams()[0] = t2.ref.nonnull();
            t2.init.kind = Method.Kind.INIT;
            t2.init.name = t2.getName();
            this.readTraits(p2, t2);
            this.m_domain.addNamedType(t2);
            return t2;
        }

        private int computeOpCodeSize(Reader p2) {
            Reader tempReader = new Reader(p2);
            int op = tempReader.readU8();
            int opCount = ABCOpCodes.operandCountTable[op];
            if (op == 36 || op == 239) {
                --opCount;
                tempReader.readU8();
            }
            if (opCount > 0) {
                if (op >= 12 && op <= 27) {
                    tempReader.readS24();
                } else {
                    tempReader.readU30();
                }
                if (op == 239) {
                    --opCount;
                    tempReader.readU8();
                }
                if (op == 27) {
                    int caseCount = tempReader.readU30() + 1;
                    tempReader.pos += caseCount * 3;
                } else if (opCount > 1) {
                    tempReader.readU30();
                }
            }
            return tempReader.pos - p2.pos;
        }

        void replaceWithVerifyError(Method m2, int pos, int errorID, String errorString) {
            Expr e2;
            System.err.println("Warning: '" + m2.toString() + "' contains a verify error at offset " + pos + ". The body of this method will be replaced with 'throw VerifyError'");
            Block b3 = new Block(m2, 0);
            m2.entry = new Edge(m2, null, 0);
            m2.entry.to = b3;
            m2.hasExceptions = true;
            Name ref = this.m_domain.createNameWithPublicNamespace("VerifyError");
            Expr e1 = new Expr(m2, 93);
            e1.ref = ref;
            b3.appendExpr(e1);
            Expr a12 = Expr.createWithValue(m2, 45, -1, new Integer(errorID));
            b3.appendExpr(a12);
            if (errorString == null) {
                e2 = new Expr(m2, 74, new Expr[]{e1, a12});
            } else {
                Expr a22 = Expr.createWithValue(m2, 44, -1, errorString);
                b3.appendExpr(a22);
                e2 = new Expr(m2, 74, new Expr[]{e1, a12, a22});
            }
            e2.ref = ref;
            b3.appendExpr(e2);
            Expr e3 = new Expr(m2, 3, e2);
            e3.succ = OptimizerConstants.noedges;
            b3.appendExpr(e3);
        }

        void replaceWithVerifyError(Method m2, int pos, int errorID) {
            this.replaceWithVerifyError(m2, pos, errorID, null);
        }

        void readCode(Method m2, Reader p2, Reader ptry) {
            Expr e2;
            int i2;
            GlobalOptimizer.addTraceAttr("Method", m2);
            GlobalOptimizer.addTraceAttr("code_start", p2.pos);
            int local_count = m2.local_count;
            int end_pos = p2.pos + m2.code_len;
            Expr[] frame = new Expr[local_count + m2.max_scope + m2.max_stack];
            TreeMap<Integer, Block> blocks = new TreeMap<Integer, Block>();
            TreeMap<Block, FrameState> states = new TreeMap<Block, FrameState>();
            int scopep = local_count;
            int sp = local_count + m2.max_scope;
            GlobalOptimizer.traceEntry("InitialFrame");
            GlobalOptimizer.addTraceAttr("length", frame.length);
            GlobalOptimizer.addTraceAttr("sp", sp);
            GlobalOptimizer.addTraceAttr("scopep", scopep);
            m2.entry = new Edge(m2, null, 0);
            Block b3 = GlobalOptimizer.this.createBlock(m2, m2.entry, states, frame, p2.pos, sp, scopep);
            for (i2 = 0; i2 < m2.getParams().length; ++i2) {
                e2 = frame[i2] = new Expr(m2, 256, -1, i2);
                b3.add(frame[i2]);
                e2.ref = i2 == 0 ? this.m_domain.createNameWithPublicNamespace("this") : (m2.paramNames != null ? m2.paramNames[i2] : this.m_domain.createNameWithPublicNamespace("arg" + i2));
            }
            if (m2.needsArguments() || m2.needsRest()) {
                e2 = frame[i2] = new Expr(m2, 256, -1, i2);
                b3.add(frame[i2]);
                e2.ref = this.m_domain.createNameWithPublicNamespace(m2.needsArguments() ? "arguments" : "rest");
                ++i2;
            }
            while (i2 < local_count) {
                e2 = frame[i2] = new Expr(m2, 256, -1, i2);
                b3.add(frame[i2]);
                e2.ref = this.m_domain.createNameWithPublicNamespace("local" + i2);
                ++i2;
            }
            HashMap allLocals = new HashMap();
            HashSet<Expr> allDebugOps = new HashSet<Expr>();
            BitSet tryBlockStarts = new BitSet();
            BitSet tryBlockEnds = new BitSet();
            BitSet catchlabels = new BitSet();
            int code_start = p2.pos;
            int try_start = ptry.pos;
            m2.handlers = new Handler[ptry.readU30()];
            Handler[] handlers = m2.handlers;
            if (handlers.length > 0) {
                m2.fixedLocals.put(frame[0], -1);
                int n2 = handlers.length;
                for (int j2 = 0; j2 < n2; ++j2) {
                    Handler h2 = handlers[j2] = new Handler();
                    int from = ptry.readU30();
                    int to = ptry.readU30();
                    int target = ptry.readU30();
                    h2.type = this.resolveTypeName((int)ptry.readU30()).ref.nonnull();
                    int name_idx = ptry.readU30();
                    h2.name = this.names[name_idx];
                    Name name = h2.name;
                    if (name != null) {
                        Type a = new Type(name, GlobalOptimizer.ANY());
                        h2.activation = a.ref.nonnull();
                        Binding bind = new Binding(0, name, this);
                        bind.type = h2.type;
                        a.defs.put(name, bind);
                        this.m_typesInABC.add(a);
                    } else {
                        h2.activation = GlobalOptimizer.ANY().ref.nonnull();
                    }
                    tryBlockStarts.set(from);
                    tryBlockEnds.set(to);
                    catchlabels.set(target);
                }
            }
            boolean in_catch_block = false;
            boolean split = false;
            boolean blockEnd = false;
            block78: while (p2.pos < end_pos) {
                int pos = p2.pos;
                int posInMethod = pos - code_start;
                int opCodeSize = this.computeOpCodeSize(p2);
                int nextOpCodePos = pos + opCodeSize;
                int op = p2.readU8();
                boolean reachable = true;
                if (split || 9 == op || blocks.containsKey(pos) || tryBlockStarts.get(posInMethod) || !blockEnd && tryBlockEnds.get(posInMethod) || catchlabels.get(posInMethod)) {
                    split = false;
                    in_catch_block = catchlabels.get(posInMethod);
                    Edge edge = null;
                    if (!blockEnd) {
                        assert (!in_catch_block);
                        Edge[] succ = b3.succ();
                        if (0 == succ.length) {
                            e2 = new Expr(m2, 16, posInMethod);
                            b3.add(e2);
                            edge = new Edge(m2, b3, 0, (Block)blocks.get(pos));
                            e2.succ = new Edge[]{edge};
                        } else {
                            edge = succ[0];
                        }
                        GlobalOptimizer.traceEntry("Successor");
                        GlobalOptimizer.addTraceAttr("Edge", edge);
                    }
                    if (!in_catch_block) {
                        GlobalOptimizer.this.merge(m2, edge, blocks, states, pos, frame, sp, scopep);
                    }
                    b3 = (Block)blocks.get(pos);
                    assert (b3 != null);
                    FrameState state = (FrameState)states.get(b3);
                    assert (state != null);
                    System.arraycopy(state.frame, 0, frame, 0, frame.length);
                    sp = state.sp;
                    scopep = state.scopep;
                    blockEnd = false;
                } else if (blockEnd) {
                    reachable = false;
                }
                if (handlers.length > 0 && b3.xsucc == OptimizerConstants.noedges) {
                    m2.hasExceptions = true;
                    GlobalOptimizer.addTraceAttr("offset", pos - code_start);
                    ArrayList<Edge> xsucc = new ArrayList<Edge>();
                    ptry.pos = try_start;
                    int n3 = ptry.readU30();
                    GlobalOptimizer.addTraceAttr("NumHandlers", n3);
                    for (int j3 = 0; j3 < n3; ++j3) {
                        int from = code_start + ptry.readU30();
                        int to = code_start + ptry.readU30();
                        int target = code_start + ptry.readU30();
                        GlobalOptimizer.traceEntry("Handler");
                        GlobalOptimizer.addTraceAttr("from", from - code_start);
                        GlobalOptimizer.addTraceAttr("to", to - code_start);
                        GlobalOptimizer.addTraceAttr("target", target - code_start);
                        if (pos >= from && pos <= to) {
                            GlobalOptimizer.addTraceAttr("activeHandler");
                            Edge edge = new Edge(m2, b3, j3, handlers[j3]);
                            GlobalOptimizer.this.xmerge(m2, edge, blocks, states, target, frame, sp, scopep);
                            xsucc.add(edge);
                        }
                        ptry.readU30();
                        ptry.readU30();
                    }
                    b3.xsucc = xsucc.toArray(new Edge[xsucc.size()]);
                }
                GlobalOptimizer.addTraceAttr("offset", pos - code_start);
                GlobalOptimizer.addTraceAttr("op", op);
                GlobalOptimizer.addTraceAttr("opName", Expr.opName(op));
                if (!reachable) {
                    p2.pos = nextOpCodePos;
                    continue;
                }
                switch (op) {
                    case 9: {
                        break;
                    }
                    case 3: 
                    case 72: {
                        e2 = new Expr(m2, op, posInMethod, frame, sp--, 1);
                        b3.add(e2);
                        e2.succ = OptimizerConstants.noedges;
                        blockEnd = true;
                        break;
                    }
                    case 7: {
                        b3.add(new Expr(m2, op, posInMethod, frame, sp--, 1));
                        break;
                    }
                    case 28: 
                    case 48: {
                        frame[scopep++] = e2 = new Expr(m2, op, posInMethod, frame, sp--, 1);
                        b3.add(e2);
                        if (in_catch_block && 257 == e2.args[0].op) {
                            Expr activ = e2.args[0];
                            while (257 == activ.op && activ.args != null && activ.args.length > 0) {
                                activ = activ.args[0];
                            }
                            if (87 == activ.op) {
                                m2.fixedLocals.put(activ, -1);
                            }
                        }
                        if (GlobalOptimizer.this.m_llvmEmitter == null) continue block78;
                        GlobalOptimizer.this.m_llvmEmitter.recordScopeDepth(e2, scopep - local_count);
                        break;
                    }
                    case 29: {
                        e2 = new Expr(m2, op, posInMethod);
                        b3.add(e2);
                        e2.scopes = new Expr[]{frame[--scopep]};
                        frame[scopep] = null;
                        if (GlobalOptimizer.this.m_llvmEmitter == null) continue block78;
                        GlobalOptimizer.this.m_llvmEmitter.recordScopeDepth(e2, scopep - local_count);
                        break;
                    }
                    case 30: 
                    case 31: 
                    case 35: {
                        e2 = new Expr(m2, op, posInMethod, frame, sp, 2);
                        b3.add(e2);
                        sp -= 2;
                        frame[sp++] = e2;
                        break;
                    }
                    case 32: {
                        int n4 = sp++;
                        Expr expr = Expr.createWithValue(m2, op, posInMethod, GlobalOptimizer.NULL());
                        frame[n4] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 33: {
                        int n5 = sp++;
                        Expr expr = Expr.createWithValue(m2, op, posInMethod, OptimizerConstants.UNDEFINED);
                        frame[n5] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 38: {
                        int n6 = sp++;
                        Expr expr = Expr.createWithValue(m2, op, posInMethod, Boolean.TRUE);
                        frame[n6] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 39: {
                        int n7 = sp++;
                        Expr expr = Expr.createWithValue(m2, op, posInMethod, Boolean.FALSE);
                        frame[n7] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 40: {
                        int n8 = sp++;
                        Expr expr = Expr.createWithValue(m2, op, posInMethod, Double.NaN);
                        frame[n8] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 87: {
                        int n9 = sp++;
                        Expr expr = new Expr(m2, op, posInMethod);
                        frame[n9] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 100: {
                        int n10 = sp++;
                        Expr expr = new Expr(m2, op, posInMethod);
                        frame[n10] = expr;
                        e2 = expr;
                        b3.add(expr);
                        e2.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        GlobalOptimizer.traceEntry("scopep", scopep);
                        break;
                    }
                    case 101: {
                        int n11 = sp++;
                        Expr expr = new Expr(m2, op, posInMethod);
                        frame[n11] = expr;
                        e2 = expr;
                        b3.add(expr);
                        int scopeid = local_count + p2.readU8() + 1;
                        for (Expr s2 : e2.scopes = GlobalOptimizer.capture(frame, scopeid, 1)) {
                            if (s2 != null) continue;
                            this.replaceWithVerifyError(m2, p2.pos, 1019, "" + scopeid);
                            return;
                        }
                        continue block78;
                    }
                    case 41: {
                        --sp;
                        break;
                    }
                    case 42: {
                        if (sp >= frame.length) {
                            this.replaceWithVerifyError(m2, pos, 1023);
                            return;
                        }
                        frame[sp] = frame[sp - 1];
                        ++sp;
                        break;
                    }
                    case 43: {
                        e2 = frame[sp - 1];
                        frame[sp - 1] = frame[sp - 2];
                        frame[sp - 2] = e2;
                        break;
                    }
                    case 71: {
                        e2 = new Expr(m2, op, posInMethod);
                        b3.add(e2);
                        e2.succ = OptimizerConstants.noedges;
                        blockEnd = true;
                        break;
                    }
                    case 131: {
                        op = 115;
                    }
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 130: 
                    case 133: 
                    case 137: 
                    case 144: 
                    case 145: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 192: 
                    case 193: 
                    case 196: {
                        Expr expr = new Expr(m2, op, posInMethod, frame, sp, 1);
                        frame[sp - 1] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 120: {
                        b3.add(new Expr(m2, op, posInMethod, frame, sp, 1));
                        break;
                    }
                    case 135: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 179: 
                    case 180: 
                    case 197: 
                    case 198: 
                    case 199: {
                        Expr expr = new Expr(m2, op, posInMethod, frame, sp, 2);
                        frame[sp - 2] = expr;
                        b3.add(expr);
                        --sp;
                        break;
                    }
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: {
                        Expr expr = new Expr(m2, op, posInMethod, frame, sp, 2);
                        frame[sp - 2] = expr;
                        b3.add(expr);
                        sp -= 2;
                        break;
                    }
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: {
                        frame[sp++] = frame[op - 208];
                        break;
                    }
                    case 8: {
                        int local = p2.readU30();
                        frame[local] = Expr.createWithValue(m2, 33, posInMethod, OptimizerConstants.UNDEFINED);
                        b3.add(frame[local]);
                        if (!allLocals.containsKey(local)) {
                            allLocals.put(local, new HashSet());
                        }
                        ((Set)allLocals.get(local)).add(frame[local]);
                        split = true;
                        break;
                    }
                    case 37: {
                        int n12 = sp++;
                        Expr expr = Expr.createWithValue(m2, op, posInMethod, new Integer((short)p2.readU30()));
                        frame[n12] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 44: {
                        int n13 = sp++;
                        Expr expr = Expr.createWithValue(m2, op, posInMethod, this.resolveString(p2.readU30()));
                        frame[n13] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 45: {
                        int n14 = sp++;
                        Expr expr = Expr.createWithValue(m2, op, posInMethod, new Integer(this.ints[p2.readU30()]));
                        frame[n14] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 46: {
                        int n15 = sp++;
                        Expr expr = Expr.createWithValue(m2, op, posInMethod, new Long(this.uints[p2.readU30()]));
                        frame[n15] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 47: {
                        int n16 = sp++;
                        Expr expr = Expr.createWithValue(m2, op, posInMethod, new Double(this.doubles[p2.readU30()]));
                        frame[n16] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 49: {
                        int n17 = sp++;
                        Expr expr = Expr.createWithValue(m2, op, posInMethod, this.resolveNamespace(p2.readU30()));
                        frame[n17] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 98: {
                        frame[sp++] = frame[p2.readU30()];
                        break;
                    }
                    case 99: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 215: {
                        int local = op == 99 ? p2.readU30() : op - 212;
                        frame[local] = frame[--sp];
                        if (!allLocals.containsKey(local)) {
                            allLocals.put(local, new HashSet());
                        }
                        ((Set)allLocals.get(local)).add(frame[local]);
                        split = true;
                        break;
                    }
                    case 128: 
                    case 134: 
                    case 178: {
                        int nameId = p2.readU30();
                        Expr expr = new Expr(m2, op, posInMethod, this.names[nameId], frame, sp, 1);
                        frame[sp - 1] = expr;
                        e2 = expr;
                        b3.add(expr);
                        break;
                    }
                    case 6: {
                        b3.add(Expr.createWithValue(m2, op, posInMethod, this.strings[p2.readU30()]));
                        break;
                    }
                    case 146: 
                    case 148: 
                    case 194: 
                    case 195: {
                        int i3 = p2.readU30();
                        op = op == 194 ? 192 : (op == 146 ? 145 : (op == 195 ? 193 : 147));
                        e2 = frame[i3] = new Expr(m2, op, posInMethod, i3, frame, i3 + 1, 1);
                        b3.add(frame[i3]);
                        break;
                    }
                    case 64: {
                        e2 = new Expr(m2, op, posInMethod);
                        e2.m = this.methods[p2.readU30()];
                        if (e2.m.debugName == null || e2.m.debugName.length() == 0) {
                            String nameForThisMethod = m2.name != null ? m2.name.format() : (m2.debugName.length() > 0 ? m2.debugName : m2.kind.toString());
                            e2.m.debugName = "OP_newfunction'd in " + nameForThisMethod;
                            e2.m.debugName = e2.m.debugName + ".";
                        }
                        e2.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        GlobalOptimizer.traceEntry("scopep", scopep);
                        int n18 = sp++;
                        Expr expr = e2;
                        frame[n18] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 88: {
                        e2 = new Expr(m2, op, posInMethod, frame, sp, 1);
                        e2.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        GlobalOptimizer.traceEntry("scopep", scopep);
                        e2.c = this.classes[p2.readU30()];
                        Expr expr = e2;
                        frame[sp - 1] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 85: {
                        int argc = 2 * p2.readU30();
                        e2 = new Expr(m2, op, posInMethod, frame, sp, argc);
                        sp -= argc;
                        int n19 = sp++;
                        Expr expr = e2;
                        frame[n19] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 86: {
                        int argc = p2.readU30();
                        e2 = new Expr(m2, op, posInMethod, frame, sp, argc);
                        sp -= argc;
                        int n20 = sp++;
                        Expr expr = e2;
                        frame[n20] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 90: {
                        e2 = new Expr(m2, op, posInMethod, p2.readU30());
                        int n21 = sp++;
                        Expr expr = e2;
                        frame[n21] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 4: {
                        Name ref = this.names[p2.readU30()];
                        int argc = 1 + refArgc[ref.kind];
                        e2 = new Expr(m2, op, posInMethod, ref, frame, sp, argc);
                        sp -= argc;
                        int n22 = sp++;
                        Expr expr = e2;
                        frame[n22] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 5: {
                        Name ref = this.names[p2.readU30()];
                        int argc = 2 + refArgc[ref.kind];
                        e2 = new Expr(m2, op, posInMethod, ref, frame, sp, argc);
                        b3.add(e2);
                        sp -= argc;
                        break;
                    }
                    case 65: {
                        int argc = 2 + p2.readU30();
                        e2 = new Expr(m2, op, posInMethod, frame, sp, argc);
                        sp -= argc;
                        int n23 = sp++;
                        Expr expr = e2;
                        frame[n23] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 66: {
                        int argc = 1 + p2.readU30();
                        e2 = new Expr(m2, op, posInMethod, frame, sp, argc);
                        sp -= argc;
                        int n24 = sp++;
                        Expr expr = e2;
                        frame[n24] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 89: 
                    case 102: 
                    case 106: {
                        Name ref = this.names[p2.readU30()];
                        int argc = 1 + refArgc[ref.kind];
                        e2 = new Expr(m2, op, posInMethod, ref, frame, sp, argc);
                        sp -= argc;
                        int n25 = sp++;
                        Expr expr = e2;
                        frame[n25] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 96: {
                        Name ref = this.names[p2.readU30()];
                        assert (refArgc[ref.kind] == 0);
                        e2 = new Expr(m2, 93, posInMethod, ref, frame, sp, 0);
                        e2.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        b3.add(e2);
                        e2 = new Expr(m2, 102, posInMethod, ref, new Expr[]{e2}, 1, 1);
                        int n26 = sp++;
                        Expr expr = e2;
                        frame[n26] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 93: 
                    case 94: {
                        Name ref = this.names[p2.readU30()];
                        int argc = refArgc[ref.kind];
                        e2 = new Expr(m2, op, posInMethod, ref, frame, sp, argc);
                        e2.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        sp -= argc;
                        int n27 = sp++;
                        Expr expr = e2;
                        frame[n27] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 95: {
                        Name ref = this.names[p2.readU30()];
                        int argc = refArgc[ref.kind];
                        e2 = new Expr(m2, op, posInMethod, ref, frame, sp, argc);
                        sp -= argc;
                        int n28 = sp++;
                        Expr expr = e2;
                        frame[n28] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 97: 
                    case 104: {
                        Name ref = this.names[p2.readU30()];
                        int argc = 2 + refArgc[ref.kind];
                        e2 = new Expr(m2, op, posInMethod, ref, frame, sp, argc);
                        sp -= argc;
                        b3.add(e2);
                        break;
                    }
                    case 110: {
                        int n29 = sp++;
                        Expr expr = new Expr(m2, 100, posInMethod);
                        frame[n29] = expr;
                        e2 = expr;
                        b3.add(expr);
                        e2.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        GlobalOptimizer.traceEntry("scopep", scopep);
                        op = 108;
                    }
                    case 108: {
                        e2 = new Expr(m2, op, posInMethod, p2.readU30(), frame, sp, 1);
                        b3.add(e2);
                        frame[sp - 1] = e2;
                        break;
                    }
                    case 111: {
                        e2 = new Expr(m2, 100, posInMethod);
                        b3.add(e2);
                        e2.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        GlobalOptimizer.traceEntry("scopep", scopep);
                        e2 = Expr.createWithArgs(m2, 109, posInMethod, new Expr[]{e2, frame[sp - 1]});
                        b3.add(e2);
                        e2.imm = new int[]{p2.readU30()};
                        --sp;
                        break;
                    }
                    case 109: {
                        e2 = new Expr(m2, op, posInMethod, p2.readU30(), frame, sp, 2);
                        b3.add(e2);
                        sp -= 2;
                        break;
                    }
                    case 16: {
                        int offset = p2.readS24();
                        e2 = new Expr(m2, op, posInMethod);
                        b3.add(e2);
                        e2.succ = new Edge[]{new Edge(m2, b3, 0, (Block)blocks.get(p2.pos + offset))};
                        GlobalOptimizer.this.merge(m2, e2.succ[0], blocks, states, p2.pos + offset, frame, sp, scopep);
                        blockEnd = true;
                        break;
                    }
                    case 17: 
                    case 18: {
                        e2 = new Expr(m2, op, posInMethod, frame, sp--, 1);
                        b3.add(e2);
                        int offset = p2.readS24();
                        e2.succ = new Edge[]{new Edge(m2, b3, 0, (Block)blocks.get(p2.pos)), new Edge(m2, b3, 1, (Block)blocks.get(p2.pos + offset))};
                        GlobalOptimizer.this.merge(m2, null, blocks, states, p2.pos, frame, sp, scopep);
                        GlobalOptimizer.this.merge(m2, e2.succ[1], blocks, states, p2.pos + offset, frame, sp, scopep);
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 20: 
                    case 26: {
                        e2 = new Expr(m2, GlobalOptimizer.this.ifoper(op), posInMethod, frame, sp, 2);
                        b3.add(e2);
                        GlobalOptimizer.traceEntry("ConditionalBranch");
                        GlobalOptimizer.addTraceAttr(e2);
                        e2 = new Expr(m2, 18, posInMethod, new Expr[]{e2}, 1, 1);
                        b3.add(e2);
                        int offset = p2.readS24();
                        e2.succ = new Edge[]{new Edge(m2, b3, 0, (Block)blocks.get(p2.pos)), new Edge(m2, b3, 1, (Block)blocks.get(p2.pos + offset))};
                        GlobalOptimizer.this.merge(m2, null, blocks, states, p2.pos, frame, sp -= 2, scopep);
                        GlobalOptimizer.this.merge(m2, e2.succ[1], blocks, states, p2.pos + offset, frame, sp, scopep);
                        break;
                    }
                    case 19: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        e2 = new Expr(m2, GlobalOptimizer.this.ifoper(op), posInMethod, frame, sp, 2);
                        b3.add(e2);
                        GlobalOptimizer.traceEntry("ConditionalBranch");
                        GlobalOptimizer.addTraceAttr(e2);
                        e2 = new Expr(m2, 17, posInMethod, new Expr[]{e2}, 1, 1);
                        b3.add(e2);
                        int offset = p2.readS24();
                        e2.succ = new Edge[]{new Edge(m2, b3, 0, (Block)blocks.get(p2.pos)), new Edge(m2, b3, 1, (Block)blocks.get(p2.pos + offset))};
                        GlobalOptimizer.this.merge(m2, null, blocks, states, p2.pos, frame, sp -= 2, scopep);
                        GlobalOptimizer.this.merge(m2, e2.succ[1], blocks, states, p2.pos + offset, frame, sp, scopep);
                        break;
                    }
                    case 27: {
                        e2 = new Expr(m2, op, posInMethod, frame, sp--, 1);
                        b3.add(e2);
                        int target = pos + p2.readS24();
                        int case_count = 1 + p2.readU30();
                        e2.succ = new Edge[case_count + 1];
                        e2.succ[case_count] = new Edge(m2, b3, case_count, (Block)blocks.get(target));
                        GlobalOptimizer.this.merge(m2, e2.succ[case_count], blocks, states, target, frame, sp, scopep);
                        for (int i4 = 0; i4 < case_count; ++i4) {
                            target = pos + p2.readS24();
                            e2.succ[i4] = new Edge(m2, b3, i4, (Block)blocks.get(target));
                            GlobalOptimizer.this.merge(m2, e2.succ[i4], blocks, states, target, frame, sp, scopep);
                        }
                        blockEnd = true;
                        break;
                    }
                    case 36: {
                        int n30 = sp++;
                        Expr expr = Expr.createWithValue(m2, op, posInMethod, new Integer((byte)p2.readU8()));
                        frame[n30] = expr;
                        e2 = expr;
                        b3.add(e2);
                        break;
                    }
                    case 50: {
                        int oloc = p2.readU30();
                        int iloc = p2.readU30();
                        Expr index = frame[iloc];
                        Expr obj = frame[oloc];
                        GlobalOptimizer.addTraceAttr("index", index);
                        GlobalOptimizer.addTraceAttr("obj", obj);
                        e2 = frame[sp] = new Expr(m2, op, posInMethod);
                        Expr hasNext2Expr = frame[sp];
                        b3.add(hasNext2Expr);
                        e2.locals = new Expr[]{obj, index};
                        e2 = frame[oloc] = new Expr(m2, 260, posInMethod, hasNext2Expr);
                        b3.add(frame[oloc]);
                        e2.locals = new Expr[]{obj};
                        e2 = frame[iloc] = new Expr(m2, 259, posInMethod, hasNext2Expr);
                        b3.add(frame[iloc]);
                        e2.locals = new Expr[]{index};
                        ++sp;
                        b3.must_isolate_block = true;
                        split = true;
                        break;
                    }
                    case 67: {
                        assert (!GlobalOptimizer.this.useExactStaticCallSites());
                        int id = p2.readU30();
                        int argc = 1 + p2.readU30();
                        e2 = new Expr(m2, op, posInMethod, id, frame, sp, argc);
                        sp -= argc;
                        int n31 = sp++;
                        Expr expr = e2;
                        frame[n31] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 68: {
                        int id = p2.readU30();
                        int argc = 1 + p2.readU30();
                        e2 = new Expr(m2, op, posInMethod, frame, sp, argc);
                        e2.m = this.methods[id];
                        sp -= argc;
                        int n32 = sp++;
                        Expr expr = e2;
                        frame[n32] = expr;
                        b3.add(expr);
                        if (!GlobalOptimizer.this.useExactStaticCallSites()) continue block78;
                        GlobalOptimizer.this.makeStaticCallSiteExact(m2, b3, null, e2, null);
                        break;
                    }
                    case 83: {
                        int argc = 1 + p2.readU30();
                        e2 = new Expr(m2, op, posInMethod, frame, sp, argc);
                        sp -= argc;
                        int n33 = sp++;
                        Expr expr = e2;
                        frame[n33] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 73: {
                        int argc = 1 + p2.readU30();
                        e2 = new Expr(m2, op, posInMethod, frame, sp, argc);
                        sp -= argc;
                        b3.add(e2);
                        break;
                    }
                    case 69: 
                    case 70: 
                    case 74: 
                    case 76: {
                        Name ref = this.names[p2.readU30()];
                        int argc = 1 + p2.readU30() + refArgc[ref.kind];
                        e2 = new Expr(m2, op, posInMethod, ref, frame, sp, argc);
                        sp -= argc;
                        int n34 = sp++;
                        Expr expr = e2;
                        frame[n34] = expr;
                        b3.add(expr);
                        break;
                    }
                    case 78: 
                    case 79: {
                        Name ref = this.names[p2.readU30()];
                        int argc = 1 + p2.readU30() + refArgc[ref.kind];
                        e2 = new Expr(m2, op, posInMethod, ref, frame, sp, argc);
                        sp -= argc;
                        b3.add(e2);
                        break;
                    }
                    case 241: {
                        int ii = p2.readU30();
                        if (!GlobalOptimizer.this.STRIP_DEBUG_INFO) {
                            e2 = Expr.createWithValue(m2, op, posInMethod, this.strings[ii]);
                            b3.add(e2);
                        }
                        GlobalOptimizer.addTraceAttr("file", this.strings[ii]);
                        break;
                    }
                    case 240: 
                    case 242: {
                        int ii = p2.readU30();
                        if (!GlobalOptimizer.this.STRIP_DEBUG_INFO) {
                            e2 = new Expr(m2, op, posInMethod, ii);
                            b3.add(e2);
                        }
                        GlobalOptimizer.addTraceAttr("line", ii);
                        break;
                    }
                    case 239: {
                        int i1 = p2.readU8();
                        int i22 = p2.readU30();
                        int i3 = p2.readU8();
                        int i4 = p2.readU30();
                        if (GlobalOptimizer.this.STRIP_DEBUG_INFO) continue block78;
                        e2 = new Expr(m2, op, posInMethod);
                        e2.imm = new int[]{i1, i22, i3, i4};
                        b3.add(e2);
                        allDebugOps.add(e2);
                        break;
                    }
                    case 1: {
                        if (GlobalOptimizer.this.STRIP_DEBUG_INFO) continue block78;
                        b3.add(new Expr(m2, op, posInMethod));
                        break;
                    }
                    case 243: {
                        b3.add(new Expr(m2, op, posInMethod));
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        System.err.println("Unknown ABC bytecode " + op);
                        assert (false);
                        continue block78;
                    }
                }
            }
            for (Expr de : allDebugOps) {
                if (de.imm[0] != 1) continue;
                int strId = de.imm[1];
                int local = de.imm[2] + m2.params.length;
                de.value = this.strings[strId];
                Set locals = (Set)allLocals.get(local);
                if (locals == null) {
                    de.locals = new Expr[0];
                    continue;
                }
                de.locals = new Expr[locals.size()];
                int i5 = 0;
                for (Expr le : locals) {
                    de.locals[i5++] = le;
                }
            }
        }

        public int nameIndex(Name n2) {
            int idx = 0;
            for (Name x2 : this.names) {
                if (x2 != null && (x2 == n2 || x2.equals(n2))) {
                    return idx;
                }
                ++idx;
            }
            return -1;
        }

        public final String scriptName() {
            return this.src_filename.substring(0, this.src_filename.lastIndexOf(46));
        }

        public final String scriptBaseName() {
            String scriptBaseName = new File(this.src_filename).getName();
            scriptBaseName = scriptBaseName.substring(0, scriptBaseName.lastIndexOf("."));
            return scriptBaseName;
        }

        public final Domain domain() {
            return this.m_domain;
        }
    }

    public final class IIDManager {
        private int m_currentIID = 0;

        IIDManager() {
        }

        public int createIID() {
            return this.m_currentIID++;
        }
    }
}

