/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import adobe.abc.APIVersions;
import com.adobe.air.Descriptor;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Utils;
import com.adobe.air.validator.ApplicationDescriptorValidator;
import com.adobe.air.validator.ApplicationDescriptorValidator10;
import com.adobe.air.validator.ApplicationDescriptorValidator20;
import com.adobe.air.validator.ApplicationDescriptorValidator25;
import com.adobe.air.validator.ApplicationDescriptorValidator26;
import com.adobe.air.validator.ApplicationDescriptorValidator30;
import com.adobe.air.validator.ApplicationDescriptorValidator31;
import com.adobe.air.validator.DescriptorValidationException;
import java.awt.Dimension;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptor
extends Descriptor {
    public static final String PROFILE_DESKTOP = "desktop";
    public static final String PROFILE_EXTENDED_DESKTOP = "extendedDesktop";
    public static final String PROFILE_MOBILE_DEVICE = "mobileDevice";
    public static final String PROFILE_EXTENDED_MOBILE_DEVICE = "extendedMobileDevice";
    public static final String PROFILE_TV = "tv";
    public static final String PROFILE_EXTENDED_TV = "extendedTV";
    public static final String NAMESPACE_1_0 = "http://ns.adobe.com/air/application/1.0";
    public static final String NAMESPACE_1_1 = "http://ns.adobe.com/air/application/1.1";
    public static final String NAMESPACE_1_5 = "http://ns.adobe.com/air/application/1.5";
    public static final String NAMESPACE_1_5_1 = "http://ns.adobe.com/air/application/1.5.1";
    public static final String NAMESPACE_1_5_2 = "http://ns.adobe.com/air/application/1.5.2";
    public static final String NAMESPACE_1_5_3 = "http://ns.adobe.com/air/application/1.5.3";
    public static final String NAMESPACE_2_0 = "http://ns.adobe.com/air/application/2.0";
    public static final String NAMESPACE_2_5 = "http://ns.adobe.com/air/application/2.5";
    public static final String NAMESPACE_2_6 = "http://ns.adobe.com/air/application/2.6";
    public static final String NAMESPACE_2_7 = "http://ns.adobe.com/air/application/2.7";
    public static final String NAMESPACE_3_0 = "http://ns.adobe.com/air/application/3.0";
    public static final String NAMESPACE_3_1 = "http://ns.adobe.com/air/application/3.1";
    private static final String[] NAMESPACES = new String[]{"http://ns.adobe.com/air/application/1.0", "http://ns.adobe.com/air/application/1.1", "http://ns.adobe.com/air/application/1.5", "http://ns.adobe.com/air/application/1.5.1", "http://ns.adobe.com/air/application/1.5.2", "http://ns.adobe.com/air/application/1.5.3", "http://ns.adobe.com/air/application/2.0", "http://ns.adobe.com/air/application/2.5", "http://ns.adobe.com/air/application/2.6", "http://ns.adobe.com/air/application/2.7", "http://ns.adobe.com/air/application/3.0", "http://ns.adobe.com/air/application/3.1"};
    private static final Map<String, String> NAMESPACE_CLASSNAMES;
    private static final Map<String, Integer> NAMESPACE_APIVERSIONS;

    public ApplicationDescriptor(File descriptorFile) throws DescriptorValidationException {
        super(descriptorFile, true);
    }

    public ApplicationDescriptor(InputStream in) throws DescriptorValidationException {
        super(in, true);
    }

    public ApplicationDescriptor(File descriptorFile, boolean validate) throws DescriptorValidationException {
        super(descriptorFile, validate);
    }

    public ApplicationDescriptor(InputStream in, boolean validate) throws DescriptorValidationException {
        super(in, validate);
    }

    public void validate(ValidationParams params, SortedMap<String, File> sources) throws DescriptorValidationException {
        this.validate(params);
        boolean allowHTML = params.allowHTML;
        if (allowHTML && this._validator instanceof ApplicationDescriptorValidator20) {
            int numProfiles = ((ApplicationDescriptorValidator20)this._validator).supportedProfiles().size();
            allowHTML = numProfiles != 1 || !this.hasProfile(PROFILE_TV);
        }
        this.validateFiles(sources, allowHTML, params.allowCrushedPNG);
    }

    public void validate(ValidationParams params) throws DescriptorValidationException {
        if (Arrays.binarySearch(NAMESPACES, this._document.getDocumentElement().getNamespaceURI()) < Arrays.binarySearch(NAMESPACES, params.minimumNamespace)) {
            this.dispatchError(307, -1, -1, new String[]{this.getVersionFromNamespace(params.minimumNamespace)});
        }
        if (params.requiredProfiles.length > 0) {
            boolean foundProfile = false;
            for (String profile : params.requiredProfiles) {
                if (!this.hasProfile(profile)) continue;
                foundProfile = true;
                break;
            }
            if (!foundProfile) {
                this.dispatchError(306, -1, -1, new String[]{Utils.stringJoin(params.requiredProfiles, ", ")});
            }
        }
        if (this.getRequiredExtensions() != null && this.getRequiredExtensions().size() > 0) {
            if (params.minimumNamespaceForExtensions == null) {
                this.dispatchError(112);
            } else if (this.namespaceCompare(params.minimumNamespaceForExtensions) < 0) {
                this.dispatchError(117, -1, -1, new String[]{this.getVersionFromNamespace(params.minimumNamespaceForExtensions)});
            }
        }
        if (!params.allowAllowBrowserInvocation && ((ApplicationDescriptorValidator10)this._validator).allowBrowserInvocation().booleanValue()) {
            this.dispatchError(116);
        }
    }

    public int getApplicationRootSWFVersion(SortedMap<String, File> sources) throws InvalidInputException {
        File rootContent = this.getValidator().getRootContentFile(sources);
        int swfVersion = Utils.getSWFVersion(rootContent);
        return swfVersion;
    }

    private void validateFiles(SortedMap<String, File> sources, boolean allowHTML, boolean allowCrushedPNG) throws DescriptorValidationException {
        if (this._validator == null) {
            throw new IllegalStateException("Tried to validate a descriptor's files before its xml");
        }
        this.failIfError();
        TreeMap<String, File> validatorSources = new TreeMap<String, File>();
        validatorSources.putAll(sources);
        this.getValidator().validateRootContentFile(validatorSources, allowHTML);
        this.failIfError();
        this.getValidator().validateImageFiles(validatorSources, allowCrushedPNG);
        this.failIfError();
    }

    private boolean hasProfile(String profile) throws DescriptorValidationException {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).supportedProfiles().contains(profile);
        }
        return profile == PROFILE_DESKTOP;
    }

    public void validateIcon(InputStream is, String name, boolean allowCrushedPNG) throws DescriptorValidationException {
        this.getValidator().validateImage(is, name, allowCrushedPNG);
        this.failIfError();
    }

    public void validateInitialContent(InputStream is, boolean allowHTML) throws DescriptorValidationException {
        this.getValidator().validateRootContentFile(is, allowHTML);
        this.failIfError();
    }

    public String filename() {
        return ((ApplicationDescriptorValidator10)this._validator).filename();
    }

    public String initialWindowTitle() {
        String value = ((ApplicationDescriptorValidator10)this._validator).initialWindowTitle();
        return value == null || value.length() == 0 ? this.name() : value;
    }

    public String name() {
        String value = ((ApplicationDescriptorValidator10)this._validator).name();
        return value == null || value.trim().length() == 0 ? this.filename() : value;
    }

    public Map<String, String> localizedNames() {
        if (this._localizedNames == null) {
            this._localizedNames = new HashMap();
            NodeList textList = this._document.getElementsByTagName("text");
            for (int i2 = 0; i2 < textList.getLength(); ++i2) {
                if (!textList.item(i2).getParentNode().getLocalName().equals("name")) continue;
                String lang = textList.item(i2).getAttributes().item(0).getNodeValue();
                String name = textList.item(i2).getTextContent();
                this._localizedNames.put(lang, name);
            }
        }
        return this._localizedNames;
    }

    public String id() {
        return ((ApplicationDescriptorValidator10)this._validator).id();
    }

    public String getNamespaceURI() {
        return this._document.getDocumentElement().getNamespaceURI();
    }

    public String versionNumber() {
        if (this._validator instanceof ApplicationDescriptorValidator25) {
            return ((ApplicationDescriptorValidator25)this._validator).versionNumber();
        }
        Pattern pattern = Pattern.compile("(\\d+)(?:\\D+(\\d+))?(?:\\D+(\\d+))?");
        Matcher matcher = pattern.matcher(((ApplicationDescriptorValidator10)this._validator).version());
        String convertedVersion = "";
        if (matcher.find()) {
            for (int i2 = 1; i2 <= matcher.groupCount(); ++i2) {
                String match = matcher.group(i2);
                if (match == null || match.length() <= 0) continue;
                convertedVersion = Integer.parseInt(match) > 999 ? convertedVersion + "999." : convertedVersion + match + ".";
            }
        } else {
            return "1";
        }
        return convertedVersion.substring(0, convertedVersion.length() - 1);
    }

    public String versionLabel() {
        if (this._validator instanceof ApplicationDescriptorValidator25) {
            if (((ApplicationDescriptorValidator25)this._validator).versionLabel().equals("")) {
                return ((ApplicationDescriptorValidator25)this._validator).versionNumber();
            }
            return ((ApplicationDescriptorValidator25)this._validator).versionLabel();
        }
        return ((ApplicationDescriptorValidator10)this._validator).version();
    }

    public String copyright() {
        return ((ApplicationDescriptorValidator10)this._validator).copyright();
    }

    public Boolean visible() {
        return ((ApplicationDescriptorValidator10)this._validator).visible();
    }

    public String aspectRatio() {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).aspectRatio();
        }
        return null;
    }

    public String renderMode() {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).renderMode();
        }
        return null;
    }

    public String softKeyboardBehavior() {
        if (this._validator instanceof ApplicationDescriptorValidator26) {
            return ((ApplicationDescriptorValidator26)this._validator).softKeyboardBehavior();
        }
        return null;
    }

    public Boolean autoOrients() {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).autoOrients();
        }
        return null;
    }

    public Boolean fullscreen() {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).fullScreen();
        }
        return null;
    }

    public String getIcon(int size) {
        return ((ApplicationDescriptorValidator10)this._validator).appIcons().get(size);
    }

    public Dimension getIconDimension(String path) {
        return this.getValidator().getIconDimension(path);
    }

    public Collection<String> appIcons() {
        return ((ApplicationDescriptorValidator10)this._validator).appIcons().values();
    }

    public Map<Integer, String> appIconsMap() {
        return ((ApplicationDescriptorValidator10)this._validator).appIcons();
    }

    public Collection<String> icons() {
        return this.getValidator().getIcons();
    }

    public String initialContent() {
        return ((ApplicationDescriptorValidator10)this._validator).initialContent();
    }

    public int maxSWFVersion() {
        return ((ApplicationDescriptorValidator)this._validator).getMaximumSWFVersion();
    }

    public String getLSMinimumSystemVersion() {
        return ((ApplicationDescriptorValidator)this._validator).getLSMinimumSystemVersion();
    }

    public String iosInfoAdditions() {
        if (this._validator instanceof ApplicationDescriptorValidator20) {
            return ((ApplicationDescriptorValidator20)this._validator).infoAdditions();
        }
        return null;
    }

    public String iosEntitlements() {
        if (this._validator instanceof ApplicationDescriptorValidator31) {
            return ((ApplicationDescriptorValidator31)this._validator).iosEntitlements();
        }
        return null;
    }

    public String iosDisplayTagVal() {
        if (this._validator instanceof ApplicationDescriptorValidator26) {
            return ((ApplicationDescriptorValidator26)this._validator).iosDisplayMode();
        }
        return null;
    }

    public boolean useAndroid32bitColorDepth() {
        if (this._validator instanceof ApplicationDescriptorValidator30) {
            return ((ApplicationDescriptorValidator30)this._validator).androidColorDepth().equals(ApplicationDescriptorValidator30.COLOR_32_BIT);
        }
        return false;
    }

    public String androidManifestInfo() {
        if (this._validator instanceof ApplicationDescriptorValidator25) {
            return ((ApplicationDescriptorValidator25)this._validator).manifestAdditions();
        }
        return null;
    }

    public boolean migrationGracePeriodInEffect() {
        return this._validator.migrationGracePeriodInEffect();
    }

    public boolean usePackageSignatureForTimestamps() {
        boolean result = true;
        if (this._validator != null) {
            result = this._validator.usePackageSignatureForTimestamps();
        }
        return result;
    }

    @Override
    public byte[] getBytes() {
        return this._descriptorBytes;
    }

    public int namespaceCompare(String compareTo) {
        int appDescInx = Arrays.binarySearch(NAMESPACES, this._document.getDocumentElement().getNamespaceURI());
        int compareInx = Arrays.binarySearch(NAMESPACES, compareTo);
        return appDescInx - compareInx;
    }

    private String getVersionFromNamespace(String namespace) {
        return namespace.substring(namespace.lastIndexOf(47) + 1);
    }

    public Set<String> getRequiredExtensions() {
        if (this._validator instanceof ApplicationDescriptorValidator25) {
            return ((ApplicationDescriptorValidator25)this._validator).getRequiredExtensions();
        }
        return null;
    }

    public String getDescriptorFileName() {
        return this._descriptorFileName;
    }

    public static int GetAPIVersionForNSURI(String namespaceURI) {
        Integer uriVersion = NAMESPACE_APIVERSIONS.get(namespaceURI);
        if (uriVersion == null) {
            throw new IllegalArgumentException("Invalid namespaceURI");
        }
        return uriVersion;
    }

    public static int GetPlatformAPIVersion(String namespaceURI, int swfVersion) {
        int apiVersion = APIVersions.kApiVersion_VM_INTERNAL;
        int swfAPIVersion = APIVersions.kApiVersion_VM_INTERNAL;
        if (namespaceURI != null) {
            Integer uriVersion = NAMESPACE_APIVERSIONS.get(namespaceURI);
            if (uriVersion == null) {
                throw new IllegalArgumentException("Invalid namespaceURI");
            }
            apiVersion = uriVersion;
        }
        if (swfVersion < 9) {
            swfVersion = 9;
        }
        switch (swfVersion) {
            case 14: {
                swfAPIVersion = APIVersions.kApiVersion_AIR_3_1;
                break;
            }
            case 13: {
                swfAPIVersion = APIVersions.kApiVersion_AIR_3_0;
                break;
            }
            case 12: {
                swfAPIVersion = APIVersions.kApiVersion_AIR_2_7;
                break;
            }
            case 11: {
                swfAPIVersion = APIVersions.kApiVersion_AIR_2_6;
                break;
            }
            case 10: {
                swfAPIVersion = APIVersions.kApiVersion_AIR_2_5;
                break;
            }
            case 9: {
                swfAPIVersion = APIVersions.kApiVersion_AIR_1_0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid swfVersion");
            }
        }
        if (apiVersion > swfAPIVersion) {
            apiVersion = swfAPIVersion;
        }
        return apiVersion;
    }

    @Override
    protected String getValidatorClassNameFromNamespaceUri(String namespaceUri) {
        return NAMESPACE_CLASSNAMES.get(namespaceUri);
    }

    @Override
    protected ApplicationDescriptorValidator getValidator() {
        return (ApplicationDescriptorValidator)this._validator;
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put(NAMESPACE_1_0, "com.adobe.air.validator.ApplicationDescriptorValidator10");
        tempMap.put(NAMESPACE_1_1, "com.adobe.air.validator.ApplicationDescriptorValidator11");
        tempMap.put(NAMESPACE_1_5, "com.adobe.air.validator.ApplicationDescriptorValidator15");
        tempMap.put(NAMESPACE_1_5_1, "com.adobe.air.validator.ApplicationDescriptorValidator151");
        tempMap.put(NAMESPACE_1_5_2, "com.adobe.air.validator.ApplicationDescriptorValidator152");
        tempMap.put(NAMESPACE_1_5_3, "com.adobe.air.validator.ApplicationDescriptorValidator153");
        tempMap.put(NAMESPACE_2_0, "com.adobe.air.validator.ApplicationDescriptorValidator20");
        tempMap.put(NAMESPACE_2_5, "com.adobe.air.validator.ApplicationDescriptorValidator25");
        tempMap.put(NAMESPACE_2_6, "com.adobe.air.validator.ApplicationDescriptorValidator26");
        tempMap.put(NAMESPACE_2_7, "com.adobe.air.validator.ApplicationDescriptorValidator27");
        tempMap.put(NAMESPACE_3_0, "com.adobe.air.validator.ApplicationDescriptorValidator30");
        tempMap.put(NAMESPACE_3_1, "com.adobe.air.validator.ApplicationDescriptorValidator31");
        NAMESPACE_CLASSNAMES = Collections.unmodifiableMap(tempMap);
        HashMap<String, Integer> versionsTempMap = new HashMap<String, Integer>();
        versionsTempMap.put(NAMESPACE_1_0, APIVersions.kApiVersion_AIR_1_0);
        versionsTempMap.put(NAMESPACE_1_1, APIVersions.kApiVersion_AIR_1_0);
        versionsTempMap.put(NAMESPACE_1_5, APIVersions.kApiVersion_AIR_1_5);
        versionsTempMap.put(NAMESPACE_1_5_1, APIVersions.kApiVersion_AIR_1_5_1);
        versionsTempMap.put(NAMESPACE_1_5_2, APIVersions.kApiVersion_AIR_1_5_2);
        versionsTempMap.put(NAMESPACE_1_5_3, APIVersions.kApiVersion_AIR_1_5_2);
        versionsTempMap.put(NAMESPACE_2_0, APIVersions.kApiVersion_AIR_2_0);
        versionsTempMap.put(NAMESPACE_2_5, APIVersions.kApiVersion_AIR_2_5);
        versionsTempMap.put(NAMESPACE_2_6, APIVersions.kApiVersion_AIR_2_6);
        versionsTempMap.put(NAMESPACE_2_7, APIVersions.kApiVersion_AIR_2_7);
        versionsTempMap.put(NAMESPACE_3_0, APIVersions.kApiVersion_AIR_3_0);
        versionsTempMap.put(NAMESPACE_3_1, APIVersions.kApiVersion_AIR_3_1);
        NAMESPACE_APIVERSIONS = Collections.unmodifiableMap(versionsTempMap);
    }

    public static class ValidationParams {
        public String minimumNamespace = "http://ns.adobe.com/air/application/1.0";
        public String minimumNamespaceForExtensions = "http://ns.adobe.com/air/application/2.5";
        public String[] requiredProfiles = new String[0];
        public boolean allowHTML = true;
        public boolean allowCrushedPNG = true;
        public boolean allowAllowBrowserInvocation = true;

        public ValidationParams(String minimumNamespace, String minimumNamespaceForExtensions, String[] requiredProfiles, boolean allowHTML, boolean allowCrushedPNG) {
            this.minimumNamespace = minimumNamespace;
            this.minimumNamespaceForExtensions = minimumNamespaceForExtensions;
            this.requiredProfiles = requiredProfiles;
            this.allowHTML = allowHTML;
            this.allowCrushedPNG = allowCrushedPNG;
        }

        public ValidationParams(String minimumNamespace, String minimumNamespaceForExtensions, String[] requiredProfiles, boolean allowHTML, boolean allowCrushedPNG, boolean allowAllowBrowserInvocation) {
            this(minimumNamespace, minimumNamespaceForExtensions, requiredProfiles, allowHTML, allowCrushedPNG);
            this.allowAllowBrowserInvocation = allowAllowBrowserInvocation;
        }
    }
}

