/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.ZipFile;

public class CentralDirectoryReader {
    protected long LOCAL_FILE_HEADER_MAGIC = 67324752L;
    protected long CENTRAL_DIRECTORY_HEADER_MAGIC = 33639248L;
    protected long DEFAULT_FILE_PERMISSONS = -2119958528L;
    protected long EXECUTABLE_FILE_PERMISSIONS = -2115174400L;
    protected long SYMLINK_FILE_PERMISSIONS = -1577254912L;
    protected long FOLDER_FILE_PERMISSIONS = 1106051072L;
    private int _permissions;
    private RandomAccessFile _raf;
    private long _cdr_start;

    public CentralDirectoryReader(ZipFile zipFile) throws IOException {
        this._raf = new RandomAccessFile(zipFile.getName(), "r");
        int header = this.readInt();
        while ((long)header != this.CENTRAL_DIRECTORY_HEADER_MAGIC) {
            this._raf.skipBytes(4);
            short compressionMethod = this.readShort();
            this._raf.skipBytes(8);
            int compressedSize = this.readInt();
            int uncompressedSize = this.readInt();
            short fileNameLength = this.readShort();
            short extraFieldLength = this.readShort();
            this._raf.skipBytes(fileNameLength);
            this._raf.skipBytes(extraFieldLength);
            this._raf.skipBytes(compressionMethod == 8 ? compressedSize : uncompressedSize);
            header = this.readInt();
        }
        this._cdr_start = this._raf.getFilePointer() - 4L;
        this._raf.seek(this._cdr_start);
    }

    public void advanceHeader(String fileName) throws IOException {
        this._raf.skipBytes(28);
        short fileNameLength = this.readShort();
        short extraFieldLength = this.readShort();
        short fileCommentLength = this.readShort();
        this._raf.skipBytes(4);
        this._permissions = this.readInt();
        this._raf.skipBytes(4);
        byte[] fileNameCD = new byte[fileNameLength];
        this._raf.read(fileNameCD);
        if (!fileName.equals(new String(fileNameCD, "UTF-8"))) {
            throw new IOException("Malformed zip file");
        }
        this._raf.skipBytes(extraFieldLength);
        this._raf.skipBytes(fileCommentLength);
    }

    public boolean searchHeader(String fileName) throws IOException {
        boolean found = false;
        this._raf.seek(this._cdr_start);
        int header = this.readInt();
        while (!found && (long)header == this.CENTRAL_DIRECTORY_HEADER_MAGIC) {
            this._raf.skipBytes(24);
            short fileNameLength = this.readShort();
            short extraFieldLength = this.readShort();
            short fileCommentLength = this.readShort();
            this._raf.skipBytes(4);
            this._permissions = this.readInt();
            this._raf.skipBytes(4);
            byte[] fileNameCD = new byte[fileNameLength];
            this._raf.read(fileNameCD);
            if (fileName.equals(new String(fileNameCD, "UTF-8"))) {
                found = true;
            }
            this._raf.skipBytes(extraFieldLength);
            this._raf.skipBytes(fileCommentLength);
            header = this.readInt();
        }
        this._raf.seek(this._raf.getFilePointer() - 4L);
        return found;
    }

    public void close() throws IOException {
        this._raf.close();
    }

    public int getPermissions() {
        return this._permissions;
    }

    private int readInt() throws IOException {
        return Integer.reverseBytes(this._raf.readInt());
    }

    private short readShort() throws IOException {
        return Short.reverseBytes(this._raf.readShort());
    }
}

