/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Plist {
    private DictionaryNode _rootDictionary = new DictionaryNode();

    public static Plist newFromFile(File plist) throws IOException {
        FileInputStream in = new FileInputStream(plist);
        Plist result = Plist.newFromString(new String(Utils.readIn(in), "UTF-8"));
        ((InputStream)in).close();
        return result;
    }

    public static Plist newFromString(String plistString) throws IOException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(plistString)));
            NodeList children = document.getDocumentElement().getChildNodes();
            Node dictionaryNode = null;
            for (int i2 = 0; i2 < children.getLength(); ++i2) {
                Node child = children.item(i2);
                if (child.getNodeType() != 1) continue;
                dictionaryNode = child;
                break;
            }
            if (dictionaryNode == null) {
                throw new IOException("plist is missing root <dict> node");
            }
            return new Plist(Plist.parsePlistDictionary(dictionaryNode));
        }
        catch (SAXException e2) {
            throw new IOException("PLIST generation failed due to SAX error:" + e2);
        }
        catch (ParserConfigurationException e3) {
            throw new IOException("PLIST generation failed due to parser error:" + e3);
        }
    }

    private static DictionaryNode parsePlistDictionary(Node dictXML) throws IOException {
        DictionaryNode dictNode = new DictionaryNode();
        String currentKey = null;
        NodeList children = dictXML.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node child = children.item(i2);
            if (child.getNodeType() != 1) continue;
            String nodeName = child.getNodeName().trim();
            if (nodeName.equals("key")) {
                if (currentKey != null) {
                    throw new IOException("Invalid plist. Found two <key> nodes in a row");
                }
                currentKey = child.getTextContent().trim();
                continue;
            }
            if (currentKey == null) {
                throw new IOException("Invalid plist. Missing a <key> node");
            }
            if (nodeName.equals("true")) {
                dictNode.putNode(currentKey, new BooleanNode(true));
            } else if (nodeName.equals("false")) {
                dictNode.putNode(currentKey, new BooleanNode(false));
            } else if (nodeName.equals("string")) {
                dictNode.putNode(currentKey, new StringNode(child.getTextContent().trim()));
            } else if (nodeName.equals("array")) {
                dictNode.putNode(currentKey, Plist.parsePlistArray(child));
            } else if (nodeName.equals("dict")) {
                dictNode.putNode(currentKey, Plist.parsePlistDictionary(child));
            } else {
                throw new IOException("Invalid plist: found an unexpected node in a dictionary: " + nodeName);
            }
            currentKey = null;
        }
        return dictNode;
    }

    private static ArrayNode parsePlistArray(Node arrayXML) throws IOException {
        ArrayNode arrayNode = new ArrayNode();
        NodeList children = arrayXML.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node child = children.item(i2);
            if (child.getNodeType() != 1) continue;
            String nodeName = child.getNodeName().trim();
            if (nodeName.equals("true")) {
                arrayNode.addNode(new BooleanNode(true));
                continue;
            }
            if (nodeName.equals("false")) {
                arrayNode.addNode(new BooleanNode(false));
                continue;
            }
            if (nodeName.equals("string")) {
                arrayNode.addNode(new StringNode(child.getTextContent().trim()));
                continue;
            }
            if (nodeName.equals("array")) {
                arrayNode.addNode(Plist.parsePlistArray(child));
                continue;
            }
            if (nodeName.equals("dict")) {
                arrayNode.addNode(Plist.parsePlistDictionary(child));
                continue;
            }
            throw new IOException("Invalid plist: found an unexpected node in an array: " + nodeName);
        }
        return arrayNode;
    }

    public Plist() {
        this._rootDictionary = new DictionaryNode();
    }

    private Plist(DictionaryNode dictNode) throws IOException {
        this._rootDictionary = dictNode;
    }

    public String getXMLString() throws IOException {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            DOMImplementation domImpl = docBuilder.getDOMImplementation();
            DocumentType doctype = domImpl.createDocumentType("plist", "-//Apple Computer//DTD PLIST 1.0//EN", "http://www.apple.com/DTDs/PropertyList-1.0.dtd");
            Document doc = domImpl.createDocument(null, "plist", doctype);
            Element plist = doc.getDocumentElement();
            plist.setAttribute("version", "1.0");
            plist.appendChild(this._rootDictionary.getXML(doc));
            DOMSource domSource = new DOMSource(doc);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("doctype-public", "-//Apple//DTD PLIST 1.0//EN");
            transformer.setOutputProperty("doctype-system", "http://www.apple.com/DTDs/PropertyList-1.0.dtd");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            transformer.transform(domSource, sr);
            return sw.toString();
        }
        catch (TransformerException e2) {
            e2.printStackTrace();
            throw new IOException("PLIST generation failed due to transformer error:" + e2);
        }
        catch (ParserConfigurationException e3) {
            throw new IOException("PLIST generation failed due to parser error:" + e3);
        }
    }

    public DictionaryNode getRootDictionary() {
        return this._rootDictionary;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DictionaryNode
    implements PlistNode {
        private LinkedHashMap<String, PlistNode> _values = new LinkedHashMap();

        public void putNode(String key, PlistNode node) {
            this._values.put(key, node);
        }

        public void putString(String key, String string) {
            this.putNode(key, new StringNode(string));
        }

        public void putBoolean(String key, boolean bool) {
            this.putNode(key, new BooleanNode(bool));
        }

        public ArrayNode putArray(String key) {
            ArrayNode array = new ArrayNode();
            this.putNode(key, array);
            return array;
        }

        public DictionaryNode putDictionary(String key) {
            DictionaryNode dict = new DictionaryNode();
            this.putNode(key, dict);
            return dict;
        }

        public PlistNode getNode(String key) {
            return this._values.get(key);
        }

        public PlistNode removeNode(String key) {
            return (PlistNode)this._values.remove(key);
        }

        public Set<String> keySet() {
            return this._values.keySet();
        }

        public void addDictionaryFragment(String fragment) throws IOException {
            Plist parsedFragment = Plist.newFromString("<plist><dict>" + fragment + "</dict></plist>");
            for (String key : parsedFragment.getRootDictionary().keySet()) {
                this.putNode(key, parsedFragment.getRootDictionary().getNode(key));
            }
        }

        @Override
        public Element getXML(Document doc) {
            Element dict = doc.createElement("dict");
            for (String key : this._values.keySet()) {
                Element keyNode = doc.createElement("key");
                keyNode.appendChild(doc.createTextNode(key));
                dict.appendChild(keyNode);
                dict.appendChild(this._values.get(key).getXML(doc));
            }
            return dict;
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public boolean indicatesSupportFor(String name) {
            return new BooleanNode(true).equals(this._values.get(name));
        }

        @Override
        public void setSupport(String name) {
            this._values.put(name, new BooleanNode(true));
        }
    }

    public static class ArrayNode
    implements PlistNode {
        private List<PlistNode> _values = new LinkedList<PlistNode>();

        public void addNode(PlistNode node) {
            this._values.add(node);
        }

        public void addString(String string) {
            this.addNode(new StringNode(string));
        }

        public PlistNode getNode(int i2) {
            return this._values.get(i2);
        }

        public PlistNode removeNode(int i2) {
            return this._values.remove(i2);
        }

        public int indexOf(PlistNode node) {
            return this._values.indexOf(node);
        }

        public int nodeCount() {
            return this._values.size();
        }

        public Element getXML(Document doc) {
            Element array = doc.createElement("array");
            for (PlistNode node : this._values) {
                array.appendChild(node.getXML(doc));
            }
            return array;
        }

        public boolean isCollection() {
            return true;
        }

        public boolean indicatesSupportFor(String name) {
            return this.indexOf(new StringNode(name)) >= 0;
        }

        public void setSupport(String name) {
            if (this.indexOf(new StringNode(name)) < 0) {
                this._values.add(new StringNode(name));
            }
        }
    }

    public static class StringNode
    implements PlistNode {
        private String _value;

        public StringNode(String value) {
            this._value = value;
        }

        public Element getXML(Document doc) {
            Element string = doc.createElement("string");
            string.appendChild(doc.createTextNode(this._value));
            return string;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof StringNode)) {
                return false;
            }
            return ((StringNode)o2)._value.equals(this._value);
        }

        public boolean isCollection() {
            return false;
        }

        public boolean indicatesSupportFor(String name) {
            return false;
        }

        public void setSupport(String name) {
        }
    }

    public static class BooleanNode
    implements PlistNode {
        private boolean _value;

        public BooleanNode(boolean value) {
            this._value = value;
        }

        public Element getXML(Document doc) {
            return doc.createElement(this._value ? "true" : "false");
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof BooleanNode)) {
                return false;
            }
            return ((BooleanNode)o2)._value == this._value;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean indicatesSupportFor(String name) {
            return false;
        }

        public void setSupport(String name) {
        }
    }

    public static interface PlistNode {
        public Element getXML(Document var1);

        public boolean isCollection();

        public boolean indicatesSupportFor(String var1);

        public void setSupport(String var1);
    }
}

