/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.validator.ApplicationDescriptorValidator27;
import com.adobe.air.validator.DescriptorValidator;
import java.util.HashSet;
import java.util.Set;

public class ApplicationDescriptorValidator30
extends ApplicationDescriptorValidator27 {
    public static String COLOR_32_BIT = "32bit";
    public static String COLOR_16_BIT = "16bit";
    private Set<String> _validColorDepths = new HashSet<String>();
    private boolean _badColorDepthTag = false;
    private String _androidColorDepth = COLOR_32_BIT;

    public ApplicationDescriptorValidator30() {
        this._validColorDepths.add(COLOR_32_BIT);
        this._validColorDepths.add(COLOR_16_BIT);
    }

    protected String getNamespace() {
        return "http://ns.adobe.com/air/application/3.0";
    }

    protected DescriptorValidator.ElementInfo createElementInfoTree() {
        DescriptorValidator.ElementInfo root = super.createElementInfoTree();
        DescriptorValidator.ElementInfo temp = root.getChild("android");
        temp.addChild(new DescriptorValidator.ElementInfo("colorDepth", 0, 1));
        return root;
    }

    protected boolean validateElement(String elementPath, String value) {
        boolean valid = super.validateElement(elementPath, value);
        if (elementPath.equals("application.android.colorDepth")) {
            valid = this._validColorDepths.contains(value);
            this._androidColorDepth = value;
        }
        return valid;
    }

    public int getMaximumSWFVersion() {
        return 13;
    }

    public String getLSMinimumSystemVersion() {
        return "10.6";
    }

    public String androidColorDepth() {
        return this._androidColorDepth;
    }
}

