/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.png;

import com.adobe.png.PNGChunk;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class PNGReader {
    private final CRC32 m_crc32 = new CRC32();
    private final DataInputStream m_in;

    public PNGReader(InputStream in) throws ParseException, IOException {
        this.m_in = new DataInputStream(in);
        try {
            long sig = this.m_in.readLong();
            if (sig != -8552249625308161526L) {
                throw new ParseException("bad signature");
            }
        }
        catch (EOFException e2) {
            throw new ParseException("bad signature");
        }
    }

    public PNGChunk readChunk() throws ParseException, IOException {
        int length;
        try {
            length = this.m_in.readInt();
            if (length < 0) {
                throw new ParseException("bad chunk length");
            }
        }
        catch (EOFException e2) {
            return null;
        }
        try {
            byte[] type = new byte[4];
            this.m_in.readFully(type);
            byte[] data = new byte[length];
            this.m_in.readFully(data);
            long crc = (long)this.m_in.readInt() & 0xFFFFFFFFL;
            this.m_crc32.reset();
            this.m_crc32.update(type);
            this.m_crc32.update(data);
            long computedCRC = this.m_crc32.getValue();
            if (computedCRC != crc) {
                throw new ParseException("bad CRC");
            }
            return new PNGChunk(type, data);
        }
        catch (EOFException e3) {
            throw new ParseException("unexpected EOF");
        }
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = -4170283848385275024L;

        public ParseException(String reason) {
            super(reason);
        }
    }
}

